/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.applovin.impl.mediation.nativeAds.MaxNativeAdImpl;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import java.util.List;

public class MaxNativeAd
extends MaxNativeAdImpl {
    private static final float MINIMUM_STARS_TO_RENDER = 3.0f;
    private final MaxAdFormat format;
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final MaxNativeAdImage icon;
    private final MaxNativeAdImage mainImage;
    private final View iconView;
    private final View optionsView;
    private final View mediaView;
    private final float mediaContentAspectRatio;
    private final Double starRating;
    private MaxNativeAdView nativeAdView;
    private boolean isExpired;

    public MaxNativeAd(Builder builder) {
        this.format = builder.adFormat;
        this.title = builder.title;
        this.advertiser = builder.advertiser;
        this.body = builder.body;
        this.callToAction = builder.callToAction;
        this.icon = builder.icon;
        this.iconView = builder.iconView;
        this.optionsView = builder.optionsView;
        this.mediaView = builder.mediaView;
        this.mainImage = builder.mainImage;
        this.mediaContentAspectRatio = builder.mediaContentAspectRatio;
        Double d2 = builder.starRating;
        this.starRating = d2 != null && d2 >= 3.0 ? d2 : null;
    }

    @NonNull
    public final MaxAdFormat getFormat() {
        return this.format;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getAdvertiser() {
        return this.advertiser;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @Nullable
    public final String getCallToAction() {
        return this.callToAction;
    }

    @Nullable
    public final MaxNativeAdImage getIcon() {
        return this.icon;
    }

    @Nullable
    public final View getIconView() {
        return this.iconView;
    }

    @Nullable
    public final View getOptionsView() {
        return this.optionsView;
    }

    @Nullable
    public final View getMediaView() {
        return this.mediaView;
    }

    @Nullable
    public final MaxNativeAdImage getMainImage() {
        return this.mainImage;
    }

    public final float getMediaContentAspectRatio() {
        return this.mediaContentAspectRatio;
    }

    @Nullable
    public final Double getStarRating() {
        return this.starRating;
    }

    public final boolean isExpired() {
        return this.isExpired;
    }

    public void setExpired() {
        this.isExpired = true;
    }

    public void setNativeAdView(MaxNativeAdView maxNativeAdView) {
        this.nativeAdView = maxNativeAdView;
    }

    @Deprecated
    public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
    }

    public boolean prepareForInteraction(List<View> list, ViewGroup viewGroup) {
        return false;
    }

    public boolean shouldPrepareViewForInteractionOnMainThread() {
        return true;
    }

    public boolean isContainerClickable() {
        return false;
    }

    @UiThread
    public void performClick() {
        Button button;
        if (this.nativeAdView != null && (button = this.nativeAdView.getCallToActionButton()) != null) {
            button.performClick();
        }
    }

    public static class MaxNativeAdImage {
        private Drawable aZe;
        private Uri ee;

        public MaxNativeAdImage(Drawable drawable2) {
            this.aZe = drawable2;
        }

        public MaxNativeAdImage(Uri uri) {
            this.ee = uri;
        }

        @Nullable
        public Drawable getDrawable() {
            return this.aZe;
        }

        @Nullable
        public Uri getUri() {
            return this.ee;
        }
    }

    public static class Builder {
        private MaxAdFormat adFormat;
        private String title;
        private String advertiser;
        private String body;
        private String callToAction;
        private MaxNativeAdImage icon;
        private View iconView;
        private View optionsView;
        private View mediaView;
        private MaxNativeAdImage mainImage;
        private float mediaContentAspectRatio;
        private Double starRating;

        public Builder setAdFormat(MaxAdFormat maxAdFormat) {
            this.adFormat = maxAdFormat;
            return this;
        }

        public Builder setTitle(String string2) {
            this.title = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.advertiser = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.body = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.callToAction = string2;
            return this;
        }

        public Builder setIcon(MaxNativeAdImage maxNativeAdImage) {
            this.icon = maxNativeAdImage;
            return this;
        }

        public Builder setIconView(View view) {
            this.iconView = view;
            return this;
        }

        public Builder setOptionsView(View view) {
            this.optionsView = view;
            return this;
        }

        public Builder setMediaView(View view) {
            this.mediaView = view;
            return this;
        }

        public Builder setMainImage(MaxNativeAdImage maxNativeAdImage) {
            this.mainImage = maxNativeAdImage;
            return this;
        }

        public Builder setMediaContentAspectRatio(float f2) {
            this.mediaContentAspectRatio = f2;
            return this;
        }

        public Builder setStarRating(Double d2) {
            this.starRating = d2;
            return this;
        }

        public MaxNativeAd build() {
            return new MaxNativeAd(this);
        }
    }
}

