/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.StrictMode;
import android.webkit.URLUtil;
import android.widget.ImageView;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.InputStream;
import java.net.URL;

public class ImageViewUtils {
    public static void setImageUri(ImageView imageView, Uri uri, m m2) {
        if (imageView == null || uri == null) {
            return;
        }
        String string2 = uri.toString();
        if (URLUtil.isFileUrl((String)string2) || URLUtil.isContentUrl((String)string2)) {
            AppLovinSdkUtils.runOnUiThread(() -> {
                StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
                imageView.setImageURI(uri);
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            });
            return;
        }
        if (m2 == null) {
            return;
        }
        m2.Cv();
        if (w.FV()) {
            m2.Cv().f("ImageViewUtils", "Fetching image: " + uri);
        }
        m2.Cx().LP().execute(() -> {
            if (m2.a(b.aLu).booleanValue()) {
                try (InputStream inputStream2 = new URL(string2).openStream();){
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream2);
                    AppLovinSdkUtils.runOnUiThread(() -> {
                        m2.Cv();
                        if (w.FV()) {
                            m2.Cv().f("ImageViewUtils", "Image fetched");
                        }
                        BitmapDrawable bitmapDrawable = new BitmapDrawable(m.getApplicationContext().getResources(), bitmap);
                        imageView.setImageDrawable((Drawable)bitmapDrawable);
                    });
                    return;
                }
                catch (Throwable throwable) {
                    m2.Cv();
                    if (w.FV()) {
                        m2.Cv().c("ImageViewUtils", "Failed to fetch image: " + uri, throwable);
                    }
                    m2.Cv().h("ImageViewUtils", throwable);
                    m2.Cw().d("ImageViewUtils", "setImageUri", throwable);
                }
                return;
            }
            InputStream inputStream = null;
            try {
                inputStream = new URL(string2).openStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                AppLovinSdkUtils.runOnUiThread(() -> {
                    m2.Cv();
                    if (w.FV()) {
                        m2.Cv().f("ImageViewUtils", "Image fetched");
                    }
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(m.getApplicationContext().getResources(), bitmap);
                    imageView.setImageDrawable((Drawable)bitmapDrawable);
                });
            }
            catch (Throwable throwable) {
                block14: {
                    try {
                        m2.Cv();
                        if (!w.FV()) break block14;
                        m2.Cv().c("ImageViewUtils", "Failed to fetch image: " + uri, throwable);
                    }
                    catch (Throwable throwable2) {
                        u.a(inputStream, m2);
                        throw throwable2;
                    }
                }
                u.a(inputStream, m2);
                return;
            }
            u.a(inputStream, m2);
            return;
        });
    }

    public static void setAndDownscaleImageUri(ImageView imageView, Uri uri) {
        if (uri == null || imageView == null) {
            return;
        }
        if (imageView.getHeight() > 0 && imageView.getWidth() > 0) {
            ImageViewUtils.setAndDownscaleBitmap(imageView, uri);
            return;
        }
        imageView.post(() -> ImageViewUtils.setAndDownscaleBitmap(imageView, uri));
    }

    public static void setAndDownscaleBitmap(ImageView imageView, Uri uri) {
        if (uri == null || imageView == null) {
            return;
        }
        if (m.aBD == null) {
            w.I("ImageViewUtils", "SDK has not been initialized");
            return;
        }
        m.aBD.Cx().LP().execute(() -> {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
            int n2 = imageView.getHeight();
            int n3 = imageView.getWidth();
            if (n2 <= 0 || n3 <= 0) {
                Point point = h.X(imageView.getContext());
                n2 = n3 = Math.min(point.x, point.y);
            }
            int n4 = 1;
            int n5 = options.outHeight;
            int n6 = options.outWidth;
            if (n5 > n2 || n6 > n3) {
                while (n5 / (n4 * 2) >= n2 || n6 / (n4 * 2) >= n3) {
                    n4 *= 2;
                }
            }
            options.inSampleSize = n4;
            options.inJustDecodeBounds = false;
            m.aBD.Cv();
            if (w.FV()) {
                m.aBD.Cv().f("ImageViewUtils", "Loading image: " + uri.getLastPathSegment() + "...");
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
            AppLovinSdkUtils.runOnUiThread(() -> imageView.setImageBitmap(bitmap));
        });
    }
}

