/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.content.Context;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.w;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinTargetingData;
import com.applovin.sdk.AppLovinUserSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AppLovinSdkInitializationConfigurationImpl
implements AppLovinSdkInitializationConfiguration {
    @Nullable
    private final String aAL;
    @Nullable
    private final String aAM;
    @Nullable
    private final String aAN;
    private final AppLovinSdkSettings aAO;
    @Nullable
    private final AppLovinUserSegment aAP;
    @Nullable
    private final AppLovinTargetingData aAQ;
    private final List<String> aAR;
    private final List<String> aAS;
    private final boolean aAT;

    private AppLovinSdkInitializationConfigurationImpl(BuilderImpl builderImpl) {
        this.aAL = builderImpl.aAL;
        this.aAM = builderImpl.aAM;
        this.aAN = builderImpl.aAN;
        this.aAO = builderImpl.aAO;
        this.aAP = builderImpl.aAP;
        this.aAQ = builderImpl.aAQ;
        this.aAR = builderImpl.aAR;
        this.aAS = builderImpl.aAS;
        this.aAT = builderImpl.aAT;
    }

    public String toString() {
        return "AppLovinSdkInitializationConfiguration{ sdkKey=" + this.aAL + ", mediationProvider=" + this.aAM + ", pluginVersion=" + this.aAN + ", testDeviceAdvertisingIdentifiers=" + this.aAR + ", adUnitIdentifiers=" + this.aAS + ", isExceptionHandlerEnabled=" + this.aAT + ", userSegment=" + this.aAP + ", targetingData=" + this.aAQ + "}";
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this.aAL;
    }

    @Override
    @Nullable
    public String getMediationProvider() {
        return this.aAM;
    }

    @Override
    @Nullable
    public String getPluginVersion() {
        return this.aAN;
    }

    @Override
    public AppLovinSdkSettings getSettings() {
        return this.aAO;
    }

    @Override
    @Nullable
    public AppLovinUserSegment getUserSegment() {
        return this.aAP;
    }

    @Override
    @Nullable
    public AppLovinTargetingData getTargetingData() {
        return this.aAQ;
    }

    @Override
    public List<String> getTestDeviceAdvertisingIds() {
        return this.aAR;
    }

    @Override
    public List<String> getAdUnitIds() {
        return this.aAS;
    }

    @Override
    public boolean isExceptionHandlerEnabled() {
        return this.aAT;
    }

    public static class BuilderImpl
    implements AppLovinSdkInitializationConfiguration.Builder {
        private String aAL;
        @Nullable
        private String aAM;
        @Nullable
        private String aAN;
        private final AppLovinSdkSettings aAO;
        @Nullable
        private AppLovinUserSegment aAP;
        @Nullable
        private AppLovinTargetingData aAQ;
        private List<String> aAR = Collections.emptyList();
        private List<String> aAS = Collections.emptyList();
        private boolean aAT = true;

        public BuilderImpl(String string2, Context context) {
            this.aAL = string2;
            this.aAO = new AppLovinSdkSettings(context);
            w.logApiCall("AppLovinSdkInitializationConfiguration", "Initializing with key: " + string2);
        }

        public AppLovinSdkInitializationConfiguration.Builder setSdkKey(String string2) {
            this.aAL = string2;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setMediationProvider(@Nullable String string2) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setMediationProvider(mediationProvider=" + string2 + ")");
            if (string2 != null && (string2.isEmpty() || string2.length() > 64 || !StringUtils.isAlphaNumeric(string2))) {
                w.I("AppLovinSdkInitializationConfiguration", "Mediation provider set to invalid value: " + string2 + ". Please use a valid mediation provider (e.g., AppLovinMediationProvider.MAX)");
                return this;
            }
            this.aAM = string2;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setPluginVersion(@Nullable String string2) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setPluginVersion(pluginVersion=" + string2 + ")");
            this.aAN = string2;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder configureSettings(@Nullable AppLovinSdkInitializationConfiguration.SettingsConfigurator settingsConfigurator) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "configureSettings()");
            if (settingsConfigurator != null) {
                settingsConfigurator.configure(this.aAO);
            }
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setUserSegment(@Nullable AppLovinUserSegment appLovinUserSegment) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setUserSegment(userSegment=" + appLovinUserSegment + ")");
            this.aAP = appLovinUserSegment;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setTargetingData(@Nullable AppLovinTargetingData appLovinTargetingData) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setTargetingData(targetingData=" + appLovinTargetingData + ")");
            this.aAQ = appLovinTargetingData;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setTestDeviceAdvertisingIds(List<String> list) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setTestDeviceAdvertisingIds(testDeviceAdvertisingIds=" + list + ")");
            if (list == null) {
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                w.I("AppLovinSdkInitializationConfiguration", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.aAR = arrayList;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setAdUnitIds(List<String> list) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setAdUnitIds(adUnitIds=" + list + ")");
            if (list == null) {
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                w.I("AppLovinSdkInitializationConfiguration", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.aAS = arrayList;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration.Builder setExceptionHandlerEnabled(boolean bl) {
            w.logApiCall("AppLovinSdkInitializationConfiguration", "setExceptionHandlerEnabled(exceptionHandlerEnabled=" + bl + ")");
            this.aAT = bl;
            return this;
        }

        @Override
        public AppLovinSdkInitializationConfiguration build() {
            return new AppLovinSdkInitializationConfigurationImpl(this);
        }

        public String toString() {
            return "AppLovinSdkInitializationConfiguration.Builder{ sdkKey=" + this.aAL + "mediationProvider=" + this.aAM + "pluginVersion=" + this.aAN + "testDeviceAdvertisingIdentifiers=" + this.aAR + "adUnitIdentifiers=" + this.aAS + "isExceptionHandlerEnabled=" + this.aAT + "userSegment=" + this.aAP + "targetingData=" + this.aAQ + "}";
        }

        @Override
        public String getSdkKey() {
            return this.aAL;
        }

        @Override
        @Nullable
        public String getMediationProvider() {
            return this.aAM;
        }

        @Override
        @Nullable
        public String getPluginVersion() {
            return this.aAN;
        }

        @Override
        public AppLovinSdkSettings getSettings() {
            return this.aAO;
        }

        @Override
        @Nullable
        public AppLovinUserSegment getUserSegment() {
            return this.aAP;
        }

        @Override
        @Nullable
        public AppLovinTargetingData getTargetingData() {
            return this.aAQ;
        }

        @Override
        public List<String> getTestDeviceAdvertisingIds() {
            return this.aAR;
        }

        @Override
        public List<String> getAdUnitIds() {
            return this.aAS;
        }

        @Override
        public boolean isExceptionHandlerEnabled() {
            return this.aAT;
        }
    }
}

