/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.CharMatcher;
import com.applovin.exoplayer2.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final b strategy;
    private final int limit;

    private Splitter(b b2) {
        this(b2, false, CharMatcher.none(), Integer.MAX_VALUE);
    }

    private Splitter(b b2, boolean bl, CharMatcher charMatcher, int n2) {
        this.strategy = b2;
        this.omitEmptyStrings = bl;
        this.trimmer = charMatcher;
        this.limit = n2;
    }

    public static Splitter on(char c2) {
        return Splitter.on(CharMatcher.is(c2));
    }

    public static Splitter on(final CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(new b(){

            public a a(Splitter splitter, CharSequence charSequence) {
                return new a(splitter, charSequence){

                    @Override
                    int aP(int n2) {
                        return charMatcher.indexIn(this.oS, n2);
                    }

                    @Override
                    int aQ(int n2) {
                        return n2 + 1;
                    }
                };
            }

            public /* synthetic */ Iterator b(Splitter splitter, CharSequence charSequence) {
                return this.a(splitter, charSequence);
            }
        });
    }

    public static Splitter on(final String string2) {
        Preconditions.checkArgument(string2.length() != 0, "The separator may not be the empty string.");
        if (string2.length() == 1) {
            return Splitter.on(string2.charAt(0));
        }
        return new Splitter(new b(){

            public a a(Splitter splitter, CharSequence charSequence) {
                return new a(splitter, charSequence){

                    @Override
                    public int aP(int n2) {
                        int n3 = string2.length();
                        int n4 = this.oS.length() - n3;
                        block0: for (int i2 = n2; i2 <= n4; ++i2) {
                            for (int i3 = 0; i3 < n3; ++i3) {
                                if (this.oS.charAt(i3 + i2) != string2.charAt(i3)) continue block0;
                            }
                            return i2;
                        }
                        return -1;
                    }

                    @Override
                    public int aQ(int n2) {
                        return n2 + string2.length();
                    }
                };
            }

            public /* synthetic */ Iterator b(Splitter splitter, CharSequence charSequence) {
                return this.a(splitter, charSequence);
            }
        });
    }

    public static Splitter fixedLength(final int n2) {
        Preconditions.checkArgument(n2 > 0, "The length may not be less than 1");
        return new Splitter(new b(){

            public a a(Splitter splitter, CharSequence charSequence) {
                return new a(splitter, charSequence){

                    @Override
                    public int aP(int n2) {
                        int n3 = n2 + n2;
                        return n3 < this.oS.length() ? n3 : -1;
                    }

                    @Override
                    public int aQ(int n2) {
                        return n2;
                    }
                };
            }

            public /* synthetic */ Iterator b(Splitter splitter, CharSequence charSequence) {
                return this.a(splitter, charSequence);
            }
        });
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    public Splitter limit(int n2) {
        Preconditions.checkArgument(n2 > 0, "must be greater than zero: %s", n2);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, n2);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.whitespace());
    }

    public Splitter trimResults(CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(this.strategy, this.omitEmptyStrings, charMatcher, this.limit);
    }

    private Iterator<String> splittingIterator(CharSequence charSequence) {
        return this.strategy.b(this, charSequence);
    }

    public List<String> splitToList(CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        Iterator<String> iterator = this.splittingIterator(charSequence);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static abstract class a
    extends com.applovin.exoplayer2.common.base.b<String> {
        final CharSequence oS;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int oT = 0;
        int limit;

        abstract int aP(int var1);

        abstract int aQ(int var1);

        protected a(Splitter splitter, CharSequence charSequence) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = splitter.limit;
            this.oS = charSequence;
        }

        protected String eZ() {
            int n2 = this.oT;
            while (this.oT != -1) {
                int n3;
                int n4 = n2;
                int n5 = this.aP(this.oT);
                if (n5 == -1) {
                    n3 = this.oS.length();
                    this.oT = -1;
                } else {
                    n3 = n5;
                    this.oT = this.aQ(n5);
                }
                if (this.oT == n2) {
                    ++this.oT;
                    if (this.oT <= this.oS.length()) continue;
                    this.oT = -1;
                    continue;
                }
                while (n4 < n3 && this.trimmer.matches(this.oS.charAt(n4))) {
                    ++n4;
                }
                while (n3 > n4 && this.trimmer.matches(this.oS.charAt(n3 - 1))) {
                    --n3;
                }
                if (this.omitEmptyStrings && n4 == n3) {
                    n2 = this.oT;
                    continue;
                }
                if (this.limit == 1) {
                    this.oT = -1;
                    for (n3 = this.oS.length(); n3 > n4 && this.trimmer.matches(this.oS.charAt(n3 - 1)); --n3) {
                    }
                } else {
                    --this.limit;
                }
                return this.oS.subSequence(n4, n3).toString();
            }
            return (String)this.eT();
        }

        @Override
        protected /* synthetic */ Object eS() {
            return this.eZ();
        }
    }

    private static interface b {
        public Iterator<String> b(Splitter var1, CharSequence var2);
    }
}

