/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import java.util.Arrays;
import java.util.BitSet;

public abstract class CharMatcher
implements Predicate<Character> {
    public static CharMatcher any() {
        return b.nJ;
    }

    public static CharMatcher none() {
        return w.od;
    }

    public static CharMatcher whitespace() {
        return aa.oi;
    }

    public static CharMatcher breakingWhitespace() {
        return e.nM;
    }

    public static CharMatcher ascii() {
        return d.nL;
    }

    @Deprecated
    public static CharMatcher digit() {
        return f.nN;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return n.nV;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return p.nX;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return q.nY;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return s.oa;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return r.nZ;
    }

    public static CharMatcher javaIsoControl() {
        return o.nW;
    }

    @Deprecated
    public static CharMatcher invisible() {
        return j.nR;
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return z.og;
    }

    public static CharMatcher is(char c2) {
        return new k(c2);
    }

    public static CharMatcher isNot(char c2) {
        return new m(c2);
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        switch (charSequence.length()) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is(charSequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(charSequence.charAt(0), charSequence.charAt(1));
            }
        }
        return new c(charSequence);
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    public static CharMatcher inRange(char c2, char c3) {
        return new i(c2, c3);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        return predicate instanceof CharMatcher ? (CharMatcher)predicate : new h(predicate);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new u(this);
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new a(this, charMatcher);
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new x(this, charMatcher);
    }

    void setBits(BitSet bitSet) {
        for (int i2 = 65535; i2 >= 0; --i2) {
            if (!this.matches((char)i2)) continue;
            bitSet.set(i2);
        }
    }

    public boolean matchesAnyOf(CharSequence charSequence) {
        return !this.matchesNoneOf(charSequence);
    }

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        return this.indexIn(charSequence) == -1;
    }

    public int indexIn(CharSequence charSequence) {
        return this.indexIn(charSequence, 0);
    }

    public int indexIn(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        Preconditions.checkPositionIndex(n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            ++n2;
        }
        return n2;
    }

    public String removeFrom(CharSequence charSequence) {
        String string2 = charSequence.toString();
        int n2 = this.indexIn(string2);
        if (n2 == -1) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n3 = 1;
        block0: while (true) {
            ++n2;
            while (n2 != cArray.length) {
                if (!this.matches(cArray[n2])) {
                    cArray[n2 - n3] = cArray[n2];
                    ++n2;
                    continue;
                }
                ++n3;
                continue block0;
            }
            break;
        }
        return new String(cArray, 0, n2 - n3);
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    public String replaceFrom(CharSequence charSequence, char c2) {
        String string2 = charSequence.toString();
        int n2 = this.indexIn(string2);
        if (n2 == -1) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        cArray[n2] = c2;
        for (int i2 = n2 + 1; i2 < cArray.length; ++i2) {
            if (!this.matches(cArray[i2])) continue;
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = charSequence2.length();
        if (n2 == 0) {
            return this.removeFrom(charSequence);
        }
        if (n2 == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        String string2 = charSequence.toString();
        int n3 = this.indexIn(string2);
        if (n3 == -1) {
            return string2;
        }
        int n4 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 3 / 2 + 16);
        int n5 = 0;
        do {
            stringBuilder.append(string2, n5, n3);
            stringBuilder.append(charSequence2);
        } while ((n3 = this.indexIn(string2, n5 = n3 + 1)) != -1);
        stringBuilder.append(string2, n5, n4);
        return stringBuilder.toString();
    }

    public String trimFrom(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && this.matches(charSequence.charAt(n3)); ++n3) {
        }
        for (n2 = n4 - 1; n2 > n3 && this.matches(charSequence.charAt(n2)); --n2) {
        }
        return charSequence.subSequence(n3, n2 + 1).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(i2, n2).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(0, i2 + 1).toString();
        }
        return "";
    }

    public String collapseFrom(CharSequence charSequence, char c2) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (!this.matches(c3)) continue;
            if (!(c3 != c2 || i2 != n2 - 1 && this.matches(charSequence.charAt(i2 + 1)))) {
                ++i2;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(n2).append(charSequence, 0, i2).append(c2);
            return this.finishCollapseFrom(charSequence, i2 + 1, n2, c2, stringBuilder, true);
        }
        return charSequence.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c2) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        while (n4 > n2 && this.matches(charSequence.charAt(n4))) {
            --n4;
        }
        return n2 == 0 && n4 == n3 - 1 ? this.collapseFrom(charSequence, c2) : this.finishCollapseFrom(charSequence, n2, n4 + 1, c2, new StringBuilder(n4 + 1 - n2), false);
    }

    private String finishCollapseFrom(CharSequence charSequence, int n2, int n3, char c2, StringBuilder stringBuilder, boolean bl) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (this.matches(c3)) {
                if (bl) continue;
                stringBuilder.append(c2);
                bl = true;
                continue;
            }
            stringBuilder.append(c3);
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    @Deprecated
    public boolean apply(Character c2) {
        return this.matches(c2.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static String showCharacter(char c2) {
        String string2 = "0123456789ABCDEF";
        char[] cArray = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i2 = 0; i2 < 4; ++i2) {
            cArray[5 - i2] = string2.charAt(c2 & 0xF);
            c2 = (char)(c2 >> 4);
        }
        return String.copyValueOf(cArray);
    }

    private static l isEither(char c2, char c3) {
        return new l(c2, c3);
    }

    private static final class h
    extends CharMatcher {
        private final Predicate<? super Character> nO;

        h(Predicate<? super Character> predicate) {
            this.nO = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean matches(char c2) {
            return this.nO.apply(Character.valueOf(c2));
        }

        @Override
        public boolean apply(Character c2) {
            return this.nO.apply(Preconditions.checkNotNull(c2));
        }

        @Override
        public String toString() {
            return "CharMatcher.forPredicate(" + this.nO + ")";
        }
    }

    private static final class i
    extends g {
        private final char nP;
        private final char nQ;

        i(char c2, char c3) {
            Preconditions.checkArgument(c3 >= c2);
            this.nP = c2;
            this.nQ = c3;
        }

        @Override
        public boolean matches(char c2) {
            return this.nP <= c2 && c2 <= this.nQ;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set((int)this.nP, this.nQ + '\u0001');
        }

        @Override
        public String toString() {
            return "CharMatcher.inRange('" + CharMatcher.showCharacter(this.nP) + "', '" + CharMatcher.showCharacter(this.nQ) + "')";
        }
    }

    private static final class c
    extends CharMatcher {
        private final char[] nK;

        public c(CharSequence charSequence) {
            this.nK = charSequence.toString().toCharArray();
            Arrays.sort(this.nK);
        }

        @Override
        public boolean matches(char c2) {
            return Arrays.binarySearch(this.nK, c2) >= 0;
        }

        @Override
        void setBits(BitSet bitSet) {
            for (char c2 : this.nK) {
                bitSet.set(c2);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("CharMatcher.anyOf(\"");
            for (char c2 : this.nK) {
                stringBuilder.append(CharMatcher.showCharacter(c2));
            }
            stringBuilder.append("\")");
            return stringBuilder.toString();
        }
    }

    private static final class l
    extends g {
        private final char nT;
        private final char nU;

        l(char c2, char c3) {
            this.nT = c2;
            this.nU = c3;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.nT || c2 == this.nU;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.nT);
            bitSet.set(this.nU);
        }

        @Override
        public String toString() {
            return "CharMatcher.anyOf(\"" + CharMatcher.showCharacter(this.nT) + CharMatcher.showCharacter(this.nU) + "\")";
        }
    }

    private static final class m
    extends g {
        private final char nS;

        m(char c2) {
            this.nS = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 != this.nS;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return charMatcher.matches(this.nS) ? super.and(charMatcher) : charMatcher;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return charMatcher.matches(this.nS) ? m.any() : this;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(0, this.nS);
            bitSet.set(this.nS + '\u0001', 65536);
        }

        @Override
        public CharMatcher negate() {
            return m.is(this.nS);
        }

        @Override
        public String toString() {
            return "CharMatcher.isNot('" + CharMatcher.showCharacter(this.nS) + "')";
        }
    }

    private static final class k
    extends g {
        private final char nS;

        k(char c2) {
            this.nS = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.nS;
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString().replace(this.nS, c2);
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return charMatcher.matches(this.nS) ? this : k.none();
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return charMatcher.matches(this.nS) ? charMatcher : super.or(charMatcher);
        }

        @Override
        public CharMatcher negate() {
            return k.isNot(this.nS);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.nS);
        }

        @Override
        public String toString() {
            return "CharMatcher.is('" + CharMatcher.showCharacter(this.nS) + "')";
        }
    }

    private static final class x
    extends CharMatcher {
        final CharMatcher nH;
        final CharMatcher nI;

        x(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.nH = Preconditions.checkNotNull(charMatcher);
            this.nI = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        void setBits(BitSet bitSet) {
            this.nH.setBits(bitSet);
            this.nI.setBits(bitSet);
        }

        @Override
        public boolean matches(char c2) {
            return this.nH.matches(c2) || this.nI.matches(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.or(" + this.nH + ", " + this.nI + ")";
        }
    }

    private static final class a
    extends CharMatcher {
        final CharMatcher nH;
        final CharMatcher nI;

        a(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.nH = Preconditions.checkNotNull(charMatcher);
            this.nI = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        public boolean matches(char c2) {
            return this.nH.matches(c2) && this.nI.matches(c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.nH.setBits(bitSet2);
            BitSet bitSet3 = new BitSet();
            this.nI.setBits(bitSet3);
            bitSet2.and(bitSet3);
            bitSet.or(bitSet2);
        }

        @Override
        public String toString() {
            return "CharMatcher.and(" + this.nH + ", " + this.nI + ")";
        }
    }

    private static class u
    extends CharMatcher {
        final CharMatcher oc;

        u(CharMatcher charMatcher) {
            this.oc = Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public boolean matches(char c2) {
            return !this.oc.matches(c2);
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return this.oc.matchesNoneOf(charSequence);
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return this.oc.matchesAllOf(charSequence);
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length() - this.oc.countIn(charSequence);
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.oc.setBits(bitSet2);
            bitSet2.flip(0, 65536);
            bitSet.or(bitSet2);
        }

        @Override
        public CharMatcher negate() {
            return this.oc;
        }

        @Override
        public String toString() {
            return this.oc + ".negate()";
        }
    }

    private static final class z
    extends y {
        static final z og = new z();

        private z() {
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        }
    }

    private static final class j
    extends y {
        static final j nR = new j();

        private j() {
            super("CharMatcher.invisible()", "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9".toCharArray(), " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb".toCharArray());
        }
    }

    private static final class o
    extends t {
        static final o nW = new o();

        private o() {
            super("CharMatcher.javaIsoControl()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f';
        }
    }

    private static final class r
    extends CharMatcher {
        static final r nZ = new r();

        private r() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class s
    extends CharMatcher {
        static final s oa = new s();

        private s() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    private static final class q
    extends CharMatcher {
        static final q nY = new q();

        private q() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetterOrDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class p
    extends CharMatcher {
        static final p nX = new p();

        private p() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetter(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class n
    extends CharMatcher {
        static final n nV = new n();

        private n() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class f
    extends y {
        static final f nN = new f();

        private static char[] eV() {
            return "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".toCharArray();
        }

        private static char[] eW() {
            char[] cArray = new char["0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".length()];
            for (int i2 = 0; i2 < "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".length(); ++i2) {
                cArray[i2] = (char)("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10".charAt(i2) + 9);
            }
            return cArray;
        }

        private f() {
            super("CharMatcher.digit()", f.eV(), f.eW());
        }
    }

    private static class y
    extends CharMatcher {
        private final String ob;
        private final char[] oe;
        private final char[] of;

        y(String string2, char[] cArray, char[] cArray2) {
            this.ob = string2;
            this.oe = cArray;
            this.of = cArray2;
            Preconditions.checkArgument(cArray.length == cArray2.length);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                Preconditions.checkArgument(cArray[i2] <= cArray2[i2]);
                if (i2 + 1 >= cArray.length) continue;
                Preconditions.checkArgument(cArray2[i2] < cArray[i2 + 1]);
            }
        }

        @Override
        public boolean matches(char c2) {
            int n2 = Arrays.binarySearch(this.oe, c2);
            if (n2 >= 0) {
                return true;
            }
            return (n2 = ~n2 - 1) >= 0 && c2 <= this.of[n2];
        }

        @Override
        public String toString() {
            return this.ob;
        }
    }

    private static final class d
    extends t {
        static final d nL = new d();

        d() {
            super("CharMatcher.ascii()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u007f';
        }
    }

    private static final class e
    extends CharMatcher {
        static final CharMatcher nM = new e();

        private e() {
        }

        @Override
        public boolean matches(char c2) {
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c2 >= '\u2000' && c2 <= '\u200a';
        }

        @Override
        public String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    static final class aa
    extends t {
        static final int oh = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        static final aa oi = new aa();

        aa() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(1682554634 * c2 >>> oh) == c2;
        }

        @Override
        void setBits(BitSet bitSet) {
            for (int i2 = 0; i2 < "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length(); ++i2) {
                bitSet.set("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(i2));
            }
        }
    }

    private static final class w
    extends t {
        static final w od = new w();

        private w() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            Preconditions.checkPositionIndex(n2, n3);
            return -1;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            Preconditions.checkNotNull(charSequence2);
            return charSequence.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimLeadingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimTrailingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public int countIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return 0;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher negate() {
            return w.any();
        }
    }

    private static final class b
    extends t {
        static final b nJ = new b();

        private b() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            return charSequence.length() == 0 ? -1 : 0;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            Preconditions.checkPositionIndex(n2, n3);
            return n2 == n3 ? -1 : n2;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            return charSequence.length() - 1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            char[] cArray = new char[charSequence.length()];
            Arrays.fill(cArray, c2);
            return new String(cArray);
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length() * charSequence2.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                stringBuilder.append(charSequence2);
            }
            return stringBuilder.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.length() == 0 ? "" : String.valueOf(c2);
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length();
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher negate() {
            return b.none();
        }
    }

    static class v
    extends u {
        v(CharMatcher charMatcher) {
            super(charMatcher);
        }
    }

    static abstract class t
    extends g {
        private final String ob;

        t(String string2) {
            this.ob = Preconditions.checkNotNull(string2);
        }

        @Override
        public final String toString() {
            return this.ob;
        }
    }

    static abstract class g
    extends CharMatcher {
        g() {
        }

        @Override
        public CharMatcher negate() {
            return new v(this);
        }
    }
}

