/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.privacy.a.c;
import com.applovin.impl.privacy.a.d;
import com.applovin.impl.sdk.AppLovinSdkSettingsBase;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdkConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AppLovinSdkSettings
extends AppLovinSdkSettingsBase {
    private boolean aZL;
    private boolean it;
    private boolean aZM = true;
    private boolean aZN = true;
    private boolean aZO = true;
    private boolean aZP = true;
    private String aZQ;
    private final Map<String, Object> localSettings = new HashMap<String, Object>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private List<String> aZR = Collections.emptyList();
    private List<String> aZS = Collections.emptyList();
    private final Map<String, String> extraParameters = new HashMap<String, String>();
    private final Object aZT = new Object();
    @Nullable
    private n sdk;
    private String abm = "";

    public AppLovinSdkSettings(Context context) {
        if (context == null) {
            x.I("AppLovinSdkSettings", "context cannot be null. Please provide a valid context.");
        }
        Context context2 = t.am(context);
        this.aZL = t.ad(context2);
        this.backingConsentFlowSettings = c.D(context2);
        this.abm = context2.getPackageName();
        this.aq(context2);
    }

    public TermsAndPrivacyPolicyFlowSettings getTermsAndPrivacyPolicyFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayG);
        return this.backingConsentFlowSettings;
    }

    public void setTestDeviceAdvertisingIds(List<String> list) {
        x.logApiCall("AppLovinSdkSettings", "setTestDeviceAdvertisingIds(testDeviceAdvertisingIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                x.I("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.aZR = arrayList;
        } else {
            this.aZR = Collections.emptyList();
        }
    }

    public List<String> getTestDeviceAdvertisingIds() {
        return this.aZR;
    }

    public void setInitializationAdUnitIds(List<String> list) {
        x.logApiCall("AppLovinSdkSettings", "setInitializationAdUnitIds(initializationAdUnitIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                x.I("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.aZS = arrayList;
        } else {
            this.aZS = Collections.emptyList();
        }
    }

    public List<String> getInitializationAdUnitIds() {
        return this.aZS;
    }

    public void setVerboseLogging(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setVerboseLogging(isVerboseLoggingEnabled=" + bl + ")");
        if (t.Mt()) {
            x.I("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already.");
            if (t.ad(null) != bl) {
                x.I("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.aZL = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.aZL;
    }

    public boolean isMuted() {
        return this.it;
    }

    public void setMuted(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setMuted(muted=" + bl + ")");
        this.it = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setCreativeDebuggerEnabled(creativeDebuggerEnabled=" + bl + ")");
        if (this.aZM == bl) {
            return;
        }
        this.aZM = bl;
        if (this.sdk == null) {
            return;
        }
        if (bl) {
            this.sdk.CQ().tH();
        } else {
            this.sdk.CQ().tI();
        }
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.aZM;
    }

    public void setExceptionHandlerEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setExceptionHandlerEnabled(exceptionHandlerEnabled=" + bl + ")");
        this.aZN = bl;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.aZN;
    }

    public void setLocationCollectionEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setLocationCollectionEnabled(locationCollectionEnabled=" + bl + ")");
        this.aZO = bl;
    }

    public boolean isLocationCollectionEnabled() {
        return this.aZO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtraParameters() {
        Object object = this.aZT;
        synchronized (object) {
            return CollectionUtils.map(this.extraParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraParameter(String string2, @Nullable String string3) {
        String string4;
        x.logApiCall("AppLovinSdkSettings", "setExtraParameter(key=" + string2 + ", value=" + string3 + ")");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            x.I("AppLovinSdkSettings", "Failed to set extra parameter for null or empty key: " + string2);
            return;
        }
        String string5 = string4 = string3 != null ? string3.trim() : null;
        if ("test_mode_network".equalsIgnoreCase(string2)) {
            if (this.sdk != null) {
                if (StringUtils.isValidString(string4)) {
                    this.sdk.Dh().C(Arrays.asList(string4.split(",")));
                } else {
                    this.sdk.Dh().bT(null);
                }
            } else {
                this.aZQ = string4;
            }
        } else if ("fan".equals(string2) || "esc".equals(string2)) {
            if (!this.abm.startsWith("com.unity.")) {
                return;
            }
        } else if ("disable_all_logs".equals(string2)) {
            x.aO(Boolean.parseBoolean(string4));
        }
        Object object = this.aZT;
        synchronized (object) {
            this.extraParameters.put(string2, string4);
        }
    }

    public void setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(shouldFailAdDisplayIfDontKeepActivitiesIsEnabled=" + bl + ")");
        this.aZP = bl;
    }

    public boolean shouldFailAdDisplayIfDontKeepActivitiesIsEnabled() {
        return this.aZP;
    }

    protected void attachAppLovinSdk(n n2) {
        this.sdk = n2;
        if (StringUtils.isValidString(this.aZQ)) {
            n2.Dh().C(Arrays.asList(this.aZQ.split(",")));
            this.aZQ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DiscouragedApi"})
    private void aq(Context context) {
        int n2 = context.getResources().getIdentifier("applovin_settings", "raw", context.getPackageName());
        if (n2 == 0) {
            return;
        }
        String string2 = t.a(n2, context, null);
        JSONObject jSONObject = StringUtils.isValidString(string2) ? JsonUtils.jsonObjectFromJsonString(string2, new JSONObject()) : new JSONObject();
        Map<String, String> map = JsonUtils.tryToStringMap(jSONObject);
        Object object = this.aZT;
        synchronized (object) {
            this.extraParameters.putAll(map);
        }
    }

    @Deprecated
    public TermsFlowSettings getTermsFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayF);
        return this.backingConsentFlowSettings;
    }

    @NonNull
    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.aZL + ", muted=" + this.it + ", testDeviceAdvertisingIds=" + this.aZR.toString() + ", initializationAdUnitIds=" + this.aZS.toString() + ", creativeDebuggerEnabled=" + this.aZM + ", exceptionHandlerEnabled=" + this.aZN + ", locationCollectionEnabled=" + this.aZO + '}';
    }

    public static interface TermsFlowSettings {
        public boolean isEnabled();

        public void setEnabled(boolean var1);

        @Nullable
        public Uri getPrivacyPolicyUri();

        public void setPrivacyPolicyUri(Uri var1);

        @Nullable
        public Uri getTermsOfServiceUri();

        public void setTermsOfServiceUri(Uri var1);
    }

    public static interface TermsAndPrivacyPolicyFlowSettings
    extends TermsFlowSettings {
        public AppLovinSdkConfiguration.ConsentFlowUserGeography getDebugUserGeography();

        public void setDebugUserGeography(AppLovinSdkConfiguration.ConsentFlowUserGeography var1);
    }
}

