/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.ads.b;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.sdk.c.a;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.nativeAd.AppLovinStarRatingView;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.x;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MaxNativeAdView
extends FrameLayout {
    public static final String MEDIUM_TEMPLATE_1 = "medium_template_1";
    private final View mainView;
    private final TextView aYZ;
    private final TextView aZa;
    private final TextView aZb;
    private final Button aZc;
    private final ImageView aZd;
    private final FrameLayout aZe;
    private final ViewGroup aZf;
    private final FrameLayout aZg;
    private final ViewGroup aZh;
    private final ViewGroup aZi;
    private final FrameLayout aZj;
    @Nullable
    private b adViewTracker;

    public MaxNativeAdView(MaxNativeAd maxNativeAd, Activity activity) {
        this(maxNativeAd, (String)null, activity);
    }

    public MaxNativeAdView(String string2, Context context) {
        this(null, string2, context);
    }

    @Deprecated
    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Activity activity) {
        this(maxNativeAd, string2, activity.getApplicationContext());
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Context context) {
        this(maxNativeAd, new MaxNativeAdViewBinder.Builder(-1).setTemplateType(string2).setTitleTextViewId(R.id.applovin_native_title_text_view).setAdvertiserTextViewId(R.id.applovin_native_advertiser_text_view).setBodyTextViewId(R.id.applovin_native_body_text_view).setCallToActionButtonId(R.id.applovin_native_cta_button).setIconImageViewId(R.id.applovin_native_icon_image_view).setIconContentViewId(R.id.applovin_native_icon_view).setOptionsContentViewGroupId(R.id.applovin_native_options_view).setOptionsContentFrameLayoutId(R.id.applovin_native_options_view).setStarRatingContentViewGroupId(R.id.applovin_native_star_rating_view).setMediaContentViewGroupId(R.id.applovin_native_media_content_view).setMediaContentFrameLayoutId(R.id.applovin_native_media_content_view).build(), context);
    }

    public MaxNativeAdView(MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        this(null, maxNativeAdViewBinder, context);
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        super(context);
        MaxAdFormat maxAdFormat;
        boolean bl = maxNativeAdViewBinder.templateType != null;
        MaxAdFormat maxAdFormat2 = maxAdFormat = maxNativeAd != null ? maxNativeAd.getFormat() : MaxAdFormat.NATIVE;
        if (maxNativeAdViewBinder.mainView != null) {
            this.mainView = maxNativeAdViewBinder.mainView;
        } else {
            int n2 = bl ? this.b(maxNativeAdViewBinder.templateType, maxAdFormat) : maxNativeAdViewBinder.layoutResourceId;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            this.mainView = layoutInflater.inflate(n2, (ViewGroup)this, false);
        }
        this.addView(this.mainView);
        this.aYZ = (TextView)this.findViewById(maxNativeAdViewBinder.titleTextViewId);
        this.aZa = (TextView)this.findViewById(maxNativeAdViewBinder.advertiserTextViewId);
        this.aZb = (TextView)this.findViewById(maxNativeAdViewBinder.bodyTextViewId);
        this.aZc = (Button)this.findViewById(maxNativeAdViewBinder.callToActionButtonId);
        this.aZd = (ImageView)this.findViewById(maxNativeAdViewBinder.iconImageViewId);
        this.aZe = (FrameLayout)this.findViewById(maxNativeAdViewBinder.iconContentViewId);
        this.aZf = (ViewGroup)this.findViewById(maxNativeAdViewBinder.optionsContentViewGroupId);
        this.aZg = (FrameLayout)this.findViewById(maxNativeAdViewBinder.optionsContentFrameLayoutId);
        this.aZh = (ViewGroup)this.findViewById(maxNativeAdViewBinder.starRatingContentViewGroupId);
        this.aZi = (ViewGroup)this.findViewById(maxNativeAdViewBinder.mediaContentViewGroupId);
        this.aZj = (FrameLayout)this.findViewById(maxNativeAdViewBinder.mediaContentFrameLayoutId);
        if (maxNativeAd != null) {
            this.a(maxNativeAd);
        }
    }

    public void render(d d2, a.a a2, n n2) {
        this.recycle();
        if (!d2.yI().get() || !d2.yH().get()) {
            this.adViewTracker = new b(d2, (ViewGroup)this, a2, n2);
        }
        MaxNativeAd maxNativeAd = d2.getNativeAd();
        if (d2.isContainerClickable() && maxNativeAd.isContainerClickable()) {
            n2.Cq();
            if (x.FN()) {
                n2.Cq().f("MaxNativeAdView", "Enabling container click");
            }
            this.setOnClickListener(view -> maxNativeAd.performClick());
        }
        if (StringUtils.isValidString(d2.yG())) {
            n2.Cq();
            if (x.FN()) {
                n2.Cq().f("MaxNativeAdView", "Rendering template ad view");
            }
            this.a(maxNativeAd);
        } else {
            n2.Cq();
            if (x.FN()) {
                n2.Cq().f("MaxNativeAdView", "Rendering custom ad view");
            }
            this.renderCustomNativeAdView(maxNativeAd);
        }
    }

    public void recycle() {
        this.setOnClickListener(null);
        if (this.adViewTracker != null) {
            this.adViewTracker.destroy();
            this.adViewTracker = null;
        }
        if (this.mainView != null && this.mainView.getParent() != this) {
            ViewGroup viewGroup = (ViewGroup)this.mainView.getParent();
            if (viewGroup != null) {
                viewGroup.removeAllViews();
                this.removeView((View)viewGroup);
            }
            this.addView(this.mainView);
        }
    }

    @Nullable
    public b getAdViewTracker() {
        return this.adViewTracker;
    }

    private int b(String string2, MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.NATIVE) {
            if ("small_template_1".equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_small_template_1;
            }
            if (MEDIUM_TEMPLATE_1.equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_medium_template_1;
            }
            throw new IllegalArgumentException("Attempting to render MAX native ad with invalid format: " + string2);
        }
        if (maxAdFormat == MaxAdFormat.BANNER) {
            if ("vertical_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_banner_view;
            }
            if ("media_banner_template".equals(string2) || "no_body_banner_template".equals(string2)) {
                return R.layout.max_native_ad_media_banner_view;
            }
            if ("vertical_media_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_media_banner_view;
            }
            return R.layout.max_native_ad_banner_view;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            if ("vertical_leader_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_leader_view;
            }
            return R.layout.max_native_ad_leader_view;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return R.layout.max_native_ad_mrec_view;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + maxAdFormat);
    }

    private void a(MaxNativeAd maxNativeAd) {
        if (this.aYZ == null) {
            x.G("MaxNativeAdView", "Rendering template ad view without title text view");
        } else if (StringUtils.isValidString(maxNativeAd.getTitle())) {
            this.aYZ.setText((CharSequence)maxNativeAd.getTitle());
        } else {
            this.aYZ.setVisibility(8);
        }
        if (this.aZa != null) {
            if (StringUtils.isValidString(maxNativeAd.getAdvertiser())) {
                this.aZa.setText((CharSequence)maxNativeAd.getAdvertiser());
            } else {
                this.aZa.setVisibility(8);
            }
        }
        if (this.aZb != null) {
            if (StringUtils.isValidString(maxNativeAd.getBody())) {
                this.aZb.setText((CharSequence)maxNativeAd.getBody());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZb.setVisibility(8);
            } else {
                this.aZb.setVisibility(4);
            }
        }
        if (this.aZc != null) {
            if (StringUtils.isValidString(maxNativeAd.getCallToAction())) {
                this.aZc.setText((CharSequence)maxNativeAd.getCallToAction());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZc.setVisibility(8);
            } else {
                this.aZc.setVisibility(4);
            }
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        View view = maxNativeAd.getIconView();
        if (this.aZe != null) {
            if (maxNativeAdImage != null && this.aZd != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZd.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null && StringUtils.isValidString(maxNativeAdImage.getUri().toString())) {
                    if (n.aBt.a(a.aJW).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZd, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZd, maxNativeAdImage.getUri(), n.aBt);
                    }
                } else {
                    this.aZe.setVisibility(8);
                }
            } else if (view != null) {
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZe.removeAllViews();
                this.aZe.addView(view);
            } else {
                this.aZe.setVisibility(8);
            }
        }
        View view2 = maxNativeAd.getOptionsView();
        if (this.aZg != null && view2 != null) {
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.aZg.addView(view2);
            this.aZg.bringToFront();
        } else if (this.aZg != null) {
            this.aZg.setVisibility(8);
        }
        View view3 = maxNativeAd.getMediaView();
        if (this.aZj != null) {
            if (view3 != null) {
                view3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZj.addView(view3);
            } else if (maxNativeAd.getFormat() == MaxAdFormat.LEADER) {
                this.aZj.setVisibility(8);
            }
        }
        if (this.aZh != null) {
            Double d2 = maxNativeAd.getStarRating();
            if (d2 != null) {
                this.aZh.removeAllViews();
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView(d2, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZh.addView((View)appLovinStarRatingView);
            } else {
                this.aZh.setVisibility(8);
            }
        }
        this.NJ();
        this.postDelayed(() -> this.setSelected(true), 2000L);
    }

    public void renderCustomNativeAdView(MaxNativeAd maxNativeAd) {
        Object object;
        View view;
        if (this.aYZ != null) {
            this.aYZ.setText((CharSequence)maxNativeAd.getTitle());
        }
        if (this.aZb != null) {
            this.aZb.setText((CharSequence)maxNativeAd.getBody());
        }
        if (this.aZa != null) {
            this.aZa.setText((CharSequence)maxNativeAd.getAdvertiser());
        }
        if (this.aZc != null) {
            this.aZc.setText((CharSequence)maxNativeAd.getCallToAction());
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        if (this.aZd != null) {
            if (maxNativeAdImage != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZd.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null) {
                    if (n.aBt.a(a.aJW).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZd, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZd, maxNativeAdImage.getUri(), n.aBt);
                    }
                } else {
                    this.aZd.setImageDrawable(null);
                }
            } else {
                this.aZd.setImageDrawable(null);
            }
        }
        View view2 = maxNativeAd.getMediaView();
        if (this.aZi != null) {
            this.aZi.removeAllViews();
            if (view2 != null) {
                view = view2.getParent();
                if (view != null) {
                    ((ViewGroup)view).removeAllViews();
                }
                view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZi.addView(view2);
            }
        }
        view = maxNativeAd.getOptionsView();
        if (this.aZf != null) {
            this.aZf.removeAllViews();
            if (view != null) {
                object = view.getParent();
                if (object != null) {
                    ((ViewGroup)object).removeAllViews();
                }
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZf.addView(view);
                this.aZf.bringToFront();
            }
        }
        if (this.aZh != null) {
            this.aZh.removeAllViews();
            object = maxNativeAd.getStarRating();
            if (object != null) {
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView((Double)object, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZh.addView((View)appLovinStarRatingView);
            }
        }
    }

    private void NJ() {
        final ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.applovin_native_inner_parent_layout);
        if (viewGroup == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        final WeakReference<ViewTreeObserver> weakReference = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)weakReference.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                } else {
                    n.aBt.Cq();
                    if (x.FN()) {
                        n.aBt.Cq().h("MaxNativeAdView", "Failed to remove onPreDrawListener since the view tree observer is not alive.");
                    }
                }
                weakReference.clear();
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)viewGroup.getLayoutParams();
                layoutParams.height = ((View)viewGroup.getParent()).getWidth();
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return true;
            }
        });
    }

    public View getMainView() {
        return this.mainView;
    }

    public TextView getTitleTextView() {
        return this.aYZ;
    }

    public TextView getAdvertiserTextView() {
        return this.aZa;
    }

    public TextView getBodyTextView() {
        return this.aZb;
    }

    public Button getCallToActionButton() {
        return this.aZc;
    }

    public ImageView getIconImageView() {
        return this.aZd;
    }

    @Deprecated
    public FrameLayout getIconContentView() {
        return this.aZe;
    }

    public ViewGroup getOptionsContentViewGroup() {
        return this.aZf != null ? this.aZf : this.aZg;
    }

    @Deprecated
    public FrameLayout getOptionsContentView() {
        return this.aZg;
    }

    public ViewGroup getStarRatingContentViewGroup() {
        return this.aZh;
    }

    public ViewGroup getMediaContentViewGroup() {
        return this.aZi != null ? this.aZi : this.aZj;
    }

    @Deprecated
    public FrameLayout getMediaContentView() {
        return this.aZj;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.adViewTracker != null) {
            this.adViewTracker.uN();
        }
        if (!this.isHardwareAccelerated()) {
            x.G("MaxNativeAdView", "Attached to non-hardware accelerated window: some native ad views require hardware accelerated Activities to render properly.");
        }
    }

    public List<View> getClickableViews() {
        ArrayList<View> arrayList = new ArrayList<View>(5);
        if (this.aYZ != null) {
            arrayList.add((View)this.aYZ);
        }
        if (this.aZa != null) {
            arrayList.add((View)this.aZa);
        }
        if (this.aZb != null) {
            arrayList.add((View)this.aZb);
        }
        if (this.aZc != null) {
            arrayList.add((View)this.aZc);
        }
        if (this.aZd != null) {
            arrayList.add((View)this.aZd);
        }
        return arrayList;
    }
}

