/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.SensorManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.aa;
import com.applovin.impl.sdk.af;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.d.c;
import com.applovin.impl.sdk.e.ab;
import com.applovin.impl.sdk.e.d;
import com.applovin.impl.sdk.e.i;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.f;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.network.b;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.d;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.l;
import com.applovin.impl.sdk.utils.o;
import com.applovin.impl.sdk.utils.s;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.w;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinBidTokenCollectionListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class o {
    private final n sdk;
    private final x logger;
    private final Context E;
    private final Map<String, Object> aCV;
    private final Object aCW = new Object();
    private final Map<String, Object> awO;
    private boolean aCX;
    private static final AtomicReference<d.a> aCY = new AtomicReference();
    private final AtomicReference<Integer> aCZ = new AtomicReference();
    private static final AtomicReference<a> aDa = new AtomicReference();

    protected o(n n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.sdk = n2;
        this.logger = n2.Cq();
        this.E = n.getApplicationContext();
        this.aCV = this.Dw();
        this.awO = this.DA();
    }

    protected String getBidToken() {
        JSONObject jSONObject = new JSONObject(this.Dq());
        byte[] byArray = jSONObject.toString().getBytes(Charset.defaultCharset());
        String string2 = Base64.encodeToString((byte[])byArray, (int)2);
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQK).booleanValue()) {
            long l2 = t.Q(this.sdk);
            return com.applovin.impl.sdk.utils.o.a(string2, l2, o.a.gX(this.sdk.a(com.applovin.impl.sdk.c.b.aQL)), this.sdk.getSdkKey(), this.sdk);
        }
        return string2;
    }

    protected void collectBidToken(AppLovinBidTokenCollectionListener appLovinBidTokenCollectionListener) {
        Boolean bl = this.sdk.a(com.applovin.impl.sdk.c.b.aPu);
        this.sdk.Cr().a((d)new ab(this.sdk, bl, "DataCollector", () -> {
            String string2;
            try {
                string2 = this.getBidToken();
            }
            catch (Throwable throwable) {
                String string3 = "Failed to collect bid token";
                o o2 = this;
                if (o2.logger.FN()) {
                    this.logger.c("DataCollector", "Failed to collect bid token", throwable);
                }
                this.sdk.CU().d("DataCollector", "collectBidToken", throwable);
                l.b(appLovinBidTokenCollectionListener, "Failed to collect bid token");
                return;
            }
            if (StringUtils.isValidString(string2)) {
                this.sdk.Cq();
                if (x.FN()) {
                    this.sdk.Cq().f("DataCollector", "Successfully retrieved bid token");
                }
                l.a(appLovinBidTokenCollectionListener, string2);
            } else {
                String string4 = "Empty bid token";
                this.sdk.Cq();
                if (x.FN()) {
                    this.sdk.Cq().i("DataCollector", "Empty bid token");
                }
                l.b(appLovinBidTokenCollectionListener, "Empty bid token");
            }
        }), q.a.aVa);
    }

    private Map<String, String> Dq() {
        return t.r(this.a(null, true, false));
    }

    public Map<String, Object> a(@Nullable Map<String, String> map, boolean bl, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(64);
        Map<String, Object> map2 = this.aM(bl);
        Map<String, Object> map3 = this.Dz();
        Map<String, Object> map4 = this.DD();
        Map<String, Object> map5 = this.DE();
        Map<String, String> map6 = this.sdk.BY().getAllData();
        if (bl2) {
            hashMap.put("device_info", map2);
            hashMap.put("app_info", map3);
            if (map4 != null) {
                hashMap.put("connection_info", map4);
            }
            if (map != null) {
                hashMap.put("ad_info", map);
            }
            if (map5 != null) {
                hashMap.put("location_info", map5);
            }
            if (!map6.isEmpty()) {
                hashMap.put("targeting_data", map6);
            }
        } else {
            hashMap.putAll(map2);
            hashMap.putAll(map3);
            if (map4 != null) {
                hashMap.putAll(map4);
            }
            if (map != null) {
                hashMap.putAll(map);
            }
            if (map5 != null) {
                hashMap.putAll(map5);
            }
            if (!map6.isEmpty()) {
                hashMap.putAll(map6);
            }
        }
        hashMap.put("accept", "custom_size,launch_app,video");
        hashMap.put("format", "json");
        CollectionUtils.putStringIfValid("mediation_provider", this.sdk.getMediationProvider(), hashMap);
        CollectionUtils.putStringIfValid("mediation_provider_v2", this.sdk.Dj(), hashMap);
        CollectionUtils.putStringIfValid("plugin_version", this.sdk.a(com.applovin.impl.sdk.c.b.aPt), hashMap);
        CollectionUtils.putLongIfValid("tssf_ms", this.sdk.BU(), hashMap);
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aQI).booleanValue()) {
            hashMap.put("sdk_key", this.sdk.getSdkKey());
        }
        hashMap.putAll(this.DC());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQi).booleanValue()) {
            com.applovin.impl.sdk.d.d d2 = this.sdk.Cu();
            hashMap.put("li", d2.b(c.aTj));
            hashMap.put("si", d2.b(c.aTm));
            hashMap.put("mad", d2.b(c.aTk));
            hashMap.put("msad", d2.b(c.aTn));
            hashMap.put("pf", d2.b(c.aTr));
            hashMap.put("mpf", d2.b(c.aTy));
            hashMap.put("gpf", d2.b(c.aTs));
            hashMap.put("asoac", d2.b(c.aTw));
        }
        hashMap.put("rid", UUID.randomUUID().toString());
        return hashMap;
    }

    public Map<String, Object> Dr() {
        return CollectionUtils.map(this.aCV);
    }

    public Map<String, Object> Ds() {
        return CollectionUtils.map(this.awO);
    }

    public Map<String, Object> Dt() {
        return this.aM(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aM(boolean bl) {
        Map<String, Object> map;
        Object object = this.aCW;
        synchronized (object) {
            map = CollectionUtils.map(this.aCV);
        }
        return this.a(map, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Du() {
        Object object = this.aCW;
        synchronized (object) {
            this.g(this.aCV);
        }
    }

    public String Dv() {
        return AppLovinSdkUtils.isFireOS(this.E) ? "fireos" : "android";
    }

    private Map<String, Object> Dw() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(34);
        hashMap.put("api_level", Build.VERSION.SDK_INT);
        hashMap.put("brand", Build.MANUFACTURER);
        hashMap.put("brand_name", Build.BRAND);
        hashMap.put("hardware", Build.HARDWARE);
        hashMap.put("sim", AppLovinSdkUtils.isEmulator());
        hashMap.put("aida", com.applovin.impl.sdk.utils.d.LL());
        hashMap.put("locale", Locale.getDefault().toString());
        hashMap.put("model", Build.MODEL);
        hashMap.put("os", Build.VERSION.RELEASE);
        hashMap.put("platform", this.Dv());
        hashMap.put("revision", Build.DEVICE);
        hashMap.put("tz_offset", this.DQ());
        hashMap.put("gy", this.DR());
        hashMap.put("country_code", this.DS());
        hashMap.put("mcc", this.DT());
        hashMap.put("mnc", this.DU());
        hashMap.put("carrier", this.DV());
        hashMap.put("is_tablet", AppLovinSdkUtils.isTablet(this.E));
        hashMap.put("tv", AppLovinSdkUtils.isTv(this.E));
        hashMap.put("pc", Runtime.getRuntime().availableProcessors());
        hashMap.put("hdr", this.DX());
        hashMap.put("supported_abis", this.DY());
        DisplayMetrics displayMetrics = this.E.getResources().getDisplayMetrics();
        if (displayMetrics != null) {
            hashMap.put("adns", Float.valueOf(displayMetrics.density));
            hashMap.put("adnsd", displayMetrics.densityDpi);
            hashMap.put("xdpi", Float.valueOf(displayMetrics.xdpi));
            hashMap.put("ydpi", Float.valueOf(displayMetrics.ydpi));
            Point point = h.X(this.E);
            double d2 = Math.sqrt(Math.pow(point.x, 2.0) + Math.pow(point.y, 2.0));
            hashMap.put("screen_size_in", d2 / (double)displayMetrics.xdpi);
            h.a a2 = h.a(this.E, this.sdk);
            if (a2 != null) {
                hashMap.put("tl_cr", a2.Me());
                hashMap.put("tr_cr", a2.Mf());
                hashMap.put("bl_cr", a2.Mg());
                hashMap.put("br_cr", a2.Mh());
            }
        }
        hashMap.put("bt_ms", System.currentTimeMillis() - SystemClock.elapsedRealtime());
        hashMap.put("tbalsi_ms", this.sdk.Ck() - n.Ci());
        CollectionUtils.putBooleanIfValid("psase", aa.L(this.E), hashMap);
        CollectionUtils.putStringIfValid("process_name", t.an(this.E), hashMap);
        CollectionUtils.putBooleanIfValid("is_main_process", t.ao(this.E), hashMap);
        this.g(hashMap);
        return hashMap;
    }

    private void g(Map<String, Object> map) {
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPB).booleanValue() && !map.containsKey("af")) {
            map.put("af", this.DJ());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPC).booleanValue() && !map.containsKey("font")) {
            map.put("font", Float.valueOf(this.DK()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPJ).booleanValue() && t.U(this.sdk)) {
            af.A(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPW).booleanValue()) {
            af.B(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPI).booleanValue() && !map.containsKey("sua")) {
            map.put("sua", System.getProperty("http.agent"));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPE).booleanValue() && !map.containsKey("network_restricted")) {
            map.put("network_restricted", this.DF());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPM).booleanValue()) {
            boolean bl = this.E.getResources().getConfiguration().keyboard == 2;
            boolean bl2 = this.E.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
            boolean bl3 = this.E.getPackageManager().hasSystemFeature("android.hardware.type.pc");
            map.put("is_pc", bl && (bl2 || bl3));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPY).booleanValue()) {
            CollectionUtils.putStringIfValid("oglv", this.DZ(), map);
        }
    }

    private Map<String, Object> a(Map<String, Object> map, boolean bl) {
        ArrayService arrayService;
        PowerManager powerManager;
        String string2;
        Map<String, Object> map2;
        block38: {
            block37: {
                block36: {
                    Object object;
                    Boolean bl2;
                    Boolean bl3;
                    Boolean bl4;
                    Object object2;
                    Object object3;
                    map2 = CollectionUtils.map(map);
                    Point point = h.X(this.E);
                    map2.put("dx", point.x);
                    map2.put("dy", point.y);
                    if (bl) {
                        object3 = aCY.get();
                        if (object3 != null) {
                            object2 = object3;
                            this.Ec();
                        } else if (t.Mu()) {
                            object2 = new d.a();
                            map2.put("inc", true);
                        } else {
                            object2 = this.DG();
                        }
                    } else {
                        object2 = this.DG();
                    }
                    object3 = ((d.a)object2).LN();
                    if (StringUtils.isValidString((String)object3)) {
                        map2.put("idfa", object3);
                    }
                    map2.put("dnt", ((d.a)object2).LM());
                    map2.put("dnt_code", ((d.a)object2).LO().LP());
                    a a2 = aDa.get();
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPi).booleanValue() && a2 != null) {
                        map2.put("idfv", a2.do);
                        map2.put("idfv_scope", a2.aDc);
                    }
                    if ((bl4 = com.applovin.impl.privacy.a.Aj().B(this.E)) != null) {
                        map2.put("huc", bl4);
                    }
                    if ((bl3 = com.applovin.impl.privacy.a.Ai().B(this.E)) != null) {
                        map2.put("aru", bl3);
                    }
                    if ((bl2 = com.applovin.impl.privacy.a.Ak().B(this.E)) != null) {
                        map2.put("dns", bl2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPv).booleanValue()) {
                        object = this.DI();
                        CollectionUtils.putIntegerIfValid("act", ((b)object).aDd, map2);
                        CollectionUtils.putIntegerIfValid("acm", ((b)object).adn, map2);
                        CollectionUtils.putBooleanIfValid("sowpie", ((b)object).aDe, map2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPD).booleanValue()) {
                        map2.put("mtl", this.sdk.CH().getLastTrimMemoryLevel());
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPG).booleanValue()) {
                        map2.put("adr", this.DW());
                    }
                    Object object4 = object = bl ? this.aCZ.get() : this.DN();
                    if (object != null) {
                        map2.put("volume", object);
                    }
                    CollectionUtils.putBooleanIfValid("ma", this.DO(), map2);
                    CollectionUtils.putBooleanIfValid("spo", this.DP(), map2);
                    CollectionUtils.putBooleanIfValid("aif", !this.sdk.CH().isApplicationPaused(), map2);
                    CollectionUtils.putLongIfValid("af_ts_ms", this.sdk.CH().getAppEnteredForegroundTimeMillis(), map2);
                    CollectionUtils.putLongIfValid("ab_ts_ms", this.sdk.CH().getAppEnteredBackgroundTimeMillis(), map2);
                    try {
                        int n2 = Settings.System.getInt((ContentResolver)this.E.getContentResolver(), (String)"screen_brightness");
                        float f2 = (float)n2 / 255.0f;
                        map2.put("sb", (int)(f2 * 100.0f));
                    }
                    catch (Settings.SettingNotFoundException settingNotFoundException) {
                        o o2 = this;
                        if (!o2.logger.FN()) break block36;
                        this.logger.c("DataCollector", "Unable to collect screen brightness", settingNotFoundException);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aPJ).booleanValue() && t.U(this.sdk)) {
                    af.A(this.sdk);
                    String string3 = af.FY();
                    if (StringUtils.isValidString(string3)) {
                        map2.put("ua", string3);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aPW).booleanValue()) {
                    af.B(this.sdk);
                    CollectionUtils.putIntegerIfValid("wvvc", af.Ga(), map2);
                    CollectionUtils.putStringIfValid("wvv", af.Gb(), map2);
                    CollectionUtils.putStringIfValid("wvpn", af.Gc(), map2);
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aPx).booleanValue()) {
                    try {
                        map2.put("fs", Environment.getDataDirectory().getFreeSpace());
                        map2.put("tds", Environment.getDataDirectory().getTotalSpace());
                    }
                    catch (Throwable throwable) {
                        map2.put("fs", -1);
                        map2.put("tds", -1);
                        o o3 = this;
                        if (!o3.logger.FN()) break block37;
                        this.logger.c("DataCollector", "Unable to collect total & free space.", throwable);
                    }
                }
            }
            if (this.sdk.a(com.applovin.impl.sdk.c.b.aPy).booleanValue()) {
                ActivityManager activityManager = (ActivityManager)this.E.getSystemService("activity");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                if (activityManager != null) {
                    try {
                        activityManager.getMemoryInfo(memoryInfo);
                        map2.put("fm", memoryInfo.availMem);
                        map2.put("tm", memoryInfo.totalMem);
                        map2.put("lmt", memoryInfo.threshold);
                        map2.put("lm", memoryInfo.lowMemory);
                    }
                    catch (Throwable throwable) {
                        map2.put("fm", -1);
                        map2.put("tm", -1);
                        map2.put("lmt", -1);
                        o o4 = this;
                        if (!o4.logger.FN()) break block38;
                        this.logger.c("DataCollector", "Unable to collect memory info.", throwable);
                    }
                }
            }
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPz).booleanValue() && h.d("android.permission.READ_PHONE_STATE", this.E) && h.LW()) {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            int n3 = telephonyManager.getDataNetworkType();
            map2.put("rat", n3);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPw).booleanValue() && !TextUtils.isEmpty((CharSequence)(string2 = this.DL()))) {
            map2.put("so", string2);
        }
        map2.put("orientation_lock", this.Dx());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPA).booleanValue()) {
            map2.put("vs", t.Mw());
        }
        if (h.LU() && (powerManager = (PowerManager)this.E.getSystemService("power")) != null) {
            map2.put("lpm", powerManager.isPowerSaveMode() ? 1 : 0);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPK).booleanValue() && this.sdk.CM() != null) {
            map2.put("da", Float.valueOf(this.sdk.CM().Mp()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPL).booleanValue() && this.sdk.CM() != null) {
            map2.put("dm", Float.valueOf(this.sdk.CM().Mo()));
        }
        map2.put("mute_switch", this.sdk.CN().Bs());
        map2.put("network", com.applovin.impl.sdk.utils.i.J(this.sdk));
        String string4 = this.DM();
        if (StringUtils.isValidString(string4)) {
            map2.put("kb", string4);
        }
        if ((arrayService = this.sdk.CT()).isAppHubInstalled()) {
            if (arrayService.getIsDirectDownloadEnabled() != null) {
                map2.put("ah_dd_enabled", arrayService.getIsDirectDownloadEnabled());
            }
            map2.put("ah_sdk_version_code", arrayService.getAppHubVersionCode());
            map2.put("ah_random_user_token", StringUtils.emptyIfNull(arrayService.getRandomUserToken()));
            map2.put("ah_sdk_package_name", StringUtils.emptyIfNull(arrayService.getAppHubPackageName()));
        }
        return map2;
    }

    private String Dx() {
        String string2 = "none";
        int n2 = AppLovinSdkUtils.getOrientation(this.E);
        if (n2 == 1) {
            string2 = "portrait";
        } else if (n2 == 2) {
            string2 = "landscape";
        }
        return string2;
    }

    public boolean Dy() {
        return this.aCX;
    }

    public Map<String, Object> Dz() {
        String string2;
        Map<String, Object> map = CollectionUtils.map(this.awO);
        map.put("first_install", this.sdk.Di());
        map.put("first_install_v2", !this.sdk.Cd());
        map.put("test_ads", this.aCX);
        map.put("muted", this.sdk.getSettings().isMuted());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPj).booleanValue()) {
            CollectionUtils.putStringIfValid("cuid", this.sdk.BV(), map);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPm).booleanValue()) {
            map.put("compass_random_token", this.sdk.BW());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPo).booleanValue()) {
            map.put("applovin_random_token", this.sdk.BX());
        }
        if (StringUtils.isValidString(string2 = this.sdk.getUserSegment().getName())) {
            map.put("user_segment_name", string2);
        }
        map.putAll(this.DB());
        if (this.sdk.CA() != null) {
            CollectionUtils.putJsonArrayIfValid("ps_topics", this.sdk.CA().FT(), map);
        }
        return map;
    }

    private Map<String, Object> DA() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PackageManager packageManager = this.E.getPackageManager();
        ApplicationInfo applicationInfo = this.E.getApplicationInfo();
        File file = new File(applicationInfo.sourceDir);
        long l2 = file.lastModified();
        PackageInfo packageInfo = null;
        String string2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.E.getPackageName(), 0);
            string2 = packageManager.getInstallerPackageName(applicationInfo.packageName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put("app_name", packageManager.getApplicationLabel(applicationInfo));
        hashMap.put("app_version", packageInfo != null ? packageInfo.versionName : "");
        hashMap.put("app_version_code", packageInfo != null ? packageInfo.versionCode : -1);
        hashMap.put("package_name", applicationInfo.packageName);
        hashMap.put("vz", StringUtils.toShortSHA1Hash(applicationInfo.packageName));
        hashMap.put("installer_name", string2 != null ? string2 : "");
        hashMap.put("tg", s.P(this.sdk));
        hashMap.put("debug", t.R(this.sdk));
        hashMap.put("ia", l2);
        hashMap.put("alts_ms", n.Ci());
        hashMap.put("j8", n.Cj());
        hashMap.put("ps_tpg", aa.N(this.E));
        hashMap.put("ps_apg", aa.O(this.E));
        hashMap.put("ps_capg", aa.P(this.E));
        hashMap.put("ps_aipg", aa.Q(this.E));
        Long l3 = this.sdk.a(com.applovin.impl.sdk.c.d.aSi);
        if (l3 != null) {
            hashMap.put("ia_v2", l3);
        } else {
            this.sdk.a(com.applovin.impl.sdk.c.d.aSi, l2);
        }
        hashMap.put("sdk_version", AppLovinSdk.VERSION);
        hashMap.put("omid_sdk_version", this.sdk.CR().getSdkVersion());
        CollectionUtils.putStringIfValid("ad_review_sdk_version", f.getVersion(), hashMap);
        hashMap.put("api_did", this.sdk.a(com.applovin.impl.sdk.c.b.aKF));
        hashMap.put("first_install_v3_ms", packageInfo != null ? Long.valueOf(packageInfo.firstInstallTime) : "");
        hashMap.put("target_sdk", applicationInfo.targetSdkVersion);
        hashMap.put("epv", t.Mz());
        return hashMap;
    }

    private Map<String, Object> DB() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CollectionUtils.putIntegerIfValid("IABTCF_gdprApplies", this.sdk.CP().AO(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_TCString", this.sdk.CP().AP(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_AddtlConsent", this.sdk.CP().AQ(), hashMap);
        return hashMap;
    }

    public Map<String, Object> DC() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sc", this.sdk.a(com.applovin.impl.sdk.c.b.aKP));
        hashMap.put("sc2", this.sdk.a(com.applovin.impl.sdk.c.b.aKQ));
        hashMap.put("sc3", this.sdk.a(com.applovin.impl.sdk.c.b.aKR));
        hashMap.put("server_installed_at", this.sdk.a(com.applovin.impl.sdk.c.b.aKS));
        String string2 = this.sdk.a(com.applovin.impl.sdk.c.d.aSK);
        CollectionUtils.putStringIfValid("persisted_data", string2, hashMap);
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DD() {
        b.c c2 = this.sdk.Ct().IJ();
        if (c2 == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("lrm_ts_ms", String.valueOf(c2.IL()));
        hashMap.put("lrm_url", c2.IM());
        hashMap.put("lrm_ct_ms", String.valueOf(c2.IO()));
        hashMap.put("lrm_rs", String.valueOf(c2.IN()));
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DE() {
        if (!this.sdk.getSettings().isLocationCollectionEnabled()) {
            return null;
        }
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aQf).booleanValue()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        w w2 = this.sdk.CS();
        boolean bl = w2.FI();
        hashMap.put("loc_services_enabled", bl);
        if (!bl) {
            return hashMap;
        }
        hashMap.put("loc_auth", w2.FH());
        if (w2.FJ()) {
            hashMap.put("loc_lat", t.a(w2.FL(), this.sdk.a(com.applovin.impl.sdk.c.b.aQh)));
            hashMap.put("loc_long", t.a(w2.FM(), this.sdk.a(com.applovin.impl.sdk.c.b.aQh)));
        }
        return hashMap;
    }

    private boolean DF() {
        block4: {
            if (!h.LW()) {
                return false;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.E.getSystemService("connectivity");
            if (connectivityManager != null) {
                try {
                    int n2 = connectivityManager.getRestrictBackgroundStatus();
                    return n2 == 3;
                }
                catch (Throwable throwable) {
                    this.sdk.Cq();
                    if (!x.FN()) break block4;
                    this.sdk.Cq().c("DataCollector", "Unable to collect constrained network info.", throwable);
                }
            }
        }
        return false;
    }

    public d.a DG() {
        d.a a2 = com.applovin.impl.sdk.utils.d.T(this.E);
        if (a2 == null) {
            return new d.a();
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPh).booleanValue()) {
            boolean bl = a2.LM();
            if (bl && !this.sdk.a(com.applovin.impl.sdk.c.b.aPg).booleanValue()) {
                a2.dE("");
            }
            aCY.set(a2);
        } else {
            a2 = new d.a();
        }
        List<String> list = this.sdk.getSettings().getTestDeviceAdvertisingIds();
        if (list != null) {
            a a3;
            String string2;
            String string3 = a2.LN();
            if (StringUtils.isValidString(string3)) {
                this.aCX = list.contains(string3);
            }
            String string4 = string2 = (a3 = this.DH()) != null ? a3.do : null;
            if (StringUtils.isValidString(string2)) {
                this.aCX |= list.contains(string2);
            }
        } else {
            this.aCX = false;
        }
        return a2;
    }

    public static void a(d.a a2) {
        aCY.set(a2);
    }

    @Nullable
    public a DH() {
        return aDa.get();
    }

    public static void a(a a2) {
        aDa.set(a2);
    }

    private b DI() {
        int n2;
        int n3;
        int n4;
        b b2 = new b();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.E.registerReceiver(null, intentFilter);
        int n5 = intent != null ? intent.getIntExtra("level", -1) : -1;
        int n6 = n4 = intent != null ? intent.getIntExtra("scale", -1) : -1;
        if (n5 > 0 && n4 > 0) {
            float f2 = (float)n5 / (float)n4;
            b2.adn = (int)(f2 * 100.0f);
        } else {
            b2.adn = -1;
        }
        int n7 = b2.aDd = intent != null ? intent.getIntExtra("status", -1) : -1;
        b2.aDe = h.LS() ? Boolean.valueOf(Settings.Global.getInt((ContentResolver)this.E.getContentResolver(), (String)"stay_on_while_plugged_in", (int)-1) > 0) : Boolean.valueOf((n3 = (n2 = intent.getIntExtra("plugged", -1)) & 1 | 2 | 4 | 8) > 0);
        return b2;
    }

    private long DJ() {
        int n2;
        int n3;
        String string2 = StringUtils.emptyIfNull(Settings.Secure.getString((ContentResolver)this.E.getContentResolver(), (String)"enabled_accessibility_services"));
        List<String> list = Arrays.asList(string2.split(":"));
        long l2 = 0L;
        if (list.contains("AccessibilityMenuService")) {
            l2 |= 0x100L;
        }
        if (list.contains("SelectToSpeakService")) {
            l2 |= 0x200L;
        }
        if (list.contains("SoundAmplifierService")) {
            l2 |= 2L;
        }
        if (list.contains("SpeechToTextAccessibilityService")) {
            l2 |= 0x80L;
        }
        if (list.contains("SwitchAccessService")) {
            l2 |= 4L;
        }
        if ((n3 = this.E.getResources().getConfiguration().uiMode & 0x30) == 32) {
            l2 |= 0x400L;
        }
        if (this.cD("accessibility_enabled")) {
            l2 |= 8L;
        }
        if (this.cD("touch_exploration_enabled")) {
            l2 |= 0x10L;
        }
        if (h.LU()) {
            if (this.cD("accessibility_display_inversion_enabled")) {
                l2 |= 0x20L;
            }
            if (this.cD("skip_first_use_hints")) {
                l2 |= 0x40L;
            }
        }
        if (this.cD("lock_screen_allow_remote_input")) {
            l2 |= 0x800L;
        }
        if (this.cD("enabled_accessibility_audio_description_by_default")) {
            l2 |= 0x1000L;
        }
        if (this.cD("accessibility_shortcut_on_lock_screen")) {
            l2 |= 0x2000L;
        }
        if (this.cD("wear_talkback_enabled")) {
            l2 |= 0x4000L;
        }
        if (this.cD("hush_gesture_used")) {
            l2 |= 0x8000L;
        }
        if (this.cD("high_text_contrast_enabled")) {
            l2 |= 0x10000L;
        }
        if (this.cD("accessibility_display_magnification_enabled")) {
            l2 |= 0x20000L;
        }
        if (this.cD("accessibility_display_magnification_navbar_enabled")) {
            l2 |= 0x40000L;
        }
        if (this.cD("accessibility_captioning_enabled")) {
            l2 |= 0x80000L;
        }
        if (this.cD("accessibility_display_daltonizer_enabled")) {
            l2 |= 0x100000L;
        }
        if (this.cD("accessibility_autoclick_enabled")) {
            l2 |= 0x200000L;
        }
        if (this.cD("accessibility_large_pointer_icon")) {
            l2 |= 0x400000L;
        }
        if (this.cD("reduce_bright_colors_activated")) {
            l2 |= 0x800000L;
        }
        if (this.cD("reduce_bright_colors_persist_across_reboots")) {
            l2 |= 0x1000000L;
        }
        if (this.cD("tty_mode_enabled")) {
            l2 |= 0x2000000L;
        }
        if (this.cD("rtt_calling_mode")) {
            l2 |= 0x4000000L;
        }
        if (this.cD("accessibility_floating_menu_fade_enabled")) {
            l2 |= 0x8000000L;
        }
        if (this.cD("accessibility_show_window_magnification_prompt")) {
            l2 |= 0x10000000L;
        }
        if (this.cD("accessibility_floating_menu_migration_tooltip_prompt")) {
            l2 |= 0x20000000L;
        }
        if ((n2 = this.cE("accessibility_magnification_mode")) == 0) {
            l2 |= 0x40000000L;
        } else if (n2 == 1) {
            l2 |= 0x80000000L;
        } else if (n2 == 2) {
            l2 |= 0x100000000L;
        } else if (n2 == 3) {
            l2 |= 0x200000000L;
        }
        int n4 = this.cE("accessibility_button_mode");
        if (n4 == 0) {
            l2 |= 0x400000000L;
        } else if (n4 == 1) {
            l2 |= 0x800000000L;
        }
        int n5 = this.cE("accessibility_floating_menu_size");
        if (n5 == 0) {
            l2 |= 0x1000000000L;
        } else if (n5 == 1) {
            l2 |= 0x2000000000L;
        }
        int n6 = this.cE("accessibility_floating_menu_icon_type");
        if (n6 == 0) {
            l2 |= 0x4000000000L;
        } else if (n6 == 1) {
            l2 |= 0x8000000000L;
        }
        return l2;
    }

    private boolean cD(String string2) {
        return this.cE(string2) == 1;
    }

    private int cE(String string2) {
        try {
            return Settings.Secure.getInt((ContentResolver)this.E.getContentResolver(), (String)string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private float DK() {
        try {
            return Settings.System.getFloat((ContentResolver)this.E.getContentResolver(), (String)"font_scale");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            o o2 = this;
            if (o2.logger.FN()) {
                this.logger.c("DataCollector", "Error collecting font scale", settingNotFoundException);
            }
            return -1.0f;
        }
    }

    private String DL() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (h.LV()) {
                for (AudioDeviceInfo audioDeviceInfo : object = audioManager.getDevices(2)) {
                    stringBuilder.append(audioDeviceInfo.getType());
                    stringBuilder.append(",");
                }
            } else {
                if (audioManager.isWiredHeadsetOn()) {
                    stringBuilder.append(3);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothScoOn()) {
                    stringBuilder.append(7);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothA2dpOn()) {
                    stringBuilder.append(8);
                }
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)(object = stringBuilder.toString()))) {
                o o2 = this;
                if (o2.logger.FN()) {
                    this.logger.f("DataCollector", "No sound outputs detected");
                }
            }
            return object;
        }
        return null;
    }

    private String DM() {
        if (!h.LW()) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            LocaleList localeList = this.E.getResources().getConfiguration().getLocales();
            for (int i2 = 0; i2 < localeList.size(); ++i2) {
                stringBuilder.append(localeList.get(i2));
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private Integer DN() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        Float f2 = this.sdk.a(com.applovin.impl.sdk.c.b.aPH);
        try {
            return (int)((float)audioManager.getStreamVolume(3) * f2.floatValue());
        }
        catch (Throwable throwable) {
            this.sdk.Cq();
            if (x.FN()) {
                this.sdk.Cq().c("DataCollector", "Unable to collect device volume", throwable);
            }
            return null;
        }
    }

    @Nullable
    private Boolean DO() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isMusicActive();
    }

    @Nullable
    private Boolean DP() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isSpeakerphoneOn();
    }

    private double DQ() {
        TimeZone timeZone = TimeZone.getDefault();
        Date date = new Date();
        double d2 = timeZone.getOffset(date.getTime());
        return (double)Math.round(10.0 * d2 / 3600000.0) / 10.0;
    }

    private boolean DR() {
        SensorManager sensorManager = (SensorManager)this.E.getSystemService("sensor");
        return sensorManager != null && sensorManager.getDefaultSensor(4) != null;
    }

    private String DS() {
        TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimCountryIso().toUpperCase(Locale.ENGLISH) : "";
    }

    private String DT() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(0, n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FN()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile country code", throwable);
                }
            }
        }
        return "";
    }

    private String DU() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FN()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile network code", throwable);
                }
            }
        }
        return "";
    }

    private String DV() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    return telephonyManager.getNetworkOperatorName();
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FN()) break block3;
                    this.logger.c("DataCollector", "Unable to collect carrier", throwable);
                }
            }
        }
        return "";
    }

    private boolean DW() {
        try {
            return this.Ea() || this.Eb();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Nullable
    private Boolean DX() {
        if (!h.LX()) {
            return null;
        }
        return this.E.getResources().getConfiguration().isScreenHdr();
    }

    private JSONArray DY() {
        if (h.LU()) {
            return CollectionUtils.toJSONArray(Build.SUPPORTED_ABIS);
        }
        JSONArray jSONArray = new JSONArray();
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI);
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI2);
        return jSONArray;
    }

    @Nullable
    public String DZ() {
        ActivityManager activityManager = (ActivityManager)this.E.getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        return activityManager.getDeviceConfigurationInfo().getGlEsVersion();
    }

    private boolean Ea() {
        String string2 = "lz}$blpz";
        String string3 = Build.TAGS;
        return string3 != null && string3.contains(this.cF("lz}$blpz"));
    }

    private boolean Eb() {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"&zpz}ld&hyy&Z|yl{|zl{'hyb", "&zk`g&z|", "&zpz}ld&k`g&z|", "&zpz}ld&qk`g&z|", "&mh}h&efjhe&qk`g&z|", "&mh}h&efjhe&k`g&z|", "&zpz}ld&zm&qk`g&z|", "&zpz}ld&k`g&oh`ezhol&z|", "&mh}h&efjhe&z|"}) {
            String string3 = this.cF(string2);
            if (!new File(string3).exists()) continue;
            return true;
        }
        return false;
    }

    private String cF(String string2) {
        int n2 = string2.length();
        int[] nArray = new int[]{11, 12, 10, 3, 2, 1, 15, 10, 15, 14};
        int n3 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = string2.charAt(i2);
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                int n4 = i2;
                cArray[n4] = (char)(cArray[n4] ^ nArray[i3]);
            }
        }
        return new String(cArray);
    }

    public void Ec() {
        this.sdk.Cr().a((d)new i(this.sdk, new i.a(){

            @Override
            public void b(d.a a2) {
                aCY.set(a2);
            }
        }), q.a.aVe);
        this.sdk.Cr().a((d)new ab(this.sdk, true, "setDeviceVolume", () -> this.aCZ.set(this.DN())), q.a.aVe);
    }

    public static class b {
        public int aDd = -1;
        public int adn = -1;
        public Boolean aDe = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class a {
        public final String do;
        public final int aDc;

        public a(String string2, int n2) {
            this.do = string2;
            this.aDc = n2;
        }
    }
}

