/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.ads.b;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.sdk.c.a;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.nativeAd.AppLovinStarRatingView;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.x;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MaxNativeAdView
extends FrameLayout {
    public static final String MEDIUM_TEMPLATE_1 = "medium_template_1";
    private final View mainView;
    private final TextView aZL;
    private final TextView aZM;
    private final TextView aZN;
    private final Button aZO;
    private final ImageView aZP;
    private final FrameLayout aZQ;
    private final ViewGroup aZR;
    private final FrameLayout aZS;
    private final ViewGroup aZT;
    private final ViewGroup aZU;
    private final FrameLayout aZV;
    @Nullable
    private b adViewTracker;

    public MaxNativeAdView(MaxNativeAd maxNativeAd, Activity activity) {
        this(maxNativeAd, (String)null, activity);
    }

    public MaxNativeAdView(String string2, Context context) {
        this(null, string2, context);
    }

    @Deprecated
    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Activity activity) {
        this(maxNativeAd, string2, activity.getApplicationContext());
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Context context) {
        this(maxNativeAd, new MaxNativeAdViewBinder.Builder(-1).setTemplateType(string2).setTitleTextViewId(R.id.applovin_native_title_text_view).setAdvertiserTextViewId(R.id.applovin_native_advertiser_text_view).setBodyTextViewId(R.id.applovin_native_body_text_view).setCallToActionButtonId(R.id.applovin_native_cta_button).setIconImageViewId(R.id.applovin_native_icon_image_view).setIconContentViewId(R.id.applovin_native_icon_view).setOptionsContentViewGroupId(R.id.applovin_native_options_view).setOptionsContentFrameLayoutId(R.id.applovin_native_options_view).setStarRatingContentViewGroupId(R.id.applovin_native_star_rating_view).setMediaContentViewGroupId(R.id.applovin_native_media_content_view).setMediaContentFrameLayoutId(R.id.applovin_native_media_content_view).build(), context);
    }

    public MaxNativeAdView(MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        this(null, maxNativeAdViewBinder, context);
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        super(context);
        MaxAdFormat maxAdFormat;
        boolean bl = maxNativeAdViewBinder.templateType != null;
        MaxAdFormat maxAdFormat2 = maxAdFormat = maxNativeAd != null ? maxNativeAd.getFormat() : MaxAdFormat.NATIVE;
        if (maxNativeAdViewBinder.mainView != null) {
            this.mainView = maxNativeAdViewBinder.mainView;
        } else {
            int n2 = bl ? this.b(maxNativeAdViewBinder.templateType, maxAdFormat) : maxNativeAdViewBinder.layoutResourceId;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            this.mainView = layoutInflater.inflate(n2, (ViewGroup)this, false);
        }
        this.addView(this.mainView);
        this.aZL = (TextView)this.findViewById(maxNativeAdViewBinder.titleTextViewId);
        this.aZM = (TextView)this.findViewById(maxNativeAdViewBinder.advertiserTextViewId);
        this.aZN = (TextView)this.findViewById(maxNativeAdViewBinder.bodyTextViewId);
        this.aZO = (Button)this.findViewById(maxNativeAdViewBinder.callToActionButtonId);
        this.aZP = (ImageView)this.findViewById(maxNativeAdViewBinder.iconImageViewId);
        this.aZQ = (FrameLayout)this.findViewById(maxNativeAdViewBinder.iconContentViewId);
        this.aZR = (ViewGroup)this.findViewById(maxNativeAdViewBinder.optionsContentViewGroupId);
        this.aZS = (FrameLayout)this.findViewById(maxNativeAdViewBinder.optionsContentFrameLayoutId);
        this.aZT = (ViewGroup)this.findViewById(maxNativeAdViewBinder.starRatingContentViewGroupId);
        this.aZU = (ViewGroup)this.findViewById(maxNativeAdViewBinder.mediaContentViewGroupId);
        this.aZV = (FrameLayout)this.findViewById(maxNativeAdViewBinder.mediaContentFrameLayoutId);
        if (maxNativeAd != null) {
            this.a(maxNativeAd);
        }
    }

    public void render(d d2, a.a a2, n n2) {
        this.recycle();
        if (!d2.yG().get() || !d2.yF().get()) {
            this.adViewTracker = new b(d2, (ViewGroup)this, a2, n2);
        }
        MaxNativeAd maxNativeAd = d2.getNativeAd();
        if (d2.isContainerClickable() && maxNativeAd.isContainerClickable()) {
            n2.Ci();
            if (x.FL()) {
                n2.Ci().f("MaxNativeAdView", "Enabling container click");
            }
            this.setOnClickListener(view -> maxNativeAd.performClick());
        }
        if (StringUtils.isValidString(d2.yE())) {
            n2.Ci();
            if (x.FL()) {
                n2.Ci().f("MaxNativeAdView", "Rendering template ad view");
            }
            this.a(maxNativeAd);
        } else {
            n2.Ci();
            if (x.FL()) {
                n2.Ci().f("MaxNativeAdView", "Rendering custom ad view");
            }
            this.renderCustomNativeAdView(maxNativeAd);
        }
    }

    public void recycle() {
        this.setOnClickListener(null);
        if (this.adViewTracker != null) {
            this.adViewTracker.destroy();
            this.adViewTracker = null;
        }
        if (this.mainView != null && this.mainView.getParent() != this) {
            ViewGroup viewGroup = (ViewGroup)this.mainView.getParent();
            if (viewGroup != null) {
                viewGroup.removeAllViews();
                this.removeView((View)viewGroup);
            }
            this.addView(this.mainView);
        }
    }

    @Nullable
    public b getAdViewTracker() {
        return this.adViewTracker;
    }

    private int b(String string2, MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.NATIVE) {
            if ("small_template_1".equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_small_template_1;
            }
            if (MEDIUM_TEMPLATE_1.equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_medium_template_1;
            }
            throw new IllegalArgumentException("Attempting to render MAX native ad with invalid format: " + string2);
        }
        if (maxAdFormat == MaxAdFormat.BANNER) {
            if ("vertical_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_banner_view;
            }
            if ("media_banner_template".equals(string2) || "no_body_banner_template".equals(string2)) {
                return R.layout.max_native_ad_media_banner_view;
            }
            if ("vertical_media_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_media_banner_view;
            }
            return R.layout.max_native_ad_banner_view;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            if ("vertical_leader_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_leader_view;
            }
            return R.layout.max_native_ad_leader_view;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return R.layout.max_native_ad_mrec_view;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + maxAdFormat);
    }

    private void a(MaxNativeAd maxNativeAd) {
        if (this.aZL == null) {
            x.G("MaxNativeAdView", "Rendering template ad view without title text view");
        } else if (StringUtils.isValidString(maxNativeAd.getTitle())) {
            this.aZL.setText((CharSequence)maxNativeAd.getTitle());
        } else {
            this.aZL.setVisibility(8);
        }
        if (this.aZM != null) {
            if (StringUtils.isValidString(maxNativeAd.getAdvertiser())) {
                this.aZM.setText((CharSequence)maxNativeAd.getAdvertiser());
            } else {
                this.aZM.setVisibility(8);
            }
        }
        if (this.aZN != null) {
            if (StringUtils.isValidString(maxNativeAd.getBody())) {
                this.aZN.setText((CharSequence)maxNativeAd.getBody());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZN.setVisibility(8);
            } else {
                this.aZN.setVisibility(4);
            }
        }
        if (this.aZO != null) {
            if (StringUtils.isValidString(maxNativeAd.getCallToAction())) {
                this.aZO.setText((CharSequence)maxNativeAd.getCallToAction());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZO.setVisibility(8);
            } else {
                this.aZO.setVisibility(4);
            }
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        View view = maxNativeAd.getIconView();
        if (this.aZQ != null) {
            if (maxNativeAdImage != null && this.aZP != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZP.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null && StringUtils.isValidString(maxNativeAdImage.getUri().toString())) {
                    if (n.aBr.a(a.aKO).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZP, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZP, maxNativeAdImage.getUri(), n.aBr);
                    }
                } else {
                    this.aZQ.setVisibility(8);
                }
            } else if (view != null) {
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZQ.removeAllViews();
                this.aZQ.addView(view);
            } else {
                this.aZQ.setVisibility(8);
            }
        }
        View view2 = maxNativeAd.getOptionsView();
        if (this.aZS != null && view2 != null) {
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.aZS.addView(view2);
            this.aZS.bringToFront();
        } else if (this.aZS != null) {
            this.aZS.setVisibility(8);
        }
        View view3 = maxNativeAd.getMediaView();
        if (this.aZV != null) {
            if (view3 != null) {
                view3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZV.addView(view3);
            } else if (maxNativeAd.getFormat() == MaxAdFormat.LEADER) {
                this.aZV.setVisibility(8);
            }
        }
        if (this.aZT != null) {
            Double d2 = maxNativeAd.getStarRating();
            if (d2 != null) {
                this.aZT.removeAllViews();
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView(d2, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZT.addView((View)appLovinStarRatingView);
            } else {
                this.aZT.setVisibility(8);
            }
        }
        this.NE();
        this.postDelayed(() -> this.setSelected(true), 2000L);
    }

    public void renderCustomNativeAdView(MaxNativeAd maxNativeAd) {
        Object object;
        View view;
        if (this.aZL != null) {
            this.aZL.setText((CharSequence)maxNativeAd.getTitle());
        }
        if (this.aZN != null) {
            this.aZN.setText((CharSequence)maxNativeAd.getBody());
        }
        if (this.aZM != null) {
            this.aZM.setText((CharSequence)maxNativeAd.getAdvertiser());
        }
        if (this.aZO != null) {
            this.aZO.setText((CharSequence)maxNativeAd.getCallToAction());
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        if (this.aZP != null) {
            if (maxNativeAdImage != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZP.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null) {
                    if (n.aBr.a(a.aKO).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZP, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZP, maxNativeAdImage.getUri(), n.aBr);
                    }
                } else {
                    this.aZP.setImageDrawable(null);
                }
            } else {
                this.aZP.setImageDrawable(null);
            }
        }
        View view2 = maxNativeAd.getMediaView();
        if (this.aZU != null) {
            this.aZU.removeAllViews();
            if (view2 != null) {
                view = view2.getParent();
                if (view != null) {
                    ((ViewGroup)view).removeAllViews();
                }
                view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZU.addView(view2);
            }
        }
        view = maxNativeAd.getOptionsView();
        if (this.aZR != null) {
            this.aZR.removeAllViews();
            if (view != null) {
                object = view.getParent();
                if (object != null) {
                    ((ViewGroup)object).removeAllViews();
                }
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZR.addView(view);
                this.aZR.bringToFront();
            }
        }
        if (this.aZT != null) {
            this.aZT.removeAllViews();
            object = maxNativeAd.getStarRating();
            if (object != null) {
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView((Double)object, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZT.addView((View)appLovinStarRatingView);
            }
        }
    }

    private void NE() {
        final ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.applovin_native_inner_parent_layout);
        if (viewGroup == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        final WeakReference<ViewTreeObserver> weakReference = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)weakReference.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                } else {
                    n.aBr.Ci();
                    if (x.FL()) {
                        n.aBr.Ci().h("MaxNativeAdView", "Failed to remove onPreDrawListener since the view tree observer is not alive.");
                    }
                }
                weakReference.clear();
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)viewGroup.getLayoutParams();
                layoutParams.height = ((View)viewGroup.getParent()).getWidth();
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return true;
            }
        });
    }

    public View getMainView() {
        return this.mainView;
    }

    public TextView getTitleTextView() {
        return this.aZL;
    }

    public TextView getAdvertiserTextView() {
        return this.aZM;
    }

    public TextView getBodyTextView() {
        return this.aZN;
    }

    public Button getCallToActionButton() {
        return this.aZO;
    }

    public ImageView getIconImageView() {
        return this.aZP;
    }

    @Deprecated
    public FrameLayout getIconContentView() {
        return this.aZQ;
    }

    public ViewGroup getOptionsContentViewGroup() {
        return this.aZR != null ? this.aZR : this.aZS;
    }

    @Deprecated
    public FrameLayout getOptionsContentView() {
        return this.aZS;
    }

    public ViewGroup getStarRatingContentViewGroup() {
        return this.aZT;
    }

    public ViewGroup getMediaContentViewGroup() {
        return this.aZU != null ? this.aZU : this.aZV;
    }

    @Deprecated
    public FrameLayout getMediaContentView() {
        return this.aZV;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.adViewTracker != null) {
            this.adViewTracker.uM();
        }
        if (!this.isHardwareAccelerated()) {
            x.G("MaxNativeAdView", "Attached to non-hardware accelerated window: some native ad views require hardware accelerated Activities to render properly.");
        }
    }

    public List<View> getClickableViews() {
        ArrayList<View> arrayList = new ArrayList<View>(5);
        if (this.aZL != null) {
            arrayList.add((View)this.aZL);
        }
        if (this.aZM != null) {
            arrayList.add((View)this.aZM);
        }
        if (this.aZN != null) {
            arrayList.add((View)this.aZN);
        }
        if (this.aZO != null) {
            arrayList.add((View)this.aZO);
        }
        if (this.aZP != null) {
            arrayList.add((View)this.aZP);
        }
        return arrayList;
    }
}

