/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.StrictMode;
import android.webkit.URLUtil;
import android.widget.ImageView;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.InputStream;
import java.net.URL;

public class ImageViewUtils {
    public static void setImageUri(ImageView imageView, Uri uri, n n2) {
        if (imageView == null || uri == null) {
            return;
        }
        String string2 = uri.toString();
        if (URLUtil.isFileUrl((String)string2) || URLUtil.isContentUrl((String)string2)) {
            AppLovinSdkUtils.runOnUiThread(() -> {
                StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
                imageView.setImageURI(uri);
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            });
            return;
        }
        if (n2 == null) {
            return;
        }
        n2.Ci();
        if (x.FL()) {
            n2.Ci().f("ImageViewUtils", "Fetching image: " + uri);
        }
        n2.Cj().LC().execute(() -> {
            InputStream inputStream = null;
            try {
                inputStream = new URL(string2).openStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                AppLovinSdkUtils.runOnUiThread(() -> {
                    n2.Ci();
                    if (x.FL()) {
                        n2.Ci().f("ImageViewUtils", "Image fetched");
                    }
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(n.getApplicationContext().getResources(), bitmap);
                    imageView.setImageDrawable((Drawable)bitmapDrawable);
                });
            }
            catch (Throwable throwable) {
                block4: {
                    try {
                        n2.Ci();
                        if (!x.FL()) break block4;
                        n2.Ci().c("ImageViewUtils", "Failed to fetch image: " + uri, throwable);
                    }
                    catch (Throwable throwable2) {
                        t.a(inputStream, n2);
                        throw throwable2;
                    }
                }
                t.a(inputStream, n2);
            }
            t.a(inputStream, n2);
        });
    }

    public static void setAndDownscaleImageUri(ImageView imageView, Uri uri) {
        if (uri == null || imageView == null) {
            return;
        }
        if (imageView.getHeight() > 0 && imageView.getWidth() > 0) {
            ImageViewUtils.setAndDownscaleBitmap(imageView, uri);
            return;
        }
        imageView.post(() -> ImageViewUtils.setAndDownscaleBitmap(imageView, uri));
    }

    public static void setAndDownscaleBitmap(ImageView imageView, Uri uri) {
        if (uri == null || imageView == null) {
            return;
        }
        if (n.aBr == null) {
            x.I("ImageViewUtils", "SDK has not been initialized");
            return;
        }
        n.aBr.Cj().LC().execute(() -> {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
            int n2 = imageView.getHeight();
            int n3 = imageView.getWidth();
            if (n2 <= 0 || n3 <= 0) {
                Point point = h.Y(imageView.getContext());
                n2 = n3 = Math.min(point.x, point.y);
            }
            int n4 = 1;
            int n5 = options.outHeight;
            int n6 = options.outWidth;
            if (n5 > n2 || n6 > n3) {
                while (n5 / (n4 * 2) >= n2 || n6 / (n4 * 2) >= n3) {
                    n4 *= 2;
                }
            }
            options.inSampleSize = n4;
            options.inJustDecodeBounds = false;
            n.aBr.Ci();
            if (x.FL()) {
                n.aBr.Ci().f("ImageViewUtils", "Loading image: " + uri.getLastPathSegment() + "...");
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
            AppLovinSdkUtils.runOnUiThread(() -> imageView.setImageBitmap(bitmap));
        });
    }
}

