/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.applovin.communicator.AppLovinCommunicator;
import com.applovin.communicator.AppLovinCommunicatorMessage;
import com.applovin.communicator.AppLovinCommunicatorSubscriber;
import com.applovin.exoplayer2.ab;
import com.applovin.exoplayer2.ak;
import com.applovin.exoplayer2.an;
import com.applovin.exoplayer2.aw;
import com.applovin.exoplayer2.h.u;
import com.applovin.exoplayer2.k.p;
import com.applovin.exoplayer2.l.ai;
import com.applovin.exoplayer2.ui.f;
import com.applovin.exoplayer2.ui.g;
import com.applovin.impl.adview.AppLovinTouchToClickListener;
import com.applovin.impl.adview.k;
import com.applovin.impl.b.a;
import com.applovin.impl.b.f;
import com.applovin.impl.b.l;
import com.applovin.impl.b.m;
import com.applovin.impl.b.o;
import com.applovin.impl.sdk.ad.e;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.nativeAd.AppLovinMediaView;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.r;
import com.applovin.impl.sdk.utils.t;
import com.applovin.sdk.AppLovinSdkUtils;
import com.applovin.sdk.R;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"ViewConstructor"})
public class AppLovinVastMediaView
extends AppLovinMediaView
implements AppLovinCommunicatorSubscriber,
t.a {
    private static final String TAG = "AppLovinVastMediaView";
    private static final String COUNTDOWN_IDENTIFIER_PROGRESS_TRACKING = "PROGRESS_TRACKING";
    private static final long FADE_ANIMATION_DURATION_MILLIS = 250L;
    private final g videoView;
    private final aw mediaPlayer;
    @Nullable
    private LinearLayout videoWidgetLinearLayout;
    @Nullable
    private ImageView playPauseButtonImageView;
    @Nullable
    private ImageView muteButtonImageView;
    @Nullable
    private ImageView industryIconImageView;
    @Nullable
    private FrameLayout replayIconContainer;
    private final Handler countdownHandler = new Handler(Looper.getMainLooper());
    private final k countdownManager = new k(this.countdownHandler, this.sdk);
    private final AtomicBoolean videoEndListenerNotified = new AtomicBoolean();
    private final AtomicBoolean mediaErrorHandled = new AtomicBoolean();
    private final AtomicBoolean initialOnAttachedToWindowHandled = new AtomicBoolean();
    private final AtomicBoolean automaticPauseHandled = new AtomicBoolean();
    private final AtomicBoolean automaticResumeHandled = new AtomicBoolean();
    private final boolean isVideoStream;
    private long startTimeMillis;
    private Activity viewActivity;
    private boolean isVideoMuted = true;
    private boolean isVideoPausedByUser;
    private boolean videoWasCompleted;
    private int savedVideoPercentViewed;
    private long lastVideoPositionFromPauseMillis = -1L;
    private long videoDurationMillis;
    private final com.applovin.impl.b.a vastAd;
    private final Set<com.applovin.impl.b.k> videoProgressTrackers = new HashSet<com.applovin.impl.b.k>();
    private final com.applovin.impl.sdk.utils.a lifecycleCallbacksAdapter = new com.applovin.impl.sdk.utils.a(){

        @Override
        public void onActivityResumed(Activity activity) {
            if (activity.equals(AppLovinVastMediaView.this.viewActivity) && !AppLovinVastMediaView.this.isVideoPausedByUser) {
                AppLovinVastMediaView.this.maybeHandleResume();
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
            if (activity.equals(AppLovinVastMediaView.this.viewActivity)) {
                AppLovinVastMediaView.this.maybeHandlePause();
            }
        }
    };

    public AppLovinVastMediaView(AppLovinNativeAdImpl appLovinNativeAdImpl, n n2, Context context) {
        super(appLovinNativeAdImpl, n2, context);
        int n3;
        this.vastAd = appLovinNativeAdImpl.getVastAd();
        this.isVideoStream = this.vastAd.Gj();
        if (t.a(com.applovin.impl.sdk.c.b.aNG, n2)) {
            this.checkCachedAdResourcesAsync(!this.isVideoStream);
        }
        if (this.isVideoStream) {
            AppLovinCommunicator.getInstance(context).subscribe((AppLovinCommunicatorSubscriber)this, "video_caching_failed");
        }
        if (this.vastAd.MS()) {
            this.industryIconImageView = com.applovin.impl.b.g.b(this.vastAd.MR().No(), context, n2);
            int n4 = AppLovinSdkUtils.dpToPx(context, n2.a(com.applovin.impl.sdk.c.b.aRk));
            this.industryIconImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n4, n4, n2.a(com.applovin.impl.sdk.c.b.aRm).intValue()));
            this.industryIconImageView.setOnClickListener((View.OnClickListener)new a());
            this.addView((View)this.industryIconImageView);
        }
        if (n2.a(com.applovin.impl.sdk.c.b.aRr).booleanValue()) {
            this.videoWidgetLinearLayout = new LinearLayout(context);
            this.videoWidgetLinearLayout.setOrientation(0);
            this.videoWidgetLinearLayout.setBackgroundResource(R.drawable.applovin_rounded_black_background);
            this.videoWidgetLinearLayout.setAlpha(n2.a(com.applovin.impl.sdk.c.b.aRq).floatValue());
            this.playPauseButtonImageView = new ImageView(context);
            this.playPauseButtonImageView.setClickable(true);
            d d2 = new d();
            this.playPauseButtonImageView.setOnClickListener((View.OnClickListener)d2);
            int n5 = AppLovinSdkUtils.dpToPx(context, n2.a(com.applovin.impl.sdk.c.b.aRo));
            this.playPauseButtonImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n5, n5));
            this.populatePlayPauseImage(false);
            this.videoWidgetLinearLayout.addView((View)this.playPauseButtonImageView);
            this.muteButtonImageView = new ImageView(context);
            n3 = 0;
            boolean bl = this.populateMuteImage(this.isVideoMuted);
            if (bl) {
                n3 = AppLovinSdkUtils.dpToPx(context, n2.a(com.applovin.impl.sdk.c.b.aRn));
                this.muteButtonImageView.setClickable(true);
                this.muteButtonImageView.setOnClickListener((View.OnClickListener)d2);
                this.muteButtonImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n3, n3));
                this.videoWidgetLinearLayout.addView((View)this.muteButtonImageView);
            }
            int n6 = AppLovinSdkUtils.dpToPx(context, n2.a(com.applovin.impl.sdk.c.b.aRp));
            this.videoWidgetLinearLayout.setPadding(n6, n6, n6, n6);
            int n7 = n5 + n3 + n6 * 2;
            int n8 = Math.max(n5, n3) + n6 * 2;
            this.videoWidgetLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n7, n8, 8388691));
            this.addView((View)this.videoWidgetLinearLayout);
        }
        if (n2.a(com.applovin.impl.sdk.c.b.aRs).booleanValue()) {
            this.replayIconContainer = new FrameLayout(this.getContext());
            this.replayIconContainer.setBackgroundColor(-16777216);
            this.replayIconContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.replayIconContainer.setVisibility(4);
            d d3 = new d();
            this.replayIconContainer.setOnClickListener((View.OnClickListener)d3);
            ImageView imageView = new ImageView(this.getContext());
            n3 = AppLovinSdkUtils.dpToPx(context, n2.a(com.applovin.impl.sdk.c.b.aRt));
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n3, n3, 17));
            imageView.setImageResource(R.drawable.applovin_ic_replay_icon);
            imageView.setAdjustViewBounds(true);
            imageView.setMaxHeight(this.replayIconContainer.getHeight());
            imageView.setMaxWidth(this.replayIconContainer.getWidth());
            this.replayIconContainer.addView((View)imageView);
            this.addView((View)this.replayIconContainer);
        }
        this.mediaPlayer = new aw.a(this.getContext()).cY();
        c c2 = new c();
        this.mediaPlayer.f(c2);
        this.mediaPlayer.u(0);
        this.videoView = new g(this.getContext());
        this.videoView.nG();
        this.videoView.setControllerVisibilityListener(c2);
        this.videoView.setPlayer(this.mediaPlayer);
        this.videoView.setOnTouchListener(new AppLovinTouchToClickListener(n2, com.applovin.impl.sdk.c.b.aMR, this.getContext(), new b(appLovinNativeAdImpl)));
        this.addView((View)this.videoView);
        this.bringChildToFront((View)this.industryIconImageView);
        this.bringChildToFront((View)this.videoWidgetLinearLayout);
        this.prepareMediaPlayer();
        appLovinNativeAdImpl.setVideoView((View)this.videoView);
        Set<com.applovin.impl.b.k> set = this.vastAd.a(a.c.aYc, l.aZb);
        this.videoProgressTrackers.addAll(set);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.maybeHandleOnAttachedToWindow();
        if (!this.isVideoPausedByUser) {
            this.maybeHandleResume();
        }
    }

    protected void onDetachedFromWindow() {
        this.maybeHandlePause();
        super.onDetachedFromWindow();
    }

    @Override
    public void destroy() {
        this.finishVideo();
        if (this.industryIconImageView != null) {
            this.industryIconImageView.setOnClickListener(null);
        }
        if (this.playPauseButtonImageView != null) {
            this.playPauseButtonImageView.setOnClickListener(null);
        }
        if (this.muteButtonImageView != null) {
            this.muteButtonImageView.setOnClickListener(null);
        }
        if (this.replayIconContainer != null) {
            this.replayIconContainer.setOnClickListener(null);
        }
        this.videoView.setOnTouchListener(null);
        this.viewActivity = null;
        this.mediaPlayer.release();
        this.vastAd.MH().JJ();
        this.countdownManager.rv();
        this.countdownHandler.removeCallbacksAndMessages(null);
        if (this.isVideoStream) {
            AppLovinCommunicator.getInstance(this.getContext()).unsubscribe((AppLovinCommunicatorSubscriber)this, "video_caching_failed");
        }
        super.destroy();
    }

    @Override
    public void onMessageReceived(AppLovinCommunicatorMessage appLovinCommunicatorMessage) {
        if (!"video_caching_failed".equals(appLovinCommunicatorMessage.getTopic())) {
            return;
        }
        Bundle bundle = appLovinCommunicatorMessage.getMessageData();
        long l2 = bundle.getLong("ad_id");
        if (l2 == this.vastAd.getAdIdNumber() && this.isVideoStream) {
            int n2 = bundle.getInt("load_response_code");
            String string2 = bundle.getString("load_exception_message");
            if (!(string2 == null && n2 >= 200 && n2 < 300 || this.videoWasCompleted || this.mediaPlayer.v())) {
                this.handleMediaError("Video cache error during stream. ResponseCode=" + n2 + ", exception=" + string2);
            }
        }
    }

    @Override
    public String getCommunicatorId() {
        return TAG;
    }

    private void prepareMediaPlayer() {
        if (!t.a(com.applovin.impl.sdk.c.b.aNG, this.sdk)) {
            this.checkCachedAdResourcesImmediately(!this.isVideoStream);
        }
        p p2 = new p(this.getContext(), ai.a(this.getContext(), "com.applovin.sdk"));
        u u2 = new u.a(p2).c(ab.a(this.vastAd.Gm()));
        boolean bl = !this.isVideoMuted;
        this.mediaPlayer.h((float)bl);
        this.mediaPlayer.a(u2);
        this.mediaPlayer.aD();
        this.mediaPlayer.k(false);
    }

    private void maybeHandleOnAttachedToWindow() {
        if (!this.initialOnAttachedToWindowHandled.compareAndSet(false, true)) {
            return;
        }
        if (this.industryIconImageView != null && this.vastAd.MS()) {
            this.maybeFireTrackers(a.c.aYe);
            this.industryIconImageView.setVisibility(0);
        }
        this.startTimeMillis = SystemClock.elapsedRealtime();
        this.maybeFireTrackers(a.c.aXZ);
        this.maybeFireTrackers(a.c.aYc, "creativeView");
        this.vastAd.MH().JI();
        this.vastAd.setHasShown(true);
        this.sdk.BY().trackImpression(this.vastAd);
        this.viewActivity = com.applovin.impl.sdk.utils.b.y(com.applovin.impl.sdk.utils.u.B((View)this));
        this.sdk.Ch().a(this.lifecycleCallbacksAdapter);
        this.mediaPlayer.k(true);
        this.countdownManager.a(COUNTDOWN_IDENTIFIER_PROGRESS_TRACKING, TimeUnit.SECONDS.toMillis(1L), new k.a(){

            @Override
            public void rw() {
                long l2 = AppLovinVastMediaView.this.mediaPlayer.aM() - AppLovinVastMediaView.this.mediaPlayer.aN();
                long l3 = TimeUnit.MILLISECONDS.toSeconds(AppLovinVastMediaView.this.videoDurationMillis - l2);
                int n2 = AppLovinVastMediaView.this.getVideoPercentViewed();
                HashSet<com.applovin.impl.b.k> hashSet = new HashSet<com.applovin.impl.b.k>();
                HashSet hashSet2 = new HashSet(AppLovinVastMediaView.this.videoProgressTrackers);
                for (com.applovin.impl.b.k k2 : hashSet2) {
                    if (!k2.h(l3, n2)) continue;
                    hashSet.add(k2);
                    AppLovinVastMediaView.this.videoProgressTrackers.remove(k2);
                }
                AppLovinVastMediaView.this.maybeFireTrackers(hashSet);
                if (n2 >= 25 && n2 < 50) {
                    AppLovinVastMediaView.this.vastAd.MH().JW();
                } else if (n2 >= 50 && n2 < 75) {
                    AppLovinVastMediaView.this.vastAd.MH().JX();
                } else if (n2 >= 75) {
                    AppLovinVastMediaView.this.vastAd.MH().JY();
                }
            }

            @Override
            public boolean rx() {
                return !AppLovinVastMediaView.this.videoWasCompleted;
            }
        });
    }

    private void maybeHandlePause() {
        if (!this.automaticPauseHandled.compareAndSet(false, true)) {
            return;
        }
        this.maybeFireTrackers(a.c.aYc, "pause");
        this.vastAd.MH().Ka();
        this.pauseVideo();
        this.populatePlayPauseImage(true);
        this.automaticResumeHandled.set(false);
    }

    private void maybeHandleResume() {
        if (!this.automaticResumeHandled.compareAndSet(false, true)) {
            return;
        }
        this.maybeFireTrackers(a.c.aYc, "resume");
        this.vastAd.MH().Kb();
        if (this.lastVideoPositionFromPauseMillis >= 0L) {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.FL()) {
                this.logger.f(TAG, "Resuming video at position " + this.lastVideoPositionFromPauseMillis);
            }
            this.mediaPlayer.k(true);
            this.countdownManager.start();
            this.lastVideoPositionFromPauseMillis = -1L;
        } else {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.FL()) {
                this.logger.f(TAG, "Invalid last video position, isVideoPlaying=" + this.mediaPlayer.v());
            }
        }
        this.populatePlayPauseImage(false);
        this.automaticPauseHandled.set(false);
    }

    private void finishVideo() {
        this.maybeFireTrackers(a.c.aYc, "close");
        this.maybeHandlePause();
        this.sdk.Ch().b(this.lifecycleCallbacksAdapter);
        if (this.videoWasCompleted) {
            this.maybeFireRemainingCompletionTrackers();
            this.vastAd.MH().JZ();
        }
        if (this.videoEndListenerNotified.compareAndSet(false, true)) {
            long l2 = SystemClock.elapsedRealtime() - this.startTimeMillis;
            this.sdk.BY().trackVideoEnd(this.vastAd, TimeUnit.MILLISECONDS.toSeconds(l2), this.getVideoPercentViewed(), this.isVideoStream);
        }
    }

    private void pauseVideo() {
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.FL()) {
            this.logger.f(TAG, "Pausing video");
        }
        this.savedVideoPercentViewed = this.getVideoPercentViewed();
        this.lastVideoPositionFromPauseMillis = this.mediaPlayer.aN();
        this.mediaPlayer.k(false);
        this.countdownManager.W();
        AppLovinVastMediaView appLovinVastMediaView2 = this;
        if (appLovinVastMediaView2.logger.FL()) {
            this.logger.f(TAG, "Paused video at position " + this.lastVideoPositionFromPauseMillis + " ms");
        }
    }

    private void checkCachedAdResourcesImmediately(boolean bl) {
        List<Uri> list = t.a(bl, this.vastAd, this.sdk, this.getContext());
        if (list.isEmpty()) {
            return;
        }
        this.handleUnavailableCachedResources();
    }

    private void checkCachedAdResourcesAsync(boolean bl) {
        t.a(bl, (e)this.vastAd, this.sdk, n.getApplicationContext(), this);
    }

    @Override
    public void onCachedResourcesChecked(boolean bl) {
        if (bl) {
            return;
        }
        this.handleUnavailableCachedResources();
    }

    private void handleUnavailableCachedResources() {
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.FL()) {
            this.logger.i(TAG, "Video failed due to unavailable resources");
        }
        this.finishVideo();
        this.showMediaImageView();
    }

    private void handleMediaError(String string2) {
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.FL()) {
            this.logger.i(TAG, string2);
        }
        this.maybeFireTrackers(a.c.aYg, f.aYF);
        this.vastAd.MH().dn(string2);
        if (this.mediaErrorHandled.compareAndSet(false, true)) {
            this.finishVideo();
            this.showMediaImageView();
        }
    }

    private void showMediaImageView() {
        if (this.imageView.getDrawable() == null) {
            return;
        }
        this.imageView.setVisibility(0);
        this.videoView.setVisibility(8);
        if (this.videoWidgetLinearLayout != null) {
            this.videoWidgetLinearLayout.setVisibility(8);
        }
        if (this.industryIconImageView != null) {
            this.industryIconImageView.setVisibility(8);
        }
    }

    private void maybeFireRemainingCompletionTrackers() {
        if (this.getVideoPercentViewed() >= this.vastAd.Hm() && !this.videoProgressTrackers.isEmpty()) {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.FL()) {
                this.logger.h(TAG, "Firing " + this.videoProgressTrackers.size() + " un-fired video progress trackers when video was completed.");
            }
            this.maybeFireTrackers(this.videoProgressTrackers);
        }
    }

    private int getVideoPercentViewed() {
        long l2 = this.mediaPlayer.aN();
        if (this.videoWasCompleted) {
            return 100;
        }
        if (l2 > 0L) {
            return (int)((float)l2 / (float)this.videoDurationMillis * 100.0f);
        }
        return this.savedVideoPercentViewed;
    }

    private void populatePlayPauseImage(boolean bl) {
        Uri uri;
        if (this.playPauseButtonImageView == null) {
            return;
        }
        Uri uri2 = uri = bl ? this.vastAd.Ip() : this.vastAd.Iq();
        if (uri != null) {
            ImageViewUtils.setImageUri(this.playPauseButtonImageView, uri, this.sdk);
            return;
        }
        int n2 = bl ? R.drawable.applovin_ic_play_icon : R.drawable.applovin_ic_pause_icon;
        this.playPauseButtonImageView.setImageResource(n2);
    }

    private boolean populateMuteImage(boolean bl) {
        Uri uri;
        if (this.muteButtonImageView == null) {
            return false;
        }
        Uri uri2 = uri = bl ? this.vastAd.Ir() : this.vastAd.Is();
        if (uri != null) {
            ImageViewUtils.setImageUri(this.muteButtonImageView, uri, this.sdk);
            return true;
        }
        if (!h.LQ()) {
            return false;
        }
        AnimatedVectorDrawable animatedVectorDrawable = (AnimatedVectorDrawable)this.getContext().getDrawable(bl ? R.drawable.applovin_ic_unmute_to_mute : R.drawable.applovin_ic_mute_to_unmute);
        if (animatedVectorDrawable == null) {
            return false;
        }
        this.muteButtonImageView.setImageDrawable((Drawable)animatedVectorDrawable);
        animatedVectorDrawable.start();
        return true;
    }

    private void maybeFireTrackers(Set<com.applovin.impl.b.k> set) {
        this.maybeFireTrackers(set, f.aYt);
    }

    private void maybeFireTrackers(a.c c2) {
        this.maybeFireTrackers(c2, f.aYt);
    }

    private void maybeFireTrackers(a.c c2, String string2) {
        this.maybeFireTrackers(c2, string2, f.aYt);
    }

    private void maybeFireTrackers(a.c c2, f f2) {
        this.maybeFireTrackers(c2, "", f2);
    }

    private void maybeFireTrackers(a.c c2, String string2, f f2) {
        Set<com.applovin.impl.b.k> set = this.vastAd.a(c2, string2);
        this.maybeFireTrackers(set, f2);
    }

    private void maybeFireTrackers(Set<com.applovin.impl.b.k> set, f f2) {
        if (set == null || set.isEmpty()) {
            return;
        }
        long l2 = TimeUnit.MILLISECONDS.toSeconds(this.mediaPlayer.aN());
        o o2 = this.vastAd.MO();
        Uri uri = o2 != null ? o2.NB() : null;
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.FL()) {
            this.logger.f(TAG, "Firing " + set.size() + " tracker(s): " + set);
        }
        m.a(set, l2, uri, f2, this.sdk);
    }

    private class d
    implements View.OnClickListener {
        private d() {
        }

        public void onClick(View view) {
            if (view == AppLovinVastMediaView.this.playPauseButtonImageView) {
                if (AppLovinVastMediaView.this.mediaPlayer.v()) {
                    AppLovinVastMediaView.this.isVideoPausedByUser = true;
                    AppLovinVastMediaView.this.maybeHandlePause();
                } else {
                    AppLovinVastMediaView.this.isVideoPausedByUser = false;
                    AppLovinVastMediaView.this.maybeHandleResume();
                }
            } else if (view == AppLovinVastMediaView.this.muteButtonImageView) {
                boolean bl = !AppLovinVastMediaView.this.isVideoMuted;
                AppLovinVastMediaView.this.isVideoMuted = bl;
                boolean bl2 = !bl;
                AppLovinVastMediaView.this.mediaPlayer.h((float)bl2);
                AppLovinVastMediaView.this.populateMuteImage(bl);
            } else if (view == AppLovinVastMediaView.this.replayIconContainer) {
                com.applovin.impl.sdk.utils.u.b((View)AppLovinVastMediaView.this.replayIconContainer, 250L, () -> {
                    AppLovinVastMediaView.this.videoWasCompleted = false;
                    AppLovinVastMediaView.this.automaticResumeHandled.set(false);
                    AppLovinVastMediaView.this.sdk.Ch().a(AppLovinVastMediaView.this.lifecycleCallbacksAdapter);
                    AppLovinVastMediaView.this.maybeHandleResume();
                });
            }
        }
    }

    private class a
    implements View.OnClickListener {
        private a() {
        }

        public void onClick(View view) {
            com.applovin.impl.b.g g2 = AppLovinVastMediaView.this.vastAd.MR();
            if (g2 == null) {
                return;
            }
            Uri uri = g2.Np();
            if (uri == null) {
                return;
            }
            AppLovinVastMediaView appLovinVastMediaView = AppLovinVastMediaView.this;
            if (appLovinVastMediaView.logger.FL()) {
                AppLovinVastMediaView.this.logger.f(AppLovinVastMediaView.TAG, "Industry icon clicked, opening URL: " + uri);
            }
            AppLovinVastMediaView.this.maybeFireTrackers(a.c.aYf);
            r.a(uri, view.getContext(), AppLovinVastMediaView.this.sdk);
        }
    }

    private class b
    implements AppLovinTouchToClickListener.OnClickListener {
        private final AppLovinNativeAdImpl aIh;

        @Override
        public void onClick(View view, MotionEvent motionEvent) {
            AppLovinVastMediaView.this.maybeFireTrackers(a.c.aYa);
            AppLovinVastMediaView.this.vastAd.MH().Kf();
            if (!AppLovinVastMediaView.this.vastAd.GX()) {
                return;
            }
            Uri uri = AppLovinVastMediaView.this.vastAd.Gp();
            if (uri == null) {
                return;
            }
            AppLovinVastMediaView appLovinVastMediaView = AppLovinVastMediaView.this;
            if (appLovinVastMediaView.logger.FL()) {
                AppLovinVastMediaView.this.logger.f(AppLovinVastMediaView.TAG, "Clicking through video");
            }
            AppLovinVastMediaView.this.sdk.BY().maybeSubmitPersistentPostbacks(AppLovinVastMediaView.this.vastAd.a(motionEvent, false));
            this.aIh.handleNativeAdClick(uri, null, motionEvent, AppLovinVastMediaView.this.getContext());
        }

        public b(AppLovinNativeAdImpl appLovinNativeAdImpl) {
            this.aIh = appLovinNativeAdImpl;
        }
    }

    private class c
    implements an.b,
    f.d {
        private c() {
        }

        @Override
        public void Z(int n2) {
            AppLovinVastMediaView appLovinVastMediaView = AppLovinVastMediaView.this;
            if (appLovinVastMediaView.logger.FL()) {
                AppLovinVastMediaView.this.logger.f(AppLovinVastMediaView.TAG, "Player state changed to state " + n2 + " and will play when ready: " + AppLovinVastMediaView.this.mediaPlayer.aE());
            }
            if (n2 == 3) {
                boolean bl = !AppLovinVastMediaView.this.isVideoMuted;
                AppLovinVastMediaView.this.mediaPlayer.h((float)bl);
                AppLovinVastMediaView.this.videoDurationMillis = AppLovinVastMediaView.this.mediaPlayer.aM();
                AppLovinVastMediaView.this.vastAd.MH().b(TimeUnit.MILLISECONDS.toSeconds(AppLovinVastMediaView.this.videoDurationMillis), t.S(AppLovinVastMediaView.this.sdk));
                AppLovinVastMediaView appLovinVastMediaView2 = AppLovinVastMediaView.this;
                if (appLovinVastMediaView2.logger.FL()) {
                    AppLovinVastMediaView.this.logger.f(AppLovinVastMediaView.TAG, "MediaPlayer prepared: " + AppLovinVastMediaView.this.mediaPlayer);
                }
                AppLovinVastMediaView.this.countdownManager.start();
            } else if (n2 == 4) {
                AppLovinVastMediaView appLovinVastMediaView3 = AppLovinVastMediaView.this;
                if (appLovinVastMediaView3.logger.FL()) {
                    AppLovinVastMediaView.this.logger.f(AppLovinVastMediaView.TAG, "Video completed");
                }
                AppLovinVastMediaView.this.videoWasCompleted = true;
                AppLovinVastMediaView.this.finishVideo();
                if (AppLovinVastMediaView.this.replayIconContainer != null) {
                    com.applovin.impl.sdk.utils.u.a((View)AppLovinVastMediaView.this.replayIconContainer, 250L, () -> AppLovinVastMediaView.this.mediaPlayer.b(0L));
                } else {
                    AppLovinVastMediaView.this.showMediaImageView();
                }
            }
        }

        @Override
        public void a(ak ak2) {
            AppLovinVastMediaView.this.handleMediaError("Video view error (" + t.a(ak2, AppLovinVastMediaView.this.sdk) + ")");
        }

        @Override
        public void eZ(int n2) {
            if (n2 == 0) {
                AppLovinVastMediaView.this.videoView.nG();
            }
        }
    }
}

