/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.array;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.array.apphub.aidl.IAppHubDirectDownloadServiceCallback;
import com.applovin.array.apphub.aidl.IAppHubService;
import com.applovin.impl.sdk.array.ArrayDataCollector;
import com.applovin.impl.sdk.array.ArrayDirectDownloadAd;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.a;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.x;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArrayService
extends IAppHubDirectDownloadServiceCallback.Stub {
    private static final String TAG = "ArrayService";
    private static final String SERVICE_INTENT_FILTER_ACTION = "com.applovin.am.intent.action.APPHUB_SERVICE";
    private static final String SERVICE_INTENT_CLASS_NAME = "com.applovin.oem.am.android.external.AppHubService";
    private static final int MAX_RECONNECT_RETRY_COUNT = 3;
    private int currentRetryCount;
    private final n sdk;
    private final x logger;
    private final ArrayDataCollector dataCollector;
    @Nullable
    private final Intent appHubServiceIntent;
    @Nullable
    private IAppHubService appHubService;
    private long appHubVersionCode = -1L;
    @Nullable
    private Boolean isDirectDownloadEnabled;
    @Nullable
    private String randomUserToken;
    @Nullable
    private String appHubPackageName;
    @Nullable
    private DirectDownloadState currentDownloadState;

    public ArrayService(n n2) {
        this.sdk = n2;
        this.logger = n2.Ci();
        this.dataCollector = new ArrayDataCollector(n2);
        this.appHubServiceIntent = this.createAppHubServiceIntent();
        if (this.appHubServiceIntent != null) {
            this.bindAppHubService();
        }
        n2.Ch().a(new a(){

            @Override
            public void onActivityStopped(Activity activity) {
                block4: {
                    DirectDownloadState directDownloadState = ArrayService.this.currentDownloadState;
                    if (ArrayService.this.appHubService == null || directDownloadState == null) {
                        return;
                    }
                    try {
                        ArrayService.this.logger;
                        if (x.FL()) {
                            ArrayService.this.logger.f(ArrayService.TAG, "Dismissing Direct Download Activity");
                        }
                        ArrayService.this.appHubService.dismissDirectDownloadAppDetails(directDownloadState.adToken);
                        directDownloadState.listener.onAppDetailsDismissed();
                        ArrayService.this.currentDownloadState = null;
                    }
                    catch (RemoteException remoteException) {
                        ArrayService.this.logger;
                        if (!x.FL()) break block4;
                        ArrayService.this.logger.c(ArrayService.TAG, "Failed dismiss Direct Download Activity", remoteException);
                    }
                }
            }
        });
    }

    public void startDirectInstallOrDownloadProcess(ArrayDirectDownloadAd arrayDirectDownloadAd, @Nullable Bundle bundle, DirectDownloadListener directDownloadListener) {
        if (this.appHubService == null) {
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.i(TAG, "Cannot begin Direct Install / Download process - service disconnected");
            }
            directDownloadListener.onFailure();
            return;
        }
        if (!arrayDirectDownloadAd.isDirectDownloadEnabled()) {
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.i(TAG, "Cannot begin Direct Install / Download process - missing token");
            }
            directDownloadListener.onFailure();
            return;
        }
        try {
            Bundle bundle2 = arrayDirectDownloadAd.getDirectDownloadParameters();
            if (bundle != null) {
                bundle2.putAll(bundle);
            }
            this.currentDownloadState = new DirectDownloadState(arrayDirectDownloadAd.getDirectDownloadToken(), bundle2, directDownloadListener);
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.f(TAG, "Starting Direct Download Activity");
            }
            if (this.appHubVersionCode >= 21L) {
                this.appHubService.showDirectDownloadAppDetailsWithExtra(this.currentDownloadState.adToken, this.currentDownloadState.parameters, this);
            } else {
                this.appHubService.showDirectDownloadAppDetails(this.currentDownloadState.adToken, this);
            }
            ArrayService arrayService2 = this;
            if (arrayService2.logger.FL()) {
                this.logger.f(TAG, "Activity started");
            }
        }
        catch (Throwable throwable) {
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.c(TAG, "Failed to execute Direct Install / Download process", throwable);
            }
            this.sdk.CN().d(TAG, "directInstallDownload", throwable);
            this.currentDownloadState = null;
            directDownloadListener.onFailure();
        }
    }

    public void collectAppHubData() {
        if (!this.isAppHubInstalled()) {
            return;
        }
        ArrayService arrayService = this;
        if (arrayService.logger.FL()) {
            this.logger.f(TAG, "Collecting data...");
        }
        if (this.isDirectDownloadEnabled == null && this.sdk.a(b.aMs).booleanValue()) {
            this.isDirectDownloadEnabled = this.dataCollector.collectDirectDownloadEnabled(this.appHubService);
        }
        if (this.appHubVersionCode == -1L && this.sdk.a(b.aMr).booleanValue()) {
            this.appHubVersionCode = this.dataCollector.collectAppHubVersionCode(this.appHubService);
        }
        if (TextUtils.isEmpty((CharSequence)this.randomUserToken) && this.sdk.a(b.aMt).booleanValue()) {
            this.randomUserToken = this.dataCollector.collectRandomUserToken(this.appHubService);
        }
    }

    @Override
    public void onError(String string2, String string3) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.FL()) {
            this.logger.i(TAG, "Encountered error: " + string3);
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        if (directDownloadState.errorCallbackInvoked.compareAndSet(false, true)) {
            directDownloadState.listener.onFailure();
            this.currentDownloadState = null;
        }
    }

    @Override
    public void onAppDetailsShown(String string2) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.FL()) {
            this.logger.f(TAG, "App details shown");
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        directDownloadState.listener.onAppDetailsDisplayed();
    }

    @Override
    public void onAppDetailsDismissed(String string2) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.FL()) {
            this.logger.f(TAG, "App details dismissed");
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        directDownloadState.listener.onAppDetailsDismissed();
        this.currentDownloadState = null;
    }

    @Override
    public void onDownloadStarted(String string2) {
        ArrayService arrayService = this;
        if (arrayService.logger.FL()) {
            this.logger.f(TAG, "Download started");
        }
    }

    public boolean isAppHubInstalled() {
        return this.appHubService != null;
    }

    @Nullable
    private Intent createAppHubServiceIntent() {
        String string2;
        Intent intent = new Intent(SERVICE_INTENT_FILTER_ACTION);
        List list = n.getApplicationContext().getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.h(TAG, "App Hub not available");
            }
            return null;
        }
        ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
        this.appHubPackageName = string2 = resolveInfo.serviceInfo.packageName;
        intent.setClassName(string2, SERVICE_INTENT_CLASS_NAME);
        return intent;
    }

    private void bindAppHubService() {
        block8: {
            if (this.currentRetryCount > 3) {
                ArrayService arrayService = this;
                if (arrayService.logger.FL()) {
                    this.logger.h(TAG, "Exceeded maximum retry count");
                }
                return;
            }
            ArrayService arrayService = this;
            if (arrayService.logger.FL()) {
                this.logger.f(TAG, "Attempting connection to App Hub service...");
            }
            ++this.currentRetryCount;
            try {
                boolean bl;
                int n2 = 1;
                if (h.LZ()) {
                    n2 |= 0x200;
                }
                if (!(bl = n.getApplicationContext().bindService(this.appHubServiceIntent, new ServiceConnection(){

                    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                        ArrayService.this.logger;
                        if (x.FL()) {
                            ArrayService.this.logger.f(ArrayService.TAG, "Connection successful: " + componentName);
                        }
                        ArrayService.this.appHubService = IAppHubService.Stub.asInterface(iBinder);
                    }

                    public void onServiceDisconnected(ComponentName componentName) {
                        ArrayService.this.logger;
                        if (x.FL()) {
                            ArrayService.this.logger.i(ArrayService.TAG, "Service disconnected: " + componentName);
                        }
                        ArrayService.this.appHubService = null;
                        ArrayService.this.logger;
                        if (x.FL()) {
                            ArrayService.this.logger.i(ArrayService.TAG, "Retrying...");
                        }
                        ArrayService.this.bindAppHubService();
                    }
                }, n2))) {
                    ArrayService arrayService2 = this;
                    if (arrayService2.logger.FL()) {
                        this.logger.h(TAG, "App Hub not available");
                    }
                }
            }
            catch (Throwable throwable) {
                ArrayService arrayService3 = this;
                if (!arrayService3.logger.FL()) break block8;
                this.logger.c(TAG, "Failed to bind to service", throwable);
            }
        }
    }

    public long getAppHubVersionCode() {
        return this.appHubVersionCode;
    }

    @Nullable
    public Boolean getIsDirectDownloadEnabled() {
        return this.isDirectDownloadEnabled;
    }

    @Nullable
    public String getRandomUserToken() {
        return this.randomUserToken;
    }

    @Nullable
    public String getAppHubPackageName() {
        return this.appHubPackageName;
    }

    public static interface DirectDownloadListener {
        public void onAppDetailsDisplayed();

        public void onAppDetailsDismissed();

        public void onFailure();
    }

    private static class DirectDownloadState {
        private final AtomicBoolean errorCallbackInvoked = new AtomicBoolean();
        private final String adToken;
        @Nullable
        private final Bundle parameters;
        private final DirectDownloadListener listener;

        public AtomicBoolean getErrorCallbackInvoked() {
            return this.errorCallbackInvoked;
        }

        public String getAdToken() {
            return this.adToken;
        }

        @Nullable
        public Bundle getParameters() {
            return this.parameters;
        }

        public DirectDownloadListener getListener() {
            return this.listener;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DirectDownloadState)) {
                return false;
            }
            DirectDownloadState directDownloadState = (DirectDownloadState)object;
            if (!directDownloadState.canEqual(this)) {
                return false;
            }
            AtomicBoolean atomicBoolean = this.getErrorCallbackInvoked();
            AtomicBoolean atomicBoolean2 = directDownloadState.getErrorCallbackInvoked();
            if (atomicBoolean == null ? atomicBoolean2 != null : !atomicBoolean.equals(atomicBoolean2)) {
                return false;
            }
            String string2 = this.getAdToken();
            String string3 = directDownloadState.getAdToken();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                return false;
            }
            Bundle bundle = this.getParameters();
            Bundle bundle2 = directDownloadState.getParameters();
            if (bundle == null ? bundle2 != null : !bundle.equals(bundle2)) {
                return false;
            }
            DirectDownloadListener directDownloadListener = this.getListener();
            DirectDownloadListener directDownloadListener2 = directDownloadState.getListener();
            return !(directDownloadListener == null ? directDownloadListener2 != null : !directDownloadListener.equals(directDownloadListener2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DirectDownloadState;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AtomicBoolean atomicBoolean = this.getErrorCallbackInvoked();
            n3 = n3 * 59 + (atomicBoolean == null ? 43 : atomicBoolean.hashCode());
            String string2 = this.getAdToken();
            n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
            Bundle bundle = this.getParameters();
            n3 = n3 * 59 + (bundle == null ? 43 : bundle.hashCode());
            DirectDownloadListener directDownloadListener = this.getListener();
            n3 = n3 * 59 + (directDownloadListener == null ? 43 : directDownloadListener.hashCode());
            return n3;
        }

        public String toString() {
            return "ArrayService.DirectDownloadState(errorCallbackInvoked=" + this.getErrorCallbackInvoked() + ", adToken=" + this.getAdToken() + ", parameters=" + this.getParameters() + ", listener=" + this.getListener() + ")";
        }

        public DirectDownloadState(String string2, @Nullable Bundle bundle, DirectDownloadListener directDownloadListener) {
            this.adToken = string2;
            this.parameters = bundle;
            this.listener = directDownloadListener;
        }
    }
}

