package com.applovin.sdk;

/**
 * This interface defines a listener for bid collection events.
 */
public interface AppLovinBidTokenCollectionListener
{
    /**
     * This method is invoked when the bid token was successfully collected.
     *
     * @param bidToken The bid token that was collected.
     */
    void onBidTokenCollected(final String bidToken);

    /**
     * This method is invoked when the bid token failed to be collected.
     *
     * @param errorMessage The reason for failure to collect the bid token.
     */
    void onBidTokenCollectionFailed(final String errorMessage);
}
