/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.privacy.a;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.applovin.communicator.AppLovinCommunicator;
import com.applovin.communicator.AppLovinCommunicatorMessage;
import com.applovin.communicator.AppLovinCommunicatorPublisher;
import com.applovin.communicator.AppLovinCommunicatorSubscriber;
import com.applovin.impl.privacy.a.b;
import com.applovin.impl.privacy.a.d;
import com.applovin.impl.privacy.a.e;
import com.applovin.impl.privacy.a.i;
import com.applovin.impl.privacy.a.j;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.s;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class c
implements AppLovinCommunicatorPublisher,
AppLovinCommunicatorSubscriber {
    private final n sdk;
    private final i axG;
    private List<e> axH;

    public c(n n2) {
        this.sdk = n2;
        this.axG = new i(n2);
    }

    public d zU() {
        return (d)this.sdk.Ci();
    }

    public boolean isEnabled() {
        Map<String, String> map = this.sdk.getSettings().getExtraParameters();
        if (map.containsKey("consent_flow_enabled")) {
            return Boolean.parseBoolean(map.get("consent_flow_enabled"));
        }
        return this.zU().isEnabled();
    }

    public d.a zV() {
        return this.zU().zV();
    }

    public Uri getPrivacyPolicyUri() {
        return this.zU().getPrivacyPolicyUri();
    }

    public Uri getTermsOfServiceUri() {
        return this.zU().getTermsOfServiceUri();
    }

    public AppLovinSdkConfiguration.ConsentFlowUserGeography getDebugUserGeography() {
        return this.zU().getDebugUserGeography();
    }

    private static d.a A(JSONObject jSONObject) {
        return jSONObject.has("consent_flow_settings") ? d.a.axO : d.a.axN;
    }

    @SuppressLint(value={"DiscouragedApi"})
    public static d D(Context context) {
        if (context == null) {
            x.H("AppLovinSdk", "Failed to get default terms flow settings.");
            return new d(false, AppLovinSdkConfiguration.ConsentFlowUserGeography.UNKNOWN, d.a.axN, null, null);
        }
        int n2 = context.getResources().getIdentifier("applovin_settings", "raw", context.getPackageName());
        String string2 = u.a(n2, context, null);
        JSONObject jSONObject = StringUtils.isValidString(string2) ? JsonUtils.jsonObjectFromJsonString(string2, new JSONObject()) : new JSONObject();
        d.a a2 = c.A(jSONObject);
        switch (a2) {
            case axO: {
                JSONObject jSONObject2 = JsonUtils.getJSONObject(jSONObject, "consent_flow_settings", new JSONObject());
                return c.B(jSONObject2);
            }
            case axN: {
                JSONObject jSONObject3 = JsonUtils.getJSONObject(jSONObject, "terms_flow_settings", new JSONObject());
                return c.C(jSONObject3);
            }
        }
        throw new IllegalStateException("Unknown consent flow type: " + (Object)((Object)a2));
    }

    public static d B(JSONObject jSONObject) {
        Boolean bl = JsonUtils.getBoolean(jSONObject, "consent_flow_enabled", false);
        String string2 = JsonUtils.getString(jSONObject, "consent_flow_debug_user_geography", "");
        String string3 = JsonUtils.getString(jSONObject, "consent_flow_terms_of_service", null);
        Uri uri = StringUtils.isValidString(string3) ? Uri.parse((String)string3) : null;
        String string4 = JsonUtils.getString(jSONObject, "consent_flow_privacy_policy", null);
        Uri uri2 = StringUtils.isValidString(string4) ? Uri.parse((String)string4) : null;
        return new d(bl, c.ci(string2), d.a.axO, uri2, uri);
    }

    public static d C(JSONObject jSONObject) {
        Boolean bl = JsonUtils.getBoolean(jSONObject, "terms_flow_enabled", false);
        String string2 = JsonUtils.getString(jSONObject, "terms_flow_terms_of_service", null);
        Uri uri = StringUtils.isValidString(string2) ? Uri.parse((String)string2) : null;
        String string3 = JsonUtils.getString(jSONObject, "terms_flow_privacy_policy", null);
        Uri uri2 = StringUtils.isValidString(string3) ? Uri.parse((String)string3) : null;
        return new d(bl, AppLovinSdkConfiguration.ConsentFlowUserGeography.UNKNOWN, d.a.axN, uri2, uri);
    }

    private static AppLovinSdkConfiguration.ConsentFlowUserGeography ci(String string2) {
        if ("gdpr".equalsIgnoreCase(string2)) {
            return AppLovinSdkConfiguration.ConsentFlowUserGeography.GDPR;
        }
        if ("other".equalsIgnoreCase(string2)) {
            return AppLovinSdkConfiguration.ConsentFlowUserGeography.OTHER;
        }
        return AppLovinSdkConfiguration.ConsentFlowUserGeography.UNKNOWN;
    }

    public void a(Activity activity, a a2) {
        if (!this.isEnabled()) {
            a2.onFlowCompleted(new com.applovin.impl.privacy.a.a(com.applovin.impl.privacy.a.a.axE, "Failed to start consent flow. Please make sure that the consent flow is enabled."));
            return;
        }
        if (this.axH == null || this.axH.size() == 0) {
            this.sdk.a(com.applovin.impl.sdk.c.d.aRo, false);
            a2.onFlowCompleted(new com.applovin.impl.privacy.a.a(com.applovin.impl.privacy.a.a.ERROR_CODE_UNSPECIFIED, "User may not be eligible for flow."));
            return;
        }
        this.a(activity, () -> {
            this.sdk.BL();
            if (x.Fk()) {
                this.sdk.BL().f("ConsentFlowManager", "Starting consent flow with states: " + this.axH);
            }
            if (!this.sdk.BJ()) {
                this.sdk.a(com.applovin.impl.sdk.c.d.aRo, true);
            }
            this.axG.a(this.axH, activity, a3 -> {
                if (a3 == null) {
                    this.sdk.a(com.applovin.impl.sdk.c.d.aRo, false);
                    this.axH = null;
                }
                a2.onFlowCompleted(a3);
            });
        });
    }

    private void a(Activity activity, Runnable runnable) {
        if (this.zU().getPrivacyPolicyUri() != null) {
            runnable.run();
            return;
        }
        AppLovinSdkUtils.runOnUiThread(() -> {
            String string2 = "You cannot use the AppLovin SDK's consent flow without defining a Privacy Policy URL";
            Uri uri = this.zX();
            new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"Missing Privacy Policy URL").setMessage((CharSequence)"You cannot use the AppLovin SDK's consent flow without defining a Privacy Policy URL").setNeutralButton((CharSequence)"Go To Documentation", (dialogInterface, n2) -> {
                s.a(uri, n.getApplicationContext(), this.sdk);
                throw new IllegalStateException("You cannot use the AppLovin SDK's consent flow without defining a Privacy Policy URL Please refer to " + uri.toString());
            }).setNegativeButton((CharSequence)"DISMISS", (dialogInterface, n2) -> {
                throw new IllegalStateException("You cannot use the AppLovin SDK's consent flow without defining a Privacy Policy URL Please refer to " + uri.toString());
            }).create().show();
        });
    }

    public boolean zW() {
        n n2 = n.aAz;
        if (n2.Bp()) {
            c c2 = n2.Cj();
            List<e> list = c2.axH;
            return c2.axG.zW() || list != null && list.size() > 0;
        }
        return false;
    }

    private Uri zX() {
        com.applovin.impl.sdk.c.b<String> b2 = this.sdk.Bq() ? com.applovin.impl.sdk.c.b.aQR : com.applovin.impl.sdk.c.b.aQQ;
        return Uri.parse((String)this.sdk.a(b2));
    }

    public void zY() {
        if (!this.sdk.Bo() && this.isEnabled()) {
            if (this.zU().zV() == d.a.axO) {
                this.sdk.BL();
                if (x.Fk()) {
                    this.sdk.BL().f("AppLovinSdk", "Generating Unified Consent Flow...");
                }
                this.axH = b.h(this.sdk);
            } else {
                this.sdk.BL();
                if (x.Fk()) {
                    this.sdk.BL().f("AppLovinSdk", "Generating Terms Flow...");
                }
                this.axH = b.i(this.sdk);
            }
        }
        c c2 = this;
        if (u.ah(c2.sdk.getApplicationContext())) {
            c c3 = this;
            AppLovinCommunicator.getInstance(c3.sdk.getApplicationContext()).subscribe((AppLovinCommunicatorSubscriber)this, "start_sdk_consent_flow");
        }
    }

    @Override
    public void onMessageReceived(AppLovinCommunicatorMessage appLovinCommunicatorMessage) {
        Uri uri = this.getTermsOfServiceUri();
        this.axH = uri != null && appLovinCommunicatorMessage.getMessageData().getBoolean("include_tos") ? j.l(this.sdk) : j.k(this.sdk);
        if (this.axH.size() == 0) {
            u.a("No Consent Flow Available", null, (Context)this.sdk.CD());
            return;
        }
        this.a(this.sdk.CD(), (com.applovin.impl.privacy.a.a a2) -> {
            AppLovinCommunicatorMessage appLovinCommunicatorMessage = new AppLovinCommunicatorMessage(new Bundle(), "sdk_consent_flow_finished", this);
            AppLovinCommunicator.getInstance(n.getApplicationContext()).getMessagingService().publish(appLovinCommunicatorMessage);
        });
    }

    @Override
    public String getCommunicatorId() {
        return "consent_flow_manager";
    }

    public JSONObject zZ() {
        d d2 = this.zU();
        Uri uri = d2.getPrivacyPolicyUri();
        Uri uri2 = d2.getTermsOfServiceUri();
        JSONObject jSONObject = new JSONObject();
        JsonUtils.putString(jSONObject, "enabled", String.valueOf(this.isEnabled()));
        JsonUtils.putString(jSONObject, "privacy_policy_url", uri != null ? uri.toString() : "");
        JsonUtils.putString(jSONObject, "terms_of_service_url", uri2 != null ? uri2.toString() : "");
        return jSONObject;
    }

    public String uI() {
        d d2 = this.zU();
        Uri uri = this.getPrivacyPolicyUri();
        Uri uri2 = this.getTermsOfServiceUri();
        return "\nConsent Flow Enabled - " + this.isEnabled() + "\nPrivacy Policy - " + (uri != null ? uri : "undefined") + "\nTerms of Service - " + (uri2 != null ? uri2 : "undefined");
    }

    public static interface a {
        public void onFlowCompleted(@Nullable com.applovin.impl.privacy.a.a var1);
    }
}

