/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.p;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.y;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AppLovinSdkSettings {
    private boolean a;
    private boolean b;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f = true;
    private String g;
    private final Map<String, Object> localSettings = CollectionUtils.map();
    private final Map<String, String> metaData = CollectionUtils.map();
    private List<String> h = Collections.emptyList();
    private List<String> i = Collections.emptyList();
    private final Map<String, String> j = CollectionUtils.map();
    private final Object k = new Object();
    private p l;

    public AppLovinSdkSettings(Context context) {
        this.a = Utils.isVerboseLoggingEnabled(context);
        this.c = true;
        this.d = true;
        this.e = true;
        this.a(context);
    }

    public void setTestDeviceAdvertisingIds(List<String> list) {
        y.j("AppLovinSdkSettings", "setTestDeviceAdvertisingIds(testDeviceAdvertisingIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                y.i("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.h = arrayList;
        } else {
            this.h = Collections.emptyList();
        }
    }

    public List<String> getTestDeviceAdvertisingIds() {
        return this.h;
    }

    public void setInitializationAdUnitIds(List<String> list) {
        y.j("AppLovinSdkSettings", "setInitializationAdUnitIds(initializationAdUnitIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                y.i("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.i = arrayList;
        } else {
            this.i = Collections.emptyList();
        }
    }

    public List<String> getInitializationAdUnitIds() {
        return this.i;
    }

    public void setVerboseLogging(boolean bl) {
        y.j("AppLovinSdkSettings", "setVerboseLogging(isVerboseLoggingEnabled=" + bl + ")");
        if (Utils.isVerboseLoggingConfigured()) {
            y.i("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already.");
            if (Utils.isVerboseLoggingEnabled(null) != bl) {
                y.i("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.a = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.a;
    }

    public boolean isMuted() {
        return this.b;
    }

    public void setMuted(boolean bl) {
        y.j("AppLovinSdkSettings", "setMuted(muted=" + bl + ")");
        this.b = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        y.j("AppLovinSdkSettings", "setCreativeDebuggerEnabled(creativeDebuggerEnabled=" + bl + ")");
        this.c = bl;
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.c;
    }

    public void setExceptionHandlerEnabled(boolean bl) {
        y.j("AppLovinSdkSettings", "setExceptionHandlerEnabled(exceptionHandlerEnabled=" + bl + ")");
        this.d = bl;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.d;
    }

    public void setLocationCollectionEnabled(boolean bl) {
        y.j("AppLovinSdkSettings", "setLocationCollectionEnabled(locationCollectionEnabled=" + bl + ")");
        this.e = bl;
    }

    public boolean isLocationCollectionEnabled() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtraParameters() {
        Object object = this.k;
        synchronized (object) {
            return CollectionUtils.map(this.j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraParameter(String string2, @Nullable String string3) {
        y.j("AppLovinSdkSettings", "setExtraParameter(key=" + string2 + ", value=" + string3 + ")");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            y.i("AppLovinSdkSettings", "Failed to set extra parameter for null or empty key: " + string2);
            return;
        }
        String string4 = string3 != null ? string3.trim() : null;
        Object object = this.k;
        synchronized (object) {
            this.j.put(string2, string4);
        }
        if ("test_mode_network".equalsIgnoreCase(string2)) {
            if (this.l != null) {
                if (StringUtils.isValidString(string4)) {
                    this.l.av().a(true);
                    this.l.av().a(string4);
                } else {
                    this.l.av().a(false);
                    this.l.av().a((String)null);
                }
            } else {
                this.g = string4;
            }
        }
    }

    public void setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(boolean bl) {
        y.j("AppLovinSdkSettings", "setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(shouldFailAdDisplayIfDontKeepActivitiesIsEnabled=" + bl + ")");
        this.f = bl;
    }

    public boolean shouldFailAdDisplayIfDontKeepActivitiesIsEnabled() {
        return this.f;
    }

    protected void attachAppLovinSdk(p p2) {
        this.l = p2;
        if (StringUtils.isValidString(this.g)) {
            p2.av().a(true);
            p2.av().a(this.g);
            this.g = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DiscouragedApi"})
    private void a(Context context) {
        int n2 = context.getResources().getIdentifier("applovin_sdk_settings", "raw", context.getPackageName());
        String string2 = Utils.getRawResourceString(n2, context, null);
        JSONObject jSONObject = StringUtils.isValidString(string2) ? JsonUtils.jsonObjectFromJsonString(string2, new JSONObject()) : new JSONObject();
        Map<String, String> map = JsonUtils.tryToStringMap(jSONObject);
        Object object = this.k;
        synchronized (object) {
            this.j.putAll(map);
        }
    }

    @NonNull
    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.a + ", muted=" + this.b + ", testDeviceAdvertisingIds=" + this.h.toString() + ", initializationAdUnitIds=" + this.i.toString() + ", creativeDebuggerEnabled=" + this.c + ", exceptionHandlerEnabled=" + this.d + ", locationCollectionEnabled=" + this.e + '}';
    }
}

