/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.applovin.impl.mediation.nativeAds.MaxNativeAdImpl;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import java.util.List;

public class MaxNativeAd
extends MaxNativeAdImpl {
    private static final float MINIMUM_STARS_TO_RENDER = 3.0f;
    private final MaxAdFormat format;
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final MaxNativeAdImage icon;
    private final MaxNativeAdImage mainImage;
    private final View iconView;
    private final View optionsView;
    private final View mediaView;
    private final float mediaContentAspectRatio;
    private final Double starRating;
    private MaxNativeAdView nativeAdView;
    private boolean isExpired;

    public MaxNativeAd(Builder builder) {
        this.format = builder.a;
        this.title = builder.b;
        this.advertiser = builder.c;
        this.body = builder.d;
        this.callToAction = builder.e;
        this.icon = builder.f;
        this.iconView = builder.g;
        this.optionsView = builder.h;
        this.mediaView = builder.i;
        this.mainImage = builder.j;
        this.mediaContentAspectRatio = builder.k;
        Double d2 = builder.l;
        this.starRating = d2 != null && d2 >= 3.0 ? d2 : null;
    }

    @NonNull
    public final MaxAdFormat getFormat() {
        return this.format;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getAdvertiser() {
        return this.advertiser;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @Nullable
    public final String getCallToAction() {
        return this.callToAction;
    }

    @Nullable
    public final MaxNativeAdImage getIcon() {
        return this.icon;
    }

    @Nullable
    public final View getIconView() {
        return this.iconView;
    }

    @Nullable
    public final View getOptionsView() {
        return this.optionsView;
    }

    @Nullable
    public final View getMediaView() {
        return this.mediaView;
    }

    @Nullable
    public final MaxNativeAdImage getMainImage() {
        return this.mainImage;
    }

    public final float getMediaContentAspectRatio() {
        return this.mediaContentAspectRatio;
    }

    @Nullable
    public final Double getStarRating() {
        return this.starRating;
    }

    public final boolean isExpired() {
        return this.isExpired;
    }

    public void setExpired() {
        this.isExpired = true;
    }

    public void setNativeAdView(MaxNativeAdView maxNativeAdView) {
        this.nativeAdView = maxNativeAdView;
    }

    @Deprecated
    public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
    }

    public boolean prepareForInteraction(List<View> list, ViewGroup viewGroup) {
        return false;
    }

    public boolean shouldPrepareViewForInteractionOnMainThread() {
        return true;
    }

    public boolean isContainerClickable() {
        return false;
    }

    @UiThread
    public void performClick() {
        Button button;
        if (this.nativeAdView != null && (button = this.nativeAdView.getCallToActionButton()) != null) {
            button.performClick();
        }
    }

    public static class MaxNativeAdImage {
        private Drawable a;
        private Uri b;

        public MaxNativeAdImage(Drawable drawable2) {
            this.a = drawable2;
        }

        public MaxNativeAdImage(Uri uri) {
            this.b = uri;
        }

        @Nullable
        public Drawable getDrawable() {
            return this.a;
        }

        @Nullable
        public Uri getUri() {
            return this.b;
        }
    }

    public static class Builder {
        private MaxAdFormat a;
        private String b;
        private String c;
        private String d;
        private String e;
        private MaxNativeAdImage f;
        private View g;
        private View h;
        private View i;
        private MaxNativeAdImage j;
        private float k;
        private Double l;

        public Builder setAdFormat(MaxAdFormat maxAdFormat) {
            this.a = maxAdFormat;
            return this;
        }

        public Builder setTitle(String string2) {
            this.b = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.c = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.d = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.e = string2;
            return this;
        }

        public Builder setIcon(MaxNativeAdImage maxNativeAdImage) {
            this.f = maxNativeAdImage;
            return this;
        }

        public Builder setIconView(View view) {
            this.g = view;
            return this;
        }

        public Builder setOptionsView(View view) {
            this.h = view;
            return this;
        }

        public Builder setMediaView(View view) {
            this.i = view;
            return this;
        }

        public Builder setMainImage(MaxNativeAdImage maxNativeAdImage) {
            this.j = maxNativeAdImage;
            return this;
        }

        public Builder setMediaContentAspectRatio(float f2) {
            this.k = f2;
            return this;
        }

        public Builder setStarRating(Double d2) {
            this.l = d2;
            return this;
        }

        public MaxNativeAd build() {
            return new MaxNativeAd(this);
        }
    }
}

