/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.MaxErrorImpl;
import com.applovin.impl.mediation.a.c;
import com.applovin.impl.mediation.a.e;
import com.applovin.impl.mediation.a.f;
import com.applovin.impl.mediation.a.g;
import com.applovin.impl.mediation.a.h;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.c.d;
import com.applovin.impl.mediation.d;
import com.applovin.impl.mediation.g;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.p;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.k;
import com.applovin.impl.sdk.w;
import com.applovin.impl.sdk.y;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final p a;
    private final y b;
    private final AtomicReference<JSONObject> c = new AtomicReference();

    public MediationServiceImpl(p p2) {
        this.a = p2;
        this.b = p2.L();
        AppLovinBroadcastManager.registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, @Nullable String string3, MaxAdFormat maxAdFormat, d.a a2, Map<String, Object> map, Map<String, Object> map2, Context context, a.a a3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a3 == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)this.a.s())) {
            y.i("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (!this.a.d()) {
            y.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.a.B().startsWith("05TMD")) {
            y.i("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        if (this.a.a(maxAdFormat)) {
            y.i("MediationService", "Ad load failed due to disabled ad format " + maxAdFormat.getLabel());
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, "Disabled ad format " + maxAdFormat.getLabel());
            k.a((MaxAdListener)a3, string2, (MaxError)maxErrorImpl);
            return;
        }
        k.a(a3, string2, true);
        this.a.au().a(string2, string3, maxAdFormat, a2, map, map2, context, a3);
    }

    public void showFullscreenAd(final c c2, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null && MaxAdFormat.APP_OPEN != c2.getFormat()) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.Z().a(true);
        final g g2 = this.a(c2);
        long l2 = c2.G();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                c2.a(true);
                MediationServiceImpl.this.b(c2);
                g2.a(c2, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    public void showFullscreenAd(final c c2, final ViewGroup viewGroup, final Lifecycle lifecycle, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.Z().a(true);
        final g g2 = this.a(c2);
        long l2 = c2.G();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                c2.a(true);
                MediationServiceImpl.this.b(c2);
                g2.a(c2, viewGroup, lifecycle, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    private g a(c c2) {
        g g2 = c2.h();
        if (g2 == null) {
            this.a.Z().a(false);
            MediationServiceImpl mediationServiceImpl = this;
            if (mediationServiceImpl.b.a()) {
                this.b.d("MediationService", "Failed to show " + c2 + ": adapter not found");
            }
            y.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        return g2;
    }

    private void b(c c2) {
        if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
            com.applovin.impl.mediation.c.h h2 = new com.applovin.impl.mediation.c.h(c2, this.a);
            this.a.M().a(h2, o.a.t);
        }
    }

    private void a(c c2, a.a a2) {
        this.a.Z().a(false);
        this.a(c2, (MaxAdListener)a2);
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.b("MediationService", "Scheduling impression for ad manually...");
        }
        this.processRawAdImpressionPostback(c2, a2);
        if (c2.o() != null && c2.y().get()) {
            MediationServiceImpl mediationServiceImpl2 = this;
            if (mediationServiceImpl2.b.a()) {
                this.b.b("MediationService", "Running ad displayed logic");
            }
            this.a.ab().a(c2, "DID_DISPLAY");
            this.a.Z().a(c2);
            k.b(a2, (MaxAd)c2, true);
        }
    }

    public void destroyAd(MaxAd maxAd) {
        com.applovin.impl.mediation.a.a a2;
        g g2;
        if (!(maxAd instanceof com.applovin.impl.mediation.a.a)) {
            return;
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Destroying " + maxAd);
        }
        if ((g2 = (a2 = (com.applovin.impl.mediation.a.a)maxAd).h()) != null) {
            g2.j();
            a2.A();
        }
        this.a.am().b(a2.g());
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.a.a a2, Activity activity, a.a a3) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.b("MediationService", "Loading " + a2 + "...");
        }
        this.a.ab().a(a2, "WILL_LOAD");
        g g2 = this.a.an().a(a2);
        if (g2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2);
            if (this.a.a(com.applovin.impl.sdk.c.a.R).booleanValue()) {
                this.a.ao().a(a2, activity);
            }
            com.applovin.impl.mediation.a.a a4 = a2.a(g2);
            g2.a(string2, a4);
            a4.v();
            g2.a(string2, maxAdapterParametersImpl, a4, activity, new a(a4, a3));
        } else {
            String string3 = "Failed to load " + a2 + ": adapter not loaded";
            y.i("MediationService", string3);
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-5001, string3);
            this.a(a2, maxErrorImpl, a3);
        }
    }

    public void collectSignal(String string2, MaxAdFormat maxAdFormat, final h h2, Context context, final g.a a2) {
        if (h2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        boolean bl = h2.b();
        final g g2 = this.a.an().a(h2, bl);
        if (g2 != null) {
            Activity activity = context instanceof Activity ? (Activity)context : this.a.x();
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(h2, string2, maxAdFormat);
            if (this.a.a(com.applovin.impl.sdk.c.a.Q).booleanValue()) {
                this.a.ao().a(h2, activity);
            }
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string2) {
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, g2, string2));
                    g2.j();
                }

                @Override
                public void onSignalCollectionFailed(String string2) {
                    MediationServiceImpl.this.a(string2, h2, g2);
                    a2.a(com.applovin.impl.mediation.a.g.b(h2, g2, string2));
                    g2.j();
                }
            };
            if (h2.a()) {
                if (this.a.ao().a(h2)) {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.b.a()) {
                        this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + g2.d());
                    }
                    g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
                } else {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.b.a()) {
                        this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + g2.d());
                    }
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, "Adapter not initialized yet"));
                }
            } else {
                MediationServiceImpl mediationServiceImpl = this;
                if (mediationServiceImpl.b.a()) {
                    this.b.b("MediationService", "Collecting signal for adapter: " + g2.d());
                }
                g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(com.applovin.impl.mediation.a.g.a(h2, "Could not load adapter"));
        }
    }

    private void a(final c c2, final MaxAdListener maxAdListener) {
        final long l2 = this.a.a(com.applovin.impl.sdk.c.a.F);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.y().get()) {
                    return;
                }
                String string2 = "Ad (" + c2.Y() + ") has not been displayed after " + l2 + "ms. Failing ad display...";
                y.i("MediationService", string2);
                MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, string2);
                MediationServiceImpl.this.b(c2, maxErrorImpl, maxAdListener);
                MediationServiceImpl.this.a.Z().b(c2);
            }
        }, l2);
    }

    public void setCustomPostBodyData(JSONObject jSONObject) {
        this.c.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBodyData() {
        return this.c.getAndSet(null);
    }

    private void a(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a(maxError, a2);
        this.destroyAd(a2);
        k.a(maxAdListener, a2.getAdUnitId(), maxError);
    }

    private void b(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        if (a2.o() != null) {
            MediationServiceImpl mediationServiceImpl = this;
            if (mediationServiceImpl.b.a()) {
                this.b.e("MediationService", "Ignoring ad display failure for hybrid ad...");
            }
            return;
        }
        this.a.ab().a(a2, "DID_FAIL_DISPLAY");
        this.processAdDisplayErrorPostback(maxError, a2);
        if (a2.y().compareAndSet(false, true)) {
            k.a(maxAdListener, (MaxAd)a2, maxError);
        }
    }

    public void processAdLossPostback(com.applovin.impl.mediation.a.a a2, @Nullable Float f2) {
        String string2 = f2 != null ? f2.toString() : "";
        Map<String, String> map = CollectionUtils.map(1);
        map.put("{MBR}", string2);
        this.a("mloss", map, a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2) {
        this.a.ab().a(a2, "DID_LOAD");
        if (a2.e().endsWith("load")) {
            this.a.ab().a(a2);
        }
        Map<String, String> map = CollectionUtils.map(3);
        long l2 = a2.u();
        map.put("{LOAD_TIME_MS}", String.valueOf(l2));
        if (a2.getFormat().isFullscreenAd()) {
            w.a a3 = this.a.Z().b(a2.getAdUnitId());
            map.put("{SHOW_ATTEMPT_COUNT}", String.valueOf(a3.b()));
            map.put("{SHOW_ATTEMPT_TIMESTAMP_MS}", String.valueOf(a3.a()));
        }
        this.a("load", map, a2);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        Map<String, String> map = CollectionUtils.map(3);
        long l2 = a2.u();
        map.put("{LOAD_TIME_MS}", String.valueOf(l2));
        if (a2.getFormat().isFullscreenAd()) {
            w.a a3 = this.a.Z().b(a2.getAdUnitId());
            map.put("{SHOW_ATTEMPT_COUNT}", String.valueOf(a3.b()));
            map.put("{SHOW_ATTEMPT_TIMESTAMP_MS}", String.valueOf(a3.a()));
        }
        this.a("mlerr", map, maxError, a2);
    }

    public void processAdapterInitializationPostback(f f2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        Map<String, String> map = CollectionUtils.map(2);
        map.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        map.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", map, new MaxErrorImpl(string2), f2);
    }

    public void processRawAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        Object object;
        this.a.ab().a(a2, "WILL_DISPLAY");
        if (a2.e().endsWith("mimp")) {
            this.a.ab().a(a2);
            k.a(a3, (MaxAd)a2);
        }
        Map<String, String> map = CollectionUtils.map(2);
        if (a2 instanceof c) {
            object = (c)a2;
            map.put("{TIME_TO_SHOW_MS}", String.valueOf(((c)object).F()));
        }
        object = StringUtils.emptyIfNull(this.a.o());
        map.put("{CUID}", (String)(this.a.a(com.applovin.impl.sdk.c.b.dQ) != false ? object : ""));
        this.a("mimp", map, a2);
    }

    public void processViewabilityAdImpressionPostback(e e2, long l2, a.a a2) {
        if (e2.e().endsWith("vimp")) {
            this.a.ab().a(e2);
            k.a(a2, (MaxAd)e2);
        }
        Map<String, String> map = CollectionUtils.map(3);
        map.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        map.put("{USED_VIEWABILITY_TIMER}", String.valueOf(e2.S()));
        String string2 = StringUtils.emptyIfNull(this.a.o());
        map.put("{CUID}", this.a.a(com.applovin.impl.sdk.c.b.dQ) != false ? string2 : "");
        this.a("mvimp", map, e2);
    }

    public void processCallbackAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        if (a2.e().endsWith("cimp")) {
            this.a.ab().a(a2);
            k.a(a3, (MaxAd)a2);
        }
        Map<String, String> map = CollectionUtils.map(1);
        String string2 = StringUtils.emptyIfNull(this.a.o());
        map.put("{CUID}", this.a.a(com.applovin.impl.sdk.c.b.dQ) != false ? string2 : "");
        this.a("mcimp", map, a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2, a.a a3) {
        this.a.ab().a(a2, "DID_CLICKED");
        this.a.ab().a(a2, "DID_CLICK");
        if (a2.e().endsWith("click")) {
            this.a.ab().a(a2);
            k.a(a3, (MaxAd)a2);
        }
        Map<String, String> map = CollectionUtils.map(1);
        String string2 = StringUtils.emptyIfNull(this.a.o());
        map.put("{CUID}", this.a.a(com.applovin.impl.sdk.c.b.dQ) != false ? string2 : "");
        this.a("mclick", map, a2);
    }

    public void processAdDisplayErrorPostback(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, maxError, a2);
    }

    private void a(String string2, h h2, g g2) {
        Map<String, String> map = CollectionUtils.map(2);
        CollectionUtils.putStringIfValid("{ADAPTER_VERSION}", g2.i(), map);
        CollectionUtils.putStringIfValid("{SDK_VERSION}", g2.h(), map);
        this.a("serr", map, new MaxErrorImpl(string2), h2);
    }

    private void a(String string2, Map<String, String> map, f f2) {
        this.a(string2, map, null, f2);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, f f2) {
        Object object;
        Map<String, String> map2 = CollectionUtils.map(map);
        map2.put("{PLACEMENT}", StringUtils.emptyIfNull(f2.getPlacement()));
        map2.put("{CUSTOM_DATA}", StringUtils.emptyIfNull(f2.al()));
        if (f2 instanceof com.applovin.impl.mediation.a.a) {
            object = (com.applovin.impl.mediation.a.a)f2;
            map2.put("{CREATIVE_ID}", StringUtils.emptyIfNull(((com.applovin.impl.mediation.a.a)object).getCreativeId()));
        }
        object = new d(string2, map2, maxError, f2, this.a);
        this.a.M().a((com.applovin.impl.sdk.e.a)object, o.a.n);
    }

    @Override
    public void onReceive(Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.a.Z().c()) instanceof com.applovin.impl.mediation.a.a) {
            com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)object;
            this.processAdDisplayErrorPostback(MaxAdapterError.WEBVIEW_ERROR, a2);
        }
    }

    public class a
    implements a.a,
    MaxAdListener,
    MaxAdRevenueListener,
    MaxAdViewAdListener,
    MaxRewardedAdListener {
        private final com.applovin.impl.mediation.a.a b;
        private a.a c;

        public a(com.applovin.impl.mediation.a.a a2, a.a a3) {
            this.b = a2;
            this.c = a3;
        }

        public void a(a.a a2) {
            this.c = a2;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.a(maxAd, null);
        }

        public void a(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            this.b.x();
            MediationServiceImpl.this.a(this.b);
            k.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string2, MaxError maxError) {
            this.b.x();
            MediationServiceImpl.this.a(this.b, maxError, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            this.b(maxAd, null);
        }

        public void b(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            MediationServiceImpl.this.b;
            if (y.a()) {
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            }
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.b, this.c);
            MediationServiceImpl.this.a.P().a(com.applovin.impl.sdk.d.f.c);
            MediationServiceImpl.this.a.P().a(com.applovin.impl.sdk.d.f.f);
            if (maxAd.getFormat().isFullscreenAd()) {
                c c2 = (c)maxAd;
                if (c2.S()) {
                    MediationServiceImpl.this.a.ab().a(this.b, "DID_DISPLAY");
                    MediationServiceImpl.this.a.Z().a(this.b);
                    k.b(this.c, maxAd);
                } else {
                    MediationServiceImpl.this.b;
                    if (y.a()) {
                        MediationServiceImpl.this.b.d("MediationService", "Received ad display callback before attempting show" + (c2.o() != null ? " for hybrid ad" : ""));
                    }
                }
            } else {
                MediationServiceImpl.this.a.ab().a(this.b, "DID_DISPLAY");
                k.b(this.c, maxAd);
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            this.c(maxAd, null);
        }

        public void c(final MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            MediationServiceImpl.this.a.ab().a((com.applovin.impl.mediation.a.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).H();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat().isFullscreenAd()) {
                        MediationServiceImpl.this.a.Z().b(maxAd);
                    }
                    k.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            this.d(maxAd, null);
        }

        public void d(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            MediationServiceImpl.this.a(this.b, this.c);
            k.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
            this.a(maxAd, maxError, null);
        }

        public void a(MaxAd maxAd, MaxError maxError, @Nullable Bundle bundle) {
            this.b.a(bundle);
            MediationServiceImpl.this.b(this.b, maxError, this.c);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).M();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            k.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            k.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            this.a(maxAd, maxReward, null);
        }

        public void a(MaxAd maxAd, MaxReward maxReward, @Nullable Bundle bundle) {
            this.b.a(bundle);
            k.a((MaxAdListener)this.c, maxAd, maxReward);
            com.applovin.impl.mediation.c.g g2 = new com.applovin.impl.mediation.c.g((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.M().a(g2, o.a.t);
        }

        @Override
        public void onAdRevenuePaid(MaxAd maxAd) {
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            this.e(maxAd, null);
        }

        public void e(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            k.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            this.f(maxAd, null);
        }

        public void f(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.a(bundle);
            k.h(this.c, maxAd);
        }

        @Override
        public void onAdRequestStarted(String string2) {
        }
    }
}

