/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, objectArray));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, n2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, l2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, char c3) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, int n2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, char c2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, int n3) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, n3));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, l2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, char c2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, int n2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, n2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, long l3) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, l3));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, n2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, l2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2, object3));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2, object3, object4));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, objectArray));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, n2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, l2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, char c3) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, int n2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, long l2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, char c2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, int n3) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, n2, n3));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, long l2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, n2, l2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, n2, object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, char c2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, int n2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, l2, n2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, long l3) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, l2, l3));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, l2, object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, n2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, l2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, object2));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, object2, object3));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string2, object, object2, object3, object4));
        }
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, objectArray));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2)));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, n2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, l2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, char c3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, int n3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, n2, n3));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, n2, l2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, n2, object));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, l2, n2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, long l3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, l2, l3));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, l2, object));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, n2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, l2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, object2));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, object2, object3));
        }
        return t2;
    }

    @NonNullDecl
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string2, object, object2, object3, object4));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string2));
        }
        return n2;
    }

    private static String badElementIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string2, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string2, n2, n3);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string2));
        }
        return n2;
    }

    private static String badPositionIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string2, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string2, n2, n3);
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
        }
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n4) {
            return Preconditions.badPositionIndex(n2, n4, "start index");
        }
        if (n3 < 0 || n3 > n4) {
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n3, n2);
    }
}

