package com.applovin.sdk;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Thomas So on October 02 2018
 * <p>
 * Object containing various flags related to the SDK configuration.
 */
public interface AppLovinSdkConfiguration
{
    /**
     * Get the country code for this user. Returns an empty string if not available.
     */
    String getCountryCode();

    /**
     * Get the list of those Ad Unit IDs that are in the waterfall that is currently active for a particular user and
     * for which Amazon Publisher Services is enabled.
     *
     * Which waterfall is currently active for a user depends on things like A/B tests, keyword targeting, or DNT.
     *
     * @return {@code null} when configuration fetching fails (e.g. in the case of no connection) or
     * an empty list if no Ad Unit IDs have Amazon Publisher Services enabled.
     */
    @Nullable
    List<String> getEnabledAmazonAdUnitIds();

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    enum ConsentDialogState
    {
        UNKNOWN,
        APPLIES,
        DOES_NOT_APPLY
    }

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    ConsentDialogState getConsentDialogState();
}
