package com.applovin.sdk;

import android.app.Activity;

import androidx.annotation.Nullable;

/**
 * Created by santoshbagadi on 10/11/22.
 */
public interface AppLovinCFService
{
    interface OnCFCompletionCallback
    {
        /**
         * Called when we finish showing the consent flow.
         *
         * @param error An error if the consent flow failed to start or failed to complete.
         */
        void onFlowCompleted(@Nullable final AppLovinCFError error);
    }

    enum CFType
    {
        /**
         * The flow type is not known.
         */
        UNKNOWN,

        /**
         * A standard flow where a TOS/PP alert is shown.
         */
        STANDARD,

        /**
         * A detailed modal shown to users in GDPR region.
         */
        DETAILED
    }

    /**
     * Starts the consent flow. Call this method to re-show the consent flow for a user in GDPR region.
     * <p>
     * Note: The flow will only be shown to users in GDPR regions.
     */
    void scf(final Activity activity, final OnCFCompletionCallback listener);

    /**
     * @return The consent flow type that will be displayed.
     * @hide
     */
    CFType getCFType();
}
