package com.applovin.sdk;

import android.app.Activity;

/**
 * Created by santoshbagadi on 10/11/22.
 */
public interface AppLovinCFError
{
    /**
     * Indicates that the flow ended in an unexpected state.
     */
    int ERROR_CODE_UNSPECIFIED = -1;

    /**
     * Indicates that the consent flow has not been integrated correctly.
     */
    int ERROR_CODE_INVALID_INTEGRATION = -100;

    /**
     * Indicates that the consent flow is already being shown.
     */
    int ERROR_CODE_FLOW_ALREADY_IN_PROGRESS = -200;

    /**
     * Indicates that the user is not in a GDPR region if the {@link AppLovinCFService#scf(Activity, AppLovinCFService.OnCFCompletionCallback)} is called for a non GDPR user.
     */
    int ERROR_CODE_NOT_IN_GDPR_REGION = -300;

    /**
     * The error code for this error. Will be one of the error codes listed in this file.
     */
    int getCode();

    /**
     * The error message for this error.
     */
    String getMessage();
}
