/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.net.Uri;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.n;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class StringUtils {
    private static final char[] a = "0123456789abcdef".toCharArray();

    public static int parseInt(String string2) {
        return StringUtils.parseInt(string2, 0);
    }

    public static int parseInt(String string2, int n2) {
        return StringUtils.isNumeric(string2) ? Integer.parseInt(string2) : n2;
    }

    public static boolean containsIgnoreCase(String string2, String string3) {
        return StringUtils.isValidString(string2) && StringUtils.isValidString(string3) && string2.toLowerCase().contains(string3.toLowerCase());
    }

    public static boolean isValidString(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    public static String emptyIfNull(String string2) {
        return string2 == null ? "" : string2;
    }

    public static String replace(String string2, String string3, String string4) {
        if (string4 == null) {
            throw new IllegalArgumentException("No replacement target specified");
        }
        if (string2 == null || string2.length() < 1) {
            return string2;
        }
        if (string3 == null || string3.length() < 1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n2 = stringBuilder.indexOf(string3);
        while (n2 != -1) {
            stringBuilder.replace(n2, n2 + string3.length(), string4);
            n2 += string4.length();
            n2 = stringBuilder.indexOf(string3, n2);
        }
        return stringBuilder.toString();
    }

    public static String replace(String string2, Map<String, String> map) {
        if (string2 == null || map == null) {
            return string2;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = string2.replace(entry.getKey(), entry.getValue());
        }
        return string2;
    }

    public static boolean isNumeric(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        char c2 = string2.charAt(0);
        int n2 = c2 == '-' || c2 == '+' ? 1 : 0;
        int n3 = string2.length();
        if (n2 == 1 && n3 == 1) {
            return false;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (Character.isDigit(string2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String string2) {
        if (StringUtils.isValidString(string2)) {
            return string2.matches("^[a-zA-Z0-9]*$");
        }
        return false;
    }

    public static String prefixToIndex(int n2, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n3 = n2 > string2.length() ? string2.length() : n2;
        return string2.substring(0, n3);
    }

    public static String encodeUriString(String string2, n n2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (n2.a(b.fi).booleanValue()) {
                return Uri.encode((String)string2);
            }
            try {
                return URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new UnsupportedOperationException(unsupportedEncodingException);
            }
        }
        return "";
    }

    public static String appendQueryParameter(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return string2;
        }
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter(string3, string4);
        return builder.build().toString();
    }

    public static String appendQueryParameters(String string2, Map<String, String> map, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (map == null || map.isEmpty()) {
            return string2;
        }
        Map<String, String> map2 = map;
        if (bl) {
            map2 = new TreeMap<String, String>(new Comparator<String>(){

                public int a(String string2, String string3) {
                    return string2.compareToIgnoreCase(string3);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((String)object, (String)object2);
                }
            });
            map2.putAll(map);
        }
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.build().toString();
    }

    public static String getHostAndPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getHost() + uri.getPath();
    }

    public static String toFullSHA1Hash(String string2) {
        return StringUtils.a(string2, -1);
    }

    public static String toShortSHA1Hash(String string2) {
        return StringUtils.a(string2, 16);
    }

    private static String a(String string2, Integer n2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string2.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            String string3 = StringUtils.toHexString(byArray);
            if (n2 > 0) {
                int n3 = Math.min(n2, string3.length());
                return string3.substring(0, n3);
            }
            return string3;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("SHA-1 for \"" + string2 + "\" failed.", throwable);
        }
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("No data specified");
        }
        char[] cArray = new char[2 * byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[2 * i2] = a[(byArray[i2] & 0xF0) >>> 4];
            cArray[2 * i2 + 1] = a[byArray[i2] & 0xF];
        }
        return new String(cArray);
    }

    public static String toHumanReadableString(String string2) {
        String[] stringArray;
        if (!StringUtils.isValidString(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (String string3 : stringArray = string2.split("_")) {
            if (!StringUtils.isValidString(string3)) continue;
            if (string3.equals("id")) {
                stringBuilder.append(string3.toUpperCase(Locale.ENGLISH));
            } else {
                stringBuilder.append(string3.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(string3.substring(1).toLowerCase(Locale.ENGLISH));
            }
            stringBuilder.append(" ");
        }
        stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static Boolean endsWith(String string2, List<String> list) {
        for (String string3 : list) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static SpannedString createListItemDetailSpannedString(String string2, int n2) {
        return StringUtils.createSpannedString(string2, n2, 16);
    }

    public static SpannedString createListItemDetailSubSpannedString(String string2, int n2) {
        return StringUtils.createSpannedString(string2, n2, 12, 1);
    }

    public static SpannedString createSpannedString(String string2, int n2, int n3) {
        return StringUtils.createSpannedString(string2, n2, n3, 0);
    }

    public static SpannedString createSpannedString(String string2, int n2, int n3, int n4) {
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        spannableString.setSpan((Object)new ForegroundColorSpan(n2), 0, spannableString.length(), 33);
        spannableString.setSpan((Object)new AbsoluteSizeSpan(n3, true), 0, spannableString.length(), 33);
        spannableString.setSpan((Object)new StyleSpan(n4), 0, spannableString.length(), 33);
        return new SpannedString((CharSequence)spannableString);
    }

    public static String toDigitsOnlyVersionString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        String[] stringArray = string2.split("\\.");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string3 : stringArray) {
            String[] stringArray2;
            if (!StringUtils.isValidString(string3) || (stringArray2 = string3.split("[^0-9]+")).length <= 0) continue;
            arrayList.add(stringArray2[0]);
        }
        return TextUtils.join((CharSequence)".", arrayList);
    }
}

