/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.adview.d;
import com.applovin.impl.sdk.AppLovinAdBase;
import com.applovin.impl.sdk.a.e;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.nativeAd.AppLovinMediaView;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdEventListener;
import com.applovin.impl.sdk.nativeAd.AppLovinOptionsView;
import com.applovin.impl.sdk.network.l;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.k;
import com.applovin.impl.sdk.v;
import com.applovin.sdk.AppLovinSdkUtils;
import com.iab.omid.library.applovin.adsession.VerificationScriptResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinNativeAdImpl
extends AppLovinAdBase
implements AppLovinNativeAd {
    private static final String DEFAULT_APPLOVIN_PRIVACY_URL = "https://www.applovin.com/privacy/";
    private static final float MINIMUM_STARS_TO_RENDER = 3.0f;
    private static final String AD_RESPONSE_TYPE_APPLOVIN = "applovin";
    private static final String AD_RESPONSE_TYPE_ORTB = "ortb";
    private static final String AD_RESPONSE_TYPE_UNDEFINED = "undefined";
    private final String tag;
    private final AtomicBoolean impressionTracked = new AtomicBoolean();
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final Double starRating;
    private final com.applovin.impl.b.a vastAd;
    private final Uri clickDestinationUri;
    private final Uri clickDestinationBackupUri;
    private final List<String> clickTrackingUrls;
    private final List<String> jsTrackers;
    private final List<l> impressionRequests;
    private final List<l> viewableMRC50Requests;
    private final List<l> viewableMRC100Requests;
    private final List<l> viewableVideo50Requests;
    private final a clickHandler;
    private final b onAttachStateChangeHandler;
    private AppLovinNativeAdEventListener eventListener;
    private ViewGroup nativeAdView;
    private Uri iconUri;
    private Uri mainImageUri;
    private Uri privacyIconUri;
    private Uri privacyDestinationUri;
    private AppLovinMediaView mediaView;
    private AppLovinOptionsView optionsView;
    private final List<View> registeredViews = new ArrayList<View>();
    private final e adEventTracker;

    private AppLovinNativeAdImpl(Builder builder) {
        super(builder.adObject, builder.fullResponse, builder.sdk);
        this.clickHandler = new a(this);
        this.onAttachStateChangeHandler = new b(this);
        this.adEventTracker = new e(this);
        this.title = builder.title;
        this.advertiser = builder.advertiser;
        this.body = builder.body;
        this.callToAction = builder.callToAction;
        this.iconUri = builder.iconUri;
        this.mainImageUri = builder.mainImageUri;
        this.privacyIconUri = builder.privacyIconUri;
        this.vastAd = builder.vastAd;
        this.clickDestinationUri = builder.clickDestinationUri;
        this.clickDestinationBackupUri = builder.clickDestinationBackupUri;
        this.clickTrackingUrls = builder.clickTrackingUrls;
        this.jsTrackers = builder.jsTrackers;
        this.impressionRequests = builder.impressionRequests;
        Double d2 = builder.starRating;
        Double d3 = this.starRating = d2 != null && d2 >= 3.0 ? d2 : null;
        if (builder.privacyDestinationUri != null) {
            this.privacyDestinationUri = builder.privacyDestinationUri;
        } else if (!this.isDspAd() || this.getSdk().ap().a()) {
            this.privacyDestinationUri = Uri.parse((String)DEFAULT_APPLOVIN_PRIVACY_URL);
        }
        this.viewableMRC50Requests = builder.viewableMRC50Requests;
        this.viewableMRC100Requests = builder.viewableMRC100Requests;
        this.viewableVideo50Requests = builder.viewableVideo50Requests;
        this.tag = "AppLovinNativeAd:" + this.getAdIdNumber();
    }

    @Override
    public void registerViewsForInteraction(List<View> list, ViewGroup viewGroup) {
        this.nativeAdView = viewGroup;
        if (h.c() && this.nativeAdView.isAttachedToWindow()) {
            this.maybeHandleOnAttachedToWindow((View)this.nativeAdView);
        } else if (!h.c() && this.nativeAdView.getParent() != null) {
            this.maybeHandleOnAttachedToWindow((View)this.nativeAdView);
        } else {
            this.nativeAdView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeHandler);
        }
        this.sdk.J();
        if (v.a()) {
            this.sdk.J().b(this.tag, "Registered ad view for impressions: " + this.nativeAdView);
        }
        if (this.clickDestinationUri == null && this.clickDestinationBackupUri == null) {
            this.sdk.J();
            if (v.a()) {
                this.sdk.J().b(this.tag, "Skipping click registration - no click URLs provided");
            }
            return;
        }
        for (View view : list) {
            if (view.hasOnClickListeners()) {
                this.sdk.J();
                if (v.a()) {
                    this.sdk.J().e(this.tag, "View has an onClickListener already - " + view);
                }
            }
            if (!view.isClickable()) {
                this.sdk.J();
                if (v.a()) {
                    this.sdk.J().e(this.tag, "View is not clickable - " + view);
                }
            }
            if (!view.isEnabled()) {
                this.sdk.J();
                if (v.a()) {
                    this.sdk.J().e(this.tag, "View is not enabled - " + view);
                }
            }
            if (view instanceof Button) {
                this.sdk.J();
                if (v.a()) {
                    this.sdk.J().b(this.tag, "Registering click for button: " + view);
                }
            } else {
                this.sdk.J();
                if (v.a()) {
                    this.sdk.J().b(this.tag, "Registering click for view: " + view);
                }
            }
            view.setOnClickListener((View.OnClickListener)this.clickHandler);
            this.registeredViews.add(view);
        }
        this.sdk.J();
        if (v.a()) {
            this.sdk.J().b(this.tag, "Registered views: " + this.registeredViews);
        }
    }

    @Override
    public void unregisterViewsForInteraction() {
        for (View view : this.registeredViews) {
            view.setOnClickListener(null);
        }
        this.sdk.J();
        if (v.a()) {
            this.sdk.J().b(this.tag, "Unregistered views: " + this.registeredViews);
        }
        this.registeredViews.clear();
        if (this.nativeAdView != null) {
            this.nativeAdView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeHandler);
            this.nativeAdView = null;
        }
        if (this.mediaView != null) {
            this.mediaView.destroy();
        }
        if (this.optionsView != null) {
            this.optionsView.destroy();
        }
    }

    @Override
    public void destroy() {
        this.unregisterViewsForInteraction();
        this.eventListener = null;
        this.adEventTracker.e();
    }

    public void setUpNativeAdViewComponents() {
        AppLovinNativeAdImpl appLovinNativeAdImpl = this;
        this.mediaView = new AppLovinMediaView(this, this.sdk, appLovinNativeAdImpl.sdk.x());
        if (this.privacyDestinationUri != null) {
            AppLovinNativeAdImpl appLovinNativeAdImpl2 = this;
            this.optionsView = new AppLovinOptionsView(this, this.sdk, appLovinNativeAdImpl2.sdk.x());
        }
    }

    private void maybeHandleOnAttachedToWindow(View view) {
        if (this.impressionTracked.compareAndSet(false, true)) {
            if (this.jsTrackers != null && this.jsTrackers.size() > 0) {
                if (this.sdk.a(com.applovin.impl.sdk.c.b.fA).booleanValue()) {
                    for (String object : this.jsTrackers) {
                        this.sdk.W().a(object);
                    }
                } else {
                    String string2 = this.jsTrackers.get(0);
                    if (StringUtils.isValidString(string2)) {
                        final d d2 = new d(null, this.sdk, view.getContext());
                        d2.loadData(string2, "text/html", "UTF-8");
                        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                            @Override
                            public void run() {
                                d2.stopLoading();
                            }
                        }, TimeUnit.SECONDS.toMillis(5L));
                    }
                }
            }
            for (l l2 : this.impressionRequests) {
                this.sdk.ae().dispatchPostbackRequest(l2, null);
            }
            this.adEventTracker.a(view);
            this.adEventTracker.d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<com.applovin.impl.sdk.d.a> getDirectClickTrackingPostbacks() {
        Object object = this.adObjectLock;
        synchronized (object) {
            String string2 = this.getStringFromAdObject("click_tracking_url", null);
            return Utils.getPostbacks("click_tracking_urls", this.adObject, this.getClCode(), string2, this.sdk);
        }
    }

    private boolean isDspAd() {
        return AD_RESPONSE_TYPE_ORTB.equalsIgnoreCase(this.getType());
    }

    public String getType() {
        return this.getStringFromAdObject("type", AD_RESPONSE_TYPE_UNDEFINED);
    }

    @Override
    public long getAdIdNumber() {
        return this.getLongFromAdObject("ad_id", -1L);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAdvertiser() {
        return this.advertiser;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getCallToAction() {
        return this.callToAction;
    }

    @Override
    public Double getStarRating() {
        return this.starRating;
    }

    @Override
    public Uri getIconUri() {
        return this.iconUri;
    }

    @Override
    public AppLovinMediaView getMediaView() {
        return this.mediaView;
    }

    @Override
    public AppLovinOptionsView getOptionsView() {
        return this.optionsView;
    }

    @Nullable
    public String getCachePrefix() {
        return this.getStringFromAdObject("cache_prefix", null);
    }

    public e getAdEventTracker() {
        return this.adEventTracker;
    }

    @Override
    public boolean isOpenMeasurementEnabled() {
        return this.getBooleanFromAdObject("omsdk_enabled", false);
    }

    @Override
    @Nullable
    public String getOpenMeasurementContentUrl() {
        return this.getStringFromAdObject("omid_content_url", null);
    }

    @Override
    public String getOpenMeasurementCustomReferenceData() {
        return this.getStringFromAdObject("omid_custom_ref_data", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VerificationScriptResource> getOpenMeasurementVerificationScriptResources() {
        ArrayList<VerificationScriptResource> arrayList = new ArrayList<VerificationScriptResource>();
        Object object = this.adObjectLock;
        synchronized (object) {
            JSONArray jSONArray = JsonUtils.getJSONArray(this.adObject, "omid_verification_script_resources", null);
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = JsonUtils.getJSONObject(jSONArray, i2, null);
                    try {
                        String string2 = JsonUtils.getString(jSONObject, "url", null);
                        URL uRL = new URL(string2);
                        String string3 = JsonUtils.getString(jSONObject, "vendor_key", null);
                        String string4 = JsonUtils.getString(jSONObject, "parameters", null);
                        if (StringUtils.isValidString(string3) && StringUtils.isValidString(string4)) {
                            arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithParameters(string3, uRL, string4));
                            continue;
                        }
                        arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithoutParameters(uRL));
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.sdk.J();
                        if (!v.a()) continue;
                        this.sdk.J().b(this.tag, "Failed to parse OMID verification script resource", throwable);
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean shouldInjectOpenMeasurementScriptDuringCaching() {
        return false;
    }

    @Override
    public boolean isDirectDownloadEnabled() {
        return StringUtils.isValidString(this.getDirectDownloadToken());
    }

    @Override
    @Nullable
    public String getDirectDownloadToken() {
        return this.getStringFromAdObject("ah_dd_token", null);
    }

    @Override
    @Nullable
    public Bundle getDirectDownloadParameters() {
        JSONObject jSONObject = this.getJsonObjectFromAdObject("ah_parameters", null);
        return jSONObject != null ? JsonUtils.toBundle(jSONObject) : null;
    }

    @NonNull
    public String toString() {
        return "AppLovinNativeAd{adIdNumber=" + this.getAdIdNumber() + " - " + this.getTitle() + "}";
    }

    public com.applovin.impl.b.a getVastAd() {
        return this.vastAd;
    }

    public a getClickHandler() {
        return this.clickHandler;
    }

    public void setEventListener(AppLovinNativeAdEventListener appLovinNativeAdEventListener) {
        this.eventListener = appLovinNativeAdEventListener;
    }

    public void setIconUri(Uri uri) {
        this.iconUri = uri;
    }

    public Uri getMainImageUri() {
        return this.mainImageUri;
    }

    public void setMainImageUri(Uri uri) {
        this.mainImageUri = uri;
    }

    public Uri getPrivacyIconUri() {
        return this.privacyIconUri;
    }

    public void setPrivacyIconUri(Uri uri) {
        this.privacyIconUri = uri;
    }

    public Uri getPrivacyDestinationUri() {
        return this.privacyDestinationUri;
    }

    public static class Builder {
        private final JSONObject adObject;
        private final JSONObject fullResponse;
        private final n sdk;
        private String title;
        private String advertiser;
        private String body;
        private String callToAction;
        private Double starRating;
        private Uri iconUri;
        private Uri mainImageUri;
        private Uri privacyIconUri;
        private com.applovin.impl.b.a vastAd;
        private Uri clickDestinationUri;
        private Uri clickDestinationBackupUri;
        private Uri privacyDestinationUri;
        private List<String> clickTrackingUrls;
        private List<String> jsTrackers;
        private List<l> impressionRequests;
        private List<l> viewableMRC50Requests;
        private List<l> viewableMRC100Requests;
        private List<l> viewableVideo50Requests;

        public Builder(JSONObject jSONObject, JSONObject jSONObject2, n n2) {
            this.adObject = jSONObject;
            this.fullResponse = jSONObject2;
            this.sdk = n2;
        }

        public Builder setTitle(String string2) {
            this.title = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.advertiser = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.body = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.callToAction = string2;
            return this;
        }

        public Builder setStarRating(Double d2) {
            this.starRating = d2;
            return this;
        }

        public Builder setIconUri(Uri uri) {
            this.iconUri = uri;
            return this;
        }

        public Builder setMainImageUri(Uri uri) {
            this.mainImageUri = uri;
            return this;
        }

        public Builder setPrivacyIconUri(Uri uri) {
            this.privacyIconUri = uri;
            return this;
        }

        public Builder setVastAd(com.applovin.impl.b.a a2) {
            this.vastAd = a2;
            return this;
        }

        public Builder setPrivacyDestinationUri(Uri uri) {
            this.privacyDestinationUri = uri;
            return this;
        }

        public Builder setClickDestinationUri(Uri uri) {
            this.clickDestinationUri = uri;
            return this;
        }

        public Builder setClickDestinationBackupUri(Uri uri) {
            this.clickDestinationBackupUri = uri;
            return this;
        }

        public Builder setClickTrackingUrls(List<String> list) {
            this.clickTrackingUrls = list;
            return this;
        }

        public Builder setJsTrackers(List<String> list) {
            this.jsTrackers = list;
            return this;
        }

        public Builder setImpressionRequests(List<l> list) {
            this.impressionRequests = list;
            return this;
        }

        public Builder setViewableMRC50Requests(List<l> list) {
            this.viewableMRC50Requests = list;
            return this;
        }

        public Builder setViewableMRC100Requests(List<l> list) {
            this.viewableMRC100Requests = list;
            return this;
        }

        public Builder setViewableVideo50Requests(List<l> list) {
            this.viewableVideo50Requests = list;
            return this;
        }

        public AppLovinNativeAdImpl build() {
            return new AppLovinNativeAdImpl(this);
        }
    }

    private static class a
    implements View.OnClickListener {
        private final AppLovinNativeAdImpl a;

        public void onClick(final View view) {
            this.a.sdk.J();
            if (v.a()) {
                this.a.sdk.J().b(this.a.tag, "Handle view clicked");
            }
            this.a.sdk.D().maybeSubmitPersistentPostbacks(this.a.getDirectClickTrackingPostbacks());
            for (String string2 : this.a.clickTrackingUrls) {
                this.a.sdk.ae().dispatchPostbackAsync(string2, null);
            }
            k.a(this.a.eventListener, this.a);
            if (this.a.isDirectDownloadEnabled()) {
                this.a.sdk.ad().startDirectInstallOrDownloadProcess(this.a, new ArrayService.DirectDownloadListener(){

                    @Override
                    public void onAppDetailsDisplayed() {
                    }

                    @Override
                    public void onAppDetailsDismissed() {
                    }

                    @Override
                    public void onFailure() {
                        this.a(a, view.getContext());
                    }
                });
            } else {
                this.a(this.a, view.getContext());
            }
        }

        private void a(AppLovinNativeAdImpl appLovinNativeAdImpl, Context context) {
            if (Utils.openUri(context, appLovinNativeAdImpl.clickDestinationUri, appLovinNativeAdImpl.sdk)) {
                appLovinNativeAdImpl.sdk.J();
                if (v.a()) {
                    appLovinNativeAdImpl.sdk.J().b(appLovinNativeAdImpl.tag, "Opening URL: " + appLovinNativeAdImpl.clickDestinationUri);
                }
            } else if (Utils.openUri(context, appLovinNativeAdImpl.clickDestinationBackupUri, appLovinNativeAdImpl.sdk)) {
                appLovinNativeAdImpl.sdk.J();
                if (v.a()) {
                    appLovinNativeAdImpl.sdk.J().b(appLovinNativeAdImpl.tag, "Opening backup URL: " + appLovinNativeAdImpl.clickDestinationBackupUri);
                }
            }
        }

        public a(AppLovinNativeAdImpl appLovinNativeAdImpl) {
            this.a = appLovinNativeAdImpl;
        }

        public AppLovinNativeAdImpl a() {
            return this.a;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a a2 = (a)object;
            if (!a2.a(this)) {
                return false;
            }
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            AppLovinNativeAdImpl appLovinNativeAdImpl2 = a2.a();
            return !(appLovinNativeAdImpl == null ? appLovinNativeAdImpl2 != null : !appLovinNativeAdImpl.equals(appLovinNativeAdImpl2));
        }

        protected boolean a(Object object) {
            return object instanceof a;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            n3 = n3 * 59 + (appLovinNativeAdImpl == null ? 43 : appLovinNativeAdImpl.hashCode());
            return n3;
        }

        public String toString() {
            return "AppLovinNativeAdImpl.ClickHandler(ad=" + this.a() + ")";
        }
    }

    private static class b
    implements View.OnAttachStateChangeListener {
        private final AppLovinNativeAdImpl a;

        public void onViewAttachedToWindow(View view) {
            this.a.maybeHandleOnAttachedToWindow(view);
        }

        public void onViewDetachedFromWindow(View view) {
        }

        public b(AppLovinNativeAdImpl appLovinNativeAdImpl) {
            this.a = appLovinNativeAdImpl;
        }

        public AppLovinNativeAdImpl a() {
            return this.a;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof b)) {
                return false;
            }
            b b2 = (b)object;
            if (!b2.a(this)) {
                return false;
            }
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            AppLovinNativeAdImpl appLovinNativeAdImpl2 = b2.a();
            return !(appLovinNativeAdImpl == null ? appLovinNativeAdImpl2 != null : !appLovinNativeAdImpl.equals(appLovinNativeAdImpl2));
        }

        protected boolean a(Object object) {
            return object instanceof b;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            n3 = n3 * 59 + (appLovinNativeAdImpl == null ? 43 : appLovinNativeAdImpl.hashCode());
            return n3;
        }

        public String toString() {
            return "AppLovinNativeAdImpl.OnAttachStateChangeHandler(ad=" + this.a() + ")";
        }
    }
}

