/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.graphics.Color;
import com.applovin.impl.sdk.a.a;
import com.applovin.impl.sdk.array.ArrayDirectDownloadAd;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import java.util.List;
import org.json.JSONObject;

public abstract class AppLovinAdBase
implements a,
ArrayDirectDownloadAd {
    protected final JSONObject adObject;
    protected final JSONObject fullResponse;
    protected final n sdk;
    protected final Object adObjectLock;
    protected final Object fullResponseLock;
    private final long createdAtMillis;

    protected AppLovinAdBase(JSONObject jSONObject, JSONObject jSONObject2, n n2) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("No ad object specified");
        }
        if (jSONObject2 == null) {
            throw new IllegalArgumentException("No response specified");
        }
        if (n2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.adObject = jSONObject;
        this.fullResponse = jSONObject2;
        this.sdk = n2;
        this.adObjectLock = new Object();
        this.fullResponseLock = new Object();
        this.createdAtMillis = System.currentTimeMillis();
    }

    public n getSdk() {
        return this.sdk;
    }

    public long getCreatedAtMillis() {
        return this.createdAtMillis;
    }

    public abstract long getAdIdNumber();

    public String getClCode() {
        String string2 = this.getStringFromAdObject("clcode", "");
        if (StringUtils.isValidString(string2)) {
            return string2;
        }
        return this.getStringFromFullResponse("clcode", "");
    }

    public String getDspName() {
        return this.getStringFromFullResponse("dsp_name", "");
    }

    public String getPrimaryKey() {
        return this.getStringFromAdObject("pk", "NA");
    }

    public String getSecondaryKey1() {
        return this.getStringFromAdObject("sk1", null);
    }

    public String getSecondaryKey2() {
        return this.getStringFromAdObject("sk2", null);
    }

    public long getFetchLatencyMillis() {
        return this.getLongFromFullResponse("ad_fetch_latency_millis", -1L);
    }

    public long getFetchResponseSize() {
        return this.getLongFromFullResponse("ad_fetch_response_size", -1L);
    }

    public boolean shouldUrlEncodeResourcePath() {
        return this.getBooleanFromAdObject("uerp", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKeyForAdObject(String string2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return this.adObject.has(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromAdObject(String string2, Boolean bl) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getBoolean(this.adObject, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatFromAdObject(String string2, float f2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getFloat(this.adObject, string2, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromAdObject(String string2, int n2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getInt(this.adObject, string2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJsonObjectFromAdObject(String string2, JSONObject jSONObject) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getJSONObject(this.adObject, string2, jSONObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromAdObject(String string2, long l2) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getLong(this.adObject, string2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromAdObject(String string2, String string3) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getString(this.adObject, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> getIntegerListFromAdObject(String string2, List<Integer> list) {
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getIntegerList(this.adObject, string2, list);
        }
    }

    protected int getColorFromAdObject(String string2, int n2) {
        String string3 = this.getStringFromAdObject(string2, null);
        return StringUtils.isValidString(string3) ? Color.parseColor((String)string3) : n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromFullResponse(String string2, boolean bl) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getBoolean(this.fullResponse, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatFromFullResponse(String string2, float f2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getFloat(this.fullResponse, string2, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromFullResponse(String string2, int n2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getInt(this.fullResponse, string2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJsonObjectFromFullResponse(String string2, JSONObject jSONObject) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getJSONObject(this.fullResponse, string2, jSONObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromFullResponse(String string2, long l2) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getLong(this.fullResponse, string2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromFullResponse(String string2, String string3) {
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getString(this.fullResponse, string2, string3);
        }
    }
}

