/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.content.Context;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinAdView;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.ad.c;
import com.applovin.impl.sdk.ad.d;
import com.applovin.impl.sdk.ad.e;
import com.applovin.impl.sdk.ad.f;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.e.j;
import com.applovin.impl.sdk.e.k;
import com.applovin.impl.sdk.e.l;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.e.p;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.network.h;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.i;
import com.applovin.impl.sdk.v;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinAdServiceImpl
implements AppLovinAdService {
    private final n a;
    private final v b;
    private final Handler c = new Handler(Looper.getMainLooper());
    private final Map<d, b> d;
    private final Object e = new Object();
    private final Map<String, String> f = CollectionUtils.map();
    private final AtomicReference<JSONObject> g = new AtomicReference();

    AppLovinAdServiceImpl(n n2) {
        this.a = n2;
        this.b = n2.D();
        this.d = CollectionUtils.map(6);
        this.d.put(com.applovin.impl.sdk.ad.d.g(), new b());
        this.d.put(com.applovin.impl.sdk.ad.d.h(), new b());
        this.d.put(com.applovin.impl.sdk.ad.d.i(), new b());
        this.d.put(com.applovin.impl.sdk.ad.d.j(), new b());
        this.d.put(com.applovin.impl.sdk.ad.d.k(), new b());
        this.d.put(com.applovin.impl.sdk.ad.d.l(), new b());
    }

    @Override
    public void loadNextAd(AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.a(com.applovin.impl.sdk.ad.d.a(appLovinAdSize, AppLovinAdType.REGULAR), appLovinAdLoadListener);
    }

    @Override
    public void loadNextAdForZoneId(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No zone id specified");
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Loading next ad of zone {" + string2 + "}");
        }
        d d2 = com.applovin.impl.sdk.ad.d.a(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    @Override
    public String getBidToken() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        String string2 = this.a.Y().a();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        return string2;
    }

    @Override
    public void loadNextAdForAdToken(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            v.i("AppLovinAdService", "Empty ad token");
            AppLovinError appLovinError = new AppLovinError(-8, "Empty ad token");
            this.a(appLovinError, appLovinAdLoadListener);
            return;
        }
        c c2 = new c(string3, this.a);
        if (c2.b() == c.a.b) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.b("AppLovinAdService", "Loading next ad for token: " + c2);
            }
            l l2 = new l(c2, appLovinAdLoadListener, this.a);
            this.a(l2);
        } else if (c2.b() == c.a.c) {
            JSONObject jSONObject = c2.d();
            if (jSONObject != null) {
                i.f(jSONObject, this.a);
                i.d(jSONObject, this.a);
                i.c(jSONObject, this.a);
                i.e(jSONObject, this.a);
                com.applovin.impl.sdk.f.a(this.a);
                JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, "ads", new JSONArray());
                if (jSONArray.length() > 0) {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.b.a()) {
                        this.b.b("AppLovinAdService", "Rendering ad for token: " + c2);
                    }
                    d d2 = Utils.getZone(jSONObject, this.a);
                    p p2 = new p(jSONObject, d2, com.applovin.impl.sdk.ad.b.f, appLovinAdLoadListener, this.a);
                    this.a(p2);
                } else {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.b.a()) {
                        this.b.e("AppLovinAdService", "No ad returned from the server for token: " + c2);
                    }
                    this.a(AppLovinError.NO_FILL, appLovinAdLoadListener);
                }
            } else {
                String string5 = "Unable to retrieve ad response JSON from token: " + c2.a();
                AppLovinError appLovinError = new AppLovinError(-8, string5);
                v.i("AppLovinAdService", string5);
                this.a(appLovinError, appLovinAdLoadListener);
            }
        } else {
            String string6 = "Invalid token type";
            AppLovinError appLovinError = new AppLovinError(-8, "Invalid token type");
            v.i("AppLovinAdService", "Invalid token type");
            this.a(appLovinError, appLovinAdLoadListener);
        }
    }

    @Override
    public void loadNextAdForZoneIds(List<String> list, AppLovinAdLoadListener appLovinAdLoadListener) {
        List<String> list2 = CollectionUtils.removeTrimmedEmptyStrings(list);
        if (list2 == null || list2.isEmpty()) {
            v.i("AppLovinAdService", "No zones were provided");
            this.a(-7, appLovinAdLoadListener);
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Loading next ad for zones: " + list2);
        }
        j j2 = new j(list2, appLovinAdLoadListener, this.a);
        this.a(j2);
    }

    public void loadNextIncentivizedAd(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Loading next incentivized ad of zone {" + string2 + "}");
        }
        d d2 = com.applovin.impl.sdk.ad.d.b(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    public void loadNextAd(String string2, AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Loading next ad of zone {" + string2 + "} with size " + appLovinAdSize);
        }
        d d2 = com.applovin.impl.sdk.ad.d.a(appLovinAdSize, AppLovinAdType.REGULAR, string2);
        this.a(d2, appLovinAdLoadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(d d2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (d2 == null) {
            throw new IllegalArgumentException("No zone specified");
        }
        if (appLovinAdLoadListener == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        this.a.D();
        if (v.a()) {
            this.a.D().b("AppLovinAdService", "Loading next ad of zone {" + d2 + "}...");
        }
        b b2 = this.a(d2);
        Object object = b2.a;
        synchronized (object) {
            b2.c.add(appLovinAdLoadListener);
            if (!b2.b) {
                b2.b = true;
                a a2 = new a(b2);
                this.a(d2, a2);
            } else {
                AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                if (appLovinAdServiceImpl.b.a()) {
                    this.b.b("AppLovinAdService", "Already waiting on an ad load...");
                }
            }
        }
    }

    private void a(com.applovin.impl.sdk.e.a a2) {
        if (!this.a.d()) {
            v.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        this.a.V().a(a2, o.a.a);
    }

    private void a(final AppLovinAd appLovinAd, final AppLovinAdLoadListener appLovinAdLoadListener) {
        this.c.post(new Runnable(){

            @Override
            public void run() {
                try {
                    appLovinAdLoadListener.adReceived(appLovinAd);
                }
                catch (Throwable throwable) {
                    v.c("AppLovinAdService", "Unable to notify listener about a newly loaded ad", throwable);
                }
            }
        });
    }

    private void a(AppLovinError appLovinError, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (appLovinAdLoadListener instanceof com.applovin.impl.sdk.ad.h) {
            ((com.applovin.impl.sdk.ad.h)appLovinAdLoadListener).failedToReceiveAdV2(appLovinError);
        } else {
            appLovinAdLoadListener.failedToReceiveAd(appLovinError.getCode());
        }
    }

    private void a(final int n2, final AppLovinAdLoadListener appLovinAdLoadListener) {
        this.c.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (appLovinAdLoadListener instanceof com.applovin.impl.sdk.ad.h) {
                        ((com.applovin.impl.sdk.ad.h)appLovinAdLoadListener).failedToReceiveAdV2(new AppLovinError(n2, ""));
                    } else {
                        appLovinAdLoadListener.failedToReceiveAd(n2);
                    }
                }
                catch (Throwable throwable) {
                    v.c("AppLovinAdService", "Unable to notify listener about ad load failure", throwable);
                }
            }
        });
    }

    private void b(final AppLovinError appLovinError, final AppLovinAdLoadListener appLovinAdLoadListener) {
        this.c.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (appLovinAdLoadListener instanceof com.applovin.impl.sdk.ad.h) {
                        ((com.applovin.impl.sdk.ad.h)appLovinAdLoadListener).failedToReceiveAdV2(appLovinError);
                    } else {
                        appLovinAdLoadListener.failedToReceiveAd(appLovinError.getCode());
                    }
                }
                catch (Throwable throwable) {
                    v.c("AppLovinAdService", "Unable to notify listener about ad load failure", throwable);
                }
            }
        });
    }

    public AppLovinAd dequeueAd(d d2) {
        AppLovinAdImpl appLovinAdImpl = this.a.ac().b(d2);
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Dequeued ad: " + appLovinAdImpl + " for zone: " + d2 + "...");
        }
        return appLovinAdImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomQueryParams(Map<String, String> map) {
        Map<String, String> map2 = this.f;
        synchronized (map2) {
            this.f.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAndResetCustomQueryParams() {
        Map<String, String> map;
        Map<String, String> map2 = this.f;
        synchronized (map2) {
            map = CollectionUtils.map(this.f);
            this.f.clear();
        }
        return map;
    }

    public void setCustomPostBody(JSONObject jSONObject) {
        this.g.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBody() {
        return this.g.getAndSet(null);
    }

    public void trackAndLaunchVideoClick(e e2, final Uri uri, PointF pointF, com.applovin.impl.adview.activity.b.a a2, final Context context) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track video click. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking VIDEO click on an ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.a(pointF));
        if (e2.isDirectDownloadEnabled()) {
            this.a.aq().startDirectInstallOrDownloadProcess(e2, new ArrayService.DirectDownloadListener(){

                @Override
                public void onAppDetailsDisplayed() {
                    AppLovinAdServiceImpl.this.a.ag().pauseForClick();
                }

                @Override
                public void onAppDetailsDismissed() {
                    AppLovinAdServiceImpl.this.a.ag().resumeForClick();
                }

                @Override
                public void onFailure() {
                    Utils.openUri(context, uri, AppLovinAdServiceImpl.this.a);
                }
            });
        } else if (this.a(uri.getScheme())) {
            this.a(uri, e2, null, a2);
        } else if (Utils.isDeepLinkPlusUrl(uri)) {
            this.a(uri, e2, null, null, context, this.a);
        } else {
            Utils.openUri(context, uri, this.a);
        }
    }

    public void trackAndLaunchClick(final e e2, final AppLovinAdView appLovinAdView, final com.applovin.impl.adview.b b2, final Uri uri, PointF pointF, boolean bl) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track ad view click. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking click on an ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.a(pointF, bl));
        if (appLovinAdView != null && uri != null) {
            if (e2.isDirectDownloadEnabled()) {
                this.a.aq().startDirectInstallOrDownloadProcess(e2, new ArrayService.DirectDownloadListener(){

                    @Override
                    public void onAppDetailsDisplayed() {
                        AppLovinAdServiceImpl.this.a.ag().pauseForClick();
                        if (b2 != null) {
                            b2.o();
                            com.applovin.impl.sdk.utils.k.a(b2.g(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onAppDetailsDismissed() {
                        if (b2 != null) {
                            AppLovinAdServiceImpl.this.a.ag().resumeForClick();
                            com.applovin.impl.sdk.utils.k.b(b2.g(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onFailure() {
                        AppLovinAdServiceImpl.this.a(uri, e2, appLovinAdView, b2);
                    }
                });
            } else if (this.a(uri.getScheme())) {
                this.a(uri, e2, b2, null);
            } else if (Utils.isDeepLinkPlusUrl(uri)) {
                this.a(uri, e2, appLovinAdView, b2, appLovinAdView.getContext(), this.a);
            } else {
                this.a(uri, e2, appLovinAdView, b2);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.b.a()) {
                this.b.e("AppLovinAdService", "Unable to launch click - adView has been prematurely destroyed");
            }
        }
    }

    public void trackImpression(e e2) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track impression click. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking impression on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.at());
    }

    public void trackVideoEnd(e e2, long l2, int n2, boolean bl) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track video end. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking video end on ad...");
        }
        if ((list = e2.aq()) != null && !list.isEmpty()) {
            String string2 = Long.toString(System.currentTimeMillis());
            for (com.applovin.impl.sdk.d.a a2 : list) {
                if (StringUtils.isValidString(a2.a())) {
                    String string3 = this.a(a2.a(), l2, n2, string2, bl);
                    String string4 = this.a(a2.b(), l2, n2, string2, bl);
                    if (string3 != null) {
                        com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string3, string4);
                        this.a(a3);
                        continue;
                    }
                    AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                    if (!appLovinAdServiceImpl2.b.a()) continue;
                    this.b.e("AppLovinAdService", "Failed to parse url: " + a2.a());
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
                if (!appLovinAdServiceImpl3.b.a()) continue;
                this.b.d("AppLovinAdService", "Requested a postback dispatch for an empty video end URL; nothing to do...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl4 = this;
            if (appLovinAdServiceImpl4.b.a()) {
                this.b.d("AppLovinAdService", "Unable to submit persistent postback for AD #" + e2.getAdIdNumber() + ". Missing video end tracking URL.");
            }
        }
    }

    private String a(String string2, long l2, int n2, String string3, boolean bl) {
        try {
            if (StringUtils.isValidString(string2)) {
                if (n2 < 0 || n2 > 100) {
                    n2 = 0;
                }
                Uri uri = Uri.parse((String)string2);
                Uri uri2 = uri.buildUpon().appendQueryParameter("et_s", Long.toString(l2)).appendQueryParameter("pv", Integer.toString(n2)).appendQueryParameter("vid_ts", string3).appendQueryParameter("uvs", Boolean.toString(bl)).build();
                return uri2.toString();
            }
            return null;
        }
        catch (Throwable throwable) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.b("AppLovinAdService", "Unknown error parsing the video end url: " + string2, throwable);
            }
            return null;
        }
    }

    private void a(Uri uri, e e2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2) {
        boolean bl = Utils.openUri(appLovinAdView.getContext(), uri, this.a);
        if (bl) {
            com.applovin.impl.sdk.utils.k.c(b2.g(), (AppLovinAd)e2, appLovinAdView);
        }
        b2.o();
    }

    private boolean a(String string2) {
        String string3 = this.a.q().getExtraParameters().get("forwarding_click_scheme");
        return StringUtils.isValidString(string3) && StringUtils.isValidString(string2) && string2.equalsIgnoreCase(string3);
    }

    private void a(Uri uri, e e2, com.applovin.impl.adview.b b2, final com.applovin.impl.adview.activity.b.a a2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Forwarding click " + uri);
        }
        e2.setMaxAdValue("forwarding_clicked_url", uri.toString());
        String string2 = this.a.q().getExtraParameters().get("close_ad_on_forwarding_click_scheme");
        if (StringUtils.isValidString(string2) && Boolean.parseBoolean(string2)) {
            if (a2 != null) {
                this.c.post(new Runnable(){

                    @Override
                    public void run() {
                        if (a2 != null) {
                            AppLovinAdServiceImpl.this.b;
                            if (v.a()) {
                                AppLovinAdServiceImpl.this.b.b("AppLovinAdService", "Dismissing ad after forwarding click");
                            }
                            a2.h();
                        }
                    }
                });
            } else if (b2 != null && !Utils.isBML(e2.getSize())) {
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (appLovinAdServiceImpl2.b.a()) {
                    this.b.b("AppLovinAdService", "Closing ad after forwarding click");
                }
                b2.l();
            }
        }
    }

    private void a(Uri uri, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, n n2) {
        if (uri != null && StringUtils.isValidString(uri.getQuery())) {
            Uri uri2 = this.a(uri, "primaryUrl");
            List<Uri> list = this.b(uri, "primaryTrackingUrl");
            Uri uri3 = this.a(uri, "fallbackUrl");
            List<Uri> list2 = this.b(uri, "fallbackTrackingUrl");
            if (uri2 == null && uri3 == null) {
                n2.D();
                if (v.a()) {
                    n2.D().e("AppLovinAdService", "Failed to parse both primary and backup URLs for Deep Link+ command");
                }
                return;
            }
            if (!this.a(uri2, "primary", list, e2, appLovinAdView, b2, context, n2)) {
                this.a(uri3, "backup", list2, e2, appLovinAdView, b2, context, n2);
            }
            if (b2 != null) {
                b2.o();
            }
        } else {
            n2.D();
            if (v.a()) {
                n2.D().e("AppLovinAdService", "Failed to execute Deep Link+ command - no query parameters found");
            }
        }
    }

    private boolean a(Uri uri, String string2, List<Uri> list, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, n n2) {
        boolean bl;
        n2.D();
        if (v.a()) {
            n2.D().b("AppLovinAdService", "Opening " + string2 + " URL: " + uri);
        }
        if (bl = Utils.openUri(context, uri, n2)) {
            n2.D();
            if (v.a()) {
                n2.D().b("AppLovinAdService", "URL opened successfully, dispatching tracking URLs: " + list);
            }
            for (Uri uri2 : list) {
                n2.aa().dispatchPostbackAsync(uri2.toString(), null);
            }
            if (b2 != null) {
                com.applovin.impl.sdk.utils.k.c(b2.g(), (AppLovinAd)e2, appLovinAdView);
            }
        } else {
            n2.D();
            if (v.a()) {
                n2.D().e("AppLovinAdService", "URL failed to open");
            }
        }
        return bl;
    }

    @Nullable
    private Uri a(Uri uri, String string2) {
        try {
            return Uri.parse((String)uri.getQueryParameter(string2));
        }
        catch (Throwable throwable) {
            this.a.D();
            if (v.a()) {
                this.a.D().d("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
            }
            return null;
        }
    }

    private List<Uri> b(Uri uri, String string2) {
        List list = uri.getQueryParameters(string2);
        ArrayList<Uri> arrayList = new ArrayList<Uri>(list.size());
        for (String string3 : list) {
            try {
                arrayList.add(Uri.parse((String)string3));
            }
            catch (Throwable throwable) {
                this.a.D();
                if (!v.a()) continue;
                this.a.D().d("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
            }
        }
        return arrayList;
    }

    public void trackFullScreenAdClosed(e e2, long l2, List<Long> list, long l3, boolean bl, int n2) {
        List<com.applovin.impl.sdk.d.a> list2;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track ad closed. No ad specified.");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking ad closed...");
        }
        if ((list2 = e2.ar()) != null && !list2.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list2) {
                String string2 = this.a(a2.a(), l2, l3, list, bl, n2);
                String string3 = this.a(a2.b(), l2, l3, list, bl, n2);
                if (StringUtils.isValidString(string2)) {
                    com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string2, string3);
                    this.a(a3);
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (!appLovinAdServiceImpl2.b.a()) continue;
                this.b.e("AppLovinAdService", "Failed to parse url: " + a2.a());
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
            if (appLovinAdServiceImpl3.b.a()) {
                this.b.d("AppLovinAdService", "Unable to track ad closed for AD #" + e2.getAdIdNumber() + ". Missing ad close tracking URL." + e2.getAdIdNumber());
            }
        }
    }

    private String a(String string2, long l2, long l3, List<Long> list, boolean bl, int n2) {
        if (StringUtils.isValidString(string2)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon().appendQueryParameter("et_ms", Long.toString(l2)).appendQueryParameter("vs_ms", Long.toString(l3));
            if (list != null && list.size() > 0) {
                builder.appendQueryParameter("ec_ms", list.toString());
            }
            if (n2 != com.applovin.impl.sdk.h.a) {
                builder.appendQueryParameter("musw_ch", Boolean.toString(bl));
                builder.appendQueryParameter("musw_st", Boolean.toString(com.applovin.impl.sdk.h.a(n2)));
            }
            return builder.build().toString();
        }
        return null;
    }

    public void trackAppKilled(e e2) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.e("AppLovinAdService", "Unable to track app killed. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.b.a()) {
            this.b.b("AppLovinAdService", "Tracking app killed during ad...");
        }
        if ((list = e2.as()) != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(a2.a(), a2.b());
                this.a(a3);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.b.a()) {
                this.b.d("AppLovinAdService", "Unable to track app killed during AD #" + e2.getAdIdNumber() + ". Missing app killed tracking URL.");
            }
        }
    }

    public void maybeSubmitPersistentPostbacks(List<com.applovin.impl.sdk.d.a> list) {
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                this.a(a2);
            }
        }
    }

    private void a(com.applovin.impl.sdk.d.a a2) {
        if (StringUtils.isValidString(a2.a())) {
            String string2 = a2.a();
            String string3 = StringUtils.isValidString(a2.b()) ? a2.b() : null;
            this.a.X().a(h.o().c(string2).d(string3).b(a2.c()).a(false).c(a2.d()).a());
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.d("AppLovinAdService", "Requested a postback dispatch for a null URL; nothing to do...");
            }
        }
    }

    private void a(d d2, a a2) {
        AppLovinAdImpl appLovinAdImpl = this.a.ac().a(d2);
        if (appLovinAdImpl != null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.b.a()) {
                this.b.b("AppLovinAdService", "Using pre-loaded ad: " + appLovinAdImpl + " for " + d2);
            }
            a2.adReceived(appLovinAdImpl);
        } else {
            k k2 = new k(d2, a2, this.a);
            this.a(k2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private b a(d d2) {
        b b2;
        Object object = this.e;
        synchronized (object) {
            b2 = this.d.get(d2);
            if (b2 == null) {
                b2 = new b();
                this.d.put(d2, b2);
            }
        }
        return b2;
    }

    @NonNull
    public String toString() {
        return "AppLovinAdService{adLoadStates=" + this.d + '}';
    }

    private static class b {
        final Object a = new Object();
        boolean b;
        final Collection<AppLovinAdLoadListener> c = new HashSet<AppLovinAdLoadListener>();

        private b() {
        }

        @NonNull
        public String toString() {
            return "AdLoadState{, isWaitingForAd=" + this.b + ", pendingAdListeners=" + this.c + '}';
        }
    }

    private class a
    implements com.applovin.impl.sdk.ad.h {
        private final b b;

        private a(b b2) {
            this.b = b2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            HashSet<AppLovinAdLoadListener> hashSet;
            d d2 = ((AppLovinAdImpl)appLovinAd).getAdZone();
            if (!(appLovinAd instanceof f)) {
                AppLovinAdServiceImpl.this.a.ac().a((AppLovinAdImpl)appLovinAd);
                appLovinAd = new f(d2, AppLovinAdServiceImpl.this.a);
            }
            Iterator iterator = this.b.a;
            synchronized (iterator) {
                hashSet = new HashSet<AppLovinAdLoadListener>(this.b.c);
                this.b.c.clear();
                this.b.b = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(appLovinAd, appLovinAdLoadListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedToReceiveAd(int n2) {
            HashSet<AppLovinAdLoadListener> hashSet;
            Iterator iterator = this.b.a;
            synchronized (iterator) {
                hashSet = new HashSet<AppLovinAdLoadListener>(this.b.c);
                this.b.c.clear();
                this.b.b = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(n2, appLovinAdLoadListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedToReceiveAdV2(AppLovinError appLovinError) {
            HashSet<AppLovinAdLoadListener> hashSet;
            Iterator iterator = this.b.a;
            synchronized (iterator) {
                hashSet = new HashSet<AppLovinAdLoadListener>(this.b.c);
                this.b.c.clear();
                this.b.b = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                if (appLovinAdLoadListener instanceof com.applovin.impl.sdk.ad.h) {
                    AppLovinAdServiceImpl.this.b(appLovinError, appLovinAdLoadListener);
                    continue;
                }
                AppLovinAdServiceImpl.this.a(appLovinError.getCode(), appLovinAdLoadListener);
            }
        }
    }
}

