/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds.adPlacer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.applovin.impl.mediation.a.d;
import com.applovin.impl.mediation.nativeAds.a.a;
import com.applovin.impl.mediation.nativeAds.a.b;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.mediation.nativeAds.adPlacer.MaxAdPlacerSettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MaxAdPlacer
implements b.a {
    private AppLovinSdkUtils.Size a = AppLovinSdkUtils.Size.ZERO;
    private MaxNativeAdViewBinder b;
    private final a c;
    private final b d;
    protected final n sdk;
    protected final w logger;
    private Listener e;

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, Context context) {
        this(maxAdPlacerSettings, AppLovinSdk.getInstance(context), context);
    }

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, AppLovinSdk appLovinSdk, Context context) {
        this.sdk = appLovinSdk.coreSdk;
        this.logger = this.sdk.C();
        this.c = new a(maxAdPlacerSettings);
        this.d = new b(maxAdPlacerSettings.getAdUnitId(), maxAdPlacerSettings.getMaxPreloadedAdCount(), context, this);
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.b("MaxAdPlacer", "Initializing ad placer with settings: " + maxAdPlacerSettings);
        }
    }

    public void destroy() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.b("MaxAdPlacer", "Destroying ad placer");
        }
        this.clearAds();
        this.d.a();
    }

    public void setAdSize(int n2, int n3) {
        this.a = new AppLovinSdkUtils.Size(n2, n3);
    }

    public void setNativeAdViewBinder(MaxNativeAdViewBinder maxNativeAdViewBinder) {
        this.b = maxNativeAdViewBinder;
    }

    public void setListener(Listener listener) {
        this.e = listener;
    }

    public void loadAds() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.b("MaxAdPlacer", "Loading ads");
        }
        this.d.c();
    }

    public void clearAds() {
        this.a(this.c.b(), new Runnable(){

            @Override
            public void run() {
                MaxAdPlacer maxAdPlacer = MaxAdPlacer.this;
                if (maxAdPlacer.logger.a()) {
                    MaxAdPlacer.this.logger.b("MaxAdPlacer", "Clearing all cached ads");
                }
                MaxAdPlacer.this.c.c();
                MaxAdPlacer.this.d.e();
            }
        });
    }

    public Collection<Integer> clearTrailingAds(final int n2) {
        final Collection<Integer> collection = this.c.d(n2);
        if (!collection.isEmpty()) {
            this.a(collection, new Runnable(){

                @Override
                public void run() {
                    MaxAdPlacer maxAdPlacer = MaxAdPlacer.this;
                    if (maxAdPlacer.logger.a()) {
                        MaxAdPlacer.this.logger.b("MaxAdPlacer", "Clearing trailing ads after position " + n2);
                    }
                    MaxAdPlacer.this.c.a(collection);
                }
            });
        }
        return collection;
    }

    public boolean isAdPosition(int n2) {
        return this.c.a(n2);
    }

    public boolean isFilledPosition(int n2) {
        return this.c.b(n2);
    }

    public long getAdItemId(int n2) {
        if (this.isFilledPosition(n2)) {
            return -System.identityHashCode(this.c.c(n2));
        }
        return 0L;
    }

    public AppLovinSdkUtils.Size getAdSize(int n2, int n3) {
        if (this.isFilledPosition(n2)) {
            boolean bl = this.a != AppLovinSdkUtils.Size.ZERO;
            int n4 = Math.min(bl ? this.a.getWidth() : 360, n3);
            d d2 = (d)this.c.c(n2);
            if ("small_template_1".equalsIgnoreCase(d2.z())) {
                int n5 = bl ? this.a.getHeight() : 120;
                return new AppLovinSdkUtils.Size(n4, n5);
            }
            if ("medium_template_1".equalsIgnoreCase(d2.z())) {
                double d3 = bl ? (double)this.a.getWidth() / (double)this.a.getHeight() : 1.2;
                return new AppLovinSdkUtils.Size(n4, (int)((double)n4 / d3));
            }
            if (bl) {
                return this.a;
            }
            if (d2.y() != null) {
                View view = d2.y().getMainView();
                return new AppLovinSdkUtils.Size(view.getMeasuredWidth(), view.getMeasuredHeight());
            }
        }
        return AppLovinSdkUtils.Size.ZERO;
    }

    public void renderAd(int n2, ViewGroup viewGroup) {
        MaxAd maxAd = this.c.c(n2);
        if (maxAd == null) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.a()) {
                this.logger.b("MaxAdPlacer", "An ad is not available for position: " + n2);
            }
            return;
        }
        d d2 = (d)maxAd;
        MaxNativeAdView maxNativeAdView = d2.y();
        if (maxNativeAdView != null) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.a()) {
                this.logger.b("MaxAdPlacer", "Using pre-rendered ad at position: " + n2);
            }
        } else if (this.b != null) {
            maxNativeAdView = new MaxNativeAdView(this.b, viewGroup.getContext());
            if (this.d.a(maxNativeAdView, maxAd)) {
                MaxAdPlacer maxAdPlacer = this;
                if (maxAdPlacer.logger.a()) {
                    this.logger.b("MaxAdPlacer", "Rendered ad at position: " + n2);
                }
            } else {
                MaxAdPlacer maxAdPlacer = this;
                if (maxAdPlacer.logger.a()) {
                    this.logger.e("MaxAdPlacer", "Unable to render ad at position: " + n2);
                }
            }
        } else {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.a()) {
                this.logger.e("MaxAdPlacer", "Unable to render ad at position: " + n2 + ". If you're using a custom ad template, check that nativeAdViewBinder is set.");
            }
            return;
        }
        for (int i2 = viewGroup.getChildCount(); i2 >= 0; --i2) {
            View view = viewGroup.getChildAt(i2);
            if (!(view instanceof MaxNativeAdView)) continue;
            viewGroup.removeViewAt(i2);
        }
        if (maxNativeAdView.getParent() != null) {
            ((ViewGroup)maxNativeAdView.getParent()).removeView((View)maxNativeAdView);
        }
        viewGroup.addView((View)maxNativeAdView, -1, -1);
    }

    public void updateFillablePositions(int n2, int n3) {
        this.c.a(n2, n3);
        if (n2 != -1 && n3 != -1) {
            this.a();
        }
    }

    public int getAdjustedCount(int n2) {
        return this.c.e(n2);
    }

    public int getAdjustedPosition(int n2) {
        return this.c.f(n2);
    }

    public int getOriginalPosition(int n2) {
        return this.c.g(n2);
    }

    public void insertItem(int n2) {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.b("MaxAdPlacer", "Inserting item at position: " + n2);
        }
        this.c.h(n2);
    }

    public void removeItem(final int n2) {
        List<Integer> list = this.isFilledPosition(n2) ? Collections.singletonList(n2) : Collections.emptyList();
        this.a(list, new Runnable(){

            @Override
            public void run() {
                MaxAdPlacer maxAdPlacer = MaxAdPlacer.this;
                if (maxAdPlacer.logger.a()) {
                    MaxAdPlacer.this.logger.b("MaxAdPlacer", "Removing item at position: " + n2);
                }
                MaxAdPlacer.this.c.i(n2);
            }
        });
    }

    public void moveItem(int n2, int n3) {
        this.c.b(n2, n3);
    }

    private void a() {
        int n2;
        while (this.d.b() && (n2 = this.c.a()) != -1) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.a()) {
                this.logger.b("MaxAdPlacer", "Placing ad at position: " + n2);
            }
            MaxAd maxAd = this.d.d();
            this.c.a(maxAd, n2);
            if (this.e == null) continue;
            this.e.onAdLoaded(n2);
        }
    }

    private void a(Collection<Integer> collection, Runnable runnable) {
        for (Integer n2 : collection) {
            MaxAd maxAd = this.c.c(n2);
            this.d.a(maxAd);
        }
        runnable.run();
        if (!collection.isEmpty()) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.a()) {
                this.logger.b("MaxAdPlacer", "Removed " + collection.size() + " ads from stream: " + collection);
            }
            if (this.e != null) {
                for (Integer n2 : collection) {
                    this.e.onAdRemoved(n2);
                }
            }
        }
    }

    @Override
    public void onNativeAdLoaded() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.b("MaxAdPlacer", "Native ad enqueued");
        }
        this.a();
    }

    @Override
    public void onNativeAdLoadFailed(String string2, MaxError maxError) {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.a()) {
            this.logger.e("MaxAdPlacer", "Native ad failed to load: " + maxError);
        }
    }

    @Override
    public void onNativeAdClicked(MaxAd maxAd) {
        if (this.e != null) {
            this.e.onAdClicked(maxAd);
        }
    }

    @Override
    public void onAdRevenuePaid(MaxAd maxAd) {
        if (this.e != null) {
            this.e.onAdRevenuePaid(maxAd);
        }
    }

    public static interface Listener {
        public void onAdLoaded(int var1);

        public void onAdRemoved(int var1);

        public void onAdClicked(MaxAd var1);

        public void onAdRevenuePaid(MaxAd var1);
    }
}

