/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import com.applovin.impl.sdk.ad.g;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import java.util.Map;

public class AppLovinAdapterRewardedInterstitialListener
implements g,
AppLovinAdClickListener,
AppLovinAdLoadListener,
AppLovinAdRewardListener,
AppLovinAdVideoPlaybackListener {
    private final AppLovinMediationAdapter parentAdapter;
    private final MaxRewardedInterstitialAdapterListener listener;
    private boolean hasGrantedReward;

    public AppLovinAdapterRewardedInterstitialListener(AppLovinMediationAdapter appLovinMediationAdapter, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        this.parentAdapter = appLovinMediationAdapter;
        this.listener = maxRewardedInterstitialAdapterListener;
    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        this.parentAdapter.log("Rewarded interstitial ad loaded");
        this.parentAdapter.loadedRewardedInterstitialAd = appLovinAd;
        this.listener.onRewardedInterstitialAdLoaded();
    }

    @Override
    public void failedToReceiveAd(int n2) {
        this.parentAdapter.log("Rewarded interstitial ad failed to load with error code: " + n2);
        this.listener.onRewardedInterstitialAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
    }

    @Override
    public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
        this.parentAdapter.log("Reward verified");
    }

    @Override
    public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
        this.parentAdapter.log("User is over quota: " + map);
    }

    @Override
    public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
        this.parentAdapter.log("Reward rejected: " + map);
    }

    @Override
    public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
        this.parentAdapter.log("Reward validation request failed with code: " + n2);
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        this.parentAdapter.log("Rewarded interstitial ad shown");
        this.listener.onRewardedInterstitialAdDisplayed();
    }

    @Override
    public void onAdDisplayFailed(String string) {
        this.parentAdapter.log("Rewarded interstitial ad failed to display with error: " + string);
        MaxAdapterError maxAdapterError = new MaxAdapterError(-5200, string);
        this.listener.onRewardedInterstitialAdDisplayFailed(maxAdapterError);
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        if (this.hasGrantedReward || this.parentAdapter.shouldAlwaysRewardUser()) {
            MaxReward maxReward = this.parentAdapter.getReward();
            this.parentAdapter.log("Rewarded interstitial rewarded user with reward: " + maxReward);
            this.listener.onUserRewarded(maxReward);
        }
        this.parentAdapter.log("Rewarded interstitial ad hidden");
        this.listener.onRewardedInterstitialAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        this.parentAdapter.log("Rewarded interstitial ad clicked");
        this.listener.onRewardedInterstitialAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        this.parentAdapter.log("Rewarded interstitial ad video started");
        this.listener.onRewardedInterstitialAdVideoStarted();
    }

    @Override
    public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
        this.parentAdapter.log("Rewarded interstitial ad video ended at " + d2 + "% and is fully watched: " + bl);
        this.hasGrantedReward = bl;
        this.listener.onRewardedInterstitialAdVideoCompleted();
    }
}

