/*
 * Decompiled with CFR 0.152.
 */
package com.iab.omid.library.applovin.adsession;

import android.webkit.WebView;
import androidx.annotation.Nullable;
import com.iab.omid.library.applovin.adsession.AdSessionContextType;
import com.iab.omid.library.applovin.adsession.Partner;
import com.iab.omid.library.applovin.adsession.VerificationScriptResource;
import com.iab.omid.library.applovin.d.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class AdSessionContext {
    private final Partner partner;
    private final WebView webView;
    private final List<VerificationScriptResource> verificationScriptResources = new ArrayList<VerificationScriptResource>();
    private final Map<String, VerificationScriptResource> injectedResourcesMap = new HashMap<String, VerificationScriptResource>();
    private final String omidJsScriptContent;
    private final String customReferenceData;
    @Nullable
    private final String contentUrl;
    private final AdSessionContextType adSessionContextType;

    private AdSessionContext(Partner partner, WebView webView, String string2, List<VerificationScriptResource> list, @Nullable String string3, String string4, AdSessionContextType adSessionContextType) {
        this.partner = partner;
        this.webView = webView;
        this.omidJsScriptContent = string2;
        this.adSessionContextType = adSessionContextType;
        if (list != null) {
            this.verificationScriptResources.addAll(list);
            for (VerificationScriptResource verificationScriptResource : list) {
                String string5 = UUID.randomUUID().toString();
                this.injectedResourcesMap.put(string5, verificationScriptResource);
            }
        }
        this.contentUrl = string3;
        this.customReferenceData = string4;
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, @Nullable String string2, String string3) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string3 != null) {
            e.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string2, string3, AdSessionContextType.HTML);
    }

    public static AdSessionContext createJavascriptAdSessionContext(Partner partner, WebView webView, @Nullable String string2, String string3) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string3 != null) {
            e.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string2, string3, AdSessionContextType.JAVASCRIPT);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string2, List<VerificationScriptResource> list, @Nullable String string3, String string4) {
        e.a(partner, "Partner is null");
        e.a((Object)string2, "OM SDK JS script content is null");
        e.a(list, "VerificationScriptResources is null");
        if (string4 != null) {
            e.a(string4, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, null, string2, list, string3, string4, AdSessionContextType.NATIVE);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public List<VerificationScriptResource> getVerificationScriptResources() {
        return Collections.unmodifiableList(this.verificationScriptResources);
    }

    public Map<String, VerificationScriptResource> getInjectedResourcesMap() {
        return Collections.unmodifiableMap(this.injectedResourcesMap);
    }

    public WebView getWebView() {
        return this.webView;
    }

    @Nullable
    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getCustomReferenceData() {
        return this.customReferenceData;
    }

    public String getOmidJsScriptContent() {
        return this.omidJsScriptContent;
    }

    public AdSessionContextType getAdSessionContextType() {
        return this.adSessionContextType;
    }
}

