/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.impl.adview.AppLovinAppOpenAd;
import com.applovin.impl.adview.AppLovinRewardedInterstitialAd;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdLoadListener;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdService;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.AppLovinAdapterAdViewListener;
import com.applovin.mediation.adapters.AppLovinAdapterAppOpenListener;
import com.applovin.mediation.adapters.AppLovinAdapterInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterMRecAppOpenListener;
import com.applovin.mediation.adapters.AppLovinAdapterMRecInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterNativeAd;
import com.applovin.mediation.adapters.AppLovinAdapterNativeAppOpenListener;
import com.applovin.mediation.adapters.AppLovinAdapterNativeInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterNativeListener;
import com.applovin.mediation.adapters.AppLovinAdapterRewardedInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterRewardedListener;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinSdk;

public class AppLovinMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxAppOpenAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxRewardedInterstitialAdapter,
MaxSignalProvider {
    protected AppLovinAd loadedInterstitialAd;
    protected AppLovinAd loadedAppOpenAd;
    protected AppLovinAd loadedRewardedAd;
    protected AppLovinAd loadedRewardedInterstitialAd;
    protected AppLovinNativeAd loadedNativeAd;
    protected AppLovinAdView loadedAdView;

    public AppLovinMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getAdapterVersion() {
        return this.getSdkVersion();
    }

    @Override
    public void onDestroy() {
        this.loadedInterstitialAd = null;
        this.loadedAppOpenAd = null;
        this.loadedRewardedAd = null;
        this.loadedRewardedInterstitialAd = null;
        if (this.loadedAdView != null) {
            this.loadedAdView.destroy();
            this.loadedAdView = null;
        }
        if (this.loadedNativeAd instanceof AppLovinNativeAdImpl) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = (AppLovinNativeAdImpl)this.loadedNativeAd;
            appLovinNativeAdImpl.destroy();
            this.loadedNativeAd = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    @Override
    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, MaxSignalCollectionListener maxSignalCollectionListener) {
        if (w.a()) {
            this.log("Collecting signal...");
        }
        String string2 = this.getWrappingSdk().getAdService().getBidToken();
        maxSignalCollectionListener.onSignalCollected(string2);
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener = new AppLovinAdapterAdViewListener(this, maxAdFormat, maxAdViewAdapterListener);
        if (StringUtils.isValidString(maxAdapterResponseParameters.getBidResponse())) {
            if (w.a()) {
                this.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdapterAdViewListener);
        } else if (StringUtils.isValidString(maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + string2 + "...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, appLovinAdapterAdViewListener);
        } else {
            AppLovinAdSize appLovinAdSize = null;
            if (maxAdFormat == MaxAdFormat.BANNER) {
                appLovinAdSize = AppLovinAdSize.BANNER;
            } else if (maxAdFormat == MaxAdFormat.MREC) {
                appLovinAdSize = AppLovinAdSize.MREC;
            } else if (maxAdFormat == MaxAdFormat.LEADER) {
                appLovinAdSize = AppLovinAdSize.LEADER;
            }
            if (appLovinAdSize != null) {
                if (w.a()) {
                    this.log("Loading regular " + maxAdFormat.getLabel() + " ad...");
                }
                this.getWrappingSdk().getAdService().loadNextAd(appLovinAdSize, appLovinAdapterAdViewListener);
            } else {
                if (w.a()) {
                    this.log("Failed to load ad for format: " + maxAdFormat);
                }
                maxAdViewAdapterListener.onAdViewAdLoadFailed(MaxAdapterError.INTERNAL_ERROR);
            }
        }
    }

    @Override
    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        String string2 = BundleUtils.getString("haf", maxAdapterResponseParameters.getServerParameters());
        MaxAdFormat maxAdFormat = MaxAdFormat.formatFromString(string2);
        Object object = maxAdFormat == MaxAdFormat.MREC ? new AppLovinAdapterMRecInterstitialListener(this, maxInterstitialAdapterListener) : (maxAdFormat == MaxAdFormat.NATIVE ? new AppLovinAdapterNativeInterstitialListener(this, maxInterstitialAdapterListener) : new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener));
        this.loadFullscreenAd("inter_regular", maxAdapterResponseParameters, MaxAdFormat.INTERSTITIAL, maxAdFormat, object);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        String string2 = BundleUtils.getString("haf", "", maxAdapterResponseParameters.getServerParameters());
        MaxAdFormat maxAdFormat = MaxAdFormat.formatFromString(string2);
        if (maxAdFormat == MaxAdFormat.MREC) {
            this.log("Showing MREC interstitial: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            this.getWrappingSdk().coreSdk.G().a((View)this.loadedAdView, (MaxAdapterListener)maxInterstitialAdapterListener);
        } else if (maxAdFormat == MaxAdFormat.NATIVE) {
            this.log("Showing native interstitial: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            AppLovinAdapterNativeAd appLovinAdapterNativeAd = new AppLovinAdapterNativeAd(this, new MaxNativeAd.Builder().setTitle(this.loadedNativeAd.getTitle()).setBody(this.loadedNativeAd.getBody()).setAdvertiser(this.loadedNativeAd.getAdvertiser()).setCallToAction(this.loadedNativeAd.getCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage(this.loadedNativeAd.getIconUri())).setMainImage(new MaxNativeAd.MaxNativeAdImage(((AppLovinNativeAdImpl)this.loadedNativeAd).getMainImageUri())).setMediaView((View)this.loadedNativeAd.getMediaView()).setMediaContentAspectRatio(this.loadedNativeAd.getMediaView().getAspectRatio()).setOptionsView((View)this.loadedNativeAd.getOptionsView()));
            this.getWrappingSdk().coreSdk.G().a(appLovinAdapterNativeAd, (MaxAdapterListener)maxInterstitialAdapterListener);
        } else {
            this.log("Showing interstitial: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
            AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener = new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener);
            appLovinInterstitialAdDialog.setAdDisplayListener(appLovinAdapterInterstitialListener);
            appLovinInterstitialAdDialog.setAdClickListener(appLovinAdapterInterstitialListener);
            appLovinInterstitialAdDialog.showAndRender(this.loadedInterstitialAd);
        }
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (w.a()) {
            this.log("Showing interstitial ad view: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
        AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener = new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener);
        appLovinInterstitialAdDialog.setAdDisplayListener(appLovinAdapterInterstitialListener);
        appLovinInterstitialAdDialog.setAdClickListener(appLovinAdapterInterstitialListener);
        appLovinInterstitialAdDialog.showAndRender(this.loadedInterstitialAd, viewGroup, lifecycle);
    }

    @Override
    public void loadAppOpenAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        String string2 = BundleUtils.getString("haf", maxAdapterResponseParameters.getServerParameters());
        MaxAdFormat maxAdFormat = MaxAdFormat.formatFromString(string2);
        Object object = maxAdFormat == MaxAdFormat.MREC ? new AppLovinAdapterMRecAppOpenListener(this, maxAppOpenAdapterListener) : (maxAdFormat == MaxAdFormat.NATIVE ? new AppLovinAdapterNativeAppOpenListener(this, maxAppOpenAdapterListener) : new AppLovinAdapterAppOpenListener(this, maxAppOpenAdapterListener));
        this.loadFullscreenAd("inter_appopen", maxAdapterResponseParameters, MaxAdFormat.APP_OPEN, maxAdFormat, object);
    }

    @Override
    public void showAppOpenAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        String string2 = BundleUtils.getString("haf", "", maxAdapterResponseParameters.getServerParameters());
        MaxAdFormat maxAdFormat = MaxAdFormat.formatFromString(string2);
        if (maxAdFormat == MaxAdFormat.MREC) {
            this.log("Showing MREC app open ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            this.getWrappingSdk().coreSdk.G().a((View)this.loadedAdView, (MaxAdapterListener)maxAppOpenAdapterListener);
        } else if (maxAdFormat == MaxAdFormat.NATIVE) {
            this.log("Showing native app open ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            AppLovinAdapterNativeAd appLovinAdapterNativeAd = new AppLovinAdapterNativeAd(this, new MaxNativeAd.Builder().setTitle(this.loadedNativeAd.getTitle()).setBody(this.loadedNativeAd.getBody()).setAdvertiser(this.loadedNativeAd.getAdvertiser()).setCallToAction(this.loadedNativeAd.getCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage(this.loadedNativeAd.getIconUri())).setMainImage(new MaxNativeAd.MaxNativeAdImage(((AppLovinNativeAdImpl)this.loadedNativeAd).getMainImageUri())).setMediaView((View)this.loadedNativeAd.getMediaView()).setMediaContentAspectRatio(this.loadedNativeAd.getMediaView().getAspectRatio()).setOptionsView((View)this.loadedNativeAd.getOptionsView()));
            this.getWrappingSdk().coreSdk.G().a(appLovinAdapterNativeAd, (MaxAdapterListener)maxAppOpenAdapterListener);
        } else {
            this.log("Showing app open ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
            AppLovinAppOpenAd appLovinAppOpenAd = new AppLovinAppOpenAd(this.getWrappingSdk());
            AppLovinAdapterAppOpenListener appLovinAdapterAppOpenListener = new AppLovinAdapterAppOpenListener(this, maxAppOpenAdapterListener);
            appLovinAppOpenAd.setAdDisplayListener(appLovinAdapterAppOpenListener);
            appLovinAppOpenAd.setAdClickListener(appLovinAdapterAppOpenListener);
            appLovinAppOpenAd.show(this.loadedAppOpenAd);
        }
    }

    @Override
    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener(this, maxRewardedAdapterListener);
        this.loadFullscreenAd("inter_videoa", maxAdapterResponseParameters, MaxAdFormat.REWARDED, appLovinAdapterRewardedListener);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        this.configureReward(maxAdapterResponseParameters);
        AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create(this.getWrappingSdk());
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener(this, maxRewardedAdapterListener);
        appLovinIncentivizedInterstitial.show(this.loadedRewardedAd, (Context)activity, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded ad view: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        this.configureReward(maxAdapterResponseParameters);
        AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create(this.getWrappingSdk());
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener(this, maxRewardedAdapterListener);
        appLovinIncentivizedInterstitial.show(this.loadedRewardedAd, viewGroup, lifecycle, (Context)activity, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener, appLovinAdapterRewardedListener);
    }

    @Override
    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        AppLovinAdapterRewardedInterstitialListener appLovinAdapterRewardedInterstitialListener = new AppLovinAdapterRewardedInterstitialListener(this, maxRewardedInterstitialAdapterListener);
        this.loadFullscreenAd("inter_autorew", maxAdapterResponseParameters, MaxAdFormat.REWARDED_INTERSTITIAL, appLovinAdapterRewardedInterstitialListener);
    }

    @Override
    public void showRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded interstitial ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        AppLovinAdapterRewardedInterstitialListener appLovinAdapterRewardedInterstitialListener = new AppLovinAdapterRewardedInterstitialListener(this, maxRewardedInterstitialAdapterListener);
        if (this.loadedRewardedInterstitialAd.getType() == AppLovinAdType.AUTO_INCENTIVIZED) {
            this.configureReward(maxAdapterResponseParameters);
            AppLovinRewardedInterstitialAd appLovinRewardedInterstitialAd = new AppLovinRewardedInterstitialAd(this.getWrappingSdk());
            appLovinRewardedInterstitialAd.setAdDisplayListener(appLovinAdapterRewardedInterstitialListener);
            appLovinRewardedInterstitialAd.setAdClickListener(appLovinAdapterRewardedInterstitialListener);
            appLovinRewardedInterstitialAd.setAdVideoPlaybackListener(appLovinAdapterRewardedInterstitialListener);
            appLovinRewardedInterstitialAd.show(this.loadedRewardedInterstitialAd, (Context)activity, appLovinAdapterRewardedInterstitialListener);
        } else {
            if (w.a()) {
                this.log("Rewarded interstitial is regular interstitial");
            }
            AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
            appLovinInterstitialAdDialog.setAdDisplayListener(appLovinAdapterRewardedInterstitialListener);
            appLovinInterstitialAdDialog.setAdClickListener(appLovinAdapterRewardedInterstitialListener);
            appLovinInterstitialAdDialog.setAdVideoPlaybackListener(appLovinAdapterRewardedInterstitialListener);
            appLovinInterstitialAdDialog.showAndRender(this.loadedRewardedInterstitialAd);
        }
    }

    @Override
    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        String string2 = maxAdapterResponseParameters.getBidResponse();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        if (w.a()) {
            this.d("Loading bidding native ad...");
        }
        AppLovinNativeAdService appLovinNativeAdService = this.getWrappingSdk().coreSdk.v();
        appLovinNativeAdService.loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), new AppLovinAdapterNativeListener(maxAdapterResponseParameters, this, maxNativeAdAdapterListener));
    }

    protected static MaxAdapterError toMaxError(int n2) {
        MaxAdapterError maxAdapterError = n2 == -1009 ? MaxAdapterError.NO_CONNECTION : (n2 == 204 ? MaxAdapterError.NO_FILL : (n2 == -1 ? MaxAdapterError.INTERNAL_ERROR : (n2 >= 500 ? MaxAdapterError.SERVER_ERROR : MaxAdapterError.UNSPECIFIED)));
        return new MaxAdapterError(maxAdapterError.getCode(), maxAdapterError.getErrorMessage(), n2, "");
    }

    protected static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    private void loadFullscreenAd(String string2, MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Object object) {
        this.loadFullscreenAd(string2, maxAdapterResponseParameters, maxAdFormat, null, object);
    }

    private void loadFullscreenAd(String string2, MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, @Nullable MaxAdFormat maxAdFormat2, Object object) {
        if (StringUtils.isValidString(maxAdapterResponseParameters.getBidResponse())) {
            if (maxAdFormat2 == MaxAdFormat.MREC) {
                if (w.a()) {
                    this.log("Loading bidding MREC " + maxAdFormat.getLabel() + " ad...");
                }
                this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), (AppLovinAdLoadListener)object);
            } else if (maxAdFormat2 == MaxAdFormat.NATIVE) {
                if (w.a()) {
                    this.log("Loading bidding native " + maxAdFormat.getLabel() + " ad...");
                }
                this.getWrappingSdk().coreSdk.v().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), (AppLovinNativeAdLoadListener)object);
            } else {
                if (w.a()) {
                    this.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
                }
                this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), (AppLovinAdLoadListener)object);
            }
        } else if (StringUtils.isValidString(maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            String string3 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + string3 + "...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string3, (AppLovinAdLoadListener)object);
        } else {
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, (AppLovinAdLoadListener)object);
        }
    }
}

