/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import com.applovin.impl.sdk.ad.g;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import java.util.Map;

public class AppLovinAdapterRewardedListener
implements g,
AppLovinAdClickListener,
AppLovinAdLoadListener,
AppLovinAdRewardListener,
AppLovinAdVideoPlaybackListener {
    private final AppLovinMediationAdapter parentAdapter;
    private final MaxRewardedAdapterListener listener;
    private boolean hasGrantedReward;

    public AppLovinAdapterRewardedListener(AppLovinMediationAdapter appLovinMediationAdapter, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.parentAdapter = appLovinMediationAdapter;
        this.listener = maxRewardedAdapterListener;
    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad loaded");
        }
        this.parentAdapter.loadedRewardedAd = appLovinAd;
        this.listener.onRewardedAdLoaded();
    }

    @Override
    public void failedToReceiveAd(int n2) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad failed to load with error code: " + n2);
        }
        this.listener.onRewardedAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
    }

    @Override
    public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
        if (w.a()) {
            this.parentAdapter.log("Reward verified");
        }
    }

    @Override
    public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
        if (w.a()) {
            this.parentAdapter.log("User is over quota: " + map);
        }
    }

    @Override
    public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
        if (w.a()) {
            this.parentAdapter.log("Reward rejected: " + map);
        }
    }

    @Override
    public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
        if (w.a()) {
            this.parentAdapter.log("Reward validation request failed with code: " + n2);
        }
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad shown");
        }
        this.listener.onRewardedAdDisplayed();
    }

    @Override
    public void onAdDisplayFailed(String string2) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad failed to display with error: " + string2);
        }
        MaxAdapterError maxAdapterError = new MaxAdapterError(-5200, string2);
        this.listener.onRewardedAdDisplayFailed(maxAdapterError);
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        if (this.hasGrantedReward || this.parentAdapter.shouldAlwaysRewardUser()) {
            MaxReward maxReward = this.parentAdapter.getReward();
            if (w.a()) {
                this.parentAdapter.log("Rewarded user with reward: " + maxReward);
            }
            this.listener.onUserRewarded(maxReward);
        }
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad hidden");
        }
        this.listener.onRewardedAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad clicked");
        }
        this.listener.onRewardedAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad video started");
        }
        this.listener.onRewardedAdVideoStarted();
    }

    @Override
    public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
        if (w.a()) {
            this.parentAdapter.log("Rewarded ad video ended at " + d2 + "% and is fully watched: " + bl);
        }
        this.hasGrantedReward = bl;
        this.listener.onRewardedAdVideoCompleted();
    }
}

