/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinSdkUtils;

public class AppLovinAdapterMRecInterstitialListener
implements AppLovinAdViewEventListener,
AppLovinAdClickListener,
AppLovinAdDisplayListener,
AppLovinAdLoadListener {
    private final AppLovinMediationAdapter parentAdapter;
    private final MaxInterstitialAdapterListener listener;

    public AppLovinAdapterMRecInterstitialListener(AppLovinMediationAdapter appLovinMediationAdapter, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.parentAdapter = appLovinMediationAdapter;
        this.listener = maxInterstitialAdapterListener;
    }

    @Override
    public void adReceived(final AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC interstitial loaded");
        AppLovinSdkUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ((AppLovinAdapterMRecInterstitialListener)AppLovinAdapterMRecInterstitialListener.this).parentAdapter.loadedAdView = new AppLovinAdView(AppLovinAdapterMRecInterstitialListener.this.parentAdapter.getWrappingSdk(), appLovinAd.getSize(), AppLovinAdapterMRecInterstitialListener.this.parentAdapter.getApplicationContext());
                ((AppLovinAdapterMRecInterstitialListener)AppLovinAdapterMRecInterstitialListener.this).parentAdapter.loadedAdView.setAdDisplayListener(AppLovinAdapterMRecInterstitialListener.this);
                ((AppLovinAdapterMRecInterstitialListener)AppLovinAdapterMRecInterstitialListener.this).parentAdapter.loadedAdView.setAdViewEventListener(AppLovinAdapterMRecInterstitialListener.this);
                ((AppLovinAdapterMRecInterstitialListener)AppLovinAdapterMRecInterstitialListener.this).parentAdapter.loadedAdView.setAdClickListener(AppLovinAdapterMRecInterstitialListener.this);
                ((AppLovinAdapterMRecInterstitialListener)AppLovinAdapterMRecInterstitialListener.this).parentAdapter.loadedAdView.renderAd(appLovinAd);
                AppLovinAdapterMRecInterstitialListener.this.listener.onInterstitialAdLoaded();
            }
        });
    }

    @Override
    public void failedToReceiveAd(int n2) {
        MaxAdapterError maxAdapterError = AppLovinMediationAdapter.toMaxError(n2);
        this.parentAdapter.log("MREC interstitial failed to load with error: " + maxAdapterError);
        this.listener.onInterstitialAdLoadFailed(maxAdapterError);
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC interstitial shown");
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC interstitial clicked");
        this.listener.onInterstitialAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC interstitial hidden");
        this.listener.onInterstitialAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC interstitial expanded");
    }

    @Override
    public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC interstitial collapsed");
    }

    @Override
    public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC interstitial left application");
    }

    @Override
    public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
        this.parentAdapter.log("MREC interstitial failed to display with error code: " + (Object)((Object)appLovinAdViewDisplayErrorCode));
    }
}

