/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinSdkUtils;

public class AppLovinAdapterMRecAppOpenListener
implements AppLovinAdViewEventListener,
AppLovinAdClickListener,
AppLovinAdDisplayListener,
AppLovinAdLoadListener {
    private final AppLovinMediationAdapter parentAdapter;
    private final MaxAppOpenAdapterListener listener;

    public AppLovinAdapterMRecAppOpenListener(AppLovinMediationAdapter appLovinMediationAdapter, MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        this.parentAdapter = appLovinMediationAdapter;
        this.listener = maxAppOpenAdapterListener;
    }

    @Override
    public void adReceived(final AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC app open ad loaded");
        AppLovinSdkUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ((AppLovinAdapterMRecAppOpenListener)AppLovinAdapterMRecAppOpenListener.this).parentAdapter.loadedAdView = new AppLovinAdView(AppLovinAdapterMRecAppOpenListener.this.parentAdapter.getWrappingSdk(), appLovinAd.getSize(), AppLovinAdapterMRecAppOpenListener.this.parentAdapter.getApplicationContext());
                ((AppLovinAdapterMRecAppOpenListener)AppLovinAdapterMRecAppOpenListener.this).parentAdapter.loadedAdView.setAdDisplayListener(AppLovinAdapterMRecAppOpenListener.this);
                ((AppLovinAdapterMRecAppOpenListener)AppLovinAdapterMRecAppOpenListener.this).parentAdapter.loadedAdView.setAdViewEventListener(AppLovinAdapterMRecAppOpenListener.this);
                ((AppLovinAdapterMRecAppOpenListener)AppLovinAdapterMRecAppOpenListener.this).parentAdapter.loadedAdView.setAdClickListener(AppLovinAdapterMRecAppOpenListener.this);
                ((AppLovinAdapterMRecAppOpenListener)AppLovinAdapterMRecAppOpenListener.this).parentAdapter.loadedAdView.renderAd(appLovinAd);
                AppLovinAdapterMRecAppOpenListener.this.listener.onAppOpenAdLoaded();
            }
        });
    }

    @Override
    public void failedToReceiveAd(int n2) {
        MaxAdapterError maxAdapterError = AppLovinMediationAdapter.toMaxError(n2);
        this.parentAdapter.log("MREC app open ad failed to load with error: " + maxAdapterError);
        this.listener.onAppOpenAdLoadFailed(maxAdapterError);
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC app open ad shown");
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC app open ad clicked");
        this.listener.onAppOpenAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        this.parentAdapter.log("MREC app open ad hidden");
        this.listener.onAppOpenAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
    }

    @Override
    public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC app open ad expanded");
    }

    @Override
    public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC app open ad collapsed");
    }

    @Override
    public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
        this.parentAdapter.log("MREC app open ad left application");
    }

    @Override
    public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
        this.parentAdapter.log("MREC app open ad failed to display with error code: " + (Object)((Object)appLovinAdViewDisplayErrorCode));
    }
}

