/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.MaxErrorImpl;
import com.applovin.impl.mediation.a.c;
import com.applovin.impl.mediation.a.e;
import com.applovin.impl.mediation.a.f;
import com.applovin.impl.mediation.a.g;
import com.applovin.impl.mediation.a.h;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.c.d;
import com.applovin.impl.mediation.g;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.j;
import com.applovin.impl.sdk.v;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final m a;
    private final v b;
    private final AtomicReference<JSONObject> c = new AtomicReference();

    public MediationServiceImpl(m m2) {
        this.a = m2;
        this.b = m2.A();
        m2.aj().registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, @Nullable String string3, MaxAdFormat maxAdFormat, Map<String, Object> map, Map<String, Object> map2, Context context, a.a a2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (v.a() && TextUtils.isEmpty((CharSequence)this.a.t())) {
            v.i("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (v.a() && !this.a.d()) {
            v.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.a.z().startsWith("05TMD") && v.a()) {
            v.i("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        if (this.a.a(maxAdFormat)) {
            if (v.a()) {
                v.i("MediationService", "Ad load failed due to disabled ad format " + maxAdFormat.getLabel());
            }
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, "Disabled ad format " + maxAdFormat.getLabel());
            j.a((MaxAdListener)a2, string2, (MaxError)maxErrorImpl);
            return;
        }
        this.a.I().a(string2, string3, maxAdFormat, map, map2, context, a2);
    }

    public void showFullscreenAd(final c c2, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.ae().a(true);
        final g g2 = this.a(c2);
        long l2 = c2.z();
        if (v.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                MediationServiceImpl.this.b(c2);
                g2.a(c2, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    public void showFullscreenAd(final c c2, final ViewGroup viewGroup, final Lifecycle lifecycle, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.ae().a(true);
        final g g2 = this.a(c2);
        long l2 = c2.z();
        if (v.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                MediationServiceImpl.this.b(c2);
                g2.a(c2, viewGroup, lifecycle, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    private g a(c c2) {
        g g2 = c2.g();
        if (g2 == null) {
            this.a.ae().a(false);
            if (v.a()) {
                this.b.d("MediationService", "Failed to show " + c2 + ": adapter not found");
                v.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            }
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        return g2;
    }

    private void b(c c2) {
        if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
            com.applovin.impl.mediation.c.g g2 = new com.applovin.impl.mediation.c.g(c2, this.a);
            this.a.S().a(g2, o.a.r);
        }
    }

    private void a(c c2, a.a a2) {
        this.a.ae().a(false);
        this.a(c2, (MaxAdListener)a2);
        if (v.a()) {
            this.b.b("MediationService", "Scheduling impression for ad manually...");
        }
        this.processRawAdImpressionPostback(c2, a2);
    }

    public void destroyAd(MaxAd maxAd) {
        com.applovin.impl.mediation.a.a a2;
        g g2;
        if (!(maxAd instanceof com.applovin.impl.mediation.a.a)) {
            return;
        }
        if (v.a()) {
            this.b.c("MediationService", "Destroying " + maxAd);
        }
        if ((g2 = (a2 = (com.applovin.impl.mediation.a.a)maxAd).g()) != null) {
            g2.j();
            a2.t();
        }
        this.a.B().c(a2.f());
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.a.a a2, Activity activity, a.a a3) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        if (v.a()) {
            this.b.b("MediationService", "Loading " + a2 + "...");
        }
        this.a.ag().a(a2, "WILL_LOAD");
        g g2 = this.a.C().a(a2);
        if (g2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2);
            if (this.a.a(com.applovin.impl.sdk.c.a.S).booleanValue()) {
                this.a.D().a(a2, activity);
            }
            com.applovin.impl.mediation.a.a a4 = a2.a(g2);
            g2.a(string2, a4);
            a4.p();
            g2.a(string2, maxAdapterParametersImpl, a4, activity, new a(a4, a3));
        } else {
            String string3 = "Failed to load " + a2 + ": adapter not loaded";
            if (v.a()) {
                v.i("MediationService", string3);
            }
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-5001, string3);
            this.a(a2, maxErrorImpl, a3);
        }
    }

    public void collectSignal(MaxAdFormat maxAdFormat, final h h2, Context context, final g.a a2) {
        if (h2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        final g g2 = this.a.C().a(h2, true);
        if (g2 != null) {
            Activity activity = context instanceof Activity ? (Activity)context : this.a.an();
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(h2, maxAdFormat);
            if (this.a.a(com.applovin.impl.sdk.c.a.R).booleanValue()) {
                this.a.D().a(h2, activity);
            }
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string2) {
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, g2, string2));
                    g2.j();
                }

                @Override
                public void onSignalCollectionFailed(String string2) {
                    MediationServiceImpl.this.a(string2, h2, g2);
                    a2.a(com.applovin.impl.mediation.a.g.b(h2, g2, string2));
                    g2.j();
                }
            };
            if (h2.a()) {
                if (this.a.D().a(h2)) {
                    if (v.a()) {
                        this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + g2.d());
                    }
                    g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
                } else {
                    if (v.a()) {
                        this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + g2.d());
                    }
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, "Adapter not initialized yet"));
                }
            } else {
                if (v.a()) {
                    this.b.b("MediationService", "Collecting signal for adapter: " + g2.d());
                }
                g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(com.applovin.impl.mediation.a.g.a(h2, "Could not load adapter"));
        }
    }

    private void a(final c c2, final MaxAdListener maxAdListener) {
        final long l2 = this.a.a(com.applovin.impl.sdk.c.a.F);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.s().get()) {
                    return;
                }
                String string2 = "Ad (" + c2.M() + ") has not been displayed after " + l2 + "ms. Failing ad display...";
                if (v.a()) {
                    v.i("MediationService", string2);
                }
                MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, string2);
                MediationServiceImpl.this.b(c2, maxErrorImpl, maxAdListener);
                MediationServiceImpl.this.a.ae().b(c2);
                MediationServiceImpl.this.a.ak().a();
            }
        }, l2);
    }

    public void setCustomPostBodyData(JSONObject jSONObject) {
        this.c.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBodyData() {
        return this.c.getAndSet(null);
    }

    private void a(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a(maxError, a2);
        this.destroyAd(a2);
        j.a(maxAdListener, a2.getAdUnitId(), maxError);
    }

    private void b(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a.ag().a(a2, "DID_FAIL_DISPLAY");
        this.processAdDisplayErrorPostback(maxError, a2);
        if (a2.s().compareAndSet(false, true)) {
            j.a(maxAdListener, (MaxAd)a2, maxError);
        }
    }

    public void processAdLossPostback(com.applovin.impl.mediation.a.a a2, @Nullable Float f2) {
        String string2 = f2 != null ? f2.toString() : "";
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{MBR}", string2);
        this.a("mloss", hashMap, a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2) {
        this.a.ag().a(a2, "DID_LOAD");
        if (a2.d().endsWith("load")) {
            this.a.ag().a(a2);
        }
        long l2 = a2.o();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("load", hashMap, a2);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        long l2 = a2.o();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("mlerr", hashMap, maxError, a2);
    }

    public void processAdapterInitializationPostback(f f2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        hashMap.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", hashMap, new MaxErrorImpl(string2), f2);
    }

    public void processRawAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        this.a.ag().a(a2, "WILL_DISPLAY");
        if (a2.d().endsWith("mimp")) {
            this.a.ag().a(a2);
            j.a(a3, (MaxAd)a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (a2 instanceof c) {
            c c2 = (c)a2;
            hashMap.put("{TIME_TO_SHOW_MS}", String.valueOf(c2.y()));
        }
        this.a("mimp", hashMap, a2);
    }

    public void processViewabilityAdImpressionPostback(e e2, long l2, a.a a2) {
        if (e2.d().endsWith("vimp")) {
            this.a.ag().a(e2);
            j.a(a2, (MaxAd)e2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        hashMap.put("{USED_VIEWABILITY_TIMER}", String.valueOf(e2.G()));
        this.a("mvimp", hashMap, e2);
    }

    public void processCallbackAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        if (a2.d().endsWith("cimp")) {
            this.a.ag().a(a2);
            j.a(a3, (MaxAd)a2);
        }
        this.a("mcimp", (f)a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2, a.a a3) {
        this.a.ag().a(a2, "DID_CLICKED");
        this.a.ag().a(a2, "DID_CLICK");
        if (a2.d().endsWith("click")) {
            this.a.ag().a(a2);
            j.a(a3, (MaxAd)a2);
        }
        this.a("mclick", (f)a2);
    }

    public void processAdDisplayErrorPostback(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, maxError, a2);
    }

    private void a(String string2, h h2, g g2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Utils.putObjectForStringIfValid("{ADAPTER_VERSION}", g2.i(), hashMap);
        Utils.putObjectForStringIfValid("{SDK_VERSION}", g2.h(), hashMap);
        this.a("serr", hashMap, new MaxErrorImpl(string2), h2);
    }

    private void a(String string2, f f2) {
        this.a(string2, Collections.EMPTY_MAP, null, f2);
    }

    private void a(String string2, Map<String, String> map, f f2) {
        this.a(string2, map, null, f2);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, f f2) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("{PLACEMENT}", StringUtils.emptyIfNull(f2.getPlacement()));
        hashMap.put("{CUSTOM_DATA}", StringUtils.emptyIfNull(f2.Z()));
        if (f2 instanceof com.applovin.impl.mediation.a.a) {
            object = (com.applovin.impl.mediation.a.a)f2;
            hashMap.put("{CREATIVE_ID}", StringUtils.emptyIfNull(((com.applovin.impl.mediation.a.a)object).getCreativeId()));
        }
        object = new d(string2, hashMap, maxError, f2, this.a);
        this.a.S().a((com.applovin.impl.sdk.e.a)object, o.a.m);
    }

    @Override
    public void onReceive(Context context, Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.a.ae().c()) instanceof com.applovin.impl.mediation.a.a) {
            com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)object;
            this.processAdDisplayErrorPostback(MaxAdapterError.WEBVIEW_ERROR, a2);
        }
    }

    public class a
    implements a.a,
    MaxAdListener,
    MaxAdRevenueListener,
    MaxAdViewAdListener,
    MaxRewardedAdListener {
        private final com.applovin.impl.mediation.a.a b;
        private a.a c;

        public a(com.applovin.impl.mediation.a.a a2, a.a a3) {
            this.b = a2;
            this.c = a3;
        }

        public void a(a.a a2) {
            this.c = a2;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.a(maxAd, null);
        }

        public void a(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.r();
            this.b.a(bundle);
            MediationServiceImpl.this.a(this.b);
            j.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string2, MaxError maxError) {
            this.b.r();
            MediationServiceImpl.this.a(this.b, maxError, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            this.b(maxAd, null);
        }

        public void b(MaxAd maxAd, @Nullable Bundle bundle) {
            if (v.a()) {
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            }
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.b, this.c);
            this.b.a(bundle);
            MediationServiceImpl.this.a.ag().a(this.b, "DID_DISPLAY");
            if (maxAd.getFormat().isFullscreenAd()) {
                MediationServiceImpl.this.a.ae().a(maxAd);
                MediationServiceImpl.this.a.ak().a(maxAd);
            }
            j.b(this.c, maxAd);
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            this.c(maxAd, null);
        }

        public void c(final MaxAd maxAd, @Nullable Bundle bundle) {
            if (bundle != null && bundle.size() > 0) {
                Bundle bundle2 = bundle.getBundle("ad_values");
                ((com.applovin.impl.mediation.a.a)maxAd).a(BundleUtils.toJSONObject(bundle2));
            }
            MediationServiceImpl.this.a.ag().a((com.applovin.impl.mediation.a.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).A();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat().isFullscreenAd()) {
                        MediationServiceImpl.this.a.ae().b(maxAd);
                        MediationServiceImpl.this.a.ak().a();
                    }
                    j.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            this.d(maxAd, null);
        }

        public void d(MaxAd maxAd, @Nullable Bundle bundle) {
            if (bundle != null && bundle.size() > 0) {
                Bundle bundle2 = bundle.getBundle("ad_values");
                ((com.applovin.impl.mediation.a.a)maxAd).a(BundleUtils.toJSONObject(bundle2));
            }
            MediationServiceImpl.this.a(this.b, this.c);
            j.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
            MediationServiceImpl.this.b(this.b, maxError, this.c);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).F();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            j.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            j.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            j.a((MaxAdListener)this.c, maxAd, maxReward);
            com.applovin.impl.mediation.c.f f2 = new com.applovin.impl.mediation.c.f((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.S().a(f2, o.a.r);
        }

        @Override
        public void onAdRevenuePaid(MaxAd maxAd) {
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            j.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            j.h(this.c, maxAd);
        }
    }
}

