/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.v;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppLovinSdkSettings {
    private boolean a;
    private boolean b;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f = true;
    private String g;
    private final Map<String, Object> localSettings = new HashMap<String, Object>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private List<String> h = Collections.emptyList();
    private List<String> i = Collections.emptyList();
    private final Map<String, String> j = new HashMap<String, String>();
    private final Object k = new Object();
    private m l;

    public AppLovinSdkSettings(Context context) {
        this.a = Utils.isVerboseLoggingEnabled(context);
        this.c = true;
        this.d = true;
        this.e = true;
    }

    public void setTestDeviceAdvertisingIds(List<String> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                if (!v.a()) continue;
                v.i("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.h = arrayList;
        } else {
            this.h = Collections.emptyList();
        }
    }

    public List<String> getTestDeviceAdvertisingIds() {
        return this.h;
    }

    public void setInitializationAdUnitIds(List<String> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                if (!v.a()) continue;
                v.i("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.i = arrayList;
        } else {
            this.i = Collections.emptyList();
        }
    }

    public List<String> getInitializationAdUnitIds() {
        return this.i;
    }

    public void setVerboseLogging(boolean bl) {
        if (Utils.isVerboseLoggingConfigured()) {
            if (v.a()) {
                v.i("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already.");
            }
            if (Utils.isVerboseLoggingEnabled(null) != bl) {
                v.i("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.a = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.a;
    }

    public boolean isMuted() {
        return this.b;
    }

    public void setMuted(boolean bl) {
        this.b = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        this.c = bl;
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.c;
    }

    public void setExceptionHandlerEnabled(boolean bl) {
        this.d = bl;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.d;
    }

    public void setLocationCollectionEnabled(boolean bl) {
        this.e = bl;
    }

    public boolean isLocationCollectionEnabled() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtraParameters() {
        Object object = this.k;
        synchronized (object) {
            return new HashMap<String, String>(this.j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraParameter(String string2, @Nullable String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (v.a()) {
                v.i("AppLovinSdkSettings", "Failed to set extra parameter for null or empty key: " + string2);
            }
            return;
        }
        String string4 = string3 != null ? string3.trim() : null;
        Object object = this.k;
        synchronized (object) {
            this.j.put(string2, string4);
        }
        if ("test_mode_network".equalsIgnoreCase(string2)) {
            if (this.l != null) {
                if (StringUtils.isValidString(string4)) {
                    this.l.J().a(true);
                    this.l.J().a(string4);
                } else {
                    this.l.J().a(false);
                    this.l.J().a((String)null);
                }
            } else {
                this.g = string4;
            }
        }
    }

    protected void attachAppLovinSdk(m m2) {
        this.l = m2;
        if (StringUtils.isValidString(this.g)) {
            m2.J().a(true);
            m2.J().a(this.g);
            this.g = null;
        }
    }

    public void setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(boolean bl) {
        this.f = bl;
    }

    public boolean shouldFailAdDisplayIfDontKeepActivitiesIsEnabled() {
        return this.f;
    }

    @NonNull
    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.a + ", muted=" + this.b + ", testDeviceAdvertisingIds=" + this.h.toString() + ", initializationAdUnitIds=" + this.i.toString() + ", creativeDebuggerEnabled=" + this.c + ", exceptionHandlerEnabled=" + this.d + ", locationCollectionEnabled=" + this.e + '}';
    }
}

