/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAdView;

public class MaxNativeAd {
    private final MaxAdFormat format;
    @NonNull
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final MaxNativeAdImage icon;
    private final View iconView;
    private final View optionsView;
    private final View mediaView;
    private MaxNativeAdView nativeAdView;

    public MaxNativeAd(Builder builder) {
        this.format = builder.a;
        this.title = builder.b;
        this.advertiser = builder.c;
        this.body = builder.d;
        this.callToAction = builder.e;
        this.icon = builder.f;
        this.iconView = builder.g;
        this.optionsView = builder.h;
        this.mediaView = builder.i;
    }

    public final MaxAdFormat getFormat() {
        return this.format;
    }

    @NonNull
    public final String getTitle() {
        return this.title;
    }

    public final String getAdvertiser() {
        return this.advertiser;
    }

    public final String getBody() {
        return this.body;
    }

    public final String getCallToAction() {
        return this.callToAction;
    }

    public final MaxNativeAdImage getIcon() {
        return this.icon;
    }

    public final View getIconView() {
        return this.iconView;
    }

    public final View getOptionsView() {
        return this.optionsView;
    }

    public final View getMediaView() {
        return this.mediaView;
    }

    public void setNativeAdView(MaxNativeAdView maxNativeAdView) {
        this.nativeAdView = maxNativeAdView;
    }

    @UiThread
    public final void performClick() {
        Button button;
        if (this.nativeAdView != null && (button = this.nativeAdView.getCallToActionButton()) != null) {
            button.performClick();
        }
    }

    public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
    }

    public static class MaxNativeAdImage {
        private Drawable a;
        private Uri b;

        public MaxNativeAdImage(Drawable drawable2) {
            this.a = drawable2;
        }

        public MaxNativeAdImage(Uri uri) {
            this.b = uri;
        }

        public Drawable getDrawable() {
            return this.a;
        }

        public Uri getUri() {
            return this.b;
        }
    }

    public static class Builder {
        private MaxAdFormat a;
        private String b;
        private String c;
        private String d;
        private String e;
        private MaxNativeAdImage f;
        private View g;
        private View h;
        private View i;

        public Builder setAdFormat(MaxAdFormat maxAdFormat) {
            this.a = maxAdFormat;
            return this;
        }

        public Builder setTitle(String string2) {
            this.b = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.c = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.d = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.e = string2;
            return this;
        }

        public Builder setIcon(MaxNativeAdImage maxNativeAdImage) {
            this.f = maxNativeAdImage;
            return this;
        }

        public Builder setIconView(View view) {
            this.g = view;
            return this;
        }

        public Builder setOptionsView(View view) {
            this.h = view;
            return this;
        }

        public Builder setMediaView(View view) {
            this.i = view;
            return this;
        }

        public MaxNativeAd build() {
            return new MaxNativeAd(this);
        }
    }
}

