/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.Lifecycle;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.impl.adview.AppLovinRewardedInterstitialAd;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.ad.g;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdEventListener;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdLoadListener;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdService;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.ArrayList;
import java.util.Map;

public class AppLovinMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxRewardedInterstitialAdapter,
MaxSignalProvider {
    private AppLovinAd mLoadedInterstitialAd;
    private AppLovinAd mLoadedRewardedAd;
    private AppLovinAd mLoadedRewardedInterstitialAd;
    private AppLovinNativeAd mNativeAd;
    private AppLovinAdView mLoadedAdView;

    public AppLovinMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getAdapterVersion() {
        return this.getSdkVersion();
    }

    @Override
    public void onDestroy() {
        this.mLoadedInterstitialAd = null;
        this.mLoadedRewardedAd = null;
        this.mLoadedRewardedInterstitialAd = null;
        if (this.mLoadedAdView != null) {
            this.mLoadedAdView.destroy();
            this.mLoadedAdView = null;
        }
        if (this.mNativeAd instanceof AppLovinNativeAdImpl) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = (AppLovinNativeAdImpl)this.mNativeAd;
            appLovinNativeAdImpl.destroy();
            this.mNativeAd = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    @Override
    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, MaxSignalCollectionListener maxSignalCollectionListener) {
        if (w.a()) {
            this.log("Collecting signal...");
        }
        String string2 = this.getWrappingSdk().getAdService().getBidToken();
        maxSignalCollectionListener.onSignalCollected(string2);
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, final MaxAdFormat maxAdFormat, Activity activity, final MaxAdViewAdapterListener maxAdViewAdapterListener) {
        AppLovinAdLoadListener appLovinAdLoadListener = new AppLovinAdLoadListener(){

            @Override
            public void adReceived(final AppLovinAd appLovinAd) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad loaded");
                }
                AppLovinSdkUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppLovinMediationAdapter.this.mLoadedAdView = new AppLovinAdView(AppLovinMediationAdapter.this.getWrappingSdk(), appLovinAd.getSize(), AppLovinMediationAdapter.this.getApplicationContext());
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdDisplayListener(new AppLovinAdDisplayListener(){

                            @Override
                            public void adDisplayed(AppLovinAd appLovinAd) {
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad shown");
                                }
                                maxAdViewAdapterListener.onAdViewAdDisplayed();
                            }

                            @Override
                            public void adHidden(AppLovinAd appLovinAd) {
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad hidden");
                                }
                                maxAdViewAdapterListener.onAdViewAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
                            }
                        });
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdClickListener(new AppLovinAdClickListener(){

                            @Override
                            public void adClicked(AppLovinAd appLovinAd) {
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad clicked");
                                }
                                maxAdViewAdapterListener.onAdViewAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
                            }
                        });
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdViewEventListener(new AppLovinAdViewEventListener(){

                            @Override
                            public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad expanded");
                                }
                                maxAdViewAdapterListener.onAdViewAdExpanded();
                            }

                            @Override
                            public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad collapsed");
                                }
                                maxAdViewAdapterListener.onAdViewAdCollapsed();
                            }

                            @Override
                            public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                            }

                            @Override
                            public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
                                MaxAdapterError maxAdapterError = AppLovinMediationAdapter.toMaxError(appLovinAdViewDisplayErrorCode);
                                if (w.a()) {
                                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad failed to display with error: " + maxAdapterError);
                                }
                                maxAdViewAdapterListener.onAdViewAdDisplayFailed(maxAdapterError);
                            }
                        });
                        maxAdViewAdapterListener.onAdViewAdLoaded((View)AppLovinMediationAdapter.this.mLoadedAdView);
                        AppLovinMediationAdapter.this.mLoadedAdView.renderAd(appLovinAd);
                    }
                });
            }

            @Override
            public void failedToReceiveAd(int n2) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad failed to load with error code: " + n2);
                }
                maxAdViewAdapterListener.onAdViewAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
            }
        };
        if (StringUtils.isValidString(maxAdapterResponseParameters.getBidResponse())) {
            if (w.a()) {
                this.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdLoadListener);
        } else if (StringUtils.isValidString(maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + string2 + "...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, appLovinAdLoadListener);
        } else {
            AppLovinAdSize appLovinAdSize = null;
            if (maxAdFormat == MaxAdFormat.BANNER) {
                appLovinAdSize = AppLovinAdSize.BANNER;
            } else if (maxAdFormat == MaxAdFormat.MREC) {
                appLovinAdSize = AppLovinAdSize.MREC;
            } else if (maxAdFormat == MaxAdFormat.LEADER) {
                appLovinAdSize = AppLovinAdSize.LEADER;
            }
            if (appLovinAdSize != null) {
                if (w.a()) {
                    this.log("Loading mediated " + maxAdFormat.getLabel() + " ad...");
                }
                this.getWrappingSdk().getAdService().loadNextAd(appLovinAdSize, appLovinAdLoadListener);
            } else {
                if (w.a()) {
                    this.log("Failed to load ad for format: " + maxAdFormat);
                }
                maxAdViewAdapterListener.onAdViewAdLoadFailed(MaxAdapterError.INTERNAL_ERROR);
            }
        }
    }

    @Override
    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.loadFullscreenAd("inter_regular", maxAdapterResponseParameters, MaxAdFormat.INTERSTITIAL, maxInterstitialAdapterListener);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (w.a()) {
            this.log("Showing interstitial: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
        InterstitialListenerWrapper interstitialListenerWrapper = new InterstitialListenerWrapper(maxInterstitialAdapterListener);
        appLovinInterstitialAdDialog.setAdDisplayListener(interstitialListenerWrapper);
        appLovinInterstitialAdDialog.setAdClickListener(interstitialListenerWrapper);
        appLovinInterstitialAdDialog.showAndRender(this.mLoadedInterstitialAd);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (w.a()) {
            this.log("Showing interstitial ad view: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
        InterstitialListenerWrapper interstitialListenerWrapper = new InterstitialListenerWrapper(maxInterstitialAdapterListener);
        appLovinInterstitialAdDialog.setAdDisplayListener(interstitialListenerWrapper);
        appLovinInterstitialAdDialog.setAdClickListener(interstitialListenerWrapper);
        appLovinInterstitialAdDialog.showAndRender(this.mLoadedInterstitialAd, viewGroup, lifecycle);
    }

    @Override
    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.loadFullscreenAd("inter_videoa", maxAdapterResponseParameters, MaxAdFormat.REWARDED, maxRewardedAdapterListener);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        this.configureReward(maxAdapterResponseParameters);
        AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create(this.getWrappingSdk());
        RewardedAdListenerWrapper rewardedAdListenerWrapper = new RewardedAdListenerWrapper(maxRewardedAdapterListener);
        appLovinIncentivizedInterstitial.show(this.mLoadedRewardedAd, (Context)activity, rewardedAdListenerWrapper, rewardedAdListenerWrapper, rewardedAdListenerWrapper, rewardedAdListenerWrapper);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded ad view: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        this.configureReward(maxAdapterResponseParameters);
        AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create(this.getWrappingSdk());
        RewardedAdListenerWrapper rewardedAdListenerWrapper = new RewardedAdListenerWrapper(maxRewardedAdapterListener);
        appLovinIncentivizedInterstitial.show(this.mLoadedRewardedAd, viewGroup, lifecycle, (Context)activity, rewardedAdListenerWrapper, rewardedAdListenerWrapper, rewardedAdListenerWrapper, rewardedAdListenerWrapper);
    }

    @Override
    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        this.loadFullscreenAd("inter_autorew", maxAdapterResponseParameters, MaxAdFormat.REWARDED_INTERSTITIAL, maxRewardedInterstitialAdapterListener);
    }

    @Override
    public void showRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        if (w.a()) {
            this.log("Showing rewarded interstitial ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        }
        RewardedInterstitialAdListenerWrapper rewardedInterstitialAdListenerWrapper = new RewardedInterstitialAdListenerWrapper(maxRewardedInterstitialAdapterListener);
        if (this.mLoadedRewardedInterstitialAd.getType() == AppLovinAdType.AUTO_INCENTIVIZED) {
            this.configureReward(maxAdapterResponseParameters);
            AppLovinRewardedInterstitialAd appLovinRewardedInterstitialAd = new AppLovinRewardedInterstitialAd(this.getWrappingSdk());
            appLovinRewardedInterstitialAd.setAdDisplayListener(rewardedInterstitialAdListenerWrapper);
            appLovinRewardedInterstitialAd.setAdClickListener(rewardedInterstitialAdListenerWrapper);
            appLovinRewardedInterstitialAd.setAdVideoPlaybackListener(rewardedInterstitialAdListenerWrapper);
            appLovinRewardedInterstitialAd.show(this.mLoadedRewardedInterstitialAd, (Context)activity, rewardedInterstitialAdListenerWrapper);
        } else {
            if (w.a()) {
                this.log("Rewarded interstitial is regular interstitial");
            }
            AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), (Context)activity);
            appLovinInterstitialAdDialog.setAdDisplayListener(rewardedInterstitialAdListenerWrapper);
            appLovinInterstitialAdDialog.setAdClickListener(rewardedInterstitialAdListenerWrapper);
            appLovinInterstitialAdDialog.setAdVideoPlaybackListener(rewardedInterstitialAdListenerWrapper);
            appLovinInterstitialAdDialog.showAndRender(this.mLoadedRewardedInterstitialAd);
        }
    }

    private void loadFullscreenAd(String string2, MaxAdapterResponseParameters maxAdapterResponseParameters, final MaxAdFormat maxAdFormat, final MaxAdapterListener maxAdapterListener) {
        AppLovinAdLoadListener appLovinAdLoadListener = new AppLovinAdLoadListener(){

            @Override
            public void adReceived(AppLovinAd appLovinAd) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad loaded");
                }
                if (maxAdFormat == MaxAdFormat.INTERSTITIAL) {
                    AppLovinMediationAdapter.this.mLoadedInterstitialAd = appLovinAd;
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoaded();
                } else if (maxAdFormat == MaxAdFormat.REWARDED) {
                    AppLovinMediationAdapter.this.mLoadedRewardedAd = appLovinAd;
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoaded();
                } else if (maxAdFormat == MaxAdFormat.REWARDED_INTERSTITIAL) {
                    AppLovinMediationAdapter.this.mLoadedRewardedInterstitialAd = appLovinAd;
                    ((MaxRewardedInterstitialAdapterListener)maxAdapterListener).onRewardedInterstitialAdLoaded();
                } else {
                    throw new IllegalStateException("Non-fullscreen ad loaded for fullscreen ad adapter");
                }
            }

            @Override
            public void failedToReceiveAd(int n2) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.log(maxAdFormat.getLabel() + " ad failed to load with error code: " + n2);
                }
                if (maxAdFormat == MaxAdFormat.INTERSTITIAL) {
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
                } else if (maxAdFormat == MaxAdFormat.REWARDED) {
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
                } else if (maxAdFormat == MaxAdFormat.REWARDED_INTERSTITIAL) {
                    ((MaxRewardedInterstitialAdapterListener)maxAdapterListener).onRewardedInterstitialAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
                } else {
                    throw new IllegalStateException("Non-fullscreen ad failed to load for fullscreen ad adapter");
                }
            }
        };
        if (StringUtils.isValidString(maxAdapterResponseParameters.getBidResponse())) {
            if (w.a()) {
                this.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdLoadListener);
        } else if (StringUtils.isValidString(maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            String string3 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + string3 + "...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string3, appLovinAdLoadListener);
        } else {
            if (w.a()) {
                this.log("Loading mediated " + maxAdFormat.getLabel() + " ad...");
            }
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, appLovinAdLoadListener);
        }
    }

    @Override
    public void loadNativeAd(final MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        String string2 = maxAdapterResponseParameters.getBidResponse();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        if (w.a()) {
            this.d("Loading bidding native ad...");
        }
        AppLovinNativeAdService appLovinNativeAdService = this.getWrappingSdk().coreSdk.v();
        appLovinNativeAdService.loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), new AppLovinNativeAdLoadListener(){

            @Override
            public void onNativeAdLoaded(AppLovinNativeAd appLovinNativeAd) {
                String string2;
                boolean bl;
                if (w.a()) {
                    AppLovinMediationAdapter.this.d("Native ad loaded: " + appLovinNativeAd);
                }
                if (!AppLovinMediationAdapter.this.hasRequiredAssets(bl = StringUtils.isValidString(string2 = BundleUtils.getString("template", "", maxAdapterResponseParameters.getServerParameters())), appLovinNativeAd)) {
                    if (w.a()) {
                        AppLovinMediationAdapter.this.e("Native ad does not have required assets: " + appLovinNativeAd);
                    }
                    maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                    return;
                }
                ((AppLovinNativeAdImpl)appLovinNativeAd).setEventListener(new AppLovinNativeAdEventListener(){

                    @Override
                    public void onNativeAdClicked(AppLovinNativeAd appLovinNativeAd) {
                        if (w.a()) {
                            AppLovinMediationAdapter.this.d("Native ad clicked");
                        }
                        maxNativeAdAdapterListener.onNativeAdClicked();
                    }
                });
                AppLovinMediationAdapter.this.mNativeAd = appLovinNativeAd;
                MaxAppLovinNativeAd maxAppLovinNativeAd = new MaxAppLovinNativeAd(new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(appLovinNativeAd.getTitle()).setBody(appLovinNativeAd.getBody()).setAdvertiser(appLovinNativeAd.getAdvertiser()).setCallToAction(appLovinNativeAd.getCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage(appLovinNativeAd.getIconUri())).setMediaView((View)appLovinNativeAd.getMediaView()).setOptionsView((View)appLovinNativeAd.getOptionsView()));
                maxNativeAdAdapterListener.onNativeAdLoaded(maxAppLovinNativeAd, null);
            }

            @Override
            public void onNativeAdLoadFailed(int n2) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.d("Native ad failed to load with error code: " + n2);
                }
                maxNativeAdAdapterListener.onNativeAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
            }
        });
    }

    private boolean hasRequiredAssets(boolean bl, AppLovinNativeAd appLovinNativeAd) {
        if (bl) {
            return StringUtils.isValidString(appLovinNativeAd.getTitle());
        }
        return StringUtils.isValidString(appLovinNativeAd.getTitle()) && StringUtils.isValidString(appLovinNativeAd.getCallToAction());
    }

    private static MaxAdapterError toMaxError(AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
        return MaxAdapterError.UNSPECIFIED;
    }

    private static MaxAdapterError toMaxError(int n2) {
        int n3 = n2 == -1009 ? -5207 : (n2 == 204 ? 204 : (n2 == -1 ? -5209 : (n2 >= 500 ? -5208 : -5200)));
        return new MaxAdapterError(n3, n2);
    }

    private static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    private class MaxAppLovinNativeAd
    extends MaxNativeAd {
        public MaxAppLovinNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        @Override
        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = (AppLovinNativeAdImpl)AppLovinMediationAdapter.this.mNativeAd;
            if (appLovinNativeAdImpl == null) {
                if (w.a()) {
                    AppLovinMediationAdapter.this.e("Failed to register native ad view for interaction. Native ad is null");
                }
                return;
            }
            ArrayList<View> arrayList = new ArrayList<View>(4);
            if (StringUtils.isValidString(this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                arrayList.add((View)maxNativeAdView.getTitleTextView());
            }
            if (StringUtils.isValidString(this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                arrayList.add((View)maxNativeAdView.getBodyTextView());
            }
            if (StringUtils.isValidString(this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                arrayList.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                arrayList.add((View)maxNativeAdView.getIconImageView());
            }
            appLovinNativeAdImpl.registerViewsForInteraction(arrayList);
        }
    }

    private class RewardedInterstitialAdListenerWrapper
    extends RewardListenerWrapper
    implements g,
    AppLovinAdClickListener,
    AppLovinAdVideoPlaybackListener {
        private final MaxRewardedInterstitialAdapterListener listener;

        private RewardedInterstitialAdListenerWrapper(MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
            this.listener = maxRewardedInterstitialAdapterListener;
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad shown");
            }
            this.listener.onRewardedInterstitialAdDisplayed();
        }

        @Override
        public void onAdDisplayFailed(String string2) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad failed to display with error: " + string2);
            }
            MaxAdapterError maxAdapterError = new MaxAdapterError(-5200, string2);
            this.listener.onRewardedInterstitialAdDisplayFailed(maxAdapterError);
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            if (this.hasGrantedReward || AppLovinMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward maxReward = AppLovinMediationAdapter.this.getReward();
                if (w.a()) {
                    AppLovinMediationAdapter.this.log("Rewarded interstitial rewarded user with reward: " + maxReward);
                }
                this.listener.onUserRewarded(maxReward);
            }
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad hidden");
            }
            this.listener.onRewardedInterstitialAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad clicked");
            }
            this.listener.onRewardedInterstitialAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad video started");
            }
            this.listener.onRewardedInterstitialAdVideoStarted();
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded interstitial ad video ended at " + d2 + "% and is fully watched: " + bl);
            }
            this.hasGrantedReward = bl;
            this.listener.onRewardedInterstitialAdVideoCompleted();
        }
    }

    private class RewardedAdListenerWrapper
    extends RewardListenerWrapper
    implements g,
    AppLovinAdClickListener,
    AppLovinAdVideoPlaybackListener {
        private final MaxRewardedAdapterListener listener;

        private RewardedAdListenerWrapper(MaxRewardedAdapterListener maxRewardedAdapterListener) {
            this.listener = maxRewardedAdapterListener;
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad shown");
            }
            this.listener.onRewardedAdDisplayed();
        }

        @Override
        public void onAdDisplayFailed(String string2) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad failed to display with error: " + string2);
            }
            MaxAdapterError maxAdapterError = new MaxAdapterError(-5200, string2);
            this.listener.onRewardedAdDisplayFailed(maxAdapterError);
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            if (this.hasGrantedReward || AppLovinMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward maxReward = AppLovinMediationAdapter.this.getReward();
                if (w.a()) {
                    AppLovinMediationAdapter.this.log("Rewarded user with reward: " + maxReward);
                }
                this.listener.onUserRewarded(maxReward);
            }
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad hidden");
            }
            this.listener.onRewardedAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad clicked");
            }
            this.listener.onRewardedAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad video started");
            }
            this.listener.onRewardedAdVideoStarted();
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Rewarded ad video ended at " + d2 + "% and is fully watched: " + bl);
            }
            this.hasGrantedReward = bl;
            this.listener.onRewardedAdVideoCompleted();
        }
    }

    private abstract class RewardListenerWrapper
    implements AppLovinAdRewardListener {
        protected boolean hasGrantedReward;

        private RewardListenerWrapper() {
        }

        @Override
        public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Reward verified");
            }
        }

        @Override
        public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("User is over quota: " + map);
            }
        }

        @Override
        public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Reward rejected: " + map);
            }
        }

        @Override
        public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Reward validation request failed with code: " + n2);
            }
        }
    }

    private class InterstitialListenerWrapper
    implements g,
    AppLovinAdClickListener {
        final MaxInterstitialAdapterListener listener;

        InterstitialListenerWrapper(MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
            this.listener = maxInterstitialAdapterListener;
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Interstitial ad shown");
            }
            this.listener.onInterstitialAdDisplayed();
        }

        @Override
        public void onAdDisplayFailed(String string2) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Interstitial ad failed to display with error: " + string2);
            }
            MaxAdapterError maxAdapterError = new MaxAdapterError(-5200, string2);
            this.listener.onInterstitialAdDisplayFailed(maxAdapterError);
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Interstitial ad clicked");
            }
            this.listener.onInterstitialAdClicked(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            if (w.a()) {
                AppLovinMediationAdapter.this.log("Interstitial ad hidden");
            }
            this.listener.onInterstitialAdHidden(AppLovinMediationAdapter.getExtraInfo(appLovinAd));
        }
    }
}

