/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.w;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static final String EMPTY_JSON = "{}";

    public static JSONObject deserialize(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            return new JSONObject(string2);
        }
        catch (Throwable throwable) {
            if (w.a()) {
                w.i("JsonUtils", "Failed to deserialize into JSON: " + string2);
            }
            return null;
        }
    }

    public static Map<String, String> toStringMap(JSONObject jSONObject) throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap.put(string2, JsonUtils.a(jSONObject.get(string2)).toString());
        }
        return hashMap;
    }

    public static Map<String, Object> toStringObjectMap(JSONObject jSONObject) throws JSONException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap.put(string2, JsonUtils.a(jSONObject.get(string2)));
        }
        return hashMap;
    }

    public static Map<String, Object> toStringObjectMap(String string2, Map<String, Object> map) {
        try {
            return JsonUtils.toStringObjectMap(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            if (w.a()) {
                w.c("JsonUtils", "Failed to convert json string '" + string2 + "' to map", jSONException);
            }
            return map;
        }
    }

    public static Bundle toBundle(Object object) {
        JSONObject jSONObject = null;
        if (object instanceof JSONObject) {
            jSONObject = (JSONObject)object;
        } else if (object instanceof String) {
            String string2 = (String)object;
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return JsonUtils.toBundle(jSONObject);
    }

    public static Bundle toBundle(JSONObject jSONObject) {
        if (jSONObject == null || jSONObject.length() == 0) {
            return new Bundle();
        }
        Bundle bundle = new Bundle();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (jSONObject.isNull(string2)) {
                bundle.putString(string2, null);
                continue;
            }
            Object object = jSONObject.opt(string2);
            if (object instanceof JSONObject) {
                bundle.putBundle(string2, JsonUtils.toBundle((JSONObject)object));
                continue;
            }
            if (object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                if (jSONArray.length() == 0) {
                    bundle.putStringArrayList(string2, new ArrayList(0));
                    continue;
                }
                Object object2 = JsonUtils.getObjectAtIndex(jSONArray, 0, null);
                if (object2 instanceof String) {
                    ArrayList<String> arrayList = new ArrayList<String>(jSONArray.length());
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        String string3 = (String)JsonUtils.getObjectAtIndex(jSONArray, i2, null);
                        arrayList.add(string3);
                    }
                    bundle.putStringArrayList(string2, arrayList);
                    continue;
                }
                bundle.putParcelableArrayList(string2, JsonUtils.toBundle((JSONArray)object));
                continue;
            }
            if (object instanceof Boolean) {
                bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof String) {
                bundle.putString(string2, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                bundle.putInt(string2, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string2, ((Long)object).longValue());
                continue;
            }
            if (!(object instanceof Double)) continue;
            bundle.putDouble(string2, ((Double)object).doubleValue());
        }
        return bundle;
    }

    public static ArrayList<Bundle> toBundle(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return new ArrayList<Bundle>();
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            arrayList.add(JsonUtils.toBundle(jSONArray.optJSONObject(i2)));
        }
        return arrayList;
    }

    public static <T> List<T> optList(JSONArray jSONArray, List<T> list) {
        try {
            return JsonUtils.a(jSONArray, list);
        }
        catch (JSONException jSONException) {
            return list;
        }
    }

    public static List<Integer> toIntegerList(JSONArray jSONArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                arrayList.add((Integer)jSONArray.get(i2));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static <T> List<T> toList(JSONArray jSONArray) throws JSONException {
        return JsonUtils.a(jSONArray, new ArrayList());
    }

    private static <T> List<T> a(JSONArray jSONArray, List<T> list) throws JSONException {
        if (jSONArray == null) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            arrayList.add(JsonUtils.a(jSONArray.get(i2)));
        }
        return arrayList;
    }

    private static Object a(Object object) throws JSONException {
        if (object == JSONObject.NULL) {
            return null;
        }
        if (object instanceof JSONObject) {
            return JsonUtils.toStringObjectMap((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return JsonUtils.toList((JSONArray)object);
        }
        return object;
    }

    public static JSONObject jsonObjectFromJsonString(String string2, JSONObject jSONObject) {
        try {
            return new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            if (w.a()) {
                w.c("JsonUtils", "Failed to convert JSON string '" + string2 + "' to JSONObject", jSONException);
            }
            return jSONObject;
        }
    }

    public static JSONObject shallowCopy(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                jSONObject2.put(string2, jSONObject.get(string2));
            }
            catch (JSONException jSONException) {
                if (!w.a()) continue;
                w.h("JsonUtils", "Failed to copy over item for key '" + string2 + "' to JSONObject copy");
            }
        }
        return jSONObject2;
    }

    public static JSONObject deepCopy(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                Object object = jSONObject.get(string2);
                if (object instanceof JSONObject) {
                    jSONObject2.put(string2, (Object)JsonUtils.deepCopy((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    jSONObject2.put(string2, (Object)JsonUtils.deepCopy((JSONArray)object));
                    continue;
                }
                jSONObject2.put(string2, object);
            }
            catch (JSONException jSONException) {
                if (!w.a()) continue;
                w.h("JsonUtils", "Failed to copy over item for key '" + string2 + "' to JSONObject deep copy");
            }
        }
        return jSONObject2;
    }

    public static JSONArray deepCopy(JSONArray jSONArray) {
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                Object object = jSONArray.get(i2);
                if (object instanceof JSONObject) {
                    jSONArray2.put(i2, (Object)JsonUtils.deepCopy((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    jSONArray2.put(i2, (Object)JsonUtils.deepCopy((JSONArray)object));
                    continue;
                }
                jSONArray2.put(i2, object);
                continue;
            }
            catch (JSONException jSONException) {
                if (!w.a()) continue;
                w.h("JsonUtils", "Failed to copy over item at index " + i2 + " to JSONArray deep copy");
            }
        }
        return jSONArray2;
    }

    public static String maybeConvertToIndentedString(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            return jSONObject.toString();
        }
    }

    public static String maybeConvertToIndentedString(String string2, int n2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        try {
            return new JSONObject(string2).toString(n2);
        }
        catch (JSONException jSONException) {
            return string2;
        }
    }

    public static boolean valueExists(JSONObject jSONObject, String string2) {
        return jSONObject != null && jSONObject.has(string2);
    }

    public static boolean valueExists(JSONArray jSONArray, Object object) {
        if (jSONArray == null || object == null) {
            return false;
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object2 = JsonUtils.getObjectAtIndex(jSONArray, i2, null);
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static void removeObjectsForKeys(JSONObject jSONObject, String[] stringArray) {
        for (String string2 : stringArray) {
            jSONObject.remove(string2);
        }
    }

    public static void putObject(JSONObject jSONObject, String string2, Object object) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, object);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put Object property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static void putString(JSONObject jSONObject, String string2, String string3) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, (Object)string3);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put String property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static String getString(JSONObject jSONObject, String string2, String string3) {
        String string4;
        block3: {
            string4 = string3;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    string4 = jSONObject.getString(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve string property for key = " + string2, jSONException);
                }
            }
        }
        return string4;
    }

    public static void putInt(JSONObject jSONObject, String string2, int n2) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, n2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put int property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static int getInt(JSONObject jSONObject, String string2, int n2) {
        int n3;
        block3: {
            n3 = n2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    n3 = jSONObject.getInt(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve int property for key = " + string2, jSONException);
                }
            }
        }
        return n3;
    }

    public static long getLong(JSONObject jSONObject, String string2, long l2) {
        long l3;
        block3: {
            l3 = l2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    l3 = jSONObject.getLong(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve long property for key = " + string2, jSONException);
                }
            }
        }
        return l3;
    }

    public static void putLong(JSONObject jSONObject, String string2, long l2) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, l2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put long property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static double getDouble(JSONObject jSONObject, String string2, double d2) {
        double d3;
        block3: {
            d3 = d2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    d3 = jSONObject.getDouble(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve double property for key = " + string2, jSONException);
                }
            }
        }
        return d3;
    }

    public static void putDouble(JSONObject jSONObject, String string2, double d2) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, d2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put double property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static Boolean getBoolean(JSONObject jSONObject, String string2, Boolean bl) {
        Boolean bl2 = bl;
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                bl2 = jSONObject.getBoolean(string2);
            }
            catch (JSONException jSONException) {
                int n2 = JsonUtils.getInt(jSONObject, string2, bl != null && bl != false ? 1 : 0);
                return n2 > 0;
            }
        }
        return bl2;
    }

    public static void putBoolean(JSONObject jSONObject, String string2, boolean bl) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, bl);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put boolean property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static float getFloat(JSONObject jSONObject, String string2, float f2) {
        float f3;
        block4: {
            f3 = f2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    double d2 = jSONObject.getDouble(string2);
                    if (-3.4028234663852886E38 < d2 && d2 < 3.4028234663852886E38) {
                        f3 = (float)d2;
                    }
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block4;
                    w.c("JsonUtils", "Failed to retrieve float property for key = " + string2, jSONException);
                }
            }
        }
        return f3;
    }

    @Nullable
    public static Float getFloat(JSONObject jSONObject, String string2, @Nullable Float f2) {
        Float f3;
        block4: {
            f3 = f2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    double d2 = jSONObject.getDouble(string2);
                    if (-3.4028234663852886E38 < d2 && d2 < 3.4028234663852886E38) {
                        f3 = Float.valueOf((float)d2);
                    }
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block4;
                    w.c("JsonUtils", "Failed to retrieve float property for key = " + string2, jSONException);
                }
            }
        }
        return f3;
    }

    public static Object getObject(JSONObject jSONObject, String string2, Object object) {
        Object object2;
        block4: {
            object2 = object;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    Object object3 = jSONObject.get(string2);
                    if (object3 != null) {
                        object2 = object3;
                    }
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block4;
                    w.c("JsonUtils", "Failed to retrieve Object for key = " + string2, jSONException);
                }
            }
        }
        return object2;
    }

    public static void putJSONObject(JSONObject jSONObject, String string2, JSONObject jSONObject2) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put JSON property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static JSONObject getJSONObject(JSONObject jSONObject, String string2, JSONObject jSONObject2) {
        JSONObject jSONObject3;
        block3: {
            jSONObject3 = jSONObject2;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    jSONObject3 = jSONObject.getJSONObject(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve JSON property for key = " + string2, jSONException);
                }
            }
        }
        return jSONObject3;
    }

    public static void putJsonArray(JSONObject jSONObject, String string2, JSONArray jSONArray) {
        block3: {
            if (jSONObject != null) {
                try {
                    jSONObject.put(string2, (Object)jSONArray);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to put JSONArray property for key = " + string2, jSONException);
                }
            }
        }
    }

    public static Object getObjectAtIndex(JSONArray jSONArray, int n2, Object object) {
        Object object2;
        block3: {
            object2 = object;
            if (jSONArray != null && jSONArray.length() > n2) {
                try {
                    object2 = jSONArray.get(n2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve object at index " + n2 + " for JSON array", jSONException);
                }
            }
        }
        return object2;
    }

    public static void putAll(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject == null || jSONObject2 == null) {
            return;
        }
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object object = JsonUtils.getObject(jSONObject2, string2, null);
            if (object == null) continue;
            JsonUtils.putObject(jSONObject, string2, object);
        }
    }

    public static List<Integer> getIntegerList(JSONObject jSONObject, String string2, List<Integer> list) {
        JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, string2, null);
        return jSONArray != null ? JsonUtils.toIntegerList(jSONArray) : list;
    }

    public static List getList(JSONObject jSONObject, String string2, List list) {
        try {
            JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, string2, null);
            return jSONArray != null ? JsonUtils.toList(jSONArray) : list;
        }
        catch (JSONException jSONException) {
            return list;
        }
    }

    public static JSONArray getJSONArray(JSONObject jSONObject, String string2, JSONArray jSONArray) {
        JSONArray jSONArray2;
        block3: {
            jSONArray2 = jSONArray;
            if (jSONObject != null && jSONObject.has(string2)) {
                try {
                    jSONArray2 = jSONObject.getJSONArray(string2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve JSON array for key = " + string2, jSONException);
                }
            }
        }
        return jSONArray2;
    }

    public static JSONObject getJSONObject(JSONArray jSONArray, int n2, JSONObject jSONObject) {
        JSONObject jSONObject2;
        block3: {
            jSONObject2 = jSONObject;
            if (jSONArray != null && n2 < jSONArray.length()) {
                try {
                    jSONObject2 = jSONArray.getJSONObject(n2);
                }
                catch (JSONException jSONException) {
                    if (!w.a()) break block3;
                    w.c("JsonUtils", "Failed to retrieve JSON object from array for index = " + n2, jSONException);
                }
            }
        }
        return jSONObject2;
    }

    public static boolean containsCaseInsensitiveString(String string2, JSONArray jSONArray) {
        try {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string3;
                Object object = jSONArray.get(i2);
                if (!(object instanceof String) || !(string3 = (String)object).equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return false;
    }

    public static JSONArray getJSONArray(Object object) {
        if (object == null) {
            return new JSONArray();
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(object);
        return jSONArray;
    }
}

