/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.applovin.impl.adview.AppLovinTouchToClickListener;
import com.applovin.impl.adview.AppLovinVideoView;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.w;
import com.applovin.sdk.R;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"ViewConstructor"})
public class AppLovinMediaView
extends FrameLayout {
    private static final String TAG = "AppLovinMediaView";
    private final AppLovinNativeAdImpl ad;
    private final n sdk;
    private final w logger;
    private final AtomicBoolean impressionTracked = new AtomicBoolean();
    private final ImageView imageView;
    @Nullable
    private AppLovinVideoView videoView;
    private boolean isVideoMuted;
    private MediaPlayer mediaPlayer;
    private final a videoUiEventHandler = new a();
    private final com.applovin.impl.sdk.utils.a lifecycleCallbacksAdapter = new com.applovin.impl.sdk.utils.a(){

        @Override
        public void onActivityResumed(Activity activity) {
            if (AppLovinMediaView.this.videoView != null) {
                AppLovinMediaView.this.videoView.start();
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
            if (AppLovinMediaView.this.videoView != null) {
                AppLovinMediaView.this.videoView.pause();
            }
        }
    };

    public AppLovinMediaView(AppLovinNativeAdImpl appLovinNativeAdImpl, n n2, Context context) {
        super(context);
        Uri uri;
        this.setBackgroundColor(-16777216);
        this.ad = appLovinNativeAdImpl;
        this.sdk = n2;
        this.logger = n2.A();
        this.isVideoMuted = true;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.applovin_native_ad_media_view, (ViewGroup)this, true);
        Uri uri2 = appLovinNativeAdImpl.getMainImageUri();
        com.applovin.impl.a.a a2 = appLovinNativeAdImpl.getVastAd();
        Uri uri3 = uri = a2 != null ? a2.h() : null;
        if (uri2 == null && uri == null) {
            throw new IllegalStateException("AppLovin native ad missing image AND video resources");
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        this.setOnTouchListener(new AppLovinTouchToClickListener(n2, b.aN, context, appLovinNativeAdImpl.getClickHandler()));
        this.imageView = (ImageView)this.findViewById(R.id.image_view);
        if (uri2 != null) {
            this.imageView.setOnClickListener((View.OnClickListener)appLovinNativeAdImpl.getClickHandler());
            this.imageView.setImageURI(uri2);
        }
        if (uri != null) {
            n2.af().a(this.lifecycleCallbacksAdapter);
            this.videoView = new AppLovinVideoView(context, n2);
            this.videoView.setOnPreparedListener(this.videoUiEventHandler);
            this.videoView.setOnCompletionListener(this.videoUiEventHandler);
            this.videoView.setOnErrorListener(this.videoUiEventHandler);
            this.videoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.addView((View)this.videoView);
            this.videoView.setVideoURI(uri);
            this.imageView.setVisibility(8);
        } else {
            this.videoView = null;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.impressionTracked.compareAndSet(false, true)) {
            for (String string2 : this.ad.getImpressionUrls()) {
                this.sdk.X().dispatchPostbackAsync(string2, null);
            }
            this.ad.getAdEventTracker().a((View)this);
            this.ad.getAdEventTracker().d();
        }
        if (this.videoView != null) {
            this.videoView.start();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.videoView != null) {
            this.videoView.pause();
        }
        super.onDetachedFromWindow();
    }

    public void destroy() {
        this.setOnTouchListener(null);
        this.sdk.af().b(this.lifecycleCallbacksAdapter);
        try {
            if (this.videoView != null) {
                this.videoView.pause();
                this.videoView.stopPlayback();
                this.videoView.setOnPreparedListener(null);
                this.videoView.setOnCompletionListener(null);
                this.videoView.setOnErrorListener(null);
                this.videoView = null;
            }
            if (this.mediaPlayer != null) {
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)("Encountered exception when destroying:" + throwable));
        }
        this.removeAllViews();
    }

    private class a
    implements MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnPreparedListener {
        private a() {
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            AppLovinMediaView.this.mediaPlayer = mediaPlayer;
            mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)AppLovinMediaView.this.videoUiEventHandler);
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)AppLovinMediaView.this.videoUiEventHandler);
            boolean bl = !AppLovinMediaView.this.isVideoMuted;
            mediaPlayer.setVolume((float)bl, (float)bl);
            if (w.a()) {
                AppLovinMediaView.this.logger.b(AppLovinMediaView.TAG, "MediaPlayer prepared: " + AppLovinMediaView.this.mediaPlayer);
            }
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
            if (w.a()) {
                AppLovinMediaView.this.logger.b(AppLovinMediaView.TAG, "MediaPlayer Info: (" + n2 + ", " + n3 + ")");
            }
            return false;
        }

        public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
            if (w.a()) {
                String string2 = "Video view error (" + n2 + "," + n3 + ")";
                AppLovinMediaView.this.logger.e(AppLovinMediaView.TAG, "Encountered media error: " + string2 + " for ad: " + AppLovinMediaView.this.ad);
            }
            return true;
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            if (w.a()) {
                AppLovinMediaView.this.logger.b(AppLovinMediaView.TAG, "Video completed");
            }
            if (AppLovinMediaView.this.videoView != null) {
                AppLovinMediaView.this.videoView.setVisibility(8);
            }
            AppLovinMediaView.this.imageView.setVisibility(0);
        }
    }
}

