/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.text.TextUtils;
import com.applovin.impl.mediation.MaxMediatedNetworkInfoImpl;
import com.applovin.impl.mediation.c.c;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.u;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.d;
import com.applovin.mediation.MaxMediatedNetworkInfo;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinEventService;
import com.applovin.sdk.AppLovinPostbackService;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinTargetingData;
import com.applovin.sdk.AppLovinUserSegment;
import com.applovin.sdk.AppLovinUserService;
import com.applovin.sdk.AppLovinVariableService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AppLovinSdk {
    public static final String VERSION = AppLovinSdk.getVersion();
    public static final int VERSION_CODE = AppLovinSdk.getVersionCode();
    private static final String TAG = "AppLovinSdk";
    private static final Map<String, AppLovinSdk> sdkInstances = new HashMap<String, AppLovinSdk>();
    private static final Object sdkInstancesLock = new Object();
    public final m coreSdk;

    public String getSdkKey() {
        return this.coreSdk.z();
    }

    public AppLovinSdkSettings getSettings() {
        return this.coreSdk.p();
    }

    public void setPluginVersion(String string2) {
        this.coreSdk.a(string2);
    }

    public void setUserIdentifier(String string2) {
        this.coreSdk.b(string2);
    }

    public String getUserIdentifier() {
        return this.coreSdk.m();
    }

    public AppLovinUserSegment getUserSegment() {
        return this.coreSdk.q();
    }

    public AppLovinTargetingData getTargetingData() {
        return this.coreSdk.r();
    }

    public AppLovinAdService getAdService() {
        return this.coreSdk.u();
    }

    public AppLovinPostbackService getPostbackService() {
        return this.coreSdk.W();
    }

    public AppLovinEventService getEventService() {
        return this.coreSdk.w();
    }

    public AppLovinUserService getUserService() {
        return this.coreSdk.x();
    }

    public AppLovinVariableService getVariableService() {
        return this.coreSdk.y();
    }

    public void setMediationProvider(String string2) {
        this.coreSdk.c(string2);
    }

    public String getMediationProvider() {
        return this.coreSdk.t();
    }

    public List<MaxMediatedNetworkInfo> getAvailableMediatedNetworks() {
        JSONArray jSONArray = c.a(this.coreSdk);
        ArrayList<MaxMediatedNetworkInfo> arrayList = new ArrayList<MaxMediatedNetworkInfo>(jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = JsonUtils.getJSONObject(jSONArray, i2, null);
            arrayList.add(new MaxMediatedNetworkInfoImpl(jSONObject));
        }
        return arrayList;
    }

    public void showMediationDebugger() {
        this.coreSdk.l();
    }

    public boolean isInitialized() {
        return this.coreSdk.d();
    }

    public void initializeSdk() {
    }

    public void initializeSdk(SdkInitializationListener sdkInitializationListener) {
        this.coreSdk.a(sdkInitializationListener);
    }

    public static void initializeSdk(Context context) {
        AppLovinSdk.initializeSdk(context, null);
    }

    public static void initializeSdk(Context context, SdkInitializationListener sdkInitializationListener) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        AppLovinSdk appLovinSdk = AppLovinSdk.getInstance(context);
        if (appLovinSdk != null) {
            appLovinSdk.initializeSdk(sdkInitializationListener);
        } else if (u.a()) {
            u.i(TAG, "Unable to initialize AppLovin SDK: SDK object not created");
        }
    }

    public AppLovinSdkConfiguration getConfiguration() {
        return this.coreSdk.s();
    }

    public static AppLovinSdk getInstance(Context context) {
        return AppLovinSdk.getInstance(new a(context), context);
    }

    public static AppLovinSdk getInstance(AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string2 = d.a(context).a("applovin.sdk.key", "");
        return AppLovinSdk.getInstance(string2, appLovinSdkSettings, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLovinSdk getInstance(String string2, AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (appLovinSdkSettings == null) {
            throw new IllegalArgumentException("No userSettings specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        Object object = sdkInstancesLock;
        synchronized (object) {
            Object object2;
            if (sdkInstances.containsKey(string2)) {
                return sdkInstances.get(string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains(File.separator)) {
                if (u.a()) {
                    object2 = "\n**************************************************\nINVALID SDK KEY: " + string2 + "\n**************************************************\n";
                    u.i(TAG, (String)object2);
                }
                if (!sdkInstances.isEmpty()) {
                    return sdkInstances.values().iterator().next();
                }
                string2 = string2.replace(File.separator, "");
            }
            object2 = new m();
            ((m)object2).a(string2, appLovinSdkSettings, context);
            AppLovinSdk appLovinSdk = new AppLovinSdk((m)object2);
            ((m)object2).a(appLovinSdk);
            appLovinSdkSettings.attachAppLovinSdk((m)object2);
            sdkInstances.put(string2, appLovinSdk);
            return appLovinSdk;
        }
    }

    public boolean isEnabled() {
        return this.coreSdk.d();
    }

    private AppLovinSdk(m m2) {
        this.coreSdk = m2;
    }

    private static String getVersion() {
        return "11.2.2";
    }

    private static int getVersionCode() {
        return 11020299;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeAll(Boolean bl, Boolean bl2, Boolean bl3) {
        Object object = sdkInstancesLock;
        synchronized (object) {
            for (AppLovinSdk appLovinSdk : sdkInstances.values()) {
                Map<String, String> map;
                appLovinSdk.coreSdk.b();
                appLovinSdk.coreSdk.i();
                if (bl != null) {
                    if (u.a()) {
                        appLovinSdk.coreSdk.A().c(TAG, "Toggled 'huc' to " + bl);
                    }
                    map = CollectionUtils.map("value", bl.toString());
                    appLovinSdk.getEventService().trackEvent("huc", map);
                }
                if (bl2 != null) {
                    if (u.a()) {
                        appLovinSdk.coreSdk.A().c(TAG, "Toggled 'aru' to " + bl2);
                    }
                    map = CollectionUtils.map("value", bl2.toString());
                    appLovinSdk.getEventService().trackEvent("aru", map);
                }
                if (bl3 == null) continue;
                if (u.a()) {
                    appLovinSdk.coreSdk.A().c(TAG, "Toggled 'dns' to " + bl3);
                }
                map = CollectionUtils.map("value", bl3.toString());
                appLovinSdk.getEventService().trackEvent("dns", map);
            }
        }
    }

    public static List<AppLovinSdk> a() {
        return new ArrayList<AppLovinSdk>(sdkInstances.values());
    }

    public String toString() {
        return "AppLovinSdk{sdkKey='" + this.getSdkKey() + "', isEnabled=" + this.isEnabled() + ", isFirstSession=" + this.coreSdk.O() + '}';
    }

    private static class a
    extends AppLovinSdkSettings {
        a(Context context) {
            super(context);
        }
    }

    public static interface SdkInitializationListener {
        public void onSdkInitialized(AppLovinSdkConfiguration var1);
    }
}

