/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.u;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleUtils {
    public static boolean containsAtLeastOneKey(Set<String> set, Bundle bundle) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String string2 : set) {
            if (!bundle.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    public static void putString(String string2, @Nullable String string3, Bundle bundle) {
        if (string3 != null) {
            bundle.putString(string2, string3);
        }
    }

    public static void putStringIfValid(String string2, @Nullable String string3, Bundle bundle) {
        if (AppLovinSdkUtils.isValidString(string3)) {
            bundle.putString(string2, string3);
        }
    }

    public static void putBoolean(String string2, @Nullable Boolean bl, Bundle bundle) {
        if (bl != null) {
            bundle.putBoolean(string2, bl.booleanValue());
        }
    }

    public static void putInt(String string2, @Nullable Integer n2, Bundle bundle) {
        if (n2 != null) {
            bundle.putInt(string2, n2.intValue());
        }
    }

    public static void putLong(String string2, @Nullable Long l2, Bundle bundle) {
        if (l2 != null) {
            bundle.putLong(string2, l2.longValue());
        }
    }

    public static void putDouble(String string2, @Nullable Double d2, Bundle bundle) {
        if (d2 != null) {
            bundle.putDouble(string2, d2.doubleValue());
        }
    }

    public static void putByte(String string2, @Nullable Byte by, Bundle bundle) {
        if (by != null) {
            bundle.putByte(string2, by.byteValue());
        }
    }

    public static void putChar(String string2, @Nullable Character c2, Bundle bundle) {
        if (c2 != null) {
            bundle.putChar(string2, c2.charValue());
        }
    }

    public static void putFloat(String string2, @Nullable Float f2, Bundle bundle) {
        if (f2 != null) {
            bundle.putFloat(string2, f2.floatValue());
        }
    }

    public static void putShort(String string2, @Nullable Short s2, Bundle bundle) {
        if (s2 != null) {
            bundle.putShort(string2, s2.shortValue());
        }
    }

    public static void putCharSequence(String string2, @Nullable CharSequence charSequence, Bundle bundle) {
        if (charSequence != null) {
            bundle.putCharSequence(string2, charSequence);
        }
    }

    public static void putStringArray(String string2, @Nullable String[] stringArray, Bundle bundle) {
        if (stringArray != null) {
            bundle.putStringArray(string2, stringArray);
        }
    }

    public static void putBooleanArray(String string2, @Nullable boolean[] blArray, Bundle bundle) {
        if (blArray != null) {
            bundle.putBooleanArray(string2, blArray);
        }
    }

    public static void putIntArray(String string2, @Nullable int[] nArray, Bundle bundle) {
        if (nArray != null) {
            bundle.putIntArray(string2, nArray);
        }
    }

    public static void putLongArray(String string2, @Nullable long[] lArray, Bundle bundle) {
        if (lArray != null) {
            bundle.putLongArray(string2, lArray);
        }
    }

    public static void putDoubleArray(String string2, @Nullable double[] dArray, Bundle bundle) {
        if (dArray != null) {
            bundle.putDoubleArray(string2, dArray);
        }
    }

    public static void putByteArray(String string2, @Nullable byte[] byArray, Bundle bundle) {
        if (byArray != null) {
            bundle.putByteArray(string2, byArray);
        }
    }

    public static void putCharArray(String string2, @Nullable char[] cArray, Bundle bundle) {
        if (cArray != null) {
            bundle.putCharArray(string2, cArray);
        }
    }

    public static void putFloatArray(String string2, @Nullable float[] fArray, Bundle bundle) {
        if (fArray != null) {
            bundle.putFloatArray(string2, fArray);
        }
    }

    public static void putShortArray(String string2, @Nullable short[] sArray, Bundle bundle) {
        if (sArray != null) {
            bundle.putShortArray(string2, sArray);
        }
    }

    public static void putCharSequenceArray(String string2, @Nullable CharSequence[] charSequenceArray, Bundle bundle) {
        if (charSequenceArray != null) {
            bundle.putCharSequenceArray(string2, charSequenceArray);
        }
    }

    public static void putStringArrayList(String string2, @Nullable ArrayList<String> arrayList, Bundle bundle) {
        if (arrayList != null) {
            bundle.putStringArrayList(string2, arrayList);
        }
    }

    public static void putIntegerArrayList(String string2, @Nullable ArrayList<Integer> arrayList, Bundle bundle) {
        if (arrayList != null) {
            bundle.putIntegerArrayList(string2, arrayList);
        }
    }

    public static void putCharSequenceArrayList(String string2, @Nullable ArrayList<CharSequence> arrayList, Bundle bundle) {
        if (arrayList != null) {
            bundle.putCharSequenceArrayList(string2, arrayList);
        }
    }

    public static void put(String string2, @Nullable Object object, Bundle bundle) {
        if (object != null) {
            if (object instanceof String) {
                BundleUtils.putString(string2, (String)object, bundle);
            } else if (object instanceof Boolean) {
                BundleUtils.putBoolean(string2, (Boolean)object, bundle);
            } else if (object instanceof Integer) {
                BundleUtils.putInt(string2, (Integer)object, bundle);
            } else if (object instanceof Long) {
                BundleUtils.putLong(string2, (Long)object, bundle);
            } else if (object instanceof Double) {
                BundleUtils.putDouble(string2, (Double)object, bundle);
            } else if (object instanceof Byte) {
                BundleUtils.putByte(string2, (Byte)object, bundle);
            } else if (object instanceof Character) {
                BundleUtils.putChar(string2, (Character)object, bundle);
            } else if (object instanceof Float) {
                BundleUtils.putFloat(string2, (Float)object, bundle);
            } else if (object instanceof Short) {
                BundleUtils.putShort(string2, (Short)object, bundle);
            } else if (object instanceof CharSequence) {
                BundleUtils.putCharSequence(string2, (CharSequence)object, bundle);
            } else if (object instanceof String[]) {
                BundleUtils.putStringArray(string2, (String[])object, bundle);
            } else if (object instanceof boolean[]) {
                BundleUtils.putBooleanArray(string2, (boolean[])object, bundle);
            } else if (object instanceof int[]) {
                BundleUtils.putIntArray(string2, (int[])object, bundle);
            } else if (object instanceof long[]) {
                BundleUtils.putLongArray(string2, (long[])object, bundle);
            } else if (object instanceof double[]) {
                BundleUtils.putDoubleArray(string2, (double[])object, bundle);
            } else if (object instanceof byte[]) {
                BundleUtils.putByteArray(string2, (byte[])object, bundle);
            } else if (object instanceof char[]) {
                BundleUtils.putCharArray(string2, (char[])object, bundle);
            } else if (object instanceof float[]) {
                BundleUtils.putFloatArray(string2, (float[])object, bundle);
            } else if (object instanceof short[]) {
                BundleUtils.putShortArray(string2, (short[])object, bundle);
            } else if (object instanceof CharSequence[]) {
                BundleUtils.putCharSequenceArray(string2, (CharSequence[])object, bundle);
            } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0) {
                if (((ArrayList)object).get(0) instanceof String) {
                    BundleUtils.putStringArrayList(string2, (ArrayList)object, bundle);
                } else if (((ArrayList)object).get(0) instanceof Integer) {
                    BundleUtils.putIntegerArrayList(string2, (ArrayList)object, bundle);
                } else if (((ArrayList)object).get(0) instanceof CharSequence) {
                    BundleUtils.putCharSequenceArrayList(string2, (ArrayList)object, bundle);
                }
            } else if (u.a()) {
                u.i("AppLovinSdk", "Skipped insertion of " + object + " into Bundle");
            }
        } else if (u.a()) {
            u.i("AppLovinSdk", "Skipped insertion into Bundle because value is null.");
        }
    }

    public static boolean getBoolean(String string2, Bundle bundle) {
        return BundleUtils.getBoolean(string2, false, bundle);
    }

    public static boolean getBoolean(String string2, boolean bl, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return bl;
        }
        Object object = bundle.get(string2);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            return n2 != 0;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("1")) {
                return true;
            }
            if (string3.equalsIgnoreCase("false") || string3.equalsIgnoreCase("0")) {
                return false;
            }
            return bl;
        }
        return bl;
    }

    public static int getInt(String string2, Bundle bundle) {
        return BundleUtils.getInt(string2, 0, bundle);
    }

    public static int getInt(String string2, int n2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return n2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return n2;
    }

    public static long getLong(String string2, Bundle bundle) {
        return BundleUtils.getLong(string2, 0L, bundle);
    }

    public static long getLong(String string2, long l2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return l2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        return l2;
    }

    public static String getString(String string2, Bundle bundle) {
        return BundleUtils.getString(string2, null, bundle);
    }

    public static String getString(String string2, String string3, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return string3;
        }
        Object object = bundle.get(string2);
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public static Bundle getBundle(String string2, Bundle bundle) {
        return BundleUtils.getBundle(string2, null, bundle);
    }

    public static Bundle getBundle(String string2, Bundle bundle, Bundle bundle2) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle2 == null) {
            return bundle;
        }
        Bundle bundle3 = bundle2.getBundle(string2);
        return bundle3 != null ? bundle3 : bundle;
    }

    public static Map<String, Object> toMap(Bundle bundle) {
        if (bundle == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            if (object == null) continue;
            if (object instanceof Bundle) {
                hashMap.put(string2, BundleUtils.toMap((Bundle)object));
                continue;
            }
            if (object instanceof Collection || object instanceof Parcelable[]) {
                List<Parcelable> list = object instanceof Collection ? (List<Parcelable>)object : Arrays.asList((Parcelable[])object);
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (Object e2 : list) {
                    if (e2 instanceof Bundle) {
                        arrayList.add(BundleUtils.toMap((Bundle)e2));
                        continue;
                    }
                    arrayList.add((Map<String, Object>)e2);
                }
                hashMap.put(string2, arrayList);
                continue;
            }
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    public static JSONObject toJSONObject(Bundle bundle) {
        JSONObject jSONObject;
        block8: {
            if (bundle == null) {
                return new JSONObject();
            }
            jSONObject = new JSONObject();
            try {
                for (String string2 : bundle.keySet()) {
                    Object object = bundle.get(string2);
                    if (object == null) continue;
                    if (object instanceof Bundle) {
                        jSONObject.put(string2, (Object)BundleUtils.toJSONObject((Bundle)object));
                        continue;
                    }
                    if (object instanceof Collection || object instanceof Parcelable[]) {
                        List<Parcelable> list = object instanceof Collection ? (List<Parcelable>)object : Arrays.asList((Parcelable[])object);
                        JSONArray jSONArray = new JSONArray();
                        for (Object e2 : list) {
                            if (e2 instanceof Bundle) {
                                jSONArray.put((Object)BundleUtils.toJSONObject((Bundle)e2));
                                continue;
                            }
                            jSONArray.put(e2);
                        }
                        jSONObject.put(string2, (Object)jSONArray);
                        continue;
                    }
                    jSONObject.put(string2, object);
                }
            }
            catch (JSONException jSONException) {
                if (!u.a()) break block8;
                u.c("AppLovinSdk", "Failed to convert Bundle to JSONObject", jSONException);
            }
        }
        return jSONObject;
    }

    public static Map<String, String> toStringMap(Bundle bundle) {
        if (bundle == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(bundle.size());
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            hashMap.put(string2, String.valueOf(object));
        }
        return hashMap;
    }
}

