/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.content.Context;
import android.graphics.PointF;
import android.net.Uri;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.adview.AppLovinTouchToClickListener;
import com.applovin.impl.sdk.AppLovinAdBase;
import com.applovin.impl.sdk.a.e;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.nativeAd.AppLovinMediaView;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdEventListener;
import com.applovin.impl.sdk.nativeAd.AppLovinOptionsView;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.j;
import com.iab.omid.library.applovin.adsession.VerificationScriptResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinNativeAdImpl
extends AppLovinAdBase
implements AppLovinNativeAd {
    private static final String AD_RESPONSE_TYPE_APPLOVIN = "applovin";
    private static final String AD_RESPONSE_TYPE_ORTB = "ortb";
    private static final String AD_RESPONSE_TYPE_UNDEFINED = "undefined";
    private final String tag;
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final com.applovin.impl.a.a vastAd;
    private final Uri privacyDestinationUri;
    private final Uri clickDestinationUri;
    private final Uri clickDestinationBackupUri;
    private final List<String> clickTrackingUrls;
    private final List<String> impressionUrls;
    private final List<String> viewableMRC50Urls;
    private final List<String> viewableMRC100Urls;
    private final List<String> viewableVideo50Urls;
    private final a clickHandler;
    private AppLovinNativeAdEventListener eventListener;
    private Uri iconUri;
    private Uri mainImageUri;
    private Uri privacyIconUri;
    private AppLovinMediaView mediaView;
    private AppLovinOptionsView optionsView;
    private final List<View> registeredViews = new ArrayList<View>();
    private final e adEventTracker;

    private AppLovinNativeAdImpl(Builder builder) {
        super(builder.adObject, builder.fullResponse, builder.sdk);
        this.clickHandler = new a(this);
        this.adEventTracker = new e(this);
        this.title = builder.title;
        this.advertiser = builder.advertiser;
        this.body = builder.body;
        this.callToAction = builder.callToAction;
        this.iconUri = builder.iconUri;
        this.mainImageUri = builder.mainImageUri;
        this.privacyIconUri = builder.privacyIconUri;
        this.vastAd = builder.vastAd;
        this.privacyDestinationUri = builder.privacyDestinationUri;
        this.clickDestinationUri = builder.clickDestinationUri;
        this.clickDestinationBackupUri = builder.clickDestinationBackupUri;
        this.clickTrackingUrls = builder.clickTrackingUrls;
        this.impressionUrls = builder.impressionUrls;
        this.viewableMRC50Urls = builder.viewableMRC50Urls;
        this.viewableMRC100Urls = builder.viewableMRC100Urls;
        this.viewableVideo50Urls = builder.viewableVideo50Urls;
        this.tag = "AppLovinNativeAd:" + this.getAdIdNumber();
    }

    @Override
    public void registerViewsForInteraction(List<View> list) {
        if (this.clickDestinationUri == null && this.clickDestinationBackupUri == null) {
            return;
        }
        for (View view : list) {
            if (view.hasOnClickListeners()) {
                this.sdk.A().e(this.tag, "View has an onClickListener already - " + view);
            }
            view.setOnClickListener((View.OnClickListener)this.clickHandler);
            this.registeredViews.add(view);
        }
        this.sdk.A().b(this.tag, "Registered views: " + this.registeredViews);
    }

    @Override
    public void unregisterViewsForInteraction() {
        for (View view : this.registeredViews) {
            view.setOnClickListener(null);
        }
        this.sdk.A().b(this.tag, "Unregistered views: " + this.registeredViews);
        this.registeredViews.clear();
    }

    public void setUpNativeAdViewComponents() {
        this.mediaView = new AppLovinMediaView(this, this.sdk, this.sdk.K());
        this.optionsView = new AppLovinOptionsView(this, this.sdk, this.sdk.K());
    }

    public String getType() {
        return this.getStringFromAdObject("type", AD_RESPONSE_TYPE_UNDEFINED);
    }

    @Override
    public long getAdIdNumber() {
        return this.getLongFromAdObject("ad_id", -1L);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAdvertiser() {
        return this.advertiser;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getCallToAction() {
        return this.callToAction;
    }

    @Override
    public Uri getIconUri() {
        return this.iconUri;
    }

    @Override
    public AppLovinMediaView getMediaView() {
        return this.mediaView;
    }

    @Override
    public AppLovinOptionsView getOptionsView() {
        return this.optionsView;
    }

    @Nullable
    public String getCachePrefix() {
        return this.getStringFromAdObject("cache_prefix", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<com.applovin.impl.sdk.d.a> getDirectClickTrackingPostbacks() {
        Object object = this.adObjectLock;
        synchronized (object) {
            String string2 = this.getStringFromAdObject("click_tracking_url", null);
            return Utils.getPostbacks("click_tracking_urls", this.adObject, this.getClCode(), string2, this.sdk);
        }
    }

    @Override
    public e getAdEventTracker() {
        return this.adEventTracker;
    }

    @Override
    public boolean isOpenMeasurementEnabled() {
        return this.getBooleanFromAdObject("omsdk_enabled", false);
    }

    @Override
    @Nullable
    public String getOpenMeasurementContentUrl() {
        return this.getStringFromAdObject("omid_content_url", null);
    }

    @Override
    public String getOpenMeasurementCustomReferenceData() {
        return this.getStringFromAdObject("omid_custom_ref_data", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VerificationScriptResource> getOpenMeasurementVerificationScriptResources() {
        ArrayList<VerificationScriptResource> arrayList = new ArrayList<VerificationScriptResource>();
        Object object = this.adObjectLock;
        synchronized (object) {
            JSONArray jSONArray = JsonUtils.getJSONArray(this.adObject, "omid_verification_script_resources", null);
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = JsonUtils.getJSONObject(jSONArray, i2, null);
                    try {
                        String string2 = JsonUtils.getString(jSONObject, "url", null);
                        URL uRL = new URL(string2);
                        String string3 = JsonUtils.getString(jSONObject, "vendor_key", null);
                        String string4 = JsonUtils.getString(jSONObject, "parameters", null);
                        if (StringUtils.isValidString(string3) && StringUtils.isValidString(string4)) {
                            arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithParameters(string3, uRL, string4));
                            continue;
                        }
                        arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithoutParameters(uRL));
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.sdk.A().b(this.tag, "Failed to parse OMID verification script resource", throwable);
                    }
                }
            }
        }
        return arrayList;
    }

    @NonNull
    public String toString() {
        return "AppLovinNativeAd{adIdNumber=" + this.getAdIdNumber() + " - " + this.getTitle() + "}";
    }

    public com.applovin.impl.a.a getVastAd() {
        return this.vastAd;
    }

    public Uri getPrivacyDestinationUri() {
        return this.privacyDestinationUri;
    }

    public List<String> getImpressionUrls() {
        return this.impressionUrls;
    }

    public a getClickHandler() {
        return this.clickHandler;
    }

    public void setEventListener(AppLovinNativeAdEventListener appLovinNativeAdEventListener) {
        this.eventListener = appLovinNativeAdEventListener;
    }

    public void setIconUri(Uri uri) {
        this.iconUri = uri;
    }

    public Uri getMainImageUri() {
        return this.mainImageUri;
    }

    public void setMainImageUri(Uri uri) {
        this.mainImageUri = uri;
    }

    public Uri getPrivacyIconUri() {
        return this.privacyIconUri;
    }

    public void setPrivacyIconUri(Uri uri) {
        this.privacyIconUri = uri;
    }

    public static class Builder {
        private final JSONObject adObject;
        private final JSONObject fullResponse;
        private final m sdk;
        private String title;
        private String advertiser;
        private String body;
        private String callToAction;
        private Uri iconUri;
        private Uri mainImageUri;
        private Uri privacyIconUri;
        private com.applovin.impl.a.a vastAd;
        private Uri clickDestinationUri;
        private Uri clickDestinationBackupUri;
        private Uri privacyDestinationUri;
        private List<String> clickTrackingUrls;
        private List<String> impressionUrls;
        private List<String> viewableMRC50Urls;
        private List<String> viewableMRC100Urls;
        private List<String> viewableVideo50Urls;

        public Builder(JSONObject jSONObject, JSONObject jSONObject2, m m2) {
            this.adObject = jSONObject;
            this.fullResponse = jSONObject2;
            this.sdk = m2;
        }

        public Builder setTitle(String string2) {
            this.title = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.advertiser = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.body = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.callToAction = string2;
            return this;
        }

        public Builder setIconUri(Uri uri) {
            this.iconUri = uri;
            return this;
        }

        public Builder setMainImageUri(Uri uri) {
            this.mainImageUri = uri;
            return this;
        }

        public Builder setPrivacyIconUri(Uri uri) {
            this.privacyIconUri = uri;
            return this;
        }

        public Builder setVastAd(com.applovin.impl.a.a a2) {
            this.vastAd = a2;
            return this;
        }

        public Builder setClickDestinationUri(Uri uri) {
            this.clickDestinationUri = uri;
            return this;
        }

        public Builder setClickDestinationBackupUri(Uri uri) {
            this.clickDestinationBackupUri = uri;
            return this;
        }

        public Builder setClickTrackingUrls(List<String> list) {
            this.clickTrackingUrls = list;
            return this;
        }

        public Builder setImpressionUrls(List<String> list) {
            this.impressionUrls = list;
            return this;
        }

        public Builder setPrivacyDestinationUri(Uri uri) {
            this.privacyDestinationUri = uri;
            return this;
        }

        public Builder setViewableMRC50Urls(List<String> list) {
            this.viewableMRC50Urls = list;
            return this;
        }

        public Builder setViewableMRC100Urls(List<String> list) {
            this.viewableMRC100Urls = list;
            return this;
        }

        public Builder setViewableVideo50Urls(List<String> list) {
            this.viewableVideo50Urls = list;
            return this;
        }

        public AppLovinNativeAdImpl build() {
            return new AppLovinNativeAdImpl(this);
        }
    }

    private static class a
    implements View.OnClickListener,
    AppLovinTouchToClickListener.OnClickListener {
        private final AppLovinNativeAdImpl a;

        @Override
        public void onClick(View view, PointF pointF) {
            this.a(view.getContext());
        }

        public void onClick(View view) {
            this.a(view.getContext());
        }

        private void a(Context context) {
            this.a.sdk.u().maybeSubmitPersistentPostbacks(this.a.getDirectClickTrackingPostbacks());
            for (String string2 : this.a.clickTrackingUrls) {
                this.a.sdk.W().dispatchPostbackAsync(string2, null);
            }
            if (Utils.openUri(context, this.a.clickDestinationUri, this.a.sdk) || Utils.openUri(context, this.a.clickDestinationBackupUri, this.a.sdk)) {
                j.a(this.a.eventListener, this.a);
            }
        }

        public a(AppLovinNativeAdImpl appLovinNativeAdImpl) {
            this.a = appLovinNativeAdImpl;
        }

        public AppLovinNativeAdImpl a() {
            return this.a;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a a2 = (a)object;
            if (!a2.a(this)) {
                return false;
            }
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            AppLovinNativeAdImpl appLovinNativeAdImpl2 = a2.a();
            return !(appLovinNativeAdImpl == null ? appLovinNativeAdImpl2 != null : !appLovinNativeAdImpl.equals(appLovinNativeAdImpl2));
        }

        protected boolean a(Object object) {
            return object instanceof a;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.a();
            n3 = n3 * 59 + (appLovinNativeAdImpl == null ? 43 : appLovinNativeAdImpl.hashCode());
            return n3;
        }

        public String toString() {
            return "AppLovinNativeAdImpl.ClickHandler(ad=" + this.a() + ")";
        }
    }
}

