/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Objects;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import com.google.errorprone.annotations.ForOverride;
import java.io.Serializable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Equivalence<T> {
    protected Equivalence() {
    }

    public final boolean equivalent(@NullableDecl T t2, @NullableDecl T t3) {
        if (t2 == t3) {
            return true;
        }
        if (t2 == null || t3 == null) {
            return false;
        }
        return this.doEquivalent(t2, t3);
    }

    @ForOverride
    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@NullableDecl T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    @ForOverride
    protected abstract int doHash(T var1);

    public final <S extends T> Wrapper<S> wrap(@NullableDecl S s2) {
        return new Wrapper(this, s2);
    }

    public final Predicate<T> equivalentTo(@NullableDecl T t2) {
        return new b<T>(this, t2);
    }

    public static Equivalence<Object> equals() {
        return a.a;
    }

    public static Equivalence<Object> identity() {
        return c.a;
    }

    static final class c
    extends Equivalence<Object>
    implements Serializable {
        static final c a = new c();

        c() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return false;
        }

        @Override
        protected int doHash(Object object) {
            return System.identityHashCode(object);
        }
    }

    static final class a
    extends Equivalence<Object>
    implements Serializable {
        static final a a = new a();

        a() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return object.equals(object2);
        }

        @Override
        protected int doHash(Object object) {
            return object.hashCode();
        }
    }

    private static final class b<T>
    implements Predicate<T>,
    Serializable {
        private final Equivalence<T> a;
        @NullableDecl
        private final T b;

        b(Equivalence<T> equivalence, @NullableDecl T t2) {
            this.a = Preconditions.checkNotNull(equivalence);
            this.b = t2;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            return this.a.equivalent(t2, this.b);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof b) {
                b b2 = (b)object;
                return this.a.equals(b2.a) && Objects.equal(this.b, b2.b);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.a, this.b);
        }

        public String toString() {
            return this.a + ".equivalentTo(" + this.b + ")";
        }
    }

    public static final class Wrapper<T>
    implements Serializable {
        private final Equivalence<? super T> equivalence;
        @NullableDecl
        private final T reference;
        private static final long serialVersionUID = 0L;

        private Wrapper(Equivalence<? super T> equivalence, @NullableDecl T t2) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.reference = t2;
        }

        @NullableDecl
        public T get() {
            return this.reference;
        }

        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)object;
                if (this.equivalence.equals(wrapper.equivalence)) {
                    Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, wrapper.reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            return this.equivalence + ".wrap(" + this.reference + ")";
        }
    }
}

