/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.ViewGroup;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxRewardImpl;
import com.applovin.impl.sdk.l;
import com.applovin.impl.sdk.t;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdViewAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdViewAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.sdk.AppLovinSdk;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class MediationAdapterBase
implements MaxAdapter,
MaxInterstitialAdViewAdapter,
MaxNativeAdAdapter,
MaxRewardedAdViewAdapter {
    private static final ExecutorService sCachingExecutorService = Executors.newFixedThreadPool(4);
    private final String mTag;
    private final AppLovinSdk mWrappingSdk;
    private final l mSdk;
    private final t mLogger;
    private MaxReward reward;
    private boolean alwaysRewardUser;

    protected static String mediationTag() {
        return "AppLovinSdk_" + AppLovinSdk.VERSION;
    }

    public MediationAdapterBase(AppLovinSdk appLovinSdk) {
        this.mWrappingSdk = appLovinSdk;
        this.mSdk = appLovinSdk.coreSdk;
        this.mLogger = this.mSdk.A();
        this.mTag = this.getClass().getSimpleName();
    }

    @Override
    public boolean isBeta() {
        return false;
    }

    protected Context getApplicationContext() {
        return this.mSdk.K();
    }

    protected AppLovinSdk getWrappingSdk() {
        return this.mWrappingSdk;
    }

    protected ExecutorService getCachingExecutorService() {
        return sCachingExecutorService;
    }

    protected void log(String string2) {
        this.mLogger.c(this.mTag, string2);
    }

    protected void log(String string2, Throwable throwable) {
        this.mLogger.b(this.mTag, string2, throwable);
    }

    protected void userError(String string2) {
        this.userError(string2, null);
    }

    protected void userError(String string2, Throwable throwable) {
        t.c(this.mTag, string2, throwable);
    }

    protected void checkExistence(Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            for (Class<?> clazz : classArray) {
                this.log("Found: " + clazz.getName());
            }
        }
    }

    protected void checkActivities(Context context, Class<?> ... classArray) {
    }

    protected Future<Drawable> createDrawableFuture(final String string2, final Resources resources) {
        return this.getCachingExecutorService().submit(new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                InputStream inputStream = new URL(string2).openStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
                inputStream.close();
                return bitmapDrawable;
            }
        });
    }

    protected MaxReward getReward() {
        return this.reward != null ? this.reward : MaxRewardImpl.createDefault();
    }

    protected boolean shouldAlwaysRewardUser() {
        return this.alwaysRewardUser;
    }

    protected void configureReward(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        Bundle bundle = maxAdapterResponseParameters.getServerParameters();
        this.alwaysRewardUser = BundleUtils.getBoolean("always_reward_user", maxAdapterResponseParameters.isTesting(), bundle);
        int n2 = BundleUtils.getInt("amount", 0, bundle);
        String string2 = BundleUtils.getString("currency", "", bundle);
        this.log("Creating reward: " + n2 + " " + string2);
        this.reward = MaxRewardImpl.create(n2, string2);
    }

    String getVersionString(Class clazz, String string2) {
        String string3 = Utils.getString(clazz, string2);
        if (string3 == null) {
            this.log("Failed to retrieve version string.");
        }
        return string3;
    }

    protected void d(String string2) {
        this.mLogger.b(this.mTag, string2);
    }

    protected void i(String string2) {
        this.mLogger.c(this.mTag, string2);
    }

    protected void w(String string2) {
        this.mLogger.d(this.mTag, string2);
    }

    protected void e(String string2) {
        this.mLogger.e(this.mTag, string2);
    }

    protected void e(String string2, Throwable throwable) {
        this.mLogger.b(this.mTag, string2, throwable);
    }

    @Override
    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support native ads.");
        maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support interstitial ad view ads.");
        maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support rewarded ad view ads.");
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    private static class ExecutorServiceAdapter
    implements ExecutorService {
        private final Executor executor;

        private ExecutorServiceAdapter(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public <T> Future<T> submit(Runnable runnable, T t2) {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws ExecutionException, InterruptedException {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            throw new RuntimeException("Method not implemented, use 'execute'");
        }

        @Override
        public void execute(Runnable runnable) {
            this.executor.execute(runnable);
        }
    }
}

