/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.MaxRewardImpl;
import com.applovin.impl.sdk.l;
import com.applovin.impl.sdk.t;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MediationAdapterRouter {
    private static final Map<String, MediationAdapterRouter> sharedInstances = new HashMap<String, MediationAdapterRouter>();
    private static final Object sharedInstancesLock = new Object();
    private final String mTag = this.getClass().getSimpleName();
    private l mSdk;
    protected MaxAdapter.OnCompletionListener mOnCompletionListener;
    private final Map<String, List<MediationAdapterRouterListenerWrapper>> listeners = new HashMap<String, List<MediationAdapterRouterListenerWrapper>>();
    private final Object listenersLock = new Object();
    private final Set<MaxAdapter> loadedAdapters = new HashSet<MaxAdapter>();
    private final Object loadedAdaptersLock = new Object();
    private final Set<MaxAdapter> showingAdapters = new HashSet<MaxAdapter>();
    private final Object showingAdaptersLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MediationAdapterRouter getSharedInstance(Class clazz) {
        Object object = sharedInstancesLock;
        synchronized (object) {
            String string2 = clazz.getName();
            MediationAdapterRouter mediationAdapterRouter = sharedInstances.get(string2);
            if (mediationAdapterRouter == null) {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    mediationAdapterRouter = (MediationAdapterRouter)constructor.newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                sharedInstances.put(string2, mediationAdapterRouter);
            }
            return mediationAdapterRouter;
        }
    }

    protected MediationAdapterRouter() {
        for (AppLovinSdk appLovinSdk : AppLovinSdk.a()) {
            if (!"max".equalsIgnoreCase(appLovinSdk.getMediationProvider())) continue;
            this.mSdk = appLovinSdk.coreSdk;
        }
        if (this.mSdk == null) {
            t.i(this.mTag, "Invalid mediation provider detected. Please set AppLovin SDK mediation provider to MAX via AppLovinSdk.getInstance(context).setMediationProvider( AppLovinMediationProvider.MAX )");
        }
    }

    abstract void initialize(MaxAdapterInitializationParameters var1, Activity var2, MaxAdapter.OnCompletionListener var3);

    public void addInterstitialAdapter(MaxAdapter maxAdapter, MaxInterstitialAdapterListener maxInterstitialAdapterListener, String string2) {
        this.addAdapter(maxAdapter, maxInterstitialAdapterListener, string2, RouterAdLoadType.INTERSTITIAL, null);
    }

    public void addRewardedAdapter(MaxAdapter maxAdapter, MaxRewardedAdapterListener maxRewardedAdapterListener, String string2) {
        this.addAdapter(maxAdapter, maxRewardedAdapterListener, string2, RouterAdLoadType.REWARDED, null);
    }

    public void addAdViewAdapter(MaxAdapter maxAdapter, MaxAdViewAdapterListener maxAdViewAdapterListener, String string2, View view) {
        this.addAdapter(maxAdapter, maxAdViewAdapterListener, string2, RouterAdLoadType.ADVIEW, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdView(View view, String string2) {
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string2);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (mediationAdapterRouterListenerWrapper.getAdView() != null) continue;
                    mediationAdapterRouterListenerWrapper.setAdView(view);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.add(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdapter(MaxAdapter maxAdapter, String string2) {
        this.removeLoadedAdapter(maxAdapter);
        this.removeShowingAdapter(maxAdapter);
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.listeners.get(string2);
            if (list != null && list.size() > 0) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = null;
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper2 : list) {
                    if (mediationAdapterRouterListenerWrapper2.getAdapter() != maxAdapter) continue;
                    mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper2;
                    break;
                }
                if (mediationAdapterRouterListenerWrapper != null) {
                    list.remove(mediationAdapterRouterListenerWrapper);
                }
            }
        }
    }

    protected void onAdLoaded(String string2) {
        this.onAdLoaded(string2, null);
    }

    protected void onAdLoaded(String string2, @Nullable Bundle bundle) {
        List<MediationAdapterRouterListenerWrapper> list = this.getLoadingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                this.addLoadedAdapter(mediationAdapterRouterListenerWrapper.getAdapter());
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial loaded");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoaded(bundle);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded loaded");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoaded(bundle);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView loaded");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdLoaded(mediationAdapterRouterListenerWrapper.getAdView(), bundle);
            }
        }
    }

    protected void onAdLoadFailed(String string2, MaxAdapterError maxAdapterError) {
        List<MediationAdapterRouterListenerWrapper> list = this.getLoadingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial failed to load with error: " + maxAdapterError.toString());
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded failed to load with error: " + maxAdapterError.toString());
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView failed to load with error: " + maxAdapterError.toString());
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdLoadFailed(maxAdapterError);
            }
        }
    }

    protected void onAdDisplayed(String string2) {
        this.onAdDisplayed(string2, null);
    }

    protected void onAdDisplayed(String string2, @Nullable Bundle bundle) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial shown");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdDisplayed(bundle);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded shown");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdDisplayed(bundle);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView shown");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdDisplayed(bundle);
            }
        }
    }

    protected void onAdDisplayFailed(String string2, MaxAdapterError maxAdapterError) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial failed to display with error: " + maxAdapterError.toString());
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded failed to display with error: " + maxAdapterError.toString());
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView failed to display with error: " + maxAdapterError.toString());
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdDisplayFailed(maxAdapterError);
            }
        }
    }

    protected void onAdClicked(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial clicked");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdClicked();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded clicked");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdClicked();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView clicked");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdClicked();
            }
        }
    }

    protected void onAdHidden(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial hidden");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdHidden();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded hidden");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdHidden();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView hidden");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdHidden();
            }
        }
    }

    protected void onRewardedAdVideoStarted(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video started");
                ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdVideoStarted();
            }
        }
    }

    protected void onRewardedAdVideoCompleted(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video completed");
                ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdVideoCompleted();
            }
        }
    }

    protected void onUserRewarded(String string2, MaxReward maxReward) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded user with reward: " + maxReward);
                ((MaxRewardedAdapterListener)maxAdapterListener).onUserRewarded(maxReward);
            }
        }
    }

    protected void onAdViewAdExpanded(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView expanded");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdExpanded();
            }
        }
    }

    protected void onAdViewAdCollapsed(String string2) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string2);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView collapsed");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdCollapsed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MaxReward getReward(String string2) {
        Object object = this.listenersLock;
        synchronized (object) {
            MaxAdapter maxAdapter;
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string2);
            if (list != null && list.size() > 0 && (maxAdapter = list.get(0).getAdapter()) instanceof MediationAdapterBase) {
                return ((MediationAdapterBase)maxAdapter).getReward();
            }
        }
        return MaxRewardImpl.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldAlwaysRewardUser(String string2) {
        Object object = this.listenersLock;
        synchronized (object) {
            MaxAdapter maxAdapter;
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string2);
            if (list != null && list.size() > 0 && (maxAdapter = list.get(0).getAdapter()) instanceof MediationAdapterBase) {
                return ((MediationAdapterBase)maxAdapter).shouldAlwaysRewardUser();
            }
        }
        return false;
    }

    protected void log(String string2) {
        if (this.mSdk != null) {
            this.mSdk.A().c(this.mTag, string2);
        }
    }

    protected void log(String string2, Throwable throwable) {
        if (this.mSdk != null) {
            this.mSdk.A().b(this.mTag, string2, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdapter(MaxAdapter maxAdapter, MaxAdapterListener maxAdapterListener, String string2, RouterAdLoadType routerAdLoadType, View view) {
        Object object = this.listenersLock;
        synchronized (object) {
            MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = new MediationAdapterRouterListenerWrapper(maxAdapter, maxAdapterListener, routerAdLoadType, view);
            List<Object> list = this.listeners.get(string2) != null ? this.listeners.get(string2) : new ArrayList(1);
            list.add(mediationAdapterRouterListenerWrapper);
            this.listeners.put(string2, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.add(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.remove(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdLoaded(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            return this.loadedAdapters.contains(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.remove(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdShowing(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            return this.showingAdapters.contains(maxAdapter);
        }
    }

    private List<MediationAdapterRouterListenerWrapper> getListenerWrappers(String string2) {
        ArrayList arrayList = this.listeners.containsKey(string2) ? new ArrayList(this.listeners.get(string2)) : null;
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MediationAdapterRouterListenerWrapper> getLoadingListenerWrappers(String string2) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string2);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (this.isAdLoaded(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                    arrayList.add(mediationAdapterRouterListenerWrapper);
                }
                return arrayList;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MediationAdapterRouterListenerWrapper> getShowingListenerWrappers(String string2) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string2);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (!this.isAdShowing(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                    arrayList.add(mediationAdapterRouterListenerWrapper);
                }
                return arrayList;
            }
        }
        return null;
    }

    private final class MediationAdapterRouterListenerWrapper {
        private final MaxAdapter mAdapter;
        private final MaxAdapterListener mListener;
        private final RouterAdLoadType mLoadType;
        private View mAdView;

        MediationAdapterRouterListenerWrapper(MaxAdapter maxAdapter, MaxAdapterListener maxAdapterListener, RouterAdLoadType routerAdLoadType, View view) {
            this.mAdapter = maxAdapter;
            this.mListener = maxAdapterListener;
            this.mLoadType = routerAdLoadType;
            this.mAdView = view;
        }

        MaxAdapter getAdapter() {
            return this.mAdapter;
        }

        MaxAdapterListener getListener() {
            return this.mListener;
        }

        RouterAdLoadType getLoadType() {
            return this.mLoadType;
        }

        View getAdView() {
            return this.mAdView;
        }

        void setAdView(View view) {
            this.mAdView = view;
        }
    }

    private static enum RouterAdLoadType {
        INTERSTITIAL,
        REWARDED,
        ADVIEW;

    }
}

