package com.applovin.mediation;

/**
 * This interface represents an ad that has been served by AppLovin MAX.
 */
public interface MaxAd
{
    /**
     * @return Loaded ad format. Guaranteed not to be null.
     */
    MaxAdFormat getFormat();

    /**
     * @return Ad unit id for which this ad was loaded. Guaranteed not to be null.
     */
    String getAdUnitId();

    /**
     * @return The ad network for which this ad was loaded from. Guaranteed not to be null.
     */
    String getNetworkName();

    /**
     * @return The ad network placement for which this ad was loaded from. Guaranteed not to be null.
     */
    String getNetworkPlacement();

    /**
     * @return The ad placement which was set for this ad. May be null.
     */
    String getPlacement();

    /**
     * The underlying waterfall of ad responses.
     */
    MaxAdWaterfallInfo getWaterfall();

    /**
     * The creative id tied to the ad, if any. It may not be available for some ad networks until {@code MaxFullscreenAdListener#onAdDisplayed()} is called.
     *
     * @return The ad's creative ID, if available. May be null.
     */
    String getCreativeId();

    /**
     * The revenue amount tied to the ad.
     *
     * @return The ad's revenue amount, or -1 if it does not exist.
     */
    double getRevenue();

    /**
     * Get an arbitrary ad value for a given key.
     *
     * @param key The designated key to retrieve desired value for.
     *
     * @return An arbitrary ad value for a given key - or null if does not exist.
     */
    String getAdValue(final String key);

    /**
     * Get an arbitrary ad value for a given key.
     *
     * @param key          The designated key to retrieve desired value for.
     * @param defaultValue The default value to return if the desired value for does not exist or is null.
     *
     * @return An arbitrary ad value for a given key - or the default value if does not exist.
     */
    String getAdValue(final String key, final String defaultValue);
}
