/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.graphics.PointF;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import android.text.TextUtils;
import com.applovin.adview.AppLovinAdView;
import com.applovin.impl.sdk.AppLovinAdBase;
import com.applovin.impl.sdk.a.c;
import com.applovin.impl.sdk.a.d;
import com.applovin.impl.sdk.a.f;
import com.applovin.impl.sdk.a.h;
import com.applovin.impl.sdk.e.j;
import com.applovin.impl.sdk.e.k;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.e.p;
import com.applovin.impl.sdk.f;
import com.applovin.impl.sdk.network.g;
import com.applovin.impl.sdk.network.i;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinAdServiceImpl
implements AppLovinAdService {
    private final com.applovin.impl.sdk.k a;
    private final r b;
    private final Handler c = new Handler(Looper.getMainLooper());
    private final Map<d, b> d;
    private final Object e = new Object();
    private final Map<String, String> f = new HashMap<String, String>();

    AppLovinAdServiceImpl(com.applovin.impl.sdk.k k2) {
        this.a = k2;
        this.b = k2.z();
        this.d = new HashMap<d, b>(5);
        this.d.put(com.applovin.impl.sdk.a.d.g(), new b());
        this.d.put(com.applovin.impl.sdk.a.d.h(), new b());
        this.d.put(com.applovin.impl.sdk.a.d.i(), new b());
        this.d.put(com.applovin.impl.sdk.a.d.j(), new b());
        this.d.put(com.applovin.impl.sdk.a.d.k(), new b());
    }

    @Override
    public void loadNextAd(AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.a(com.applovin.impl.sdk.a.d.a(appLovinAdSize, AppLovinAdType.REGULAR), null, appLovinAdLoadListener);
    }

    @Override
    public void loadNextAdForZoneId(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No zone id specified");
        }
        this.b.b("AppLovinAdService", "Loading next ad of zone {" + string2 + "}");
        d d2 = com.applovin.impl.sdk.a.d.a(string2);
        this.a(d2, null, appLovinAdLoadListener);
    }

    @Override
    public String getBidToken() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        String string2 = this.a.T().a();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        return string2;
    }

    @Override
    public void loadNextAdForAdToken(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            r.i("AppLovinAdService", "Invalid ad token specified");
            this.a(-8, appLovinAdLoadListener);
            return;
        }
        c c2 = new c(string3, this.a);
        if (c2.b() == c.a.b) {
            this.b.b("AppLovinAdService", "Loading next ad for token: " + c2);
            k k2 = new k(c2, appLovinAdLoadListener, this.a);
            this.a(k2);
        } else if (c2.b() == c.a.c) {
            JSONObject jSONObject = c2.d();
            if (jSONObject != null) {
                com.applovin.impl.sdk.utils.g.h(jSONObject, this.a);
                com.applovin.impl.sdk.utils.g.d(jSONObject, this.a);
                com.applovin.impl.sdk.utils.g.c(jSONObject, this.a);
                com.applovin.impl.sdk.utils.g.e(jSONObject, this.a);
                JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, "ads", new JSONArray());
                if (jSONArray.length() > 0) {
                    this.b.b("AppLovinAdService", "Rendering ad for token: " + c2);
                    d d2 = Utils.getZone(jSONObject, this.a);
                    f.a a2 = new f.a(d2, appLovinAdLoadListener, this.a);
                    a2.a(true);
                    p p2 = new p(jSONObject, d2, com.applovin.impl.sdk.a.b.f, a2, this.a);
                    this.a(p2);
                } else {
                    this.b.e("AppLovinAdService", "No ad returned from the server for token: " + c2);
                    appLovinAdLoadListener.failedToReceiveAd(204);
                }
            } else {
                this.b.e("AppLovinAdService", "Unable to retrieve ad response JSON from token: " + c2);
                appLovinAdLoadListener.failedToReceiveAd(-8);
            }
        } else {
            r.i("AppLovinAdService", "Invalid ad token specified: " + c2);
            appLovinAdLoadListener.failedToReceiveAd(-8);
        }
    }

    @Override
    public void loadNextAdForZoneIds(List<String> list, AppLovinAdLoadListener appLovinAdLoadListener) {
        List<String> list2 = CollectionUtils.removeTrimmedEmptyStrings(list);
        if (list2 == null || list2.isEmpty()) {
            r.i("AppLovinAdService", "No zones were provided");
            this.a(-7, appLovinAdLoadListener);
            return;
        }
        this.b.b("AppLovinAdService", "Loading next ad for zones: " + list2);
        com.applovin.impl.sdk.e.i i2 = new com.applovin.impl.sdk.e.i(list2, appLovinAdLoadListener, this.a);
        this.a(i2);
    }

    public void loadNextIncentivizedAd(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.b.b("AppLovinAdService", "Loading next incentivized ad of zone {" + string2 + "}");
        d d2 = com.applovin.impl.sdk.a.d.b(string2);
        this.a(d2, null, appLovinAdLoadListener);
    }

    public void loadNextAd(String string2, AppLovinAdSize appLovinAdSize, i i2, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.b.b("AppLovinAdService", "Loading next ad of zone {" + string2 + "} with size " + appLovinAdSize);
        d d2 = com.applovin.impl.sdk.a.d.a(appLovinAdSize, AppLovinAdType.REGULAR, string2);
        this.a(d2, i2, appLovinAdLoadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(d d2, i i2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (d2 == null) {
            throw new IllegalArgumentException("No zone specified");
        }
        if (appLovinAdLoadListener == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        this.a.z().b("AppLovinAdService", "Loading next ad of zone {" + d2 + "}...");
        b b2 = this.a(d2);
        Object object = b2.a;
        synchronized (object) {
            b2.c.add(appLovinAdLoadListener);
            if (!b2.b) {
                b2.b = true;
                a a2 = new a(b2);
                this.a(d2, i2, a2);
            } else {
                this.b.b("AppLovinAdService", "Already waiting on an ad load...");
            }
        }
    }

    private void a(com.applovin.impl.sdk.e.a a2) {
        if (!this.a.d()) {
            r.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        this.a.Q().a(a2, o.a.a);
    }

    private void a(final AppLovinAd appLovinAd, final AppLovinAdLoadListener appLovinAdLoadListener) {
        this.c.post(new Runnable(){

            @Override
            public void run() {
                try {
                    appLovinAdLoadListener.adReceived(appLovinAd);
                }
                catch (Throwable throwable) {
                    r.c("AppLovinAdService", "Unable to notify listener about a newly loaded ad", throwable);
                }
            }
        });
    }

    private void a(final int n2, final AppLovinAdLoadListener appLovinAdLoadListener) {
        this.c.post(new Runnable(){

            @Override
            public void run() {
                try {
                    appLovinAdLoadListener.failedToReceiveAd(n2);
                }
                catch (Throwable throwable) {
                    r.c("AppLovinAdService", "Unable to notify listener about ad load failure", throwable);
                }
            }
        });
    }

    public AppLovinAd dequeueAd(d d2) {
        AppLovinAdBase appLovinAdBase = this.a.X().c(d2);
        this.b.b("AppLovinAdService", "Dequeued ad: " + appLovinAdBase + " for zone: " + d2 + "...");
        return appLovinAdBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomQueryParams(Map<String, String> map) {
        Map<String, String> map2 = this.f;
        synchronized (map2) {
            this.f.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCustomQueryParamsForNextAdRequest() {
        HashMap<String, String> hashMap;
        Map<String, String> map = this.f;
        synchronized (map) {
            hashMap = new HashMap<String, String>(this.f);
            this.f.clear();
        }
        return hashMap;
    }

    public void trackAndLaunchVideoClick(com.applovin.impl.sdk.a.g g2, AppLovinAdView appLovinAdView, Uri uri, PointF pointF) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track video click. No ad specified");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking VIDEO click on an ad...");
        this.a(g2.a(pointF));
        Utils.openUri(appLovinAdView.getContext(), uri, this.a);
    }

    public void trackAndLaunchClick(com.applovin.impl.sdk.a.g g2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2, Uri uri, PointF pointF, boolean bl) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track ad view click. No ad specified");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking click on an ad...");
        this.a(g2.a(pointF, bl));
        this.a(uri, g2, appLovinAdView, b2);
    }

    public void trackImpression(com.applovin.impl.sdk.a.g g2) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track impression click. No ad specified");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking impression on ad...");
        this.a(g2.at());
        this.a.Z().a(g2);
    }

    public void trackVideoEnd(com.applovin.impl.sdk.a.g g2, long l2, int n2, boolean bl) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track video end. No ad specified");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking video end on ad...");
        List<com.applovin.impl.sdk.d.a> list = g2.aq();
        if (list != null && !list.isEmpty()) {
            String string2 = Long.toString(System.currentTimeMillis());
            for (com.applovin.impl.sdk.d.a a2 : list) {
                if (StringUtils.isValidString(a2.a())) {
                    String string3 = this.a(a2.a(), l2, n2, string2, bl);
                    String string4 = this.a(a2.b(), l2, n2, string2, bl);
                    if (string3 != null) {
                        com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string3, string4);
                        this.a(a3);
                        continue;
                    }
                    this.b.e("AppLovinAdService", "Failed to parse url: " + a2.a());
                    continue;
                }
                this.b.d("AppLovinAdService", "Requested a postback dispatch for an empty video end URL; nothing to do...");
            }
        } else {
            this.b.d("AppLovinAdService", "Unable to submit persistent postback for AD #" + g2.getAdIdNumber() + ". Missing video end tracking URL.");
        }
    }

    private String a(String string2, long l2, int n2, String string3, boolean bl) {
        try {
            if (StringUtils.isValidString(string2)) {
                if (n2 < 0 || n2 > 100) {
                    n2 = 0;
                }
                Uri uri = Uri.parse((String)string2);
                Uri uri2 = uri.buildUpon().appendQueryParameter("et_s", Long.toString(l2)).appendQueryParameter("pv", Integer.toString(n2)).appendQueryParameter("vid_ts", string3).appendQueryParameter("uvs", Boolean.toString(bl)).build();
                return uri2.toString();
            }
            return null;
        }
        catch (Throwable throwable) {
            this.b.b("AppLovinAdService", "Unknown error parsing the video end url: " + string2, throwable);
            return null;
        }
    }

    private void a(Uri uri, com.applovin.impl.sdk.a.g g2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2) {
        if (appLovinAdView != null) {
            boolean bl = Utils.openUri(appLovinAdView.getContext(), uri, this.a);
            if (bl) {
                com.applovin.impl.sdk.utils.i.c(b2.g(), (AppLovinAd)g2, appLovinAdView);
            }
            b2.o();
        } else {
            this.b.e("AppLovinAdService", "Unable to launch click - adView has been prematurely destroyed");
        }
    }

    public void trackFullScreenAdClosed(com.applovin.impl.sdk.a.g g2, long l2, long l3, boolean bl, int n2) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track ad closed. No ad specified.");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking ad closed...");
        List<com.applovin.impl.sdk.d.a> list = g2.ar();
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                String string2 = this.a(a2.a(), l2, l3, bl, n2);
                String string3 = this.a(a2.b(), l2, l3, bl, n2);
                if (StringUtils.isValidString(string2)) {
                    com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string2, string3);
                    this.a(a3);
                    continue;
                }
                this.b.e("AppLovinAdService", "Failed to parse url: " + a2.a());
            }
        } else {
            this.b.d("AppLovinAdService", "Unable to track ad closed for AD #" + g2.getAdIdNumber() + ". Missing ad close tracking URL." + g2.getAdIdNumber());
        }
    }

    private String a(String string2, long l2, long l3, boolean bl, int n2) {
        if (StringUtils.isValidString(string2)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon().appendQueryParameter("et_ms", Long.toString(l2)).appendQueryParameter("vs_ms", Long.toString(l3));
            if (n2 != com.applovin.impl.sdk.f.a) {
                builder.appendQueryParameter("musw_ch", Boolean.toString(bl));
                builder.appendQueryParameter("musw_st", Boolean.toString(com.applovin.impl.sdk.f.a(n2)));
            }
            return builder.build().toString();
        }
        return null;
    }

    public void trackAppKilled(com.applovin.impl.sdk.a.g g2) {
        if (g2 == null) {
            this.b.e("AppLovinAdService", "Unable to track app killed. No ad specified");
            return;
        }
        this.b.b("AppLovinAdService", "Tracking app killed during ad...");
        List<com.applovin.impl.sdk.d.a> list = g2.as();
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(a2.a(), a2.b());
                this.a(a3);
            }
        } else {
            this.b.d("AppLovinAdService", "Unable to track app killed during AD #" + g2.getAdIdNumber() + ". Missing app killed tracking URL.");
        }
    }

    private void a(List<com.applovin.impl.sdk.d.a> list) {
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                this.a(a2);
            }
        }
    }

    private void a(com.applovin.impl.sdk.d.a a2) {
        if (StringUtils.isValidString(a2.a())) {
            String string2 = Utils.replaceCommonMacros(a2.a());
            String string3 = StringUtils.isValidString(a2.b()) ? Utils.replaceCommonMacros(a2.b()) : null;
            this.a.S().a(g.o().c(string2).d(string3).b(a2.c()).a(false).c(a2.d()).a());
        } else {
            this.b.d("AppLovinAdService", "Requested a postback dispatch for a null URL; nothing to do...");
        }
    }

    private void a(d d2, i i2, a a2) {
        AppLovinAdBase appLovinAdBase = this.a.X().b(d2);
        if (appLovinAdBase != null) {
            this.b.b("AppLovinAdService", "Using pre-loaded ad: " + appLovinAdBase + " for " + d2);
            this.a.Z().a(appLovinAdBase, true, false);
            a2.adReceived(appLovinAdBase);
        } else {
            j j2 = new j(d2, i2, a2, this.a);
            this.a(j2);
        }
    }

    @Override
    public boolean hasPreloadedAd(AppLovinAdSize appLovinAdSize) {
        d d2 = com.applovin.impl.sdk.a.d.a(appLovinAdSize, AppLovinAdType.REGULAR);
        return this.a.X().a(d2);
    }

    @Override
    public boolean hasPreloadedAdForZoneId(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            r.i("AppLovinAdService", "Unable to check if ad is preloaded - invalid zone id");
            return false;
        }
        d d2 = com.applovin.impl.sdk.a.d.a(string2);
        return this.a.X().a(d2);
    }

    @Override
    public void preloadAd(AppLovinAdSize appLovinAdSize) {
    }

    @Override
    public void preloadAdForZoneId(String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private b a(d d2) {
        b b2;
        Object object = this.e;
        synchronized (object) {
            b2 = this.d.get(d2);
            if (b2 == null) {
                b2 = new b();
                this.d.put(d2, b2);
            }
        }
        return b2;
    }

    public String toString() {
        return "AppLovinAdService{adLoadStates=" + this.d + '}';
    }

    private static class b {
        final Object a = new Object();
        boolean b;
        final Collection<AppLovinAdLoadListener> c = new HashSet<AppLovinAdLoadListener>();

        private b() {
        }

        public String toString() {
            return "AdLoadState{, isWaitingForAd=" + this.b + ", pendingAdListeners=" + this.c + '}';
        }
    }

    private class a
    implements AppLovinAdLoadListener {
        private final b b;

        private a(b b2) {
            this.b = b2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            HashSet<AppLovinAdLoadListener> hashSet;
            d d2 = ((AppLovinAdBase)appLovinAd).getAdZone();
            if (!(appLovinAd instanceof h)) {
                AppLovinAdServiceImpl.this.a.X().a((AppLovinAdBase)appLovinAd);
                appLovinAd = new h(d2, AppLovinAdServiceImpl.this.a);
            }
            Iterator iterator = this.b.a;
            synchronized (iterator) {
                hashSet = new HashSet<AppLovinAdLoadListener>(this.b.c);
                this.b.c.clear();
                this.b.b = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(appLovinAd, appLovinAdLoadListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedToReceiveAd(int n2) {
            HashSet<AppLovinAdLoadListener> hashSet;
            Iterator iterator = this.b.a;
            synchronized (iterator) {
                hashSet = new HashSet<AppLovinAdLoadListener>(this.b.c);
                this.b.c.clear();
                this.b.b = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(n2, appLovinAdLoadListener);
            }
        }
    }
}

