/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.MaxErrorImpl;
import com.applovin.impl.mediation.a.b;
import com.applovin.impl.mediation.a.c;
import com.applovin.impl.mediation.a.e;
import com.applovin.impl.mediation.a.f;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.mediation.b.f;
import com.applovin.impl.mediation.b.g;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.network.i;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final k a;
    private final r b;

    public MediationServiceImpl(k k2) {
        this.a = k2;
        this.b = k2.z();
        k2.ai().registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, MaxAdFormat maxAdFormat, i i2, Activity activity, a.a a2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)this.a.s())) {
            r.i("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (!this.a.d()) {
            r.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.a.x().startsWith("05TMD")) {
            r.i("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        if (this.a.a(maxAdFormat)) {
            r.i("MediationService", "Ad load failed due to disabled ad format " + maxAdFormat.getLabel());
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, "Disabled ad format " + maxAdFormat.getLabel());
            com.applovin.impl.sdk.utils.i.a((MaxAdListener)a2, string2, (MaxError)maxErrorImpl);
            return;
        }
        this.a.G().a(string2, maxAdFormat, i2, activity, a2);
    }

    public void showFullscreenAd(MaxAd maxAd, String string2, final Activity activity, final a.a a2) {
        if (maxAd == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (!(maxAd instanceof c)) {
            r.i("MediationService", "Unable to show ad for '" + maxAd.getAdUnitId() + "': only REWARDED or INTERSTITIAL ads are eligible for showFullscreenAd(). " + maxAd.getFormat() + " ad was provided.");
            throw new IllegalArgumentException("Provided ad is not a MediatedFullscreenAd");
        }
        this.a.ac().a(true);
        final c c2 = (c)maxAd;
        final com.applovin.impl.mediation.g g2 = c2.f();
        if (g2 == null) {
            this.a.ac().a(false);
            this.b.d("MediationService", "Failed to show " + maxAd + ": adapter not found");
            r.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        c2.c(string2);
        long l2 = c2.v();
        this.b.c("MediationService", "Showing ad " + maxAd.getAdUnitId() + " with delay of " + l2 + "ms...");
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
                    g g22 = new g(c2, MediationServiceImpl.this.a);
                    MediationServiceImpl.this.a.Q().a(g22, o.a.r);
                }
                g2.a(c2, activity);
                MediationServiceImpl.this.a.ac().a(false);
                MediationServiceImpl.this.a(c2, (MaxAdListener)a2);
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad manually...");
                MediationServiceImpl.this.processRawAdImpressionPostback(c2, a2);
            }
        }, l2);
    }

    public void destroyAd(MaxAd maxAd) {
        if (!(maxAd instanceof com.applovin.impl.mediation.a.a)) {
            return;
        }
        this.b.c("MediationService", "Destroying " + maxAd);
        com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)maxAd;
        com.applovin.impl.mediation.g g2 = a2.f();
        if (g2 != null) {
            g2.h();
            a2.p();
        }
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.a.a a2, Activity activity, a.a a3) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("A valid Activity is required");
        }
        this.b.b("MediationService", "Loading " + a2 + "...");
        this.a.af().a(a2, "WILL_LOAD");
        this.a(a2);
        com.applovin.impl.mediation.g g2 = this.a.A().a(a2);
        if (g2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2);
            g2.a(maxAdapterParametersImpl, activity);
            com.applovin.impl.mediation.a.a a4 = a2.a(g2);
            g2.a(string2, a4);
            a4.l();
            g2.a(string2, maxAdapterParametersImpl, a4, activity, new a(a4, a3));
        } else {
            String string3 = "Failed to load " + a2 + ": adapter not loaded";
            r.i("MediationService", string3);
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-5001, string3);
            this.a(a2, maxErrorImpl, a3);
        }
    }

    public void collectSignal(MaxAdFormat maxAdFormat, final com.applovin.impl.mediation.a.g g2, Activity activity, final f.a a2) {
        if (g2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        final com.applovin.impl.mediation.g g3 = this.a.A().a(g2);
        if (g3 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(g2, maxAdFormat);
            g3.a(maxAdapterParametersImpl, activity);
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string2) {
                    a2.a(com.applovin.impl.mediation.a.f.a(g2, g3, string2));
                }

                @Override
                public void onSignalCollectionFailed(String string2) {
                    MediationServiceImpl.this.a(string2, g2, g3);
                    a2.a(com.applovin.impl.mediation.a.f.b(g2, g3, string2));
                }
            };
            if (g2.a()) {
                if (this.a.B().a(g2)) {
                    this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + g3.b());
                    g3.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
                } else {
                    this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + g3.b());
                    a2.a(com.applovin.impl.mediation.a.f.a(g2, "Adapter not initialized yet"));
                }
            } else {
                this.b.b("MediationService", "Collecting signal for adapter: " + g3.b());
                g3.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(com.applovin.impl.mediation.a.f.a(g2, "Could not load adapter"));
        }
    }

    private void a(final c c2, final MaxAdListener maxAdListener) {
        final long l2 = this.a.a(com.applovin.impl.sdk.c.a.H);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.o().get()) {
                    return;
                }
                String string2 = "Ad (" + c2.L() + ") has not been displayed after " + l2 + "ms. Failing ad display...";
                r.i("MediationService", string2);
                MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, string2);
                MediationServiceImpl.this.b(c2, maxErrorImpl, maxAdListener);
                MediationServiceImpl.this.a.ac().b(c2);
                MediationServiceImpl.this.a.ak().a();
            }
        }, l2);
    }

    private void a(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a(maxError, a2);
        this.destroyAd(a2);
        com.applovin.impl.sdk.utils.i.a(maxAdListener, a2.getAdUnitId(), maxError);
    }

    private void b(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a.af().a(a2, "DID_FAIL_DISPLAY");
        this.processAdDisplayErrorPostback(maxError, a2);
        if (a2.o().compareAndSet(false, true)) {
            com.applovin.impl.sdk.utils.i.a(maxAdListener, (MaxAd)a2, maxError);
        }
    }

    private void a(com.applovin.impl.mediation.a.a a2) {
        this.a("mpreload", (e)a2);
    }

    public void processAdLossPostback(com.applovin.impl.mediation.a.a a2, @Nullable Float f2) {
        String string2 = f2 != null ? f2.toString() : "";
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{MBR}", string2);
        this.a("mloss", hashMap, a2);
    }

    private void b(com.applovin.impl.mediation.a.a a2) {
        this.a.af().a(a2, "DID_LOAD");
        if (a2.c().endsWith("load")) {
            this.a.af().a(a2);
        }
        long l2 = a2.k();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("load", hashMap, a2);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        long l2 = a2.k();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("mlerr", hashMap, maxError, a2);
    }

    public void processAdapterInitializationPostback(e e2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        hashMap.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", hashMap, new MaxErrorImpl(string2), e2);
    }

    public void processRawAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        this.a.af().a(a2, "WILL_DISPLAY");
        if (a2.c().endsWith("mimp")) {
            this.a.af().a(a2);
            com.applovin.impl.sdk.utils.i.a(a3, (MaxAd)a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (a2 instanceof c) {
            c c2 = (c)a2;
            hashMap.put("{TIME_TO_SHOW_MS}", String.valueOf(c2.u()));
        }
        this.a("mimp", hashMap, a2);
    }

    public void processViewabilityAdImpressionPostback(b b2, long l2, a.a a2) {
        if (b2.c().endsWith("vimp")) {
            this.a.af().a(b2);
            com.applovin.impl.sdk.utils.i.a(a2, (MaxAd)b2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        hashMap.put("{USED_VIEWABILITY_TIMER}", String.valueOf(b2.y()));
        this.a("mvimp", hashMap, b2);
    }

    public void processCallbackAdImpressionPostback(com.applovin.impl.mediation.a.a a2, a.a a3) {
        if (a2.c().endsWith("cimp")) {
            this.a.af().a(a2);
            com.applovin.impl.sdk.utils.i.a(a3, (MaxAd)a2);
        }
        this.a("mcimp", (e)a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2, a.a a3) {
        this.a.af().a(a2, "DID_CLICKED");
        this.a.af().a(a2, "DID_CLICK");
        if (a2.c().endsWith("click")) {
            this.a.af().a(a2);
            com.applovin.impl.sdk.utils.i.a(a3, (MaxAd)a2);
        }
        this.a("mclick", (e)a2);
    }

    public void processAdDisplayErrorPostback(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, maxError, a2);
    }

    private void a(String string2, com.applovin.impl.mediation.a.g g2, com.applovin.impl.mediation.g g3) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Utils.putObjectForStringIfValid("{ADAPTER_VERSION}", g3.g(), hashMap);
        Utils.putObjectForStringIfValid("{SDK_VERSION}", g3.f(), hashMap);
        this.a("serr", hashMap, new MaxErrorImpl(string2), g2);
    }

    private void a(String string2, e e2) {
        this.a(string2, Collections.EMPTY_MAP, null, e2);
    }

    private void a(String string2, Map<String, String> map, e e2) {
        this.a(string2, map, null, e2);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, e e2) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("{PLACEMENT}", StringUtils.emptyIfNull(e2.getPlacement()));
        if (e2 instanceof com.applovin.impl.mediation.a.a) {
            object = (com.applovin.impl.mediation.a.a)e2;
            hashMap.put("{CREATIVE_ID}", StringUtils.emptyIfNull(((com.applovin.impl.mediation.a.a)object).getCreativeId()));
        }
        object = new d(string2, hashMap, maxError, e2, this.a);
        this.a.Q().a((com.applovin.impl.sdk.e.a)object, o.a.m);
    }

    @Override
    public void onReceive(Context context, Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.a.ac().c()) instanceof com.applovin.impl.mediation.a.a) {
            com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)object;
            this.processAdDisplayErrorPostback(MaxAdapterError.WEBVIEW_ERROR, a2);
        }
    }

    public class a
    implements a.a,
    MaxAdListener,
    MaxAdRevenueListener,
    MaxAdViewAdListener,
    MaxRewardedAdListener {
        private final com.applovin.impl.mediation.a.a b;
        private a.a c;

        public a(com.applovin.impl.mediation.a.a a2, a.a a3) {
            this.b = a2;
            this.c = a3;
        }

        public void a(a.a a2) {
            this.c = a2;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.a(maxAd, null);
        }

        public void a(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.n();
            this.b.a(bundle);
            MediationServiceImpl.this.b(this.b);
            com.applovin.impl.sdk.utils.i.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string2, MaxError maxError) {
            this.b.n();
            MediationServiceImpl.this.a(this.b, maxError, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            this.b(maxAd, null);
        }

        public void b(MaxAd maxAd, @Nullable Bundle bundle) {
            MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.b, this.c);
            this.b.a(bundle);
            MediationServiceImpl.this.a.af().a(this.b, "DID_DISPLAY");
            if (maxAd.getFormat().isFullscreenAd()) {
                MediationServiceImpl.this.a.ac().a(maxAd);
                MediationServiceImpl.this.a.ak().a(maxAd);
            }
            com.applovin.impl.sdk.utils.i.b(this.c, maxAd);
        }

        @Override
        public void onAdHidden(final MaxAd maxAd) {
            MediationServiceImpl.this.a.af().a((com.applovin.impl.mediation.a.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).w();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat().isFullscreenAd()) {
                        MediationServiceImpl.this.a.ac().b(maxAd);
                        MediationServiceImpl.this.a.ak().a();
                    }
                    com.applovin.impl.sdk.utils.i.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            MediationServiceImpl.this.a(this.b, this.c);
            com.applovin.impl.sdk.utils.i.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
            MediationServiceImpl.this.b(this.b, maxError, this.c);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).A();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.i.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.i.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            com.applovin.impl.sdk.utils.i.a((MaxAdListener)this.c, maxAd, maxReward);
            f f2 = new f((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.Q().a(f2, o.a.r);
        }

        @Override
        public void onAdRevenuePaid(MaxAd maxAd) {
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.i.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.i.h(this.c, maxAd);
        }
    }
}

