/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.applovin.impl.a.a;
import com.applovin.impl.sdk.AppLovinAdBase;
import com.applovin.impl.sdk.a.d;
import com.applovin.impl.sdk.a.g;
import com.applovin.impl.sdk.a.h;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.c;
import com.applovin.impl.sdk.utils.f;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

@Keep
public abstract class Utils {
    private static final String TAG = "Utils";
    private static final String PLACEMENT_MACRO = "{PLACEMENT}";
    public static final String SHOWN_OUT_OF_CONTEXT_MACRO = "{SOC}";
    public static final String MACRO_CLCODE = "{CLCODE}";
    private static final String MACRO_EVENT_ID = "{EVENT_ID}";
    public static final String MACRO_CLICK_X = "{CLICK_X}";
    public static final String MACRO_CLICK_Y = "{CLICK_Y}";
    public static final String MACRO_SCREEN_WIDTH = "{SCREEN_WIDTH}";
    public static final String MACRO_SCREEN_HEIGHT = "{SCREEN_HEIGHT}";
    public static final String MACRO_IS_VIDEO_CLICK = "{IS_VIDEO_CLICK}";
    public static final String PLAY_STORE_SCHEME = "market";
    public static final String PLAY_STORE_PACKAGE_NAME = "com.android.vending";
    public static Boolean isExoPlayerEligible;

    @Keep
    public static boolean isVerboseLoggingConfigured() {
        Context context = k.K();
        if (context != null) {
            return c.a(context).a("applovin.sdk.verbose_logging");
        }
        return false;
    }

    public static boolean isVerboseLoggingEnabled(Context context) {
        if (context == null) {
            context = k.K();
        }
        if (context != null) {
            return c.a(context).a("applovin.sdk.verbose_logging", false);
        }
        return false;
    }

    public static String shortenKey(String string2) {
        if (string2 != null && string2.length() > 4) {
            return string2.substring(string2.length() - 4);
        }
        return "NOKEY";
    }

    public static String encodeUrlMap(Map<String, String> map, boolean bl) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map2 = map;
        if (bl) {
            map2 = new TreeMap<String, String>(new Comparator<String>(){

                public int a(String string2, String string3) {
                    return string2.compareToIgnoreCase(string3);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((String)object, (String)object2);
                }
            });
            map2.putAll(map);
        }
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append((Object)entry.getKey()).append('=').append((Object)entry.getValue());
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> stringifyObjectMap(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map == null || map.isEmpty()) {
            return hashMap;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return hashMap;
    }

    public static boolean isDomainWhitelisted(String string2, List<String> list) {
        for (String string3 : list) {
            if (!string2.startsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean bitMaskContainsFlag(long l2, long l3) {
        return (l2 & l3) != 0L;
    }

    public static int getOrientation(Context context) {
        Configuration configuration;
        Resources resources;
        if (context != null && (resources = context.getResources()) != null && (configuration = resources.getConfiguration()) != null) {
            return configuration.orientation;
        }
        return 0;
    }

    public static int getVideoCompletionPercent(JSONObject jSONObject) {
        int n2 = JsonUtils.getInt(jSONObject, "video_completion_percent", -1);
        if (0 <= n2 && n2 <= 100) {
            return n2;
        }
        return 95;
    }

    public static long getServerAdjustedUnixTimestampMillis(k k2) {
        long l2 = k2.a(b.ep);
        long l3 = k2.a(b.eq);
        long l4 = System.currentTimeMillis();
        if (l2 > 0L && l3 > 0L) {
            long l5 = l2 - l3;
            return l4 + l5;
        }
        return l4;
    }

    public static void putObjectForStringIfValid(String string2, String string3, Map map) {
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            map.put(string2, string3);
        }
    }

    public static void renameKeyInObjectMap(String string2, String string3, Map<String, Object> map) {
        if (map.containsKey(string2)) {
            Object object = map.get(string2);
            map.put(string3, object);
            map.remove(string2);
        }
    }

    public static float secondsToMillis(float f2) {
        return f2 * 1000.0f;
    }

    public static double millisToSeconds(long l2) {
        return (double)l2 / 1000.0;
    }

    private static long floatToLong(float f2) {
        return Math.round(f2);
    }

    public static long secondsToMillisLong(float f2) {
        return Utils.floatToLong(Utils.secondsToMillis(f2));
    }

    public static double tryParseDouble(String string2, double d2) {
        try {
            return Double.parseDouble(string2);
        }
        catch (Throwable throwable) {
            r.c(TAG, "Failed to parse double from String: " + string2, throwable);
            return d2;
        }
    }

    public static String replaceCommonMacros(String string2) {
        return Utils.replaceCommonMacros(false, string2);
    }

    public static String replaceCommonMacros(boolean bl, String string2) {
        return string2.replace(PLACEMENT_MACRO, "").replace(SHOWN_OUT_OF_CONTEXT_MACRO, String.valueOf(bl));
    }

    public static Activity retrieveParentActivity(View view, k k2) {
        if (view == null) {
            return null;
        }
        View view2 = view;
        try {
            for (int i2 = 0; i2 < 1000; ++i2) {
                Context context = view2.getContext();
                if (context instanceof Activity) {
                    return (Activity)context;
                }
                ViewParent viewParent = view2.getParent();
                if (viewParent instanceof View) {
                    view2 = (View)viewParent;
                    continue;
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            k2.z().b(TAG, "Encountered error while retrieving activity from view", throwable);
        }
        return null;
    }

    public static void maybeHandleNoFillResponseForPublisher(String string2, MaxAdFormat maxAdFormat, JSONObject jSONObject, k k2) {
        if (jSONObject.has("no_fill_reason")) {
            Object object = JsonUtils.getObject(jSONObject, "no_fill_reason", new Object());
            String string3 = "\n**************************************************\nNO FILL received:\n..ID: \"" + string2 + "\"\n..FORMAT: \"" + maxAdFormat.getLabel() + "\"\n..SDK KEY: \"" + k2.x() + "\"\n..PACKAGE NAME: \"" + k2.J().getPackageName() + "\"\n..Reason: " + object + "\n**************************************************\n";
            r.i("AppLovinSdk", string3);
        }
    }

    public static AppLovinAd maybeRetrieveNonDummyAd(AppLovinAd appLovinAd, k k2) {
        if (appLovinAd instanceof h) {
            h h2 = (h)appLovinAd;
            AppLovinAd appLovinAd2 = k2.t().dequeueAd(h2.getAdZone());
            k2.z().b(TAG, "Dequeued ad for dummy ad: " + appLovinAd2);
            if (appLovinAd2 != null) {
                h2.a(appLovinAd2);
                ((AppLovinAdBase)appLovinAd2).setDummyAd(h2);
                return appLovinAd2;
            }
            return h2.a();
        }
        return appLovinAd;
    }

    public static d getZone(JSONObject jSONObject, k k2) {
        String string2 = JsonUtils.getString(jSONObject, "ad_size", null);
        AppLovinAdSize appLovinAdSize = AppLovinAdSize.fromString(string2);
        String string3 = JsonUtils.getString(jSONObject, "ad_type", null);
        AppLovinAdType appLovinAdType = AppLovinAdType.fromString(string3);
        String string4 = JsonUtils.getString(jSONObject, "zone_id", null);
        return d.a(appLovinAdSize, appLovinAdType, string4);
    }

    public static boolean openUri(Context context, Uri uri, k k2) {
        boolean bl = false;
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            if (PLAY_STORE_SCHEME.equals(intent.getScheme())) {
                intent.setPackage(PLAY_STORE_PACKAGE_NAME);
            }
            k2.ab().b();
            context.startActivity(intent);
            bl = true;
        }
        catch (Throwable throwable) {
            k2.z().b(TAG, "Unable to open \"" + uri + "\".", throwable);
        }
        if (!bl) {
            k2.ab().c();
        }
        return bl;
    }

    public static Field getField(Class clazz, String string2) {
        try {
            return clazz.getDeclaredField(string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return null;
            }
            return Utils.getField(clazz2, string2);
        }
    }

    public static String getString(Class clazz, String string2) {
        try {
            Field field = Utils.getField(clazz, string2);
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, String string3, String string4, k k2) {
        return Utils.getPostbacks(string2, jSONObject, string3, null, string4, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, String string3, String string4, Map<String, String> map, k k2) {
        return Utils.getPostbacks(string2, jSONObject, string3, Collections.emptyMap(), string4, map, false, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, String string3, Map<String, String> map, String string4, k k2) {
        return Utils.getPostbacks(string2, jSONObject, string3, map, string4, null, false, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, String string3, Map<String, String> hashMap, String string4, Map<String, String> map, boolean bl, k k2) {
        HashMap<String, String> hashMap2 = hashMap != null ? hashMap : new HashMap<String, String>(1);
        hashMap2.put(MACRO_CLCODE, string3);
        return Utils.getPostbacks(string2, jSONObject, hashMap2, string4, map, bl, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, Map<String, String> map, String string3, k k2) {
        return Utils.getPostbacks(string2, jSONObject, map, string3, null, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, Map<String, String> map, String string3, Map<String, String> map2, k k2) {
        return Utils.getPostbacks(string2, jSONObject, map, string3, map2, false, k2);
    }

    public static List<com.applovin.impl.sdk.d.a> getPostbacks(String string2, JSONObject jSONObject, Map<String, String> map, String string3, Map<String, String> map2, boolean bl, k k2) {
        Object object;
        JSONObject jSONObject2 = JsonUtils.getJSONObject(jSONObject, string2, new JSONObject());
        ArrayList<com.applovin.impl.sdk.d.a> arrayList = new ArrayList<com.applovin.impl.sdk.d.a>(jSONObject2.length() + 1);
        if (StringUtils.isValidString(string3)) {
            object = new com.applovin.impl.sdk.d.a(string3, null, map2, bl);
            arrayList.add((com.applovin.impl.sdk.d.a)object);
        }
        if (jSONObject2.length() > 0) {
            object = jSONObject2.keys();
            while (object.hasNext()) {
                try {
                    String string4 = (String)object.next();
                    if (TextUtils.isEmpty((CharSequence)string4)) continue;
                    String string5 = jSONObject2.optString(string4);
                    string4 = StringUtils.replace(string4, map);
                    if (!TextUtils.isEmpty((CharSequence)string5)) {
                        string5 = StringUtils.replace(string5, map);
                    }
                    com.applovin.impl.sdk.d.a a2 = new com.applovin.impl.sdk.d.a(string4, string5, map2, bl);
                    arrayList.add(a2);
                }
                catch (Throwable throwable) {
                    k2.z().b(TAG, "Failed to create and add postback url.", throwable);
                }
            }
        }
        return arrayList;
    }

    public static boolean isViewInTopActivity(View view, Activity activity) {
        if (activity == null || view == null) {
            return false;
        }
        Window window = activity.getWindow();
        if (window != null) {
            return Utils.isViewInChildView(view, window.getDecorView());
        }
        View view2 = activity.findViewById(0x1020002);
        if (view2 != null) {
            return Utils.isViewInChildView(view, view2.getRootView());
        }
        return false;
    }

    public static boolean isViewInChildView(View view, View view2) {
        if (view == view2) {
            return true;
        }
        if (view2 instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view2;
            for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
                boolean bl = Utils.isViewInChildView(view, viewGroup.getChildAt(i2));
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public static View getRootView(View view) {
        if (view == null) {
            return null;
        }
        View view2 = view.getRootView();
        if (view2 == null) {
            return null;
        }
        View view3 = view2.findViewById(0x1020002);
        return view3 != null ? view3 : view2;
    }

    public static String urlStringWithoutQueryParameters(String string2) {
        Uri uri = Uri.parse((String)string2);
        return new Uri.Builder().scheme(uri.getScheme()).authority(uri.getAuthority()).path(uri.getPath()).build().toString();
    }

    public static void validateAdSdkKey(AppLovinAd appLovinAd, k k2) {
        String string2;
        if (!(appLovinAd instanceof AppLovinAdBase)) {
            return;
        }
        AppLovinAdBase appLovinAdBase = (AppLovinAdBase)appLovinAd;
        String string3 = k2.x();
        if (!string3.equals(string2 = appLovinAdBase.getSdk().x())) {
            r.i("AppLovinAd", "Ad was loaded from sdk with key: " + string2 + ", but is being rendered from sdk with key: " + string3);
            k2.R().a(com.applovin.impl.sdk.d.f.l);
        }
    }

    public static Map<String, String> toUrlSafeMap(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (String string2 : hashMap.keySet()) {
            String string3 = (String)hashMap.get(string2);
            if (string3 == null) continue;
            hashMap.put(string2, StringUtils.encodeUrlString(string3));
        }
        return hashMap;
    }

    public static boolean objectIsOfType(Object object, List<String> list, k k2) {
        if (list == null) {
            return false;
        }
        List<Class> list2 = Utils.generateClassesList(list, k2);
        for (Class clazz : list2) {
            if (!clazz.isInstance(object)) continue;
            if (object instanceof Map) {
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) {
                        k2.z().b(TAG, "Invalid key type used. Map keys should be of type String.");
                        return false;
                    }
                    if (Utils.objectIsOfType(entry.getValue(), list, k2)) continue;
                    return false;
                }
            } else if (object instanceof List) {
                List list3 = (List)object;
                for (Object e2 : list3) {
                    if (Utils.objectIsOfType(e2, list, k2)) continue;
                    return false;
                }
            }
            return true;
        }
        k2.z().b(TAG, "Object '" + object + "' does not match any of the required types '" + list + "'.");
        return false;
    }

    private static List<Class> generateClassesList(List<String> list, k k2) {
        if (list == null) {
            return null;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>(list.size());
        for (String string2 : list) {
            try {
                Class<?> clazz = Class.forName(string2);
                arrayList.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                k2.z().e(TAG, "Failed to create class for name: " + string2);
            }
        }
        return arrayList;
    }

    public static Object sanitizeSuperProperty(Object object, k k2) {
        int n2;
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object k3 = entry.getKey();
                String string2 = k3 instanceof String ? (String)k3 : String.valueOf(k3);
                hashMap.put(string2, Utils.sanitizeSuperProperty(entry.getValue(), k2));
            }
            return hashMap;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (Object e2 : list) {
                arrayList.add(Utils.sanitizeSuperProperty(e2, k2));
            }
            return arrayList;
        }
        if (object instanceof Date) {
            return String.valueOf(((Date)object).getTime());
        }
        String string3 = String.valueOf(object);
        if (object instanceof String) {
            int n3 = k2.a(b.bb);
            if (n3 > 0 && string3.length() > n3) {
                string3 = string3.substring(0, n3);
            }
        } else if (object instanceof Uri && (n2 = k2.a(b.bc).intValue()) > 0 && string3.length() > n2) {
            string3 = string3.substring(0, n2);
        }
        return string3;
    }

    public static String retrieveLauncherActivityFullyQualifiedName(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        if (!list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            return resolveInfo.activityInfo.name;
        }
        return null;
    }

    public static int getRotation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        return windowManager.getDefaultDisplay().getRotation();
    }

    public static boolean checkClassExistence(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            Class.forName(string2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean checkClassesExistence(List<String> list) {
        for (String string2 : list) {
            if (!Utils.checkClassExistence(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static long parseColor(String string2) {
        if (StringUtils.isValidString(string2)) {
            try {
                return Color.parseColor((String)string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Long.MAX_VALUE;
    }

    public static void close(Closeable closeable, k k2) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                if (k2 == null) break block3;
                k2.z().b(TAG, "Unable to close stream: " + closeable, throwable);
            }
        }
    }

    public static void disconnect(HttpURLConnection httpURLConnection, k k2) {
        block3: {
            if (httpURLConnection == null) {
                return;
            }
            try {
                httpURLConnection.disconnect();
            }
            catch (Throwable throwable) {
                if (k2 == null) break block3;
                k2.z().b(TAG, "Unable to disconnect connection: " + httpURLConnection, throwable);
            }
        }
    }

    public static boolean isCurrentProcessInForeground() {
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
        try {
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
        }
        catch (Throwable throwable) {
            r.c(TAG, "Exception thrown while getting memory state.", throwable);
        }
        return runningAppProcessInfo.importance == 100 || runningAppProcessInfo.importance == 200;
    }

    public static int toVersionCode(String string2) {
        String string3 = string2.replaceAll("-beta", ".");
        String[] stringArray = string3.split("\\.");
        int n2 = 0;
        for (String string4 : stringArray) {
            if (string4.length() > 2) {
                r.i(TAG, "Version number components cannot be longer than two digits -> " + string2);
                return n2;
            }
            n2 *= 100;
            n2 += Integer.parseInt(string4);
        }
        if (!string2.contains("-beta")) {
            n2 *= 100;
            n2 += 99;
        }
        return n2;
    }

    public static boolean isVPNConnected() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().getDisplayName();
                if (!string2.contains("tun") && !string2.contains("ppp") && !string2.contains("ipsec")) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            r.c(TAG, "Unable to check Network Interfaces", throwable);
        }
        return false;
    }

    public static boolean isPubInDebugMode(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static void showToast(final String string2, final Context context) {
        AppLovinSdkUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast toast = Toast.makeText((Context)context, (CharSequence)string2, (int)0);
                toast.setMargin(0.0f, 0.1f);
                toast.show();
            }
        });
    }

    public static void showToast(String string2, MaxAd maxAd, Context context) {
        Toast.makeText((Context)context, (CharSequence)(maxAd.getFormat().getDisplayName() + ": " + string2), (int)1).show();
    }

    public static boolean isBML(AppLovinAdSize appLovinAdSize) {
        return appLovinAdSize == AppLovinAdSize.BANNER || appLovinAdSize == AppLovinAdSize.MREC || appLovinAdSize == AppLovinAdSize.LEADER || appLovinAdSize == AppLovinAdSize.CROSS_PROMO;
    }

    public static String getAndroidSdkCodename() {
        try {
            for (Field field : Build.VERSION_CODES.class.getFields()) {
                if (field.getInt(null) != Build.VERSION.SDK_INT) continue;
                return field.getName();
            }
        }
        catch (Throwable throwable) {
            r.c(TAG, "Unable to get Android SDK codename", throwable);
        }
        return "";
    }

    public static String getAndroidOSInfo() {
        try {
            return Build.VERSION.RELEASE + " (" + Utils.getAndroidSdkCodename() + " - API " + Build.VERSION.SDK_INT + ")";
        }
        catch (Throwable throwable) {
            r.c(TAG, "Unable to get Android OS info", throwable);
            return "";
        }
    }

    public static String getUserEngagementSdkVersion() {
        try {
            Class<?> clazz = Class.forName("com.applovin.sdk.userengagement.impl.api.AppLovinUserEngagementSdkImpl");
            Method method = clazz.getMethod("getVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getSafedkVersion() {
        return Utils.getSafedkString("getVersion");
    }

    public static String getSafedkSdkKey() {
        return Utils.getSafedkString("getSdkKey");
    }

    private static String getSafedkString(String string2) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.applovin.quality.AppLovinQualityService");
            }
            catch (Throwable throwable) {
                clazz = Class.forName("com.safedk.android.SafeDK");
            }
            Method method = clazz.getMethod(string2, new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static int tryToGetExoPlayerVersionCode() {
        try {
            Field field = Utils.getField(Class.forName("com.google.android.exoplayer2.ExoPlayerLibraryInfo"), "VERSION_INT");
            field.setAccessible(true);
            return (Integer)field.get(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean checkExoPlayerEligibility(k k2) {
        if (isExoPlayerEligible == null) {
            int n2 = Utils.tryToGetExoPlayerVersionCode();
            int n3 = k2.a(b.cJ);
            isExoPlayerEligible = Utils.checkClassExistence("com.google.android.exoplayer2.ui.PlayerView") && n2 >= k2.a(b.cI) && (n3 < 0 || n2 <= n3);
        }
        return isExoPlayerEligible;
    }

    public static List<Uri> checkCachedResourcesExist(boolean bl, g g2, k k2, Context context) {
        if (g2 instanceof a) {
            return Collections.emptyList();
        }
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        ArrayList<Uri> arrayList2 = new ArrayList<Uri>(g2.A());
        for (Uri uri : arrayList2) {
            if (k2.Y().b(uri.getLastPathSegment(), context)) continue;
            k2.z().e(TAG, "Cached HTML asset missing: " + uri);
            arrayList.add(uri);
        }
        if (bl) {
            Uri uri = g2.h();
            if (!k2.Y().b(uri.getLastPathSegment(), context)) {
                k2.z().e(TAG, "Cached video missing: " + uri);
                arrayList.add(uri);
            }
        }
        return arrayList;
    }

    public static void showAlert(String string2, String string3, Context context) {
        new AlertDialog.Builder(context).setTitle((CharSequence)string2).setMessage((CharSequence)string3).setNegativeButton(17039370, null).create().show();
    }

    public static boolean getBooleanForProbability(int n2) {
        if (n2 <= 0 || n2 > 100) {
            return false;
        }
        return (int)(Math.random() * 100.0) + 1 <= n2;
    }

    public static boolean isAppLovinTestEnvironment(Context context) {
        return c.a(context).a("applovin.sdk.is_test_environment");
    }

    @Nullable
    public static Map<String, String> getMetaData(AppLovinSdkSettings appLovinSdkSettings) {
        try {
            Field field = Utils.getField(appLovinSdkSettings.getClass(), "metaData");
            if (field != null) {
                field.setAccessible(true);
            }
            return (Map)field.get(appLovinSdkSettings);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isProguardRulesOmitted() {
        try {
            Class.forName("com.applovin.sdk.AppLovinSdk");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        return false;
    }

    public static byte[] gzip(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static int getAlwaysFinishActivitiesSetting(Context context) {
        String string2 = f.b() ? "always_finish_activities" : "always_finish_activities";
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)string2, (int)0);
    }

    public static boolean hasAndroidCoreJsonLibrary(k k2) {
        if (f.c()) {
            try {
                JSONObject.wrap((Object)JSONObject.NULL);
            }
            catch (Throwable throwable) {
                k2.z().a(TAG, "Failed to wrap JSONObject with exception", throwable);
                return false;
            }
        }
        return true;
    }

    public static boolean isTestApp(Context context) {
        String string2 = context.getPackageName();
        return "com.revolverolver.fliptrickster".equals(string2) || "com.mindstormstudios.idlemakeover".equals(string2);
    }
}

