package com.applovin.mediation;

/**
 * Created by Thomas So on May 08 2021
 * <p>
 * This class encapsulates various data for MAX load and display errors.
 */
public interface MaxError
{
    /**
     * The error code for the error. Will be one of the codes listed in {@link MaxErrorCode}.
     */
    int getCode();

    /**
     * The error message for the error.
     */
    String getMessage();

    /**
     * A description string containing error codes and reasons for why each mediated network failed to load an ad.
     */
    String getAdLoadFailureInfo();
}
