/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.webkit.MimeTypeMap;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.r;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class AppLovinContentProviderUtils {
    private static final String[] a = new String[]{"_display_name", "_size"};

    @Nullable
    public static Uri cacheTextWithFileName(String string2, String string3) {
        try {
            File file = AppLovinContentProviderUtils.b(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            return AppLovinContentProviderUtils.a(string3);
        }
        catch (Throwable throwable) {
            r.i("AppLovinContentProvider", "Failed to create text file '" + string3 + "' for content provider with exception: " + throwable);
            return null;
        }
    }

    private static Uri a(String string2) {
        String string3 = k.K().getPackageName() + ".applovincontentprovider/" + string2;
        return Uri.parse((String)("content://" + string3));
    }

    @Nullable
    private static File b(String string2) {
        File file = new File(k.K().getCacheDir() + File.separator + "ALContentProviderCache");
        if (!file.exists()) {
            try {
                if (!file.mkdir()) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new File(file, string2);
    }

    @Nullable
    private static File a(Uri uri) {
        String string2 = uri.getLastPathSegment();
        if (string2 == null) {
            return null;
        }
        return AppLovinContentProviderUtils.b(string2);
    }

    @Nullable
    public static Cursor query(Uri uri) {
        File file = AppLovinContentProviderUtils.a(uri);
        try {
            MatrixCursor matrixCursor = new MatrixCursor(a, 1);
            matrixCursor.addRow(new Object[]{file.getName(), file.length()});
            return matrixCursor;
        }
        catch (Throwable throwable) {
            r.c("AppLovinContentProvider", "Failed to query file '" + uri.toString() + "'", throwable);
            return null;
        }
    }

    @Nullable
    public static String getType(Uri uri) {
        File file = AppLovinContentProviderUtils.a(uri);
        try {
            String string2 = file.getName().substring(file.getName().indexOf(46) + 1);
            if (MimeTypeMap.getSingleton().hasExtension(string2)) {
                return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            }
        }
        catch (Throwable throwable) {
            r.c("AppLovinContentProvider", "Failed to get file type for '" + uri.toString() + "'", throwable);
        }
        return null;
    }

    @Nullable
    public static ParcelFileDescriptor openFile(Uri uri) {
        File file = AppLovinContentProviderUtils.a(uri);
        try {
            return ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            r.c("AppLovinContentProvider", "Failed to open file '" + uri.toString() + "'", fileNotFoundException);
            return null;
        }
    }
}

